<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketStyleOverride StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketStyleOverride
 * @subpackage Structs
 */
class TicketStyleOverride extends AbstractStructBase
{
    /**
     * The HideBackgroundImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HideBackgroundImage;
    /**
     * The TicketBackgroundColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBackgroundColor;
    /**
     * The TicketBackgroundImageAdaDominantColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBackgroundImageAdaDominantColor;
    /**
     * The TicketBackgroundImageFileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBackgroundImageFileType;
    /**
     * The TicketBackgroundImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketBackgroundImageGuid;
    /**
     * The TicketSponsorshipLogoFileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSponsorshipLogoFileType;
    /**
     * The TicketSponsorshipLogoGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSponsorshipLogoGuid;
    /**
     * Constructor method for TicketStyleOverride
     * @uses TicketStyleOverride::setHideBackgroundImage()
     * @uses TicketStyleOverride::setTicketBackgroundColor()
     * @uses TicketStyleOverride::setTicketBackgroundImageAdaDominantColor()
     * @uses TicketStyleOverride::setTicketBackgroundImageFileType()
     * @uses TicketStyleOverride::setTicketBackgroundImageGuid()
     * @uses TicketStyleOverride::setTicketSponsorshipLogoFileType()
     * @uses TicketStyleOverride::setTicketSponsorshipLogoGuid()
     * @param bool $hideBackgroundImage
     * @param string $ticketBackgroundColor
     * @param string $ticketBackgroundImageAdaDominantColor
     * @param string $ticketBackgroundImageFileType
     * @param string $ticketBackgroundImageGuid
     * @param string $ticketSponsorshipLogoFileType
     * @param string $ticketSponsorshipLogoGuid
     */
    public function __construct($hideBackgroundImage = null, $ticketBackgroundColor = null, $ticketBackgroundImageAdaDominantColor = null, $ticketBackgroundImageFileType = null, $ticketBackgroundImageGuid = null, $ticketSponsorshipLogoFileType = null, $ticketSponsorshipLogoGuid = null)
    {
        $this
            ->setHideBackgroundImage($hideBackgroundImage)
            ->setTicketBackgroundColor($ticketBackgroundColor)
            ->setTicketBackgroundImageAdaDominantColor($ticketBackgroundImageAdaDominantColor)
            ->setTicketBackgroundImageFileType($ticketBackgroundImageFileType)
            ->setTicketBackgroundImageGuid($ticketBackgroundImageGuid)
            ->setTicketSponsorshipLogoFileType($ticketSponsorshipLogoFileType)
            ->setTicketSponsorshipLogoGuid($ticketSponsorshipLogoGuid);
    }
    /**
     * Get HideBackgroundImage value
     * @return bool|null
     */
    public function getHideBackgroundImage()
    {
        return $this->HideBackgroundImage;
    }
    /**
     * Set HideBackgroundImage value
     * @param bool $hideBackgroundImage
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setHideBackgroundImage($hideBackgroundImage = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideBackgroundImage) && !is_bool($hideBackgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideBackgroundImage, true), gettype($hideBackgroundImage)), __LINE__);
        }
        $this->HideBackgroundImage = $hideBackgroundImage;
        return $this;
    }
    /**
     * Get TicketBackgroundColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackgroundColor()
    {
        return isset($this->TicketBackgroundColor) ? $this->TicketBackgroundColor : null;
    }
    /**
     * Set TicketBackgroundColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackgroundColor
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketBackgroundColor($ticketBackgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackgroundColor) && !is_string($ticketBackgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackgroundColor, true), gettype($ticketBackgroundColor)), __LINE__);
        }
        if (is_null($ticketBackgroundColor) || (is_array($ticketBackgroundColor) && empty($ticketBackgroundColor))) {
            unset($this->TicketBackgroundColor);
        } else {
            $this->TicketBackgroundColor = $ticketBackgroundColor;
        }
        return $this;
    }
    /**
     * Get TicketBackgroundImageAdaDominantColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackgroundImageAdaDominantColor()
    {
        return isset($this->TicketBackgroundImageAdaDominantColor) ? $this->TicketBackgroundImageAdaDominantColor : null;
    }
    /**
     * Set TicketBackgroundImageAdaDominantColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackgroundImageAdaDominantColor
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketBackgroundImageAdaDominantColor($ticketBackgroundImageAdaDominantColor = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackgroundImageAdaDominantColor) && !is_string($ticketBackgroundImageAdaDominantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackgroundImageAdaDominantColor, true), gettype($ticketBackgroundImageAdaDominantColor)), __LINE__);
        }
        if (is_null($ticketBackgroundImageAdaDominantColor) || (is_array($ticketBackgroundImageAdaDominantColor) && empty($ticketBackgroundImageAdaDominantColor))) {
            unset($this->TicketBackgroundImageAdaDominantColor);
        } else {
            $this->TicketBackgroundImageAdaDominantColor = $ticketBackgroundImageAdaDominantColor;
        }
        return $this;
    }
    /**
     * Get TicketBackgroundImageFileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackgroundImageFileType()
    {
        return isset($this->TicketBackgroundImageFileType) ? $this->TicketBackgroundImageFileType : null;
    }
    /**
     * Set TicketBackgroundImageFileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackgroundImageFileType
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketBackgroundImageFileType($ticketBackgroundImageFileType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackgroundImageFileType) && !is_string($ticketBackgroundImageFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackgroundImageFileType, true), gettype($ticketBackgroundImageFileType)), __LINE__);
        }
        if (is_null($ticketBackgroundImageFileType) || (is_array($ticketBackgroundImageFileType) && empty($ticketBackgroundImageFileType))) {
            unset($this->TicketBackgroundImageFileType);
        } else {
            $this->TicketBackgroundImageFileType = $ticketBackgroundImageFileType;
        }
        return $this;
    }
    /**
     * Get TicketBackgroundImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackgroundImageGuid()
    {
        return isset($this->TicketBackgroundImageGuid) ? $this->TicketBackgroundImageGuid : null;
    }
    /**
     * Set TicketBackgroundImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackgroundImageGuid
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketBackgroundImageGuid($ticketBackgroundImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackgroundImageGuid) && !is_string($ticketBackgroundImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackgroundImageGuid, true), gettype($ticketBackgroundImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketBackgroundImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketBackgroundImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketBackgroundImageGuid, true)), __LINE__);
        }
        if (is_null($ticketBackgroundImageGuid) || (is_array($ticketBackgroundImageGuid) && empty($ticketBackgroundImageGuid))) {
            unset($this->TicketBackgroundImageGuid);
        } else {
            $this->TicketBackgroundImageGuid = $ticketBackgroundImageGuid;
        }
        return $this;
    }
    /**
     * Get TicketSponsorshipLogoFileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSponsorshipLogoFileType()
    {
        return isset($this->TicketSponsorshipLogoFileType) ? $this->TicketSponsorshipLogoFileType : null;
    }
    /**
     * Set TicketSponsorshipLogoFileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSponsorshipLogoFileType
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketSponsorshipLogoFileType($ticketSponsorshipLogoFileType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSponsorshipLogoFileType) && !is_string($ticketSponsorshipLogoFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSponsorshipLogoFileType, true), gettype($ticketSponsorshipLogoFileType)), __LINE__);
        }
        if (is_null($ticketSponsorshipLogoFileType) || (is_array($ticketSponsorshipLogoFileType) && empty($ticketSponsorshipLogoFileType))) {
            unset($this->TicketSponsorshipLogoFileType);
        } else {
            $this->TicketSponsorshipLogoFileType = $ticketSponsorshipLogoFileType;
        }
        return $this;
    }
    /**
     * Get TicketSponsorshipLogoGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSponsorshipLogoGuid()
    {
        return isset($this->TicketSponsorshipLogoGuid) ? $this->TicketSponsorshipLogoGuid : null;
    }
    /**
     * Set TicketSponsorshipLogoGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSponsorshipLogoGuid
     * @return \patest\StructType\TicketStyleOverride
     */
    public function setTicketSponsorshipLogoGuid($ticketSponsorshipLogoGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSponsorshipLogoGuid) && !is_string($ticketSponsorshipLogoGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSponsorshipLogoGuid, true), gettype($ticketSponsorshipLogoGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSponsorshipLogoGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSponsorshipLogoGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSponsorshipLogoGuid, true)), __LINE__);
        }
        if (is_null($ticketSponsorshipLogoGuid) || (is_array($ticketSponsorshipLogoGuid) && empty($ticketSponsorshipLogoGuid))) {
            unset($this->TicketSponsorshipLogoGuid);
        } else {
            $this->TicketSponsorshipLogoGuid = $ticketSponsorshipLogoGuid;
        }
        return $this;
    }
}
