<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketFooterNote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketFooterNote
 * @subpackage Structs
 */
class TicketFooterNote extends AbstractStructBase
{
    /**
     * The FreeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreeText;
    /**
     * The PropertyToShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PropertyToShow;
    /**
     * The TicketFooterNoteLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketFooterNoteLabel;
    /**
     * Constructor method for TicketFooterNote
     * @uses TicketFooterNote::setFreeText()
     * @uses TicketFooterNote::setPropertyToShow()
     * @uses TicketFooterNote::setTicketFooterNoteLabel()
     * @param string $freeText
     * @param string $propertyToShow
     * @param string $ticketFooterNoteLabel
     */
    public function __construct($freeText = null, $propertyToShow = null, $ticketFooterNoteLabel = null)
    {
        $this
            ->setFreeText($freeText)
            ->setPropertyToShow($propertyToShow)
            ->setTicketFooterNoteLabel($ticketFooterNoteLabel);
    }
    /**
     * Get FreeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreeText()
    {
        return isset($this->FreeText) ? $this->FreeText : null;
    }
    /**
     * Set FreeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freeText
     * @return \patest\StructType\TicketFooterNote
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeText, true), gettype($freeText)), __LINE__);
        }
        if (is_null($freeText) || (is_array($freeText) && empty($freeText))) {
            unset($this->FreeText);
        } else {
            $this->FreeText = $freeText;
        }
        return $this;
    }
    /**
     * Get PropertyToShow value
     * @return string|null
     */
    public function getPropertyToShow()
    {
        return $this->PropertyToShow;
    }
    /**
     * Set PropertyToShow value
     * @uses \patest\EnumType\TicketFooterNotePropertyTypes::valueIsValid()
     * @uses \patest\EnumType\TicketFooterNotePropertyTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyToShow
     * @return \patest\StructType\TicketFooterNote
     */
    public function setPropertyToShow($propertyToShow = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketFooterNotePropertyTypes::valueIsValid($propertyToShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketFooterNotePropertyTypes', is_array($propertyToShow) ? implode(', ', $propertyToShow) : var_export($propertyToShow, true), implode(', ', \patest\EnumType\TicketFooterNotePropertyTypes::getValidValues())), __LINE__);
        }
        $this->PropertyToShow = $propertyToShow;
        return $this;
    }
    /**
     * Get TicketFooterNoteLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketFooterNoteLabel()
    {
        return isset($this->TicketFooterNoteLabel) ? $this->TicketFooterNoteLabel : null;
    }
    /**
     * Set TicketFooterNoteLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketFooterNoteLabel
     * @return \patest\StructType\TicketFooterNote
     */
    public function setTicketFooterNoteLabel($ticketFooterNoteLabel = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFooterNoteLabel) && !is_string($ticketFooterNoteLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketFooterNoteLabel, true), gettype($ticketFooterNoteLabel)), __LINE__);
        }
        if (is_null($ticketFooterNoteLabel) || (is_array($ticketFooterNoteLabel) && empty($ticketFooterNoteLabel))) {
            unset($this->TicketFooterNoteLabel);
        } else {
            $this->TicketFooterNoteLabel = $ticketFooterNoteLabel;
        }
        return $this;
    }
}
