<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TestGetNextRandomBarcodeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TestGetNextRandomBarcodeRequest
 * @subpackage Structs
 */
class TestGetNextRandomBarcodeRequest extends ExtensibleDataContract
{
    /**
     * The BarcodesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BarcodesCount;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * Constructor method for TestGetNextRandomBarcodeRequest
     * @uses TestGetNextRandomBarcodeRequest::setBarcodesCount()
     * @uses TestGetNextRandomBarcodeRequest::setEventId()
     * @param int $barcodesCount
     * @param string $eventId
     */
    public function __construct($barcodesCount = null, $eventId = null)
    {
        $this
            ->setBarcodesCount($barcodesCount)
            ->setEventId($eventId);
    }
    /**
     * Get BarcodesCount value
     * @return int|null
     */
    public function getBarcodesCount()
    {
        return $this->BarcodesCount;
    }
    /**
     * Set BarcodesCount value
     * @param int $barcodesCount
     * @return \patest\StructType\TestGetNextRandomBarcodeRequest
     */
    public function setBarcodesCount($barcodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($barcodesCount) && !(is_int($barcodesCount) || ctype_digit($barcodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodesCount, true), gettype($barcodesCount)), __LINE__);
        }
        $this->BarcodesCount = $barcodesCount;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\TestGetNextRandomBarcodeRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
}
