<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription.SubscriptionInstanceTicketIsAssignableTo
 * StructType
 * @subpackage Structs
 */
class Subscription_SubscriptionInstanceTicketIsAssignableTo extends AnyEntity
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Balance;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SubscriptionNameAndNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNameAndNumber;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubsTicketsBalanceOutOfTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsTicketsBalanceOutOfTotal;
    /**
     * The TicketSubscriptionsAvailablity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSubscriptionsAvailablity;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Total;
    /**
     * Constructor method for Subscription.SubscriptionInstanceTicketIsAssignableTo
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setAreaName()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setBalance()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setId()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setRowName()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSeatName()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSeriesId()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSeriesName()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSubscriptionNameAndNumber()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSubscriptionNumber()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setSubsTicketsBalanceOutOfTotal()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setTicketSubscriptionsAvailablity()
     * @uses Subscription_SubscriptionInstanceTicketIsAssignableTo::setTotal()
     * @param \patest\StructType\GlobalString $areaName
     * @param int $balance
     * @param string $id
     * @param string $rowName
     * @param string $seatName
     * @param string $seriesId
     * @param string $seriesName
     * @param string $subscriptionNameAndNumber
     * @param string $subscriptionNumber
     * @param string $subsTicketsBalanceOutOfTotal
     * @param string $ticketSubscriptionsAvailablity
     * @param int $total
     */
    public function __construct(\patest\StructType\GlobalString $areaName = null, $balance = null, $id = null, $rowName = null, $seatName = null, $seriesId = null, $seriesName = null, $subscriptionNameAndNumber = null, $subscriptionNumber = null, $subsTicketsBalanceOutOfTotal = null, $ticketSubscriptionsAvailablity = null, $total = null)
    {
        $this
            ->setAreaName($areaName)
            ->setBalance($balance)
            ->setId($id)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName)
            ->setSubscriptionNameAndNumber($subscriptionNameAndNumber)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubsTicketsBalanceOutOfTotal($subsTicketsBalanceOutOfTotal)
            ->setTicketSubscriptionsAvailablity($ticketSubscriptionsAvailablity)
            ->setTotal($total);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $balance
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: int
        if (!is_null($balance) && !(is_int($balance) || ctype_digit($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SubscriptionNameAndNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNameAndNumber()
    {
        return isset($this->SubscriptionNameAndNumber) ? $this->SubscriptionNameAndNumber : null;
    }
    /**
     * Set SubscriptionNameAndNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNameAndNumber
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSubscriptionNameAndNumber($subscriptionNameAndNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNameAndNumber) && !is_string($subscriptionNameAndNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNameAndNumber, true), gettype($subscriptionNameAndNumber)), __LINE__);
        }
        if (is_null($subscriptionNameAndNumber) || (is_array($subscriptionNameAndNumber) && empty($subscriptionNameAndNumber))) {
            unset($this->SubscriptionNameAndNumber);
        } else {
            $this->SubscriptionNameAndNumber = $subscriptionNameAndNumber;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubsTicketsBalanceOutOfTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsTicketsBalanceOutOfTotal()
    {
        return isset($this->SubsTicketsBalanceOutOfTotal) ? $this->SubsTicketsBalanceOutOfTotal : null;
    }
    /**
     * Set SubsTicketsBalanceOutOfTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsTicketsBalanceOutOfTotal
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setSubsTicketsBalanceOutOfTotal($subsTicketsBalanceOutOfTotal = null)
    {
        // validation for constraint: string
        if (!is_null($subsTicketsBalanceOutOfTotal) && !is_string($subsTicketsBalanceOutOfTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsTicketsBalanceOutOfTotal, true), gettype($subsTicketsBalanceOutOfTotal)), __LINE__);
        }
        if (is_null($subsTicketsBalanceOutOfTotal) || (is_array($subsTicketsBalanceOutOfTotal) && empty($subsTicketsBalanceOutOfTotal))) {
            unset($this->SubsTicketsBalanceOutOfTotal);
        } else {
            $this->SubsTicketsBalanceOutOfTotal = $subsTicketsBalanceOutOfTotal;
        }
        return $this;
    }
    /**
     * Get TicketSubscriptionsAvailablity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSubscriptionsAvailablity()
    {
        return isset($this->TicketSubscriptionsAvailablity) ? $this->TicketSubscriptionsAvailablity : null;
    }
    /**
     * Set TicketSubscriptionsAvailablity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSubscriptionsAvailablityStatus::valueIsValid()
     * @uses \patest\EnumType\TicketSubscriptionsAvailablityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketSubscriptionsAvailablity
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setTicketSubscriptionsAvailablity($ticketSubscriptionsAvailablity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSubscriptionsAvailablityStatus::valueIsValid($ticketSubscriptionsAvailablity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSubscriptionsAvailablityStatus', is_array($ticketSubscriptionsAvailablity) ? implode(', ', $ticketSubscriptionsAvailablity) : var_export($ticketSubscriptionsAvailablity, true), implode(', ', \patest\EnumType\TicketSubscriptionsAvailablityStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketSubscriptionsAvailablity) || (is_array($ticketSubscriptionsAvailablity) && empty($ticketSubscriptionsAvailablity))) {
            unset($this->TicketSubscriptionsAvailablity);
        } else {
            $this->TicketSubscriptionsAvailablity = $ticketSubscriptionsAvailablity;
        }
        return $this;
    }
    /**
     * Get Total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->Total) ? $this->Total : null;
    }
    /**
     * Set Total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \patest\StructType\Subscription_SubscriptionInstanceTicketIsAssignableTo
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->Total);
        } else {
            $this->Total = $total;
        }
        return $this;
    }
}
