<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionTicketOperationRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscriptionTicketOperationRequestBase
 * @subpackage Structs
 */
class SubscriptionTicketOperationRequestBase extends ExtensibleDataContract
{
    /**
     * The ChangeSubsTicketAppliedPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public $ChangeSubsTicketAppliedPriceList;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableExistingTicketProperty
     */
    public $Tickets;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for SubscriptionTicketOperationRequestBase
     * @uses SubscriptionTicketOperationRequestBase::setChangeSubsTicketAppliedPriceList()
     * @uses SubscriptionTicketOperationRequestBase::setClientId()
     * @uses SubscriptionTicketOperationRequestBase::setTickets()
     * @uses SubscriptionTicketOperationRequestBase::setTransactionGuid()
     * @uses SubscriptionTicketOperationRequestBase::setTransactionSnapshotType()
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $tickets
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null, $clientId = null, \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $tickets = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setChangeSubsTicketAppliedPriceList($changeSubsTicketAppliedPriceList)
            ->setClientId($clientId)
            ->setTickets($tickets)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get ChangeSubsTicketAppliedPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType|null
     */
    public function getChangeSubsTicketAppliedPriceList()
    {
        return isset($this->ChangeSubsTicketAppliedPriceList) ? $this->ChangeSubsTicketAppliedPriceList : null;
    }
    /**
     * Set ChangeSubsTicketAppliedPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @return \patest\StructType\SubscriptionTicketOperationRequestBase
     */
    public function setChangeSubsTicketAppliedPriceList(\patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null)
    {
        if (is_null($changeSubsTicketAppliedPriceList) || (is_array($changeSubsTicketAppliedPriceList) && empty($changeSubsTicketAppliedPriceList))) {
            unset($this->ChangeSubsTicketAppliedPriceList);
        } else {
            $this->ChangeSubsTicketAppliedPriceList = $changeSubsTicketAppliedPriceList;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\SubscriptionTicketOperationRequestBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableExistingTicketProperty|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $tickets
     * @return \patest\StructType\SubscriptionTicketOperationRequestBase
     */
    public function setTickets(\patest\ArrayType\ArrayOfOverridableExistingTicketProperty $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\SubscriptionTicketOperationRequestBase
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\SubscriptionTicketOperationRequestBase
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
