<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetPrintOptionsForFollowUpBasketPrint-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetPrintOptionsForFollowUpBasketPrint-Request
 * @subpackage Structs
 */
class SetPrintOptionsForFollowUpBasketPrint_Request extends SetPrintOptionsBaseRequest
{
    /**
     * The DocumentTypesToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $DocumentTypesToPrint;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for SetPrintOptionsForFollowUpBasketPrint-Request
     * @uses SetPrintOptionsForFollowUpBasketPrint_Request::setDocumentTypesToPrint()
     * @uses SetPrintOptionsForFollowUpBasketPrint_Request::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null, $transactionGuid = null)
    {
        $this
            ->setDocumentTypesToPrint($documentTypesToPrint)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get DocumentTypesToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getDocumentTypesToPrint()
    {
        return isset($this->DocumentTypesToPrint) ? $this->DocumentTypesToPrint : null;
    }
    /**
     * Set DocumentTypesToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @return \patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Request
     */
    public function setDocumentTypesToPrint(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null)
    {
        if (is_null($documentTypesToPrint) || (is_array($documentTypesToPrint) && empty($documentTypesToPrint))) {
            unset($this->DocumentTypesToPrint);
        } else {
            $this->DocumentTypesToPrint = $documentTypesToPrint;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
