<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendFollowUpBasketToPrint-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendFollowUpBasketToPrint-Request
 * @subpackage Structs
 */
class SendFollowUpBasketToPrint_Request extends SendToPrintRequestBase
{
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ItemIds;
    /**
     * The ItemTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemTypes;
    /**
     * The KeepOriginalBarcodesOnReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KeepOriginalBarcodesOnReprint;
    /**
     * The Reprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Reprint;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for SendFollowUpBasketToPrint-Request
     * @uses SendFollowUpBasketToPrint_Request::setItemIds()
     * @uses SendFollowUpBasketToPrint_Request::setItemTypes()
     * @uses SendFollowUpBasketToPrint_Request::setKeepOriginalBarcodesOnReprint()
     * @uses SendFollowUpBasketToPrint_Request::setReprint()
     * @uses SendFollowUpBasketToPrint_Request::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @param \patest\ArrayType\ArrayOfint $itemTypes
     * @param bool $keepOriginalBarcodesOnReprint
     * @param bool $reprint
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $itemIds = null, \patest\ArrayType\ArrayOfint $itemTypes = null, $keepOriginalBarcodesOnReprint = null, $reprint = null, $transactionGuid = null)
    {
        $this
            ->setItemIds($itemIds)
            ->setItemTypes($itemTypes)
            ->setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint)
            ->setReprint($reprint)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $itemIds
     * @return \patest\StructType\SendFollowUpBasketToPrint_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfguid $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get ItemTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemTypes()
    {
        return isset($this->ItemTypes) ? $this->ItemTypes : null;
    }
    /**
     * Set ItemTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemTypes
     * @return \patest\StructType\SendFollowUpBasketToPrint_Request
     */
    public function setItemTypes(\patest\ArrayType\ArrayOfint $itemTypes = null)
    {
        if (is_null($itemTypes) || (is_array($itemTypes) && empty($itemTypes))) {
            unset($this->ItemTypes);
        } else {
            $this->ItemTypes = $itemTypes;
        }
        return $this;
    }
    /**
     * Get KeepOriginalBarcodesOnReprint value
     * @return bool|null
     */
    public function getKeepOriginalBarcodesOnReprint()
    {
        return $this->KeepOriginalBarcodesOnReprint;
    }
    /**
     * Set KeepOriginalBarcodesOnReprint value
     * @param bool $keepOriginalBarcodesOnReprint
     * @return \patest\StructType\SendFollowUpBasketToPrint_Request
     */
    public function setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOriginalBarcodesOnReprint) && !is_bool($keepOriginalBarcodesOnReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOriginalBarcodesOnReprint, true), gettype($keepOriginalBarcodesOnReprint)), __LINE__);
        }
        $this->KeepOriginalBarcodesOnReprint = $keepOriginalBarcodesOnReprint;
        return $this;
    }
    /**
     * Get Reprint value
     * @return bool|null
     */
    public function getReprint()
    {
        return $this->Reprint;
    }
    /**
     * Set Reprint value
     * @param bool $reprint
     * @return \patest\StructType\SendFollowUpBasketToPrint_Request
     */
    public function setReprint($reprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprint) && !is_bool($reprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reprint, true), gettype($reprint)), __LINE__);
        }
        $this->Reprint = $reprint;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\SendFollowUpBasketToPrint_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
