<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendBasketToPrint-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendBasketToPrint-Response
 * @subpackage Structs
 */
class SendBasketToPrint_Response extends ExtensibleDataContract
{
    /**
     * The NothingToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NothingToPrint;
    /**
     * The SpoolGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolGroupId;
    /**
     * Constructor method for SendBasketToPrint-Response
     * @uses SendBasketToPrint_Response::setNothingToPrint()
     * @uses SendBasketToPrint_Response::setSpoolGroupId()
     * @param bool $nothingToPrint
     * @param string $spoolGroupId
     */
    public function __construct($nothingToPrint = null, $spoolGroupId = null)
    {
        $this
            ->setNothingToPrint($nothingToPrint)
            ->setSpoolGroupId($spoolGroupId);
    }
    /**
     * Get NothingToPrint value
     * @return bool|null
     */
    public function getNothingToPrint()
    {
        return $this->NothingToPrint;
    }
    /**
     * Set NothingToPrint value
     * @param bool $nothingToPrint
     * @return \patest\StructType\SendBasketToPrint_Response
     */
    public function setNothingToPrint($nothingToPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($nothingToPrint) && !is_bool($nothingToPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nothingToPrint, true), gettype($nothingToPrint)), __LINE__);
        }
        $this->NothingToPrint = $nothingToPrint;
        return $this;
    }
    /**
     * Get SpoolGroupId value
     * @return string|null
     */
    public function getSpoolGroupId()
    {
        return $this->SpoolGroupId;
    }
    /**
     * Set SpoolGroupId value
     * @param string $spoolGroupId
     * @return \patest\StructType\SendBasketToPrint_Response
     */
    public function setSpoolGroupId($spoolGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolGroupId) && !is_string($spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolGroupId, true), gettype($spoolGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolGroupId, true)), __LINE__);
        }
        $this->SpoolGroupId = $spoolGroupId;
        return $this;
    }
}
