<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.UserPasswordPolicyParameters StructType
 * @subpackage Structs
 */
class Security_UserPasswordPolicyParameters extends AnyEntity
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The User_CheckPasswordDoesNotContainUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_CheckPasswordDoesNotContainUserName;
    /**
     * The User_CheckPasswordHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_CheckPasswordHistory;
    /**
     * The User_InvalidPasswordAttemptsPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_InvalidPasswordAttemptsPeriodInMinutes;
    /**
     * The User_LockPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_LockPeriodInMinutes;
    /**
     * The User_MaxInvalidPasswordAttemptsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_MaxInvalidPasswordAttemptsCount;
    /**
     * The User_MinPasswordLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_MinPasswordLength;
    /**
     * The User_PasswordExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_PasswordExpirationDays;
    /**
     * The User_PasswordMustHaveAlphaNumericCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveAlphaNumericCharacters;
    /**
     * The User_PasswordMustHaveLowerAndUpperCaseCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveLowerAndUpperCaseCharacters;
    /**
     * The User_PasswordMustHaveSpecialCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveSpecialCharacters;
    /**
     * The User_PasswordsHistoryDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_PasswordsHistoryDepth;
    /**
     * The User_UserMustChangePasswordOnFirstLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_UserMustChangePasswordOnFirstLogin;
    /**
     * Constructor method for Security.UserPasswordPolicyParameters
     * @uses Security_UserPasswordPolicyParameters::setId()
     * @uses Security_UserPasswordPolicyParameters::setUser_CheckPasswordDoesNotContainUserName()
     * @uses Security_UserPasswordPolicyParameters::setUser_CheckPasswordHistory()
     * @uses Security_UserPasswordPolicyParameters::setUser_InvalidPasswordAttemptsPeriodInMinutes()
     * @uses Security_UserPasswordPolicyParameters::setUser_LockPeriodInMinutes()
     * @uses Security_UserPasswordPolicyParameters::setUser_MaxInvalidPasswordAttemptsCount()
     * @uses Security_UserPasswordPolicyParameters::setUser_MinPasswordLength()
     * @uses Security_UserPasswordPolicyParameters::setUser_PasswordExpirationDays()
     * @uses Security_UserPasswordPolicyParameters::setUser_PasswordMustHaveAlphaNumericCharacters()
     * @uses Security_UserPasswordPolicyParameters::setUser_PasswordMustHaveLowerAndUpperCaseCharacters()
     * @uses Security_UserPasswordPolicyParameters::setUser_PasswordMustHaveSpecialCharacters()
     * @uses Security_UserPasswordPolicyParameters::setUser_PasswordsHistoryDepth()
     * @uses Security_UserPasswordPolicyParameters::setUser_UserMustChangePasswordOnFirstLogin()
     * @param string $id
     * @param bool $user_CheckPasswordDoesNotContainUserName
     * @param bool $user_CheckPasswordHistory
     * @param int $user_InvalidPasswordAttemptsPeriodInMinutes
     * @param int $user_LockPeriodInMinutes
     * @param int $user_MaxInvalidPasswordAttemptsCount
     * @param int $user_MinPasswordLength
     * @param int $user_PasswordExpirationDays
     * @param bool $user_PasswordMustHaveAlphaNumericCharacters
     * @param bool $user_PasswordMustHaveLowerAndUpperCaseCharacters
     * @param bool $user_PasswordMustHaveSpecialCharacters
     * @param int $user_PasswordsHistoryDepth
     * @param bool $user_UserMustChangePasswordOnFirstLogin
     */
    public function __construct($id = null, $user_CheckPasswordDoesNotContainUserName = null, $user_CheckPasswordHistory = null, $user_InvalidPasswordAttemptsPeriodInMinutes = null, $user_LockPeriodInMinutes = null, $user_MaxInvalidPasswordAttemptsCount = null, $user_MinPasswordLength = null, $user_PasswordExpirationDays = null, $user_PasswordMustHaveAlphaNumericCharacters = null, $user_PasswordMustHaveLowerAndUpperCaseCharacters = null, $user_PasswordMustHaveSpecialCharacters = null, $user_PasswordsHistoryDepth = null, $user_UserMustChangePasswordOnFirstLogin = null)
    {
        $this
            ->setId($id)
            ->setUser_CheckPasswordDoesNotContainUserName($user_CheckPasswordDoesNotContainUserName)
            ->setUser_CheckPasswordHistory($user_CheckPasswordHistory)
            ->setUser_InvalidPasswordAttemptsPeriodInMinutes($user_InvalidPasswordAttemptsPeriodInMinutes)
            ->setUser_LockPeriodInMinutes($user_LockPeriodInMinutes)
            ->setUser_MaxInvalidPasswordAttemptsCount($user_MaxInvalidPasswordAttemptsCount)
            ->setUser_MinPasswordLength($user_MinPasswordLength)
            ->setUser_PasswordExpirationDays($user_PasswordExpirationDays)
            ->setUser_PasswordMustHaveAlphaNumericCharacters($user_PasswordMustHaveAlphaNumericCharacters)
            ->setUser_PasswordMustHaveLowerAndUpperCaseCharacters($user_PasswordMustHaveLowerAndUpperCaseCharacters)
            ->setUser_PasswordMustHaveSpecialCharacters($user_PasswordMustHaveSpecialCharacters)
            ->setUser_PasswordsHistoryDepth($user_PasswordsHistoryDepth)
            ->setUser_UserMustChangePasswordOnFirstLogin($user_UserMustChangePasswordOnFirstLogin);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get User_CheckPasswordDoesNotContainUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_CheckPasswordDoesNotContainUserName()
    {
        return isset($this->User_CheckPasswordDoesNotContainUserName) ? $this->User_CheckPasswordDoesNotContainUserName : null;
    }
    /**
     * Set User_CheckPasswordDoesNotContainUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_CheckPasswordDoesNotContainUserName
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_CheckPasswordDoesNotContainUserName($user_CheckPasswordDoesNotContainUserName = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_CheckPasswordDoesNotContainUserName) && !is_bool($user_CheckPasswordDoesNotContainUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_CheckPasswordDoesNotContainUserName, true), gettype($user_CheckPasswordDoesNotContainUserName)), __LINE__);
        }
        if (is_null($user_CheckPasswordDoesNotContainUserName) || (is_array($user_CheckPasswordDoesNotContainUserName) && empty($user_CheckPasswordDoesNotContainUserName))) {
            unset($this->User_CheckPasswordDoesNotContainUserName);
        } else {
            $this->User_CheckPasswordDoesNotContainUserName = $user_CheckPasswordDoesNotContainUserName;
        }
        return $this;
    }
    /**
     * Get User_CheckPasswordHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_CheckPasswordHistory()
    {
        return isset($this->User_CheckPasswordHistory) ? $this->User_CheckPasswordHistory : null;
    }
    /**
     * Set User_CheckPasswordHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_CheckPasswordHistory
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_CheckPasswordHistory($user_CheckPasswordHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_CheckPasswordHistory) && !is_bool($user_CheckPasswordHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_CheckPasswordHistory, true), gettype($user_CheckPasswordHistory)), __LINE__);
        }
        if (is_null($user_CheckPasswordHistory) || (is_array($user_CheckPasswordHistory) && empty($user_CheckPasswordHistory))) {
            unset($this->User_CheckPasswordHistory);
        } else {
            $this->User_CheckPasswordHistory = $user_CheckPasswordHistory;
        }
        return $this;
    }
    /**
     * Get User_InvalidPasswordAttemptsPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_InvalidPasswordAttemptsPeriodInMinutes()
    {
        return isset($this->User_InvalidPasswordAttemptsPeriodInMinutes) ? $this->User_InvalidPasswordAttemptsPeriodInMinutes : null;
    }
    /**
     * Set User_InvalidPasswordAttemptsPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_InvalidPasswordAttemptsPeriodInMinutes
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_InvalidPasswordAttemptsPeriodInMinutes($user_InvalidPasswordAttemptsPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($user_InvalidPasswordAttemptsPeriodInMinutes) && !(is_int($user_InvalidPasswordAttemptsPeriodInMinutes) || ctype_digit($user_InvalidPasswordAttemptsPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_InvalidPasswordAttemptsPeriodInMinutes, true), gettype($user_InvalidPasswordAttemptsPeriodInMinutes)), __LINE__);
        }
        if (is_null($user_InvalidPasswordAttemptsPeriodInMinutes) || (is_array($user_InvalidPasswordAttemptsPeriodInMinutes) && empty($user_InvalidPasswordAttemptsPeriodInMinutes))) {
            unset($this->User_InvalidPasswordAttemptsPeriodInMinutes);
        } else {
            $this->User_InvalidPasswordAttemptsPeriodInMinutes = $user_InvalidPasswordAttemptsPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get User_LockPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_LockPeriodInMinutes()
    {
        return isset($this->User_LockPeriodInMinutes) ? $this->User_LockPeriodInMinutes : null;
    }
    /**
     * Set User_LockPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_LockPeriodInMinutes
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_LockPeriodInMinutes($user_LockPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($user_LockPeriodInMinutes) && !(is_int($user_LockPeriodInMinutes) || ctype_digit($user_LockPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_LockPeriodInMinutes, true), gettype($user_LockPeriodInMinutes)), __LINE__);
        }
        if (is_null($user_LockPeriodInMinutes) || (is_array($user_LockPeriodInMinutes) && empty($user_LockPeriodInMinutes))) {
            unset($this->User_LockPeriodInMinutes);
        } else {
            $this->User_LockPeriodInMinutes = $user_LockPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get User_MaxInvalidPasswordAttemptsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_MaxInvalidPasswordAttemptsCount()
    {
        return isset($this->User_MaxInvalidPasswordAttemptsCount) ? $this->User_MaxInvalidPasswordAttemptsCount : null;
    }
    /**
     * Set User_MaxInvalidPasswordAttemptsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_MaxInvalidPasswordAttemptsCount
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_MaxInvalidPasswordAttemptsCount($user_MaxInvalidPasswordAttemptsCount = null)
    {
        // validation for constraint: int
        if (!is_null($user_MaxInvalidPasswordAttemptsCount) && !(is_int($user_MaxInvalidPasswordAttemptsCount) || ctype_digit($user_MaxInvalidPasswordAttemptsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_MaxInvalidPasswordAttemptsCount, true), gettype($user_MaxInvalidPasswordAttemptsCount)), __LINE__);
        }
        if (is_null($user_MaxInvalidPasswordAttemptsCount) || (is_array($user_MaxInvalidPasswordAttemptsCount) && empty($user_MaxInvalidPasswordAttemptsCount))) {
            unset($this->User_MaxInvalidPasswordAttemptsCount);
        } else {
            $this->User_MaxInvalidPasswordAttemptsCount = $user_MaxInvalidPasswordAttemptsCount;
        }
        return $this;
    }
    /**
     * Get User_MinPasswordLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_MinPasswordLength()
    {
        return isset($this->User_MinPasswordLength) ? $this->User_MinPasswordLength : null;
    }
    /**
     * Set User_MinPasswordLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_MinPasswordLength
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_MinPasswordLength($user_MinPasswordLength = null)
    {
        // validation for constraint: int
        if (!is_null($user_MinPasswordLength) && !(is_int($user_MinPasswordLength) || ctype_digit($user_MinPasswordLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_MinPasswordLength, true), gettype($user_MinPasswordLength)), __LINE__);
        }
        if (is_null($user_MinPasswordLength) || (is_array($user_MinPasswordLength) && empty($user_MinPasswordLength))) {
            unset($this->User_MinPasswordLength);
        } else {
            $this->User_MinPasswordLength = $user_MinPasswordLength;
        }
        return $this;
    }
    /**
     * Get User_PasswordExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_PasswordExpirationDays()
    {
        return isset($this->User_PasswordExpirationDays) ? $this->User_PasswordExpirationDays : null;
    }
    /**
     * Set User_PasswordExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_PasswordExpirationDays
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_PasswordExpirationDays($user_PasswordExpirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($user_PasswordExpirationDays) && !(is_int($user_PasswordExpirationDays) || ctype_digit($user_PasswordExpirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_PasswordExpirationDays, true), gettype($user_PasswordExpirationDays)), __LINE__);
        }
        if (is_null($user_PasswordExpirationDays) || (is_array($user_PasswordExpirationDays) && empty($user_PasswordExpirationDays))) {
            unset($this->User_PasswordExpirationDays);
        } else {
            $this->User_PasswordExpirationDays = $user_PasswordExpirationDays;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveAlphaNumericCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveAlphaNumericCharacters()
    {
        return isset($this->User_PasswordMustHaveAlphaNumericCharacters) ? $this->User_PasswordMustHaveAlphaNumericCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveAlphaNumericCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveAlphaNumericCharacters
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_PasswordMustHaveAlphaNumericCharacters($user_PasswordMustHaveAlphaNumericCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveAlphaNumericCharacters) && !is_bool($user_PasswordMustHaveAlphaNumericCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveAlphaNumericCharacters, true), gettype($user_PasswordMustHaveAlphaNumericCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveAlphaNumericCharacters) || (is_array($user_PasswordMustHaveAlphaNumericCharacters) && empty($user_PasswordMustHaveAlphaNumericCharacters))) {
            unset($this->User_PasswordMustHaveAlphaNumericCharacters);
        } else {
            $this->User_PasswordMustHaveAlphaNumericCharacters = $user_PasswordMustHaveAlphaNumericCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveLowerAndUpperCaseCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveLowerAndUpperCaseCharacters()
    {
        return isset($this->User_PasswordMustHaveLowerAndUpperCaseCharacters) ? $this->User_PasswordMustHaveLowerAndUpperCaseCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveLowerAndUpperCaseCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveLowerAndUpperCaseCharacters
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_PasswordMustHaveLowerAndUpperCaseCharacters($user_PasswordMustHaveLowerAndUpperCaseCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveLowerAndUpperCaseCharacters) && !is_bool($user_PasswordMustHaveLowerAndUpperCaseCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveLowerAndUpperCaseCharacters, true), gettype($user_PasswordMustHaveLowerAndUpperCaseCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveLowerAndUpperCaseCharacters) || (is_array($user_PasswordMustHaveLowerAndUpperCaseCharacters) && empty($user_PasswordMustHaveLowerAndUpperCaseCharacters))) {
            unset($this->User_PasswordMustHaveLowerAndUpperCaseCharacters);
        } else {
            $this->User_PasswordMustHaveLowerAndUpperCaseCharacters = $user_PasswordMustHaveLowerAndUpperCaseCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveSpecialCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveSpecialCharacters()
    {
        return isset($this->User_PasswordMustHaveSpecialCharacters) ? $this->User_PasswordMustHaveSpecialCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveSpecialCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveSpecialCharacters
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_PasswordMustHaveSpecialCharacters($user_PasswordMustHaveSpecialCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveSpecialCharacters) && !is_bool($user_PasswordMustHaveSpecialCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveSpecialCharacters, true), gettype($user_PasswordMustHaveSpecialCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveSpecialCharacters) || (is_array($user_PasswordMustHaveSpecialCharacters) && empty($user_PasswordMustHaveSpecialCharacters))) {
            unset($this->User_PasswordMustHaveSpecialCharacters);
        } else {
            $this->User_PasswordMustHaveSpecialCharacters = $user_PasswordMustHaveSpecialCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordsHistoryDepth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_PasswordsHistoryDepth()
    {
        return isset($this->User_PasswordsHistoryDepth) ? $this->User_PasswordsHistoryDepth : null;
    }
    /**
     * Set User_PasswordsHistoryDepth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_PasswordsHistoryDepth
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_PasswordsHistoryDepth($user_PasswordsHistoryDepth = null)
    {
        // validation for constraint: int
        if (!is_null($user_PasswordsHistoryDepth) && !(is_int($user_PasswordsHistoryDepth) || ctype_digit($user_PasswordsHistoryDepth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_PasswordsHistoryDepth, true), gettype($user_PasswordsHistoryDepth)), __LINE__);
        }
        if (is_null($user_PasswordsHistoryDepth) || (is_array($user_PasswordsHistoryDepth) && empty($user_PasswordsHistoryDepth))) {
            unset($this->User_PasswordsHistoryDepth);
        } else {
            $this->User_PasswordsHistoryDepth = $user_PasswordsHistoryDepth;
        }
        return $this;
    }
    /**
     * Get User_UserMustChangePasswordOnFirstLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_UserMustChangePasswordOnFirstLogin()
    {
        return isset($this->User_UserMustChangePasswordOnFirstLogin) ? $this->User_UserMustChangePasswordOnFirstLogin : null;
    }
    /**
     * Set User_UserMustChangePasswordOnFirstLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_UserMustChangePasswordOnFirstLogin
     * @return \patest\StructType\Security_UserPasswordPolicyParameters
     */
    public function setUser_UserMustChangePasswordOnFirstLogin($user_UserMustChangePasswordOnFirstLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_UserMustChangePasswordOnFirstLogin) && !is_bool($user_UserMustChangePasswordOnFirstLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_UserMustChangePasswordOnFirstLogin, true), gettype($user_UserMustChangePasswordOnFirstLogin)), __LINE__);
        }
        if (is_null($user_UserMustChangePasswordOnFirstLogin) || (is_array($user_UserMustChangePasswordOnFirstLogin) && empty($user_UserMustChangePasswordOnFirstLogin))) {
            unset($this->User_UserMustChangePasswordOnFirstLogin);
        } else {
            $this->User_UserMustChangePasswordOnFirstLogin = $user_UserMustChangePasswordOnFirstLogin;
        }
        return $this;
    }
}
