<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SroWebApiCompanyParameters StructType
 * @subpackage Structs
 */
class Security_SroWebApiCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AwayClubBadgeDefaultSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AwayClubBadgeDefaultSource;
    /**
     * The AwayClubBadgeMobileOptimizedSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AwayClubBadgeMobileOptimizedSource;
    /**
     * The BaseHexColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseHexColor;
    /**
     * The ClientTypeForMobileSdkUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientTypeForMobileSdkUser;
    /**
     * The ClubImagesBaseUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClubImagesBaseUrl;
    /**
     * The CompetitionLogoDefaultSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompetitionLogoDefaultSource;
    /**
     * The CompetitionLogoMobileOptimizedSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompetitionLogoMobileOptimizedSource;
    /**
     * The DeviceLockEnforcedFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceLockEnforcedFromDate;
    /**
     * The HideTicketBarcodeUntil
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $HideTicketBarcodeUntil;
    /**
     * The HomeClubBadgeDefaultSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeClubBadgeDefaultSource;
    /**
     * The HomeClubBadgeMobileOptimizedSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeClubBadgeMobileOptimizedSource;
    /**
     * The MobileSdkAllowTicketResaleRequestsFromRelatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MobileSdkAllowTicketResaleRequestsFromRelatives;
    /**
     * The MobileSdkDisplayMobiliseTicketsOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MobileSdkDisplayMobiliseTicketsOnline;
    /**
     * The MobileSdkEnforceSingleDeviceBinding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MobileSdkEnforceSingleDeviceBinding;
    /**
     * The MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
    /**
     * The MobileSdkSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileSdkSaleMode;
    /**
     * The MobileSdkSalePoint
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileSdkSalePoint;
    /**
     * The NumberOfDeviceChangesPermitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfDeviceChangesPermitted;
    /**
     * The RelationshipTypeEnablingTicketManage
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeEnablingTicketManage;
    /**
     * The StronglyRelatedClientsMaxAgeFilterForTicketList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StronglyRelatedClientsMaxAgeFilterForTicketList;
    /**
     * The WeblinkBaseUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeblinkBaseUrl;
    /**
     * Constructor method for Security.SroWebApiCompanyParameters
     * @uses Security_SroWebApiCompanyParameters::setAwayClubBadgeDefaultSource()
     * @uses Security_SroWebApiCompanyParameters::setAwayClubBadgeMobileOptimizedSource()
     * @uses Security_SroWebApiCompanyParameters::setBaseHexColor()
     * @uses Security_SroWebApiCompanyParameters::setClientTypeForMobileSdkUser()
     * @uses Security_SroWebApiCompanyParameters::setClubImagesBaseUrl()
     * @uses Security_SroWebApiCompanyParameters::setCompetitionLogoDefaultSource()
     * @uses Security_SroWebApiCompanyParameters::setCompetitionLogoMobileOptimizedSource()
     * @uses Security_SroWebApiCompanyParameters::setDeviceLockEnforcedFromDate()
     * @uses Security_SroWebApiCompanyParameters::setHideTicketBarcodeUntil()
     * @uses Security_SroWebApiCompanyParameters::setHomeClubBadgeDefaultSource()
     * @uses Security_SroWebApiCompanyParameters::setHomeClubBadgeMobileOptimizedSource()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkAllowTicketResaleRequestsFromRelatives()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkDisplayMobiliseTicketsOnline()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkEnforceSingleDeviceBinding()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkSaleMode()
     * @uses Security_SroWebApiCompanyParameters::setMobileSdkSalePoint()
     * @uses Security_SroWebApiCompanyParameters::setNumberOfDeviceChangesPermitted()
     * @uses Security_SroWebApiCompanyParameters::setRelationshipTypeEnablingTicketManage()
     * @uses Security_SroWebApiCompanyParameters::setStronglyRelatedClientsMaxAgeFilterForTicketList()
     * @uses Security_SroWebApiCompanyParameters::setWeblinkBaseUrl()
     * @param string $awayClubBadgeDefaultSource
     * @param string $awayClubBadgeMobileOptimizedSource
     * @param string $baseHexColor
     * @param string $clientTypeForMobileSdkUser
     * @param string $clubImagesBaseUrl
     * @param string $competitionLogoDefaultSource
     * @param string $competitionLogoMobileOptimizedSource
     * @param string $deviceLockEnforcedFromDate
     * @param string $hideTicketBarcodeUntil
     * @param string $homeClubBadgeDefaultSource
     * @param string $homeClubBadgeMobileOptimizedSource
     * @param bool $mobileSdkAllowTicketResaleRequestsFromRelatives
     * @param bool $mobileSdkDisplayMobiliseTicketsOnline
     * @param bool $mobileSdkEnforceSingleDeviceBinding
     * @param bool $mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @param string $mobileSdkSaleMode
     * @param string $mobileSdkSalePoint
     * @param int $numberOfDeviceChangesPermitted
     * @param string $relationshipTypeEnablingTicketManage
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @param string $weblinkBaseUrl
     */
    public function __construct($awayClubBadgeDefaultSource = null, $awayClubBadgeMobileOptimizedSource = null, $baseHexColor = null, $clientTypeForMobileSdkUser = null, $clubImagesBaseUrl = null, $competitionLogoDefaultSource = null, $competitionLogoMobileOptimizedSource = null, $deviceLockEnforcedFromDate = null, $hideTicketBarcodeUntil = null, $homeClubBadgeDefaultSource = null, $homeClubBadgeMobileOptimizedSource = null, $mobileSdkAllowTicketResaleRequestsFromRelatives = null, $mobileSdkDisplayMobiliseTicketsOnline = null, $mobileSdkEnforceSingleDeviceBinding = null, $mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null, $mobileSdkSaleMode = null, $mobileSdkSalePoint = null, $numberOfDeviceChangesPermitted = null, $relationshipTypeEnablingTicketManage = null, $stronglyRelatedClientsMaxAgeFilterForTicketList = null, $weblinkBaseUrl = null)
    {
        $this
            ->setAwayClubBadgeDefaultSource($awayClubBadgeDefaultSource)
            ->setAwayClubBadgeMobileOptimizedSource($awayClubBadgeMobileOptimizedSource)
            ->setBaseHexColor($baseHexColor)
            ->setClientTypeForMobileSdkUser($clientTypeForMobileSdkUser)
            ->setClubImagesBaseUrl($clubImagesBaseUrl)
            ->setCompetitionLogoDefaultSource($competitionLogoDefaultSource)
            ->setCompetitionLogoMobileOptimizedSource($competitionLogoMobileOptimizedSource)
            ->setDeviceLockEnforcedFromDate($deviceLockEnforcedFromDate)
            ->setHideTicketBarcodeUntil($hideTicketBarcodeUntil)
            ->setHomeClubBadgeDefaultSource($homeClubBadgeDefaultSource)
            ->setHomeClubBadgeMobileOptimizedSource($homeClubBadgeMobileOptimizedSource)
            ->setMobileSdkAllowTicketResaleRequestsFromRelatives($mobileSdkAllowTicketResaleRequestsFromRelatives)
            ->setMobileSdkDisplayMobiliseTicketsOnline($mobileSdkDisplayMobiliseTicketsOnline)
            ->setMobileSdkEnforceSingleDeviceBinding($mobileSdkEnforceSingleDeviceBinding)
            ->setMobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged)
            ->setMobileSdkSaleMode($mobileSdkSaleMode)
            ->setMobileSdkSalePoint($mobileSdkSalePoint)
            ->setNumberOfDeviceChangesPermitted($numberOfDeviceChangesPermitted)
            ->setRelationshipTypeEnablingTicketManage($relationshipTypeEnablingTicketManage)
            ->setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList)
            ->setWeblinkBaseUrl($weblinkBaseUrl);
    }
    /**
     * Get AwayClubBadgeDefaultSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwayClubBadgeDefaultSource()
    {
        return isset($this->AwayClubBadgeDefaultSource) ? $this->AwayClubBadgeDefaultSource : null;
    }
    /**
     * Set AwayClubBadgeDefaultSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awayClubBadgeDefaultSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setAwayClubBadgeDefaultSource($awayClubBadgeDefaultSource = null)
    {
        // validation for constraint: string
        if (!is_null($awayClubBadgeDefaultSource) && !is_string($awayClubBadgeDefaultSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awayClubBadgeDefaultSource, true), gettype($awayClubBadgeDefaultSource)), __LINE__);
        }
        if (is_null($awayClubBadgeDefaultSource) || (is_array($awayClubBadgeDefaultSource) && empty($awayClubBadgeDefaultSource))) {
            unset($this->AwayClubBadgeDefaultSource);
        } else {
            $this->AwayClubBadgeDefaultSource = $awayClubBadgeDefaultSource;
        }
        return $this;
    }
    /**
     * Get AwayClubBadgeMobileOptimizedSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwayClubBadgeMobileOptimizedSource()
    {
        return isset($this->AwayClubBadgeMobileOptimizedSource) ? $this->AwayClubBadgeMobileOptimizedSource : null;
    }
    /**
     * Set AwayClubBadgeMobileOptimizedSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awayClubBadgeMobileOptimizedSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setAwayClubBadgeMobileOptimizedSource($awayClubBadgeMobileOptimizedSource = null)
    {
        // validation for constraint: string
        if (!is_null($awayClubBadgeMobileOptimizedSource) && !is_string($awayClubBadgeMobileOptimizedSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awayClubBadgeMobileOptimizedSource, true), gettype($awayClubBadgeMobileOptimizedSource)), __LINE__);
        }
        if (is_null($awayClubBadgeMobileOptimizedSource) || (is_array($awayClubBadgeMobileOptimizedSource) && empty($awayClubBadgeMobileOptimizedSource))) {
            unset($this->AwayClubBadgeMobileOptimizedSource);
        } else {
            $this->AwayClubBadgeMobileOptimizedSource = $awayClubBadgeMobileOptimizedSource;
        }
        return $this;
    }
    /**
     * Get BaseHexColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseHexColor()
    {
        return isset($this->BaseHexColor) ? $this->BaseHexColor : null;
    }
    /**
     * Set BaseHexColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseHexColor
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setBaseHexColor($baseHexColor = null)
    {
        // validation for constraint: string
        if (!is_null($baseHexColor) && !is_string($baseHexColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseHexColor, true), gettype($baseHexColor)), __LINE__);
        }
        if (is_null($baseHexColor) || (is_array($baseHexColor) && empty($baseHexColor))) {
            unset($this->BaseHexColor);
        } else {
            $this->BaseHexColor = $baseHexColor;
        }
        return $this;
    }
    /**
     * Get ClientTypeForMobileSdkUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeForMobileSdkUser()
    {
        return isset($this->ClientTypeForMobileSdkUser) ? $this->ClientTypeForMobileSdkUser : null;
    }
    /**
     * Set ClientTypeForMobileSdkUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeForMobileSdkUser
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setClientTypeForMobileSdkUser($clientTypeForMobileSdkUser = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeForMobileSdkUser) && !is_string($clientTypeForMobileSdkUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeForMobileSdkUser, true), gettype($clientTypeForMobileSdkUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientTypeForMobileSdkUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientTypeForMobileSdkUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientTypeForMobileSdkUser, true)), __LINE__);
        }
        if (is_null($clientTypeForMobileSdkUser) || (is_array($clientTypeForMobileSdkUser) && empty($clientTypeForMobileSdkUser))) {
            unset($this->ClientTypeForMobileSdkUser);
        } else {
            $this->ClientTypeForMobileSdkUser = $clientTypeForMobileSdkUser;
        }
        return $this;
    }
    /**
     * Get ClubImagesBaseUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClubImagesBaseUrl()
    {
        return isset($this->ClubImagesBaseUrl) ? $this->ClubImagesBaseUrl : null;
    }
    /**
     * Set ClubImagesBaseUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clubImagesBaseUrl
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setClubImagesBaseUrl($clubImagesBaseUrl = null)
    {
        // validation for constraint: string
        if (!is_null($clubImagesBaseUrl) && !is_string($clubImagesBaseUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clubImagesBaseUrl, true), gettype($clubImagesBaseUrl)), __LINE__);
        }
        if (is_null($clubImagesBaseUrl) || (is_array($clubImagesBaseUrl) && empty($clubImagesBaseUrl))) {
            unset($this->ClubImagesBaseUrl);
        } else {
            $this->ClubImagesBaseUrl = $clubImagesBaseUrl;
        }
        return $this;
    }
    /**
     * Get CompetitionLogoDefaultSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompetitionLogoDefaultSource()
    {
        return isset($this->CompetitionLogoDefaultSource) ? $this->CompetitionLogoDefaultSource : null;
    }
    /**
     * Set CompetitionLogoDefaultSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $competitionLogoDefaultSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setCompetitionLogoDefaultSource($competitionLogoDefaultSource = null)
    {
        // validation for constraint: string
        if (!is_null($competitionLogoDefaultSource) && !is_string($competitionLogoDefaultSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($competitionLogoDefaultSource, true), gettype($competitionLogoDefaultSource)), __LINE__);
        }
        if (is_null($competitionLogoDefaultSource) || (is_array($competitionLogoDefaultSource) && empty($competitionLogoDefaultSource))) {
            unset($this->CompetitionLogoDefaultSource);
        } else {
            $this->CompetitionLogoDefaultSource = $competitionLogoDefaultSource;
        }
        return $this;
    }
    /**
     * Get CompetitionLogoMobileOptimizedSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompetitionLogoMobileOptimizedSource()
    {
        return isset($this->CompetitionLogoMobileOptimizedSource) ? $this->CompetitionLogoMobileOptimizedSource : null;
    }
    /**
     * Set CompetitionLogoMobileOptimizedSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $competitionLogoMobileOptimizedSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setCompetitionLogoMobileOptimizedSource($competitionLogoMobileOptimizedSource = null)
    {
        // validation for constraint: string
        if (!is_null($competitionLogoMobileOptimizedSource) && !is_string($competitionLogoMobileOptimizedSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($competitionLogoMobileOptimizedSource, true), gettype($competitionLogoMobileOptimizedSource)), __LINE__);
        }
        if (is_null($competitionLogoMobileOptimizedSource) || (is_array($competitionLogoMobileOptimizedSource) && empty($competitionLogoMobileOptimizedSource))) {
            unset($this->CompetitionLogoMobileOptimizedSource);
        } else {
            $this->CompetitionLogoMobileOptimizedSource = $competitionLogoMobileOptimizedSource;
        }
        return $this;
    }
    /**
     * Get DeviceLockEnforcedFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceLockEnforcedFromDate()
    {
        return isset($this->DeviceLockEnforcedFromDate) ? $this->DeviceLockEnforcedFromDate : null;
    }
    /**
     * Set DeviceLockEnforcedFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceLockEnforcedFromDate
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setDeviceLockEnforcedFromDate($deviceLockEnforcedFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($deviceLockEnforcedFromDate) && !is_string($deviceLockEnforcedFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceLockEnforcedFromDate, true), gettype($deviceLockEnforcedFromDate)), __LINE__);
        }
        if (is_null($deviceLockEnforcedFromDate) || (is_array($deviceLockEnforcedFromDate) && empty($deviceLockEnforcedFromDate))) {
            unset($this->DeviceLockEnforcedFromDate);
        } else {
            $this->DeviceLockEnforcedFromDate = $deviceLockEnforcedFromDate;
        }
        return $this;
    }
    /**
     * Get HideTicketBarcodeUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHideTicketBarcodeUntil()
    {
        return isset($this->HideTicketBarcodeUntil) ? $this->HideTicketBarcodeUntil : null;
    }
    /**
     * Set HideTicketBarcodeUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hideTicketBarcodeUntil
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setHideTicketBarcodeUntil($hideTicketBarcodeUntil = null)
    {
        // validation for constraint: string
        if (!is_null($hideTicketBarcodeUntil) && !is_string($hideTicketBarcodeUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hideTicketBarcodeUntil, true), gettype($hideTicketBarcodeUntil)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($hideTicketBarcodeUntil) && false === mb_strpos($hideTicketBarcodeUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $hideTicketBarcodeUntil)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($hideTicketBarcodeUntil, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($hideTicketBarcodeUntil) && false !== mb_strpos($hideTicketBarcodeUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $hideTicketBarcodeUntil)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($hideTicketBarcodeUntil, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($hideTicketBarcodeUntil) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $hideTicketBarcodeUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($hideTicketBarcodeUntil, true)), __LINE__);
        }
        if (is_null($hideTicketBarcodeUntil) || (is_array($hideTicketBarcodeUntil) && empty($hideTicketBarcodeUntil))) {
            unset($this->HideTicketBarcodeUntil);
        } else {
            $this->HideTicketBarcodeUntil = $hideTicketBarcodeUntil;
        }
        return $this;
    }
    /**
     * Get HomeClubBadgeDefaultSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomeClubBadgeDefaultSource()
    {
        return isset($this->HomeClubBadgeDefaultSource) ? $this->HomeClubBadgeDefaultSource : null;
    }
    /**
     * Set HomeClubBadgeDefaultSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homeClubBadgeDefaultSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setHomeClubBadgeDefaultSource($homeClubBadgeDefaultSource = null)
    {
        // validation for constraint: string
        if (!is_null($homeClubBadgeDefaultSource) && !is_string($homeClubBadgeDefaultSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeClubBadgeDefaultSource, true), gettype($homeClubBadgeDefaultSource)), __LINE__);
        }
        if (is_null($homeClubBadgeDefaultSource) || (is_array($homeClubBadgeDefaultSource) && empty($homeClubBadgeDefaultSource))) {
            unset($this->HomeClubBadgeDefaultSource);
        } else {
            $this->HomeClubBadgeDefaultSource = $homeClubBadgeDefaultSource;
        }
        return $this;
    }
    /**
     * Get HomeClubBadgeMobileOptimizedSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomeClubBadgeMobileOptimizedSource()
    {
        return isset($this->HomeClubBadgeMobileOptimizedSource) ? $this->HomeClubBadgeMobileOptimizedSource : null;
    }
    /**
     * Set HomeClubBadgeMobileOptimizedSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homeClubBadgeMobileOptimizedSource
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setHomeClubBadgeMobileOptimizedSource($homeClubBadgeMobileOptimizedSource = null)
    {
        // validation for constraint: string
        if (!is_null($homeClubBadgeMobileOptimizedSource) && !is_string($homeClubBadgeMobileOptimizedSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeClubBadgeMobileOptimizedSource, true), gettype($homeClubBadgeMobileOptimizedSource)), __LINE__);
        }
        if (is_null($homeClubBadgeMobileOptimizedSource) || (is_array($homeClubBadgeMobileOptimizedSource) && empty($homeClubBadgeMobileOptimizedSource))) {
            unset($this->HomeClubBadgeMobileOptimizedSource);
        } else {
            $this->HomeClubBadgeMobileOptimizedSource = $homeClubBadgeMobileOptimizedSource;
        }
        return $this;
    }
    /**
     * Get MobileSdkAllowTicketResaleRequestsFromRelatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMobileSdkAllowTicketResaleRequestsFromRelatives()
    {
        return isset($this->MobileSdkAllowTicketResaleRequestsFromRelatives) ? $this->MobileSdkAllowTicketResaleRequestsFromRelatives : null;
    }
    /**
     * Set MobileSdkAllowTicketResaleRequestsFromRelatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mobileSdkAllowTicketResaleRequestsFromRelatives
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkAllowTicketResaleRequestsFromRelatives($mobileSdkAllowTicketResaleRequestsFromRelatives = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobileSdkAllowTicketResaleRequestsFromRelatives) && !is_bool($mobileSdkAllowTicketResaleRequestsFromRelatives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobileSdkAllowTicketResaleRequestsFromRelatives, true), gettype($mobileSdkAllowTicketResaleRequestsFromRelatives)), __LINE__);
        }
        if (is_null($mobileSdkAllowTicketResaleRequestsFromRelatives) || (is_array($mobileSdkAllowTicketResaleRequestsFromRelatives) && empty($mobileSdkAllowTicketResaleRequestsFromRelatives))) {
            unset($this->MobileSdkAllowTicketResaleRequestsFromRelatives);
        } else {
            $this->MobileSdkAllowTicketResaleRequestsFromRelatives = $mobileSdkAllowTicketResaleRequestsFromRelatives;
        }
        return $this;
    }
    /**
     * Get MobileSdkDisplayMobiliseTicketsOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMobileSdkDisplayMobiliseTicketsOnline()
    {
        return isset($this->MobileSdkDisplayMobiliseTicketsOnline) ? $this->MobileSdkDisplayMobiliseTicketsOnline : null;
    }
    /**
     * Set MobileSdkDisplayMobiliseTicketsOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mobileSdkDisplayMobiliseTicketsOnline
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkDisplayMobiliseTicketsOnline($mobileSdkDisplayMobiliseTicketsOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobileSdkDisplayMobiliseTicketsOnline) && !is_bool($mobileSdkDisplayMobiliseTicketsOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobileSdkDisplayMobiliseTicketsOnline, true), gettype($mobileSdkDisplayMobiliseTicketsOnline)), __LINE__);
        }
        if (is_null($mobileSdkDisplayMobiliseTicketsOnline) || (is_array($mobileSdkDisplayMobiliseTicketsOnline) && empty($mobileSdkDisplayMobiliseTicketsOnline))) {
            unset($this->MobileSdkDisplayMobiliseTicketsOnline);
        } else {
            $this->MobileSdkDisplayMobiliseTicketsOnline = $mobileSdkDisplayMobiliseTicketsOnline;
        }
        return $this;
    }
    /**
     * Get MobileSdkEnforceSingleDeviceBinding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMobileSdkEnforceSingleDeviceBinding()
    {
        return isset($this->MobileSdkEnforceSingleDeviceBinding) ? $this->MobileSdkEnforceSingleDeviceBinding : null;
    }
    /**
     * Set MobileSdkEnforceSingleDeviceBinding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mobileSdkEnforceSingleDeviceBinding
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkEnforceSingleDeviceBinding($mobileSdkEnforceSingleDeviceBinding = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobileSdkEnforceSingleDeviceBinding) && !is_bool($mobileSdkEnforceSingleDeviceBinding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobileSdkEnforceSingleDeviceBinding, true), gettype($mobileSdkEnforceSingleDeviceBinding)), __LINE__);
        }
        if (is_null($mobileSdkEnforceSingleDeviceBinding) || (is_array($mobileSdkEnforceSingleDeviceBinding) && empty($mobileSdkEnforceSingleDeviceBinding))) {
            unset($this->MobileSdkEnforceSingleDeviceBinding);
        } else {
            $this->MobileSdkEnforceSingleDeviceBinding = $mobileSdkEnforceSingleDeviceBinding;
        }
        return $this;
    }
    /**
     * Get MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
    {
        return isset($this->MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) ? $this->MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged : null;
    }
    /**
     * Set MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && !is_bool($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged, true), gettype($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged)), __LINE__);
        }
        if (is_null($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) || (is_array($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && empty($mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged))) {
            unset($this->MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged);
        } else {
            $this->MobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = $mobileSdkIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
        }
        return $this;
    }
    /**
     * Get MobileSdkSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileSdkSaleMode()
    {
        return isset($this->MobileSdkSaleMode) ? $this->MobileSdkSaleMode : null;
    }
    /**
     * Set MobileSdkSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileSdkSaleMode
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkSaleMode($mobileSdkSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($mobileSdkSaleMode) && !is_string($mobileSdkSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileSdkSaleMode, true), gettype($mobileSdkSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileSdkSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileSdkSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileSdkSaleMode, true)), __LINE__);
        }
        if (is_null($mobileSdkSaleMode) || (is_array($mobileSdkSaleMode) && empty($mobileSdkSaleMode))) {
            unset($this->MobileSdkSaleMode);
        } else {
            $this->MobileSdkSaleMode = $mobileSdkSaleMode;
        }
        return $this;
    }
    /**
     * Get MobileSdkSalePoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileSdkSalePoint()
    {
        return isset($this->MobileSdkSalePoint) ? $this->MobileSdkSalePoint : null;
    }
    /**
     * Set MobileSdkSalePoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileSdkSalePoint
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setMobileSdkSalePoint($mobileSdkSalePoint = null)
    {
        // validation for constraint: string
        if (!is_null($mobileSdkSalePoint) && !is_string($mobileSdkSalePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileSdkSalePoint, true), gettype($mobileSdkSalePoint)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileSdkSalePoint) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileSdkSalePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileSdkSalePoint, true)), __LINE__);
        }
        if (is_null($mobileSdkSalePoint) || (is_array($mobileSdkSalePoint) && empty($mobileSdkSalePoint))) {
            unset($this->MobileSdkSalePoint);
        } else {
            $this->MobileSdkSalePoint = $mobileSdkSalePoint;
        }
        return $this;
    }
    /**
     * Get NumberOfDeviceChangesPermitted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfDeviceChangesPermitted()
    {
        return isset($this->NumberOfDeviceChangesPermitted) ? $this->NumberOfDeviceChangesPermitted : null;
    }
    /**
     * Set NumberOfDeviceChangesPermitted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfDeviceChangesPermitted
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setNumberOfDeviceChangesPermitted($numberOfDeviceChangesPermitted = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDeviceChangesPermitted) && !(is_int($numberOfDeviceChangesPermitted) || ctype_digit($numberOfDeviceChangesPermitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDeviceChangesPermitted, true), gettype($numberOfDeviceChangesPermitted)), __LINE__);
        }
        if (is_null($numberOfDeviceChangesPermitted) || (is_array($numberOfDeviceChangesPermitted) && empty($numberOfDeviceChangesPermitted))) {
            unset($this->NumberOfDeviceChangesPermitted);
        } else {
            $this->NumberOfDeviceChangesPermitted = $numberOfDeviceChangesPermitted;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeEnablingTicketManage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeEnablingTicketManage()
    {
        return isset($this->RelationshipTypeEnablingTicketManage) ? $this->RelationshipTypeEnablingTicketManage : null;
    }
    /**
     * Set RelationshipTypeEnablingTicketManage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeEnablingTicketManage
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setRelationshipTypeEnablingTicketManage($relationshipTypeEnablingTicketManage = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeEnablingTicketManage) && !is_string($relationshipTypeEnablingTicketManage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeEnablingTicketManage, true), gettype($relationshipTypeEnablingTicketManage)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeEnablingTicketManage) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeEnablingTicketManage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeEnablingTicketManage, true)), __LINE__);
        }
        if (is_null($relationshipTypeEnablingTicketManage) || (is_array($relationshipTypeEnablingTicketManage) && empty($relationshipTypeEnablingTicketManage))) {
            unset($this->RelationshipTypeEnablingTicketManage);
        } else {
            $this->RelationshipTypeEnablingTicketManage = $relationshipTypeEnablingTicketManage;
        }
        return $this;
    }
    /**
     * Get StronglyRelatedClientsMaxAgeFilterForTicketList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStronglyRelatedClientsMaxAgeFilterForTicketList()
    {
        return isset($this->StronglyRelatedClientsMaxAgeFilterForTicketList) ? $this->StronglyRelatedClientsMaxAgeFilterForTicketList : null;
    }
    /**
     * Set StronglyRelatedClientsMaxAgeFilterForTicketList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        // validation for constraint: int
        if (!is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) && !(is_int($stronglyRelatedClientsMaxAgeFilterForTicketList) || ctype_digit($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stronglyRelatedClientsMaxAgeFilterForTicketList, true), gettype($stronglyRelatedClientsMaxAgeFilterForTicketList)), __LINE__);
        }
        if (is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) || (is_array($stronglyRelatedClientsMaxAgeFilterForTicketList) && empty($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            unset($this->StronglyRelatedClientsMaxAgeFilterForTicketList);
        } else {
            $this->StronglyRelatedClientsMaxAgeFilterForTicketList = $stronglyRelatedClientsMaxAgeFilterForTicketList;
        }
        return $this;
    }
    /**
     * Get WeblinkBaseUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeblinkBaseUrl()
    {
        return isset($this->WeblinkBaseUrl) ? $this->WeblinkBaseUrl : null;
    }
    /**
     * Set WeblinkBaseUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weblinkBaseUrl
     * @return \patest\StructType\Security_SroWebApiCompanyParameters
     */
    public function setWeblinkBaseUrl($weblinkBaseUrl = null)
    {
        // validation for constraint: string
        if (!is_null($weblinkBaseUrl) && !is_string($weblinkBaseUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weblinkBaseUrl, true), gettype($weblinkBaseUrl)), __LINE__);
        }
        if (is_null($weblinkBaseUrl) || (is_array($weblinkBaseUrl) && empty($weblinkBaseUrl))) {
            unset($this->WeblinkBaseUrl);
        } else {
            $this->WeblinkBaseUrl = $weblinkBaseUrl;
        }
        return $this;
    }
}
