<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.PublicConnectionProperties StructType
 * @subpackage Structs
 */
class Security_PublicConnectionProperties extends AnyEntity
{
    /**
     * The AffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AffiliateAccountId;
    /**
     * The AllowSellNonAllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowSellNonAllocatedSeats;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ApplicationChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationChannelId;
    /**
     * The ApplicationChannelLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationChannelLocalId;
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ApplicationChannelName;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The CompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompanyId;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CompanyName;
    /**
     * The CompanyTimezoneId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyTimezoneId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The FallbackCultureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FallbackCultureId;
    /**
     * The HashCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HashCode;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitIsMaster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrganizationUnitIsMaster;
    /**
     * The OrganizationUnitIsSeller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrganizationUnitIsSeller;
    /**
     * The OrganizationUnitIsSupplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrganizationUnitIsSupplier;
    /**
     * The OrganizationUnitLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrganizationUnitLocalId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The OrganizationUnitStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitStatus;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleId;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $RoleName;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalePointLocalId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalePointName;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * The SecurityTokenLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SecurityTokenLocalId;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SecurityTokenName;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SiteLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SiteLocalId;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SiteName;
    /**
     * The SiteTimezoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteTimezoneId;
    /**
     * The SystemFallbackCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SystemFallbackCultureId;
    /**
     * The TillGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillGroupId;
    /**
     * The TillGroupLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TillGroupLocalId;
    /**
     * The TillGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillGroupName;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * The TillLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TillLocalId;
    /**
     * The TillName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillName;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserLocalId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The UserProfileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserProfileId;
    /**
     * The UserProfileLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserProfileLocalId;
    /**
     * The UserProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UserProfileName;
    /**
     * Constructor method for Security.PublicConnectionProperties
     * @uses Security_PublicConnectionProperties::setAffiliateAccountId()
     * @uses Security_PublicConnectionProperties::setAllowSellNonAllocatedSeats()
     * @uses Security_PublicConnectionProperties::setApplication()
     * @uses Security_PublicConnectionProperties::setApplicationChannel()
     * @uses Security_PublicConnectionProperties::setApplicationChannelId()
     * @uses Security_PublicConnectionProperties::setApplicationChannelLocalId()
     * @uses Security_PublicConnectionProperties::setApplicationChannelName()
     * @uses Security_PublicConnectionProperties::setAuditId()
     * @uses Security_PublicConnectionProperties::setCompanyCurrencyCode()
     * @uses Security_PublicConnectionProperties::setCompanyId()
     * @uses Security_PublicConnectionProperties::setCompanyName()
     * @uses Security_PublicConnectionProperties::setCompanyTimezoneId()
     * @uses Security_PublicConnectionProperties::setCultureId()
     * @uses Security_PublicConnectionProperties::setFallbackCultureId()
     * @uses Security_PublicConnectionProperties::setHashCode()
     * @uses Security_PublicConnectionProperties::setHolderTenantId()
     * @uses Security_PublicConnectionProperties::setOnBehalfOfAccountId()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitId()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitIsMaster()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitIsSeller()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitIsSupplier()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitLocalId()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitName()
     * @uses Security_PublicConnectionProperties::setOrganizationUnitStatus()
     * @uses Security_PublicConnectionProperties::setRoleId()
     * @uses Security_PublicConnectionProperties::setRoleName()
     * @uses Security_PublicConnectionProperties::setSalePointId()
     * @uses Security_PublicConnectionProperties::setSalePointLocalId()
     * @uses Security_PublicConnectionProperties::setSalePointName()
     * @uses Security_PublicConnectionProperties::setSecurityTokenId()
     * @uses Security_PublicConnectionProperties::setSecurityTokenLocalId()
     * @uses Security_PublicConnectionProperties::setSecurityTokenName()
     * @uses Security_PublicConnectionProperties::setSiteCurrencyCode()
     * @uses Security_PublicConnectionProperties::setSiteId()
     * @uses Security_PublicConnectionProperties::setSiteLocalId()
     * @uses Security_PublicConnectionProperties::setSiteName()
     * @uses Security_PublicConnectionProperties::setSiteTimezoneId()
     * @uses Security_PublicConnectionProperties::setSystemFallbackCultureId()
     * @uses Security_PublicConnectionProperties::setTillGroupId()
     * @uses Security_PublicConnectionProperties::setTillGroupLocalId()
     * @uses Security_PublicConnectionProperties::setTillGroupName()
     * @uses Security_PublicConnectionProperties::setTillId()
     * @uses Security_PublicConnectionProperties::setTillLocalId()
     * @uses Security_PublicConnectionProperties::setTillName()
     * @uses Security_PublicConnectionProperties::setUserId()
     * @uses Security_PublicConnectionProperties::setUserLocalId()
     * @uses Security_PublicConnectionProperties::setUserName()
     * @uses Security_PublicConnectionProperties::setUserProfileId()
     * @uses Security_PublicConnectionProperties::setUserProfileLocalId()
     * @uses Security_PublicConnectionProperties::setUserProfileName()
     * @param string $affiliateAccountId
     * @param bool $allowSellNonAllocatedSeats
     * @param string $application
     * @param string $applicationChannel
     * @param string $applicationChannelId
     * @param int $applicationChannelLocalId
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @param int $auditId
     * @param string $companyCurrencyCode
     * @param string $companyId
     * @param \patest\StructType\GlobalString $companyName
     * @param string $companyTimezoneId
     * @param int $cultureId
     * @param int $fallbackCultureId
     * @param string $hashCode
     * @param int $holderTenantId
     * @param string $onBehalfOfAccountId
     * @param string $organizationUnitId
     * @param bool $organizationUnitIsMaster
     * @param bool $organizationUnitIsSeller
     * @param bool $organizationUnitIsSupplier
     * @param int $organizationUnitLocalId
     * @param string $organizationUnitName
     * @param string $organizationUnitStatus
     * @param string $roleId
     * @param \patest\StructType\GlobalString $roleName
     * @param string $salePointId
     * @param int $salePointLocalId
     * @param \patest\StructType\GlobalString $salePointName
     * @param string $securityTokenId
     * @param int $securityTokenLocalId
     * @param \patest\StructType\GlobalString $securityTokenName
     * @param string $siteCurrencyCode
     * @param string $siteId
     * @param int $siteLocalId
     * @param \patest\StructType\GlobalString $siteName
     * @param string $siteTimezoneId
     * @param int $systemFallbackCultureId
     * @param string $tillGroupId
     * @param int $tillGroupLocalId
     * @param \patest\StructType\GlobalString $tillGroupName
     * @param string $tillId
     * @param int $tillLocalId
     * @param \patest\StructType\GlobalString $tillName
     * @param string $userId
     * @param int $userLocalId
     * @param string $userName
     * @param string $userProfileId
     * @param int $userProfileLocalId
     * @param \patest\StructType\GlobalString $userProfileName
     */
    public function __construct($affiliateAccountId = null, $allowSellNonAllocatedSeats = null, $application = null, $applicationChannel = null, $applicationChannelId = null, $applicationChannelLocalId = null, \patest\StructType\GlobalString $applicationChannelName = null, $auditId = null, $companyCurrencyCode = null, $companyId = null, \patest\StructType\GlobalString $companyName = null, $companyTimezoneId = null, $cultureId = null, $fallbackCultureId = null, $hashCode = null, $holderTenantId = null, $onBehalfOfAccountId = null, $organizationUnitId = null, $organizationUnitIsMaster = null, $organizationUnitIsSeller = null, $organizationUnitIsSupplier = null, $organizationUnitLocalId = null, $organizationUnitName = null, $organizationUnitStatus = null, $roleId = null, \patest\StructType\GlobalString $roleName = null, $salePointId = null, $salePointLocalId = null, \patest\StructType\GlobalString $salePointName = null, $securityTokenId = null, $securityTokenLocalId = null, \patest\StructType\GlobalString $securityTokenName = null, $siteCurrencyCode = null, $siteId = null, $siteLocalId = null, \patest\StructType\GlobalString $siteName = null, $siteTimezoneId = null, $systemFallbackCultureId = null, $tillGroupId = null, $tillGroupLocalId = null, \patest\StructType\GlobalString $tillGroupName = null, $tillId = null, $tillLocalId = null, \patest\StructType\GlobalString $tillName = null, $userId = null, $userLocalId = null, $userName = null, $userProfileId = null, $userProfileLocalId = null, \patest\StructType\GlobalString $userProfileName = null)
    {
        $this
            ->setAffiliateAccountId($affiliateAccountId)
            ->setAllowSellNonAllocatedSeats($allowSellNonAllocatedSeats)
            ->setApplication($application)
            ->setApplicationChannel($applicationChannel)
            ->setApplicationChannelId($applicationChannelId)
            ->setApplicationChannelLocalId($applicationChannelLocalId)
            ->setApplicationChannelName($applicationChannelName)
            ->setAuditId($auditId)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setCompanyId($companyId)
            ->setCompanyName($companyName)
            ->setCompanyTimezoneId($companyTimezoneId)
            ->setCultureId($cultureId)
            ->setFallbackCultureId($fallbackCultureId)
            ->setHashCode($hashCode)
            ->setHolderTenantId($holderTenantId)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitIsMaster($organizationUnitIsMaster)
            ->setOrganizationUnitIsSeller($organizationUnitIsSeller)
            ->setOrganizationUnitIsSupplier($organizationUnitIsSupplier)
            ->setOrganizationUnitLocalId($organizationUnitLocalId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setOrganizationUnitStatus($organizationUnitStatus)
            ->setRoleId($roleId)
            ->setRoleName($roleName)
            ->setSalePointId($salePointId)
            ->setSalePointLocalId($salePointLocalId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenId($securityTokenId)
            ->setSecurityTokenLocalId($securityTokenLocalId)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setSiteId($siteId)
            ->setSiteLocalId($siteLocalId)
            ->setSiteName($siteName)
            ->setSiteTimezoneId($siteTimezoneId)
            ->setSystemFallbackCultureId($systemFallbackCultureId)
            ->setTillGroupId($tillGroupId)
            ->setTillGroupLocalId($tillGroupLocalId)
            ->setTillGroupName($tillGroupName)
            ->setTillId($tillId)
            ->setTillLocalId($tillLocalId)
            ->setTillName($tillName)
            ->setUserId($userId)
            ->setUserLocalId($userLocalId)
            ->setUserName($userName)
            ->setUserProfileId($userProfileId)
            ->setUserProfileLocalId($userProfileLocalId)
            ->setUserProfileName($userProfileName);
    }
    /**
     * Get AffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAffiliateAccountId()
    {
        return isset($this->AffiliateAccountId) ? $this->AffiliateAccountId : null;
    }
    /**
     * Set AffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $affiliateAccountId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setAffiliateAccountId($affiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateAccountId) && !is_string($affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateAccountId, true), gettype($affiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($affiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($affiliateAccountId, true)), __LINE__);
        }
        if (is_null($affiliateAccountId) || (is_array($affiliateAccountId) && empty($affiliateAccountId))) {
            unset($this->AffiliateAccountId);
        } else {
            $this->AffiliateAccountId = $affiliateAccountId;
        }
        return $this;
    }
    /**
     * Get AllowSellNonAllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowSellNonAllocatedSeats()
    {
        return isset($this->AllowSellNonAllocatedSeats) ? $this->AllowSellNonAllocatedSeats : null;
    }
    /**
     * Set AllowSellNonAllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowSellNonAllocatedSeats
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setAllowSellNonAllocatedSeats($allowSellNonAllocatedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSellNonAllocatedSeats) && !is_bool($allowSellNonAllocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSellNonAllocatedSeats, true), gettype($allowSellNonAllocatedSeats)), __LINE__);
        }
        if (is_null($allowSellNonAllocatedSeats) || (is_array($allowSellNonAllocatedSeats) && empty($allowSellNonAllocatedSeats))) {
            unset($this->AllowSellNonAllocatedSeats);
        } else {
            $this->AllowSellNonAllocatedSeats = $allowSellNonAllocatedSeats;
        }
        return $this;
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelId()
    {
        return isset($this->ApplicationChannelId) ? $this->ApplicationChannelId : null;
    }
    /**
     * Set ApplicationChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setApplicationChannelId($applicationChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelId) && !is_string($applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelId, true), gettype($applicationChannelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationChannelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationChannelId, true)), __LINE__);
        }
        if (is_null($applicationChannelId) || (is_array($applicationChannelId) && empty($applicationChannelId))) {
            unset($this->ApplicationChannelId);
        } else {
            $this->ApplicationChannelId = $applicationChannelId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationChannelLocalId()
    {
        return isset($this->ApplicationChannelLocalId) ? $this->ApplicationChannelLocalId : null;
    }
    /**
     * Set ApplicationChannelLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationChannelLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setApplicationChannelLocalId($applicationChannelLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationChannelLocalId) && !(is_int($applicationChannelLocalId) || ctype_digit($applicationChannelLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationChannelLocalId, true), gettype($applicationChannelLocalId)), __LINE__);
        }
        if (is_null($applicationChannelLocalId) || (is_array($applicationChannelLocalId) && empty($applicationChannelLocalId))) {
            unset($this->ApplicationChannelLocalId);
        } else {
            $this->ApplicationChannelLocalId = $applicationChannelLocalId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setApplicationChannelName(\patest\StructType\GlobalString $applicationChannelName = null)
    {
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get CompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyId()
    {
        return isset($this->CompanyId) ? $this->CompanyId : null;
    }
    /**
     * Set CompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setCompanyId($companyId = null)
    {
        // validation for constraint: string
        if (!is_null($companyId) && !is_string($companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyId, true), gettype($companyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($companyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($companyId, true)), __LINE__);
        }
        if (is_null($companyId) || (is_array($companyId) && empty($companyId))) {
            unset($this->CompanyId);
        } else {
            $this->CompanyId = $companyId;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $companyName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setCompanyName(\patest\StructType\GlobalString $companyName = null)
    {
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CompanyTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyTimezoneId()
    {
        return isset($this->CompanyTimezoneId) ? $this->CompanyTimezoneId : null;
    }
    /**
     * Set CompanyTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyTimezoneId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setCompanyTimezoneId($companyTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($companyTimezoneId) && !is_string($companyTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyTimezoneId, true), gettype($companyTimezoneId)), __LINE__);
        }
        if (is_null($companyTimezoneId) || (is_array($companyTimezoneId) && empty($companyTimezoneId))) {
            unset($this->CompanyTimezoneId);
        } else {
            $this->CompanyTimezoneId = $companyTimezoneId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get FallbackCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFallbackCultureId()
    {
        return isset($this->FallbackCultureId) ? $this->FallbackCultureId : null;
    }
    /**
     * Set FallbackCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fallbackCultureId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setFallbackCultureId($fallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($fallbackCultureId) && !(is_int($fallbackCultureId) || ctype_digit($fallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fallbackCultureId, true), gettype($fallbackCultureId)), __LINE__);
        }
        if (is_null($fallbackCultureId) || (is_array($fallbackCultureId) && empty($fallbackCultureId))) {
            unset($this->FallbackCultureId);
        } else {
            $this->FallbackCultureId = $fallbackCultureId;
        }
        return $this;
    }
    /**
     * Get HashCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHashCode()
    {
        return isset($this->HashCode) ? $this->HashCode : null;
    }
    /**
     * Set HashCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hashCode
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setHashCode($hashCode = null)
    {
        // validation for constraint: string
        if (!is_null($hashCode) && !is_string($hashCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashCode, true), gettype($hashCode)), __LINE__);
        }
        if (is_null($hashCode) || (is_array($hashCode) && empty($hashCode))) {
            unset($this->HashCode);
        } else {
            $this->HashCode = $hashCode;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitIsMaster value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganizationUnitIsMaster()
    {
        return isset($this->OrganizationUnitIsMaster) ? $this->OrganizationUnitIsMaster : null;
    }
    /**
     * Set OrganizationUnitIsMaster value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organizationUnitIsMaster
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitIsMaster($organizationUnitIsMaster = null)
    {
        // validation for constraint: boolean
        if (!is_null($organizationUnitIsMaster) && !is_bool($organizationUnitIsMaster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organizationUnitIsMaster, true), gettype($organizationUnitIsMaster)), __LINE__);
        }
        if (is_null($organizationUnitIsMaster) || (is_array($organizationUnitIsMaster) && empty($organizationUnitIsMaster))) {
            unset($this->OrganizationUnitIsMaster);
        } else {
            $this->OrganizationUnitIsMaster = $organizationUnitIsMaster;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitIsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganizationUnitIsSeller()
    {
        return isset($this->OrganizationUnitIsSeller) ? $this->OrganizationUnitIsSeller : null;
    }
    /**
     * Set OrganizationUnitIsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organizationUnitIsSeller
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitIsSeller($organizationUnitIsSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($organizationUnitIsSeller) && !is_bool($organizationUnitIsSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organizationUnitIsSeller, true), gettype($organizationUnitIsSeller)), __LINE__);
        }
        if (is_null($organizationUnitIsSeller) || (is_array($organizationUnitIsSeller) && empty($organizationUnitIsSeller))) {
            unset($this->OrganizationUnitIsSeller);
        } else {
            $this->OrganizationUnitIsSeller = $organizationUnitIsSeller;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitIsSupplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganizationUnitIsSupplier()
    {
        return isset($this->OrganizationUnitIsSupplier) ? $this->OrganizationUnitIsSupplier : null;
    }
    /**
     * Set OrganizationUnitIsSupplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organizationUnitIsSupplier
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitIsSupplier($organizationUnitIsSupplier = null)
    {
        // validation for constraint: boolean
        if (!is_null($organizationUnitIsSupplier) && !is_bool($organizationUnitIsSupplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organizationUnitIsSupplier, true), gettype($organizationUnitIsSupplier)), __LINE__);
        }
        if (is_null($organizationUnitIsSupplier) || (is_array($organizationUnitIsSupplier) && empty($organizationUnitIsSupplier))) {
            unset($this->OrganizationUnitIsSupplier);
        } else {
            $this->OrganizationUnitIsSupplier = $organizationUnitIsSupplier;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrganizationUnitLocalId()
    {
        return isset($this->OrganizationUnitLocalId) ? $this->OrganizationUnitLocalId : null;
    }
    /**
     * Set OrganizationUnitLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $organizationUnitLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitLocalId($organizationUnitLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($organizationUnitLocalId) && !(is_int($organizationUnitLocalId) || ctype_digit($organizationUnitLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organizationUnitLocalId, true), gettype($organizationUnitLocalId)), __LINE__);
        }
        if (is_null($organizationUnitLocalId) || (is_array($organizationUnitLocalId) && empty($organizationUnitLocalId))) {
            unset($this->OrganizationUnitLocalId);
        } else {
            $this->OrganizationUnitLocalId = $organizationUnitLocalId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitStatus()
    {
        return isset($this->OrganizationUnitStatus) ? $this->OrganizationUnitStatus : null;
    }
    /**
     * Set OrganizationUnitStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrganizationUnitStatus::valueIsValid()
     * @uses \patest\EnumType\OrganizationUnitStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $organizationUnitStatus
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setOrganizationUnitStatus($organizationUnitStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrganizationUnitStatus::valueIsValid($organizationUnitStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrganizationUnitStatus', is_array($organizationUnitStatus) ? implode(', ', $organizationUnitStatus) : var_export($organizationUnitStatus, true), implode(', ', \patest\EnumType\OrganizationUnitStatus::getValidValues())), __LINE__);
        }
        if (is_null($organizationUnitStatus) || (is_array($organizationUnitStatus) && empty($organizationUnitStatus))) {
            unset($this->OrganizationUnitStatus);
        } else {
            $this->OrganizationUnitStatus = $organizationUnitStatus;
        }
        return $this;
    }
    /**
     * Get RoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleId()
    {
        return isset($this->RoleId) ? $this->RoleId : null;
    }
    /**
     * Set RoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roleId, true)), __LINE__);
        }
        if (is_null($roleId) || (is_array($roleId) && empty($roleId))) {
            unset($this->RoleId);
        } else {
            $this->RoleId = $roleId;
        }
        return $this;
    }
    /**
     * Get RoleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRoleName()
    {
        return isset($this->RoleName) ? $this->RoleName : null;
    }
    /**
     * Set RoleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $roleName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setRoleName(\patest\StructType\GlobalString $roleName = null)
    {
        if (is_null($roleName) || (is_array($roleName) && empty($roleName))) {
            unset($this->RoleName);
        } else {
            $this->RoleName = $roleName;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get SalePointLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalePointLocalId()
    {
        return isset($this->SalePointLocalId) ? $this->SalePointLocalId : null;
    }
    /**
     * Set SalePointLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salePointLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSalePointLocalId($salePointLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($salePointLocalId) && !(is_int($salePointLocalId) || ctype_digit($salePointLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salePointLocalId, true), gettype($salePointLocalId)), __LINE__);
        }
        if (is_null($salePointLocalId) || (is_array($salePointLocalId) && empty($salePointLocalId))) {
            unset($this->SalePointLocalId);
        } else {
            $this->SalePointLocalId = $salePointLocalId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salePointName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSalePointName(\patest\StructType\GlobalString $salePointName = null)
    {
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
    /**
     * Get SecurityTokenLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSecurityTokenLocalId()
    {
        return isset($this->SecurityTokenLocalId) ? $this->SecurityTokenLocalId : null;
    }
    /**
     * Set SecurityTokenLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $securityTokenLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSecurityTokenLocalId($securityTokenLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($securityTokenLocalId) && !(is_int($securityTokenLocalId) || ctype_digit($securityTokenLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($securityTokenLocalId, true), gettype($securityTokenLocalId)), __LINE__);
        }
        if (is_null($securityTokenLocalId) || (is_array($securityTokenLocalId) && empty($securityTokenLocalId))) {
            unset($this->SecurityTokenLocalId);
        } else {
            $this->SecurityTokenLocalId = $securityTokenLocalId;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $securityTokenName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSecurityTokenName(\patest\StructType\GlobalString $securityTokenName = null)
    {
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get SiteLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSiteLocalId()
    {
        return isset($this->SiteLocalId) ? $this->SiteLocalId : null;
    }
    /**
     * Set SiteLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $siteLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSiteLocalId($siteLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($siteLocalId) && !(is_int($siteLocalId) || ctype_digit($siteLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siteLocalId, true), gettype($siteLocalId)), __LINE__);
        }
        if (is_null($siteLocalId) || (is_array($siteLocalId) && empty($siteLocalId))) {
            unset($this->SiteLocalId);
        } else {
            $this->SiteLocalId = $siteLocalId;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $siteName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSiteName(\patest\StructType\GlobalString $siteName = null)
    {
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get SiteTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteTimezoneId()
    {
        return isset($this->SiteTimezoneId) ? $this->SiteTimezoneId : null;
    }
    /**
     * Set SiteTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteTimezoneId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSiteTimezoneId($siteTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($siteTimezoneId) && !is_string($siteTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteTimezoneId, true), gettype($siteTimezoneId)), __LINE__);
        }
        if (is_null($siteTimezoneId) || (is_array($siteTimezoneId) && empty($siteTimezoneId))) {
            unset($this->SiteTimezoneId);
        } else {
            $this->SiteTimezoneId = $siteTimezoneId;
        }
        return $this;
    }
    /**
     * Get SystemFallbackCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSystemFallbackCultureId()
    {
        return isset($this->SystemFallbackCultureId) ? $this->SystemFallbackCultureId : null;
    }
    /**
     * Set SystemFallbackCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $systemFallbackCultureId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setSystemFallbackCultureId($systemFallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($systemFallbackCultureId) && !(is_int($systemFallbackCultureId) || ctype_digit($systemFallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemFallbackCultureId, true), gettype($systemFallbackCultureId)), __LINE__);
        }
        if (is_null($systemFallbackCultureId) || (is_array($systemFallbackCultureId) && empty($systemFallbackCultureId))) {
            unset($this->SystemFallbackCultureId);
        } else {
            $this->SystemFallbackCultureId = $systemFallbackCultureId;
        }
        return $this;
    }
    /**
     * Get TillGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillGroupId()
    {
        return isset($this->TillGroupId) ? $this->TillGroupId : null;
    }
    /**
     * Set TillGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillGroupId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillGroupId($tillGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($tillGroupId) && !is_string($tillGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillGroupId, true), gettype($tillGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillGroupId, true)), __LINE__);
        }
        if (is_null($tillGroupId) || (is_array($tillGroupId) && empty($tillGroupId))) {
            unset($this->TillGroupId);
        } else {
            $this->TillGroupId = $tillGroupId;
        }
        return $this;
    }
    /**
     * Get TillGroupLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTillGroupLocalId()
    {
        return isset($this->TillGroupLocalId) ? $this->TillGroupLocalId : null;
    }
    /**
     * Set TillGroupLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tillGroupLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillGroupLocalId($tillGroupLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($tillGroupLocalId) && !(is_int($tillGroupLocalId) || ctype_digit($tillGroupLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tillGroupLocalId, true), gettype($tillGroupLocalId)), __LINE__);
        }
        if (is_null($tillGroupLocalId) || (is_array($tillGroupLocalId) && empty($tillGroupLocalId))) {
            unset($this->TillGroupLocalId);
        } else {
            $this->TillGroupLocalId = $tillGroupLocalId;
        }
        return $this;
    }
    /**
     * Get TillGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillGroupName()
    {
        return isset($this->TillGroupName) ? $this->TillGroupName : null;
    }
    /**
     * Set TillGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillGroupName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillGroupName(\patest\StructType\GlobalString $tillGroupName = null)
    {
        if (is_null($tillGroupName) || (is_array($tillGroupName) && empty($tillGroupName))) {
            unset($this->TillGroupName);
        } else {
            $this->TillGroupName = $tillGroupName;
        }
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
    /**
     * Get TillLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTillLocalId()
    {
        return isset($this->TillLocalId) ? $this->TillLocalId : null;
    }
    /**
     * Set TillLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tillLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillLocalId($tillLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($tillLocalId) && !(is_int($tillLocalId) || ctype_digit($tillLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tillLocalId, true), gettype($tillLocalId)), __LINE__);
        }
        if (is_null($tillLocalId) || (is_array($tillLocalId) && empty($tillLocalId))) {
            unset($this->TillLocalId);
        } else {
            $this->TillLocalId = $tillLocalId;
        }
        return $this;
    }
    /**
     * Get TillName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillName()
    {
        return isset($this->TillName) ? $this->TillName : null;
    }
    /**
     * Set TillName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setTillName(\patest\StructType\GlobalString $tillName = null)
    {
        if (is_null($tillName) || (is_array($tillName) && empty($tillName))) {
            unset($this->TillName);
        } else {
            $this->TillName = $tillName;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserLocalId()
    {
        return isset($this->UserLocalId) ? $this->UserLocalId : null;
    }
    /**
     * Set UserLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserLocalId($userLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($userLocalId) && !(is_int($userLocalId) || ctype_digit($userLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userLocalId, true), gettype($userLocalId)), __LINE__);
        }
        if (is_null($userLocalId) || (is_array($userLocalId) && empty($userLocalId))) {
            unset($this->UserLocalId);
        } else {
            $this->UserLocalId = $userLocalId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get UserProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserProfileId()
    {
        return isset($this->UserProfileId) ? $this->UserProfileId : null;
    }
    /**
     * Set UserProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userProfileId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserProfileId($userProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($userProfileId) && !is_string($userProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userProfileId, true), gettype($userProfileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userProfileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userProfileId, true)), __LINE__);
        }
        if (is_null($userProfileId) || (is_array($userProfileId) && empty($userProfileId))) {
            unset($this->UserProfileId);
        } else {
            $this->UserProfileId = $userProfileId;
        }
        return $this;
    }
    /**
     * Get UserProfileLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserProfileLocalId()
    {
        return isset($this->UserProfileLocalId) ? $this->UserProfileLocalId : null;
    }
    /**
     * Set UserProfileLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userProfileLocalId
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserProfileLocalId($userProfileLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($userProfileLocalId) && !(is_int($userProfileLocalId) || ctype_digit($userProfileLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userProfileLocalId, true), gettype($userProfileLocalId)), __LINE__);
        }
        if (is_null($userProfileLocalId) || (is_array($userProfileLocalId) && empty($userProfileLocalId))) {
            unset($this->UserProfileLocalId);
        } else {
            $this->UserProfileLocalId = $userProfileLocalId;
        }
        return $this;
    }
    /**
     * Get UserProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUserProfileName()
    {
        return isset($this->UserProfileName) ? $this->UserProfileName : null;
    }
    /**
     * Set UserProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $userProfileName
     * @return \patest\StructType\Security_PublicConnectionProperties
     */
    public function setUserProfileName(\patest\StructType\GlobalString $userProfileName = null)
    {
        if (is_null($userProfileName) || (is_array($userProfileName) && empty($userProfileName))) {
            unset($this->UserProfileName);
        } else {
            $this->UserProfileName = $userProfileName;
        }
        return $this;
    }
}
