<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.PrintingCompanyParameters StructType
 * @subpackage Structs
 */
class Security_PrintingCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowForceCompleteBatchPrintRunningOverXMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowForceCompleteBatchPrintRunningOverXMinutes;
    /**
     * The BatchPrintSyncMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchPrintSyncMethod;
    /**
     * The CanPrintReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanPrintReservations;
    /**
     * The DefaultTicketPrintingMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultTicketPrintingMethods;
    /**
     * The GenerateMultiTicketsByOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateMultiTicketsByOwner;
    /**
     * The GenerateMultiTicketsPerEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateMultiTicketsPerEvent;
    /**
     * The InEsroWebAppOfferSendToAnyOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InEsroWebAppOfferSendToAnyOwner;
    /**
     * The InEsroWebAppTargetIsMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InEsroWebAppTargetIsMandatory;
    /**
     * The IsMarketDrivenResaleSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMarketDrivenResaleSupported;
    /**
     * The MinNumberOfTicketsPerEventForGroupTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinNumberOfTicketsPerEventForGroupTicket;
    /**
     * The MinTransactionBasketItemsCountForCache
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinTransactionBasketItemsCountForCache;
    /**
     * The MinutesAfterEventStartsToStopTicketsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinutesAfterEventStartsToStopTicketsPrinting;
    /**
     * The MobileApplication
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileApplication;
    /**
     * The MultiTicketInSubscriptionGroupingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MultiTicketInSubscriptionGroupingPolicy;
    /**
     * The NotifyOnBatchPrintCompletion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NotifyOnBatchPrintCompletion;
    /**
     * The PrintingTicketsOrderBy1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy1;
    /**
     * The PrintingTicketsOrderBy1Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy1Desc;
    /**
     * The PrintingTicketsOrderBy2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy2;
    /**
     * The PrintingTicketsOrderBy2Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy2Desc;
    /**
     * The PrintingTicketsOrderBy3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy3;
    /**
     * The PrintingTicketsOrderBy3Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy3Desc;
    /**
     * The PrintingTicketsOrderBy4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy4;
    /**
     * The PrintingTicketsOrderBy4Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy4Desc;
    /**
     * The PrintingTicketsOrderBy5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy5;
    /**
     * The PrintingTicketsOrderBy5Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy5Desc;
    /**
     * The PrintingTicketsOrderBy6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingTicketsOrderBy6;
    /**
     * The PrintingTicketsOrderBy6Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintingTicketsOrderBy6Desc;
    /**
     * The PrintSingleCustomerLabelPerAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintSingleCustomerLabelPerAddress;
    /**
     * The UseAutoLoadOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAutoLoadOnCard;
    /**
     * The UseMobileApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseMobileApp;
    /**
     * The UseTicketPrintingMethodsRuleEngine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseTicketPrintingMethodsRuleEngine;
    /**
     * Constructor method for Security.PrintingCompanyParameters
     * @uses Security_PrintingCompanyParameters::setAllowForceCompleteBatchPrintRunningOverXMinutes()
     * @uses Security_PrintingCompanyParameters::setBatchPrintSyncMethod()
     * @uses Security_PrintingCompanyParameters::setCanPrintReservations()
     * @uses Security_PrintingCompanyParameters::setDefaultTicketPrintingMethods()
     * @uses Security_PrintingCompanyParameters::setGenerateMultiTicketsByOwner()
     * @uses Security_PrintingCompanyParameters::setGenerateMultiTicketsPerEvent()
     * @uses Security_PrintingCompanyParameters::setInEsroWebAppOfferSendToAnyOwner()
     * @uses Security_PrintingCompanyParameters::setInEsroWebAppTargetIsMandatory()
     * @uses Security_PrintingCompanyParameters::setIsMarketDrivenResaleSupported()
     * @uses Security_PrintingCompanyParameters::setMinNumberOfTicketsPerEventForGroupTicket()
     * @uses Security_PrintingCompanyParameters::setMinTransactionBasketItemsCountForCache()
     * @uses Security_PrintingCompanyParameters::setMinutesAfterEventStartsToStopTicketsPrinting()
     * @uses Security_PrintingCompanyParameters::setMobileApplication()
     * @uses Security_PrintingCompanyParameters::setMultiTicketInSubscriptionGroupingPolicy()
     * @uses Security_PrintingCompanyParameters::setNotifyOnBatchPrintCompletion()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy1()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy1Desc()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy2()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy2Desc()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy3()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy3Desc()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy4()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy4Desc()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy5()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy5Desc()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy6()
     * @uses Security_PrintingCompanyParameters::setPrintingTicketsOrderBy6Desc()
     * @uses Security_PrintingCompanyParameters::setPrintSingleCustomerLabelPerAddress()
     * @uses Security_PrintingCompanyParameters::setUseAutoLoadOnCard()
     * @uses Security_PrintingCompanyParameters::setUseMobileApp()
     * @uses Security_PrintingCompanyParameters::setUseTicketPrintingMethodsRuleEngine()
     * @param int $allowForceCompleteBatchPrintRunningOverXMinutes
     * @param string $batchPrintSyncMethod
     * @param bool $canPrintReservations
     * @param string $defaultTicketPrintingMethods
     * @param bool $generateMultiTicketsByOwner
     * @param bool $generateMultiTicketsPerEvent
     * @param bool $inEsroWebAppOfferSendToAnyOwner
     * @param bool $inEsroWebAppTargetIsMandatory
     * @param bool $isMarketDrivenResaleSupported
     * @param int $minNumberOfTicketsPerEventForGroupTicket
     * @param int $minTransactionBasketItemsCountForCache
     * @param int $minutesAfterEventStartsToStopTicketsPrinting
     * @param string $mobileApplication
     * @param string $multiTicketInSubscriptionGroupingPolicy
     * @param bool $notifyOnBatchPrintCompletion
     * @param string $printingTicketsOrderBy1
     * @param bool $printingTicketsOrderBy1Desc
     * @param string $printingTicketsOrderBy2
     * @param bool $printingTicketsOrderBy2Desc
     * @param string $printingTicketsOrderBy3
     * @param bool $printingTicketsOrderBy3Desc
     * @param string $printingTicketsOrderBy4
     * @param bool $printingTicketsOrderBy4Desc
     * @param string $printingTicketsOrderBy5
     * @param bool $printingTicketsOrderBy5Desc
     * @param string $printingTicketsOrderBy6
     * @param bool $printingTicketsOrderBy6Desc
     * @param bool $printSingleCustomerLabelPerAddress
     * @param bool $useAutoLoadOnCard
     * @param bool $useMobileApp
     * @param bool $useTicketPrintingMethodsRuleEngine
     */
    public function __construct($allowForceCompleteBatchPrintRunningOverXMinutes = null, $batchPrintSyncMethod = null, $canPrintReservations = null, $defaultTicketPrintingMethods = null, $generateMultiTicketsByOwner = null, $generateMultiTicketsPerEvent = null, $inEsroWebAppOfferSendToAnyOwner = null, $inEsroWebAppTargetIsMandatory = null, $isMarketDrivenResaleSupported = null, $minNumberOfTicketsPerEventForGroupTicket = null, $minTransactionBasketItemsCountForCache = null, $minutesAfterEventStartsToStopTicketsPrinting = null, $mobileApplication = null, $multiTicketInSubscriptionGroupingPolicy = null, $notifyOnBatchPrintCompletion = null, $printingTicketsOrderBy1 = null, $printingTicketsOrderBy1Desc = null, $printingTicketsOrderBy2 = null, $printingTicketsOrderBy2Desc = null, $printingTicketsOrderBy3 = null, $printingTicketsOrderBy3Desc = null, $printingTicketsOrderBy4 = null, $printingTicketsOrderBy4Desc = null, $printingTicketsOrderBy5 = null, $printingTicketsOrderBy5Desc = null, $printingTicketsOrderBy6 = null, $printingTicketsOrderBy6Desc = null, $printSingleCustomerLabelPerAddress = null, $useAutoLoadOnCard = null, $useMobileApp = null, $useTicketPrintingMethodsRuleEngine = null)
    {
        $this
            ->setAllowForceCompleteBatchPrintRunningOverXMinutes($allowForceCompleteBatchPrintRunningOverXMinutes)
            ->setBatchPrintSyncMethod($batchPrintSyncMethod)
            ->setCanPrintReservations($canPrintReservations)
            ->setDefaultTicketPrintingMethods($defaultTicketPrintingMethods)
            ->setGenerateMultiTicketsByOwner($generateMultiTicketsByOwner)
            ->setGenerateMultiTicketsPerEvent($generateMultiTicketsPerEvent)
            ->setInEsroWebAppOfferSendToAnyOwner($inEsroWebAppOfferSendToAnyOwner)
            ->setInEsroWebAppTargetIsMandatory($inEsroWebAppTargetIsMandatory)
            ->setIsMarketDrivenResaleSupported($isMarketDrivenResaleSupported)
            ->setMinNumberOfTicketsPerEventForGroupTicket($minNumberOfTicketsPerEventForGroupTicket)
            ->setMinTransactionBasketItemsCountForCache($minTransactionBasketItemsCountForCache)
            ->setMinutesAfterEventStartsToStopTicketsPrinting($minutesAfterEventStartsToStopTicketsPrinting)
            ->setMobileApplication($mobileApplication)
            ->setMultiTicketInSubscriptionGroupingPolicy($multiTicketInSubscriptionGroupingPolicy)
            ->setNotifyOnBatchPrintCompletion($notifyOnBatchPrintCompletion)
            ->setPrintingTicketsOrderBy1($printingTicketsOrderBy1)
            ->setPrintingTicketsOrderBy1Desc($printingTicketsOrderBy1Desc)
            ->setPrintingTicketsOrderBy2($printingTicketsOrderBy2)
            ->setPrintingTicketsOrderBy2Desc($printingTicketsOrderBy2Desc)
            ->setPrintingTicketsOrderBy3($printingTicketsOrderBy3)
            ->setPrintingTicketsOrderBy3Desc($printingTicketsOrderBy3Desc)
            ->setPrintingTicketsOrderBy4($printingTicketsOrderBy4)
            ->setPrintingTicketsOrderBy4Desc($printingTicketsOrderBy4Desc)
            ->setPrintingTicketsOrderBy5($printingTicketsOrderBy5)
            ->setPrintingTicketsOrderBy5Desc($printingTicketsOrderBy5Desc)
            ->setPrintingTicketsOrderBy6($printingTicketsOrderBy6)
            ->setPrintingTicketsOrderBy6Desc($printingTicketsOrderBy6Desc)
            ->setPrintSingleCustomerLabelPerAddress($printSingleCustomerLabelPerAddress)
            ->setUseAutoLoadOnCard($useAutoLoadOnCard)
            ->setUseMobileApp($useMobileApp)
            ->setUseTicketPrintingMethodsRuleEngine($useTicketPrintingMethodsRuleEngine);
    }
    /**
     * Get AllowForceCompleteBatchPrintRunningOverXMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowForceCompleteBatchPrintRunningOverXMinutes()
    {
        return isset($this->AllowForceCompleteBatchPrintRunningOverXMinutes) ? $this->AllowForceCompleteBatchPrintRunningOverXMinutes : null;
    }
    /**
     * Set AllowForceCompleteBatchPrintRunningOverXMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowForceCompleteBatchPrintRunningOverXMinutes
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setAllowForceCompleteBatchPrintRunningOverXMinutes($allowForceCompleteBatchPrintRunningOverXMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($allowForceCompleteBatchPrintRunningOverXMinutes) && !(is_int($allowForceCompleteBatchPrintRunningOverXMinutes) || ctype_digit($allowForceCompleteBatchPrintRunningOverXMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowForceCompleteBatchPrintRunningOverXMinutes, true), gettype($allowForceCompleteBatchPrintRunningOverXMinutes)), __LINE__);
        }
        if (is_null($allowForceCompleteBatchPrintRunningOverXMinutes) || (is_array($allowForceCompleteBatchPrintRunningOverXMinutes) && empty($allowForceCompleteBatchPrintRunningOverXMinutes))) {
            unset($this->AllowForceCompleteBatchPrintRunningOverXMinutes);
        } else {
            $this->AllowForceCompleteBatchPrintRunningOverXMinutes = $allowForceCompleteBatchPrintRunningOverXMinutes;
        }
        return $this;
    }
    /**
     * Get BatchPrintSyncMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintSyncMethod()
    {
        return isset($this->BatchPrintSyncMethod) ? $this->BatchPrintSyncMethod : null;
    }
    /**
     * Set BatchPrintSyncMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintSyncMethod::valueIsValid()
     * @uses \patest\EnumType\BatchPrintSyncMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $batchPrintSyncMethod
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setBatchPrintSyncMethod($batchPrintSyncMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintSyncMethod::valueIsValid($batchPrintSyncMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintSyncMethod', is_array($batchPrintSyncMethod) ? implode(', ', $batchPrintSyncMethod) : var_export($batchPrintSyncMethod, true), implode(', ', \patest\EnumType\BatchPrintSyncMethod::getValidValues())), __LINE__);
        }
        if (is_null($batchPrintSyncMethod) || (is_array($batchPrintSyncMethod) && empty($batchPrintSyncMethod))) {
            unset($this->BatchPrintSyncMethod);
        } else {
            $this->BatchPrintSyncMethod = $batchPrintSyncMethod;
        }
        return $this;
    }
    /**
     * Get CanPrintReservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanPrintReservations()
    {
        return isset($this->CanPrintReservations) ? $this->CanPrintReservations : null;
    }
    /**
     * Set CanPrintReservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canPrintReservations
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setCanPrintReservations($canPrintReservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($canPrintReservations) && !is_bool($canPrintReservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canPrintReservations, true), gettype($canPrintReservations)), __LINE__);
        }
        if (is_null($canPrintReservations) || (is_array($canPrintReservations) && empty($canPrintReservations))) {
            unset($this->CanPrintReservations);
        } else {
            $this->CanPrintReservations = $canPrintReservations;
        }
        return $this;
    }
    /**
     * Get DefaultTicketPrintingMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultTicketPrintingMethods()
    {
        return isset($this->DefaultTicketPrintingMethods) ? $this->DefaultTicketPrintingMethods : null;
    }
    /**
     * Set DefaultTicketPrintingMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultTicketPrintingMethods
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setDefaultTicketPrintingMethods($defaultTicketPrintingMethods = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTicketPrintingMethods) && !is_string($defaultTicketPrintingMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTicketPrintingMethods, true), gettype($defaultTicketPrintingMethods)), __LINE__);
        }
        if (is_null($defaultTicketPrintingMethods) || (is_array($defaultTicketPrintingMethods) && empty($defaultTicketPrintingMethods))) {
            unset($this->DefaultTicketPrintingMethods);
        } else {
            $this->DefaultTicketPrintingMethods = $defaultTicketPrintingMethods;
        }
        return $this;
    }
    /**
     * Get GenerateMultiTicketsByOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateMultiTicketsByOwner()
    {
        return isset($this->GenerateMultiTicketsByOwner) ? $this->GenerateMultiTicketsByOwner : null;
    }
    /**
     * Set GenerateMultiTicketsByOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateMultiTicketsByOwner
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setGenerateMultiTicketsByOwner($generateMultiTicketsByOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateMultiTicketsByOwner) && !is_bool($generateMultiTicketsByOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateMultiTicketsByOwner, true), gettype($generateMultiTicketsByOwner)), __LINE__);
        }
        if (is_null($generateMultiTicketsByOwner) || (is_array($generateMultiTicketsByOwner) && empty($generateMultiTicketsByOwner))) {
            unset($this->GenerateMultiTicketsByOwner);
        } else {
            $this->GenerateMultiTicketsByOwner = $generateMultiTicketsByOwner;
        }
        return $this;
    }
    /**
     * Get GenerateMultiTicketsPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateMultiTicketsPerEvent()
    {
        return isset($this->GenerateMultiTicketsPerEvent) ? $this->GenerateMultiTicketsPerEvent : null;
    }
    /**
     * Set GenerateMultiTicketsPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateMultiTicketsPerEvent
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setGenerateMultiTicketsPerEvent($generateMultiTicketsPerEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateMultiTicketsPerEvent) && !is_bool($generateMultiTicketsPerEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateMultiTicketsPerEvent, true), gettype($generateMultiTicketsPerEvent)), __LINE__);
        }
        if (is_null($generateMultiTicketsPerEvent) || (is_array($generateMultiTicketsPerEvent) && empty($generateMultiTicketsPerEvent))) {
            unset($this->GenerateMultiTicketsPerEvent);
        } else {
            $this->GenerateMultiTicketsPerEvent = $generateMultiTicketsPerEvent;
        }
        return $this;
    }
    /**
     * Get InEsroWebAppOfferSendToAnyOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInEsroWebAppOfferSendToAnyOwner()
    {
        return isset($this->InEsroWebAppOfferSendToAnyOwner) ? $this->InEsroWebAppOfferSendToAnyOwner : null;
    }
    /**
     * Set InEsroWebAppOfferSendToAnyOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inEsroWebAppOfferSendToAnyOwner
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setInEsroWebAppOfferSendToAnyOwner($inEsroWebAppOfferSendToAnyOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($inEsroWebAppOfferSendToAnyOwner) && !is_bool($inEsroWebAppOfferSendToAnyOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inEsroWebAppOfferSendToAnyOwner, true), gettype($inEsroWebAppOfferSendToAnyOwner)), __LINE__);
        }
        if (is_null($inEsroWebAppOfferSendToAnyOwner) || (is_array($inEsroWebAppOfferSendToAnyOwner) && empty($inEsroWebAppOfferSendToAnyOwner))) {
            unset($this->InEsroWebAppOfferSendToAnyOwner);
        } else {
            $this->InEsroWebAppOfferSendToAnyOwner = $inEsroWebAppOfferSendToAnyOwner;
        }
        return $this;
    }
    /**
     * Get InEsroWebAppTargetIsMandatory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInEsroWebAppTargetIsMandatory()
    {
        return isset($this->InEsroWebAppTargetIsMandatory) ? $this->InEsroWebAppTargetIsMandatory : null;
    }
    /**
     * Set InEsroWebAppTargetIsMandatory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inEsroWebAppTargetIsMandatory
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setInEsroWebAppTargetIsMandatory($inEsroWebAppTargetIsMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($inEsroWebAppTargetIsMandatory) && !is_bool($inEsroWebAppTargetIsMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inEsroWebAppTargetIsMandatory, true), gettype($inEsroWebAppTargetIsMandatory)), __LINE__);
        }
        if (is_null($inEsroWebAppTargetIsMandatory) || (is_array($inEsroWebAppTargetIsMandatory) && empty($inEsroWebAppTargetIsMandatory))) {
            unset($this->InEsroWebAppTargetIsMandatory);
        } else {
            $this->InEsroWebAppTargetIsMandatory = $inEsroWebAppTargetIsMandatory;
        }
        return $this;
    }
    /**
     * Get IsMarketDrivenResaleSupported value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMarketDrivenResaleSupported()
    {
        return isset($this->IsMarketDrivenResaleSupported) ? $this->IsMarketDrivenResaleSupported : null;
    }
    /**
     * Set IsMarketDrivenResaleSupported value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMarketDrivenResaleSupported
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setIsMarketDrivenResaleSupported($isMarketDrivenResaleSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketDrivenResaleSupported) && !is_bool($isMarketDrivenResaleSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarketDrivenResaleSupported, true), gettype($isMarketDrivenResaleSupported)), __LINE__);
        }
        if (is_null($isMarketDrivenResaleSupported) || (is_array($isMarketDrivenResaleSupported) && empty($isMarketDrivenResaleSupported))) {
            unset($this->IsMarketDrivenResaleSupported);
        } else {
            $this->IsMarketDrivenResaleSupported = $isMarketDrivenResaleSupported;
        }
        return $this;
    }
    /**
     * Get MinNumberOfTicketsPerEventForGroupTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinNumberOfTicketsPerEventForGroupTicket()
    {
        return isset($this->MinNumberOfTicketsPerEventForGroupTicket) ? $this->MinNumberOfTicketsPerEventForGroupTicket : null;
    }
    /**
     * Set MinNumberOfTicketsPerEventForGroupTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minNumberOfTicketsPerEventForGroupTicket
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setMinNumberOfTicketsPerEventForGroupTicket($minNumberOfTicketsPerEventForGroupTicket = null)
    {
        // validation for constraint: int
        if (!is_null($minNumberOfTicketsPerEventForGroupTicket) && !(is_int($minNumberOfTicketsPerEventForGroupTicket) || ctype_digit($minNumberOfTicketsPerEventForGroupTicket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNumberOfTicketsPerEventForGroupTicket, true), gettype($minNumberOfTicketsPerEventForGroupTicket)), __LINE__);
        }
        if (is_null($minNumberOfTicketsPerEventForGroupTicket) || (is_array($minNumberOfTicketsPerEventForGroupTicket) && empty($minNumberOfTicketsPerEventForGroupTicket))) {
            unset($this->MinNumberOfTicketsPerEventForGroupTicket);
        } else {
            $this->MinNumberOfTicketsPerEventForGroupTicket = $minNumberOfTicketsPerEventForGroupTicket;
        }
        return $this;
    }
    /**
     * Get MinTransactionBasketItemsCountForCache value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinTransactionBasketItemsCountForCache()
    {
        return isset($this->MinTransactionBasketItemsCountForCache) ? $this->MinTransactionBasketItemsCountForCache : null;
    }
    /**
     * Set MinTransactionBasketItemsCountForCache value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minTransactionBasketItemsCountForCache
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setMinTransactionBasketItemsCountForCache($minTransactionBasketItemsCountForCache = null)
    {
        // validation for constraint: int
        if (!is_null($minTransactionBasketItemsCountForCache) && !(is_int($minTransactionBasketItemsCountForCache) || ctype_digit($minTransactionBasketItemsCountForCache))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTransactionBasketItemsCountForCache, true), gettype($minTransactionBasketItemsCountForCache)), __LINE__);
        }
        if (is_null($minTransactionBasketItemsCountForCache) || (is_array($minTransactionBasketItemsCountForCache) && empty($minTransactionBasketItemsCountForCache))) {
            unset($this->MinTransactionBasketItemsCountForCache);
        } else {
            $this->MinTransactionBasketItemsCountForCache = $minTransactionBasketItemsCountForCache;
        }
        return $this;
    }
    /**
     * Get MinutesAfterEventStartsToStopTicketsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinutesAfterEventStartsToStopTicketsPrinting()
    {
        return isset($this->MinutesAfterEventStartsToStopTicketsPrinting) ? $this->MinutesAfterEventStartsToStopTicketsPrinting : null;
    }
    /**
     * Set MinutesAfterEventStartsToStopTicketsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minutesAfterEventStartsToStopTicketsPrinting
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setMinutesAfterEventStartsToStopTicketsPrinting($minutesAfterEventStartsToStopTicketsPrinting = null)
    {
        // validation for constraint: int
        if (!is_null($minutesAfterEventStartsToStopTicketsPrinting) && !(is_int($minutesAfterEventStartsToStopTicketsPrinting) || ctype_digit($minutesAfterEventStartsToStopTicketsPrinting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesAfterEventStartsToStopTicketsPrinting, true), gettype($minutesAfterEventStartsToStopTicketsPrinting)), __LINE__);
        }
        if (is_null($minutesAfterEventStartsToStopTicketsPrinting) || (is_array($minutesAfterEventStartsToStopTicketsPrinting) && empty($minutesAfterEventStartsToStopTicketsPrinting))) {
            unset($this->MinutesAfterEventStartsToStopTicketsPrinting);
        } else {
            $this->MinutesAfterEventStartsToStopTicketsPrinting = $minutesAfterEventStartsToStopTicketsPrinting;
        }
        return $this;
    }
    /**
     * Get MobileApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileApplication()
    {
        return isset($this->MobileApplication) ? $this->MobileApplication : null;
    }
    /**
     * Set MobileApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileApplication
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setMobileApplication($mobileApplication = null)
    {
        // validation for constraint: string
        if (!is_null($mobileApplication) && !is_string($mobileApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileApplication, true), gettype($mobileApplication)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileApplication) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileApplication, true)), __LINE__);
        }
        if (is_null($mobileApplication) || (is_array($mobileApplication) && empty($mobileApplication))) {
            unset($this->MobileApplication);
        } else {
            $this->MobileApplication = $mobileApplication;
        }
        return $this;
    }
    /**
     * Get MultiTicketInSubscriptionGroupingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMultiTicketInSubscriptionGroupingPolicy()
    {
        return isset($this->MultiTicketInSubscriptionGroupingPolicy) ? $this->MultiTicketInSubscriptionGroupingPolicy : null;
    }
    /**
     * Set MultiTicketInSubscriptionGroupingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MultiTicketInSubscriptionGroupingPolicy::valueIsValid()
     * @uses \patest\EnumType\MultiTicketInSubscriptionGroupingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $multiTicketInSubscriptionGroupingPolicy
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setMultiTicketInSubscriptionGroupingPolicy($multiTicketInSubscriptionGroupingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MultiTicketInSubscriptionGroupingPolicy::valueIsValid($multiTicketInSubscriptionGroupingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MultiTicketInSubscriptionGroupingPolicy', is_array($multiTicketInSubscriptionGroupingPolicy) ? implode(', ', $multiTicketInSubscriptionGroupingPolicy) : var_export($multiTicketInSubscriptionGroupingPolicy, true), implode(', ', \patest\EnumType\MultiTicketInSubscriptionGroupingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($multiTicketInSubscriptionGroupingPolicy) || (is_array($multiTicketInSubscriptionGroupingPolicy) && empty($multiTicketInSubscriptionGroupingPolicy))) {
            unset($this->MultiTicketInSubscriptionGroupingPolicy);
        } else {
            $this->MultiTicketInSubscriptionGroupingPolicy = $multiTicketInSubscriptionGroupingPolicy;
        }
        return $this;
    }
    /**
     * Get NotifyOnBatchPrintCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNotifyOnBatchPrintCompletion()
    {
        return isset($this->NotifyOnBatchPrintCompletion) ? $this->NotifyOnBatchPrintCompletion : null;
    }
    /**
     * Set NotifyOnBatchPrintCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $notifyOnBatchPrintCompletion
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setNotifyOnBatchPrintCompletion($notifyOnBatchPrintCompletion = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyOnBatchPrintCompletion) && !is_bool($notifyOnBatchPrintCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notifyOnBatchPrintCompletion, true), gettype($notifyOnBatchPrintCompletion)), __LINE__);
        }
        if (is_null($notifyOnBatchPrintCompletion) || (is_array($notifyOnBatchPrintCompletion) && empty($notifyOnBatchPrintCompletion))) {
            unset($this->NotifyOnBatchPrintCompletion);
        } else {
            $this->NotifyOnBatchPrintCompletion = $notifyOnBatchPrintCompletion;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy1()
    {
        return isset($this->PrintingTicketsOrderBy1) ? $this->PrintingTicketsOrderBy1 : null;
    }
    /**
     * Set PrintingTicketsOrderBy1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy1
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy1($printingTicketsOrderBy1 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy1) && !is_string($printingTicketsOrderBy1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy1, true), gettype($printingTicketsOrderBy1)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy1) || (is_array($printingTicketsOrderBy1) && empty($printingTicketsOrderBy1))) {
            unset($this->PrintingTicketsOrderBy1);
        } else {
            $this->PrintingTicketsOrderBy1 = $printingTicketsOrderBy1;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy1Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy1Desc()
    {
        return isset($this->PrintingTicketsOrderBy1Desc) ? $this->PrintingTicketsOrderBy1Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy1Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy1Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy1Desc($printingTicketsOrderBy1Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy1Desc) && !is_bool($printingTicketsOrderBy1Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy1Desc, true), gettype($printingTicketsOrderBy1Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy1Desc) || (is_array($printingTicketsOrderBy1Desc) && empty($printingTicketsOrderBy1Desc))) {
            unset($this->PrintingTicketsOrderBy1Desc);
        } else {
            $this->PrintingTicketsOrderBy1Desc = $printingTicketsOrderBy1Desc;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy2()
    {
        return isset($this->PrintingTicketsOrderBy2) ? $this->PrintingTicketsOrderBy2 : null;
    }
    /**
     * Set PrintingTicketsOrderBy2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy2
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy2($printingTicketsOrderBy2 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy2) && !is_string($printingTicketsOrderBy2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy2, true), gettype($printingTicketsOrderBy2)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy2) || (is_array($printingTicketsOrderBy2) && empty($printingTicketsOrderBy2))) {
            unset($this->PrintingTicketsOrderBy2);
        } else {
            $this->PrintingTicketsOrderBy2 = $printingTicketsOrderBy2;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy2Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy2Desc()
    {
        return isset($this->PrintingTicketsOrderBy2Desc) ? $this->PrintingTicketsOrderBy2Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy2Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy2Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy2Desc($printingTicketsOrderBy2Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy2Desc) && !is_bool($printingTicketsOrderBy2Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy2Desc, true), gettype($printingTicketsOrderBy2Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy2Desc) || (is_array($printingTicketsOrderBy2Desc) && empty($printingTicketsOrderBy2Desc))) {
            unset($this->PrintingTicketsOrderBy2Desc);
        } else {
            $this->PrintingTicketsOrderBy2Desc = $printingTicketsOrderBy2Desc;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy3()
    {
        return isset($this->PrintingTicketsOrderBy3) ? $this->PrintingTicketsOrderBy3 : null;
    }
    /**
     * Set PrintingTicketsOrderBy3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy3
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy3($printingTicketsOrderBy3 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy3) && !is_string($printingTicketsOrderBy3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy3, true), gettype($printingTicketsOrderBy3)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy3) || (is_array($printingTicketsOrderBy3) && empty($printingTicketsOrderBy3))) {
            unset($this->PrintingTicketsOrderBy3);
        } else {
            $this->PrintingTicketsOrderBy3 = $printingTicketsOrderBy3;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy3Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy3Desc()
    {
        return isset($this->PrintingTicketsOrderBy3Desc) ? $this->PrintingTicketsOrderBy3Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy3Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy3Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy3Desc($printingTicketsOrderBy3Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy3Desc) && !is_bool($printingTicketsOrderBy3Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy3Desc, true), gettype($printingTicketsOrderBy3Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy3Desc) || (is_array($printingTicketsOrderBy3Desc) && empty($printingTicketsOrderBy3Desc))) {
            unset($this->PrintingTicketsOrderBy3Desc);
        } else {
            $this->PrintingTicketsOrderBy3Desc = $printingTicketsOrderBy3Desc;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy4()
    {
        return isset($this->PrintingTicketsOrderBy4) ? $this->PrintingTicketsOrderBy4 : null;
    }
    /**
     * Set PrintingTicketsOrderBy4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy4
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy4($printingTicketsOrderBy4 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy4) && !is_string($printingTicketsOrderBy4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy4, true), gettype($printingTicketsOrderBy4)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy4) || (is_array($printingTicketsOrderBy4) && empty($printingTicketsOrderBy4))) {
            unset($this->PrintingTicketsOrderBy4);
        } else {
            $this->PrintingTicketsOrderBy4 = $printingTicketsOrderBy4;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy4Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy4Desc()
    {
        return isset($this->PrintingTicketsOrderBy4Desc) ? $this->PrintingTicketsOrderBy4Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy4Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy4Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy4Desc($printingTicketsOrderBy4Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy4Desc) && !is_bool($printingTicketsOrderBy4Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy4Desc, true), gettype($printingTicketsOrderBy4Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy4Desc) || (is_array($printingTicketsOrderBy4Desc) && empty($printingTicketsOrderBy4Desc))) {
            unset($this->PrintingTicketsOrderBy4Desc);
        } else {
            $this->PrintingTicketsOrderBy4Desc = $printingTicketsOrderBy4Desc;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy5()
    {
        return isset($this->PrintingTicketsOrderBy5) ? $this->PrintingTicketsOrderBy5 : null;
    }
    /**
     * Set PrintingTicketsOrderBy5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy5
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy5($printingTicketsOrderBy5 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy5) && !is_string($printingTicketsOrderBy5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy5, true), gettype($printingTicketsOrderBy5)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy5) || (is_array($printingTicketsOrderBy5) && empty($printingTicketsOrderBy5))) {
            unset($this->PrintingTicketsOrderBy5);
        } else {
            $this->PrintingTicketsOrderBy5 = $printingTicketsOrderBy5;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy5Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy5Desc()
    {
        return isset($this->PrintingTicketsOrderBy5Desc) ? $this->PrintingTicketsOrderBy5Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy5Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy5Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy5Desc($printingTicketsOrderBy5Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy5Desc) && !is_bool($printingTicketsOrderBy5Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy5Desc, true), gettype($printingTicketsOrderBy5Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy5Desc) || (is_array($printingTicketsOrderBy5Desc) && empty($printingTicketsOrderBy5Desc))) {
            unset($this->PrintingTicketsOrderBy5Desc);
        } else {
            $this->PrintingTicketsOrderBy5Desc = $printingTicketsOrderBy5Desc;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingTicketsOrderBy6()
    {
        return isset($this->PrintingTicketsOrderBy6) ? $this->PrintingTicketsOrderBy6 : null;
    }
    /**
     * Set PrintingTicketsOrderBy6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingTicketsOrderBy6
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy6($printingTicketsOrderBy6 = null)
    {
        // validation for constraint: string
        if (!is_null($printingTicketsOrderBy6) && !is_string($printingTicketsOrderBy6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingTicketsOrderBy6, true), gettype($printingTicketsOrderBy6)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy6) || (is_array($printingTicketsOrderBy6) && empty($printingTicketsOrderBy6))) {
            unset($this->PrintingTicketsOrderBy6);
        } else {
            $this->PrintingTicketsOrderBy6 = $printingTicketsOrderBy6;
        }
        return $this;
    }
    /**
     * Get PrintingTicketsOrderBy6Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintingTicketsOrderBy6Desc()
    {
        return isset($this->PrintingTicketsOrderBy6Desc) ? $this->PrintingTicketsOrderBy6Desc : null;
    }
    /**
     * Set PrintingTicketsOrderBy6Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printingTicketsOrderBy6Desc
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintingTicketsOrderBy6Desc($printingTicketsOrderBy6Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($printingTicketsOrderBy6Desc) && !is_bool($printingTicketsOrderBy6Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printingTicketsOrderBy6Desc, true), gettype($printingTicketsOrderBy6Desc)), __LINE__);
        }
        if (is_null($printingTicketsOrderBy6Desc) || (is_array($printingTicketsOrderBy6Desc) && empty($printingTicketsOrderBy6Desc))) {
            unset($this->PrintingTicketsOrderBy6Desc);
        } else {
            $this->PrintingTicketsOrderBy6Desc = $printingTicketsOrderBy6Desc;
        }
        return $this;
    }
    /**
     * Get PrintSingleCustomerLabelPerAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintSingleCustomerLabelPerAddress()
    {
        return isset($this->PrintSingleCustomerLabelPerAddress) ? $this->PrintSingleCustomerLabelPerAddress : null;
    }
    /**
     * Set PrintSingleCustomerLabelPerAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printSingleCustomerLabelPerAddress
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setPrintSingleCustomerLabelPerAddress($printSingleCustomerLabelPerAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($printSingleCustomerLabelPerAddress) && !is_bool($printSingleCustomerLabelPerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printSingleCustomerLabelPerAddress, true), gettype($printSingleCustomerLabelPerAddress)), __LINE__);
        }
        if (is_null($printSingleCustomerLabelPerAddress) || (is_array($printSingleCustomerLabelPerAddress) && empty($printSingleCustomerLabelPerAddress))) {
            unset($this->PrintSingleCustomerLabelPerAddress);
        } else {
            $this->PrintSingleCustomerLabelPerAddress = $printSingleCustomerLabelPerAddress;
        }
        return $this;
    }
    /**
     * Get UseAutoLoadOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAutoLoadOnCard()
    {
        return isset($this->UseAutoLoadOnCard) ? $this->UseAutoLoadOnCard : null;
    }
    /**
     * Set UseAutoLoadOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAutoLoadOnCard
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setUseAutoLoadOnCard($useAutoLoadOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAutoLoadOnCard) && !is_bool($useAutoLoadOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAutoLoadOnCard, true), gettype($useAutoLoadOnCard)), __LINE__);
        }
        if (is_null($useAutoLoadOnCard) || (is_array($useAutoLoadOnCard) && empty($useAutoLoadOnCard))) {
            unset($this->UseAutoLoadOnCard);
        } else {
            $this->UseAutoLoadOnCard = $useAutoLoadOnCard;
        }
        return $this;
    }
    /**
     * Get UseMobileApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseMobileApp()
    {
        return isset($this->UseMobileApp) ? $this->UseMobileApp : null;
    }
    /**
     * Set UseMobileApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useMobileApp
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setUseMobileApp($useMobileApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMobileApp) && !is_bool($useMobileApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMobileApp, true), gettype($useMobileApp)), __LINE__);
        }
        if (is_null($useMobileApp) || (is_array($useMobileApp) && empty($useMobileApp))) {
            unset($this->UseMobileApp);
        } else {
            $this->UseMobileApp = $useMobileApp;
        }
        return $this;
    }
    /**
     * Get UseTicketPrintingMethodsRuleEngine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseTicketPrintingMethodsRuleEngine()
    {
        return isset($this->UseTicketPrintingMethodsRuleEngine) ? $this->UseTicketPrintingMethodsRuleEngine : null;
    }
    /**
     * Set UseTicketPrintingMethodsRuleEngine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useTicketPrintingMethodsRuleEngine
     * @return \patest\StructType\Security_PrintingCompanyParameters
     */
    public function setUseTicketPrintingMethodsRuleEngine($useTicketPrintingMethodsRuleEngine = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTicketPrintingMethodsRuleEngine) && !is_bool($useTicketPrintingMethodsRuleEngine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useTicketPrintingMethodsRuleEngine, true), gettype($useTicketPrintingMethodsRuleEngine)), __LINE__);
        }
        if (is_null($useTicketPrintingMethodsRuleEngine) || (is_array($useTicketPrintingMethodsRuleEngine) && empty($useTicketPrintingMethodsRuleEngine))) {
            unset($this->UseTicketPrintingMethodsRuleEngine);
        } else {
            $this->UseTicketPrintingMethodsRuleEngine = $useTicketPrintingMethodsRuleEngine;
        }
        return $this;
    }
}
