<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.PaymentCompanyParameters StructType
 * @subpackage Structs
 */
class Security_PaymentCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AdHocRefundAmountLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AdHocRefundAmountLimit;
    /**
     * The AllowImplicitSettlement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowImplicitSettlement;
    /**
     * The AllowPayForBalancedBasketWithProducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowPayForBalancedBasketWithProducts;
    /**
     * The AllowUnionAvailablePaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowUnionAvailablePaymentMethods;
    /**
     * The ClientPayForItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPayForItems;
    /**
     * The DirectDebitExportSummarizationPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitExportSummarizationPolicy;
    /**
     * The IsDisplayPointsAsCash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDisplayPointsAsCash;
    /**
     * The ItemsPaidByPointsGainPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemsPaidByPointsGainPoints;
    /**
     * The LoyaltyPointsExpiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LoyaltyPointsExpiry;
    /**
     * The LoyaltyPointsExpirySpecificDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoyaltyPointsExpirySpecificDate;
    /**
     * The LoyaltyPointsGrantPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoyaltyPointsGrantPolicy;
    /**
     * The LoyaltyPointsHandler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoyaltyPointsHandler;
    /**
     * The MaxPointsToGainPerOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxPointsToGainPerOwner;
    /**
     * The MaxPointsToGainPerOwner_Quality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxPointsToGainPerOwner_Quality;
    /**
     * The MaxPointsToGainPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxPointsToGainPerTransaction;
    /**
     * The MaxPointsToGainPerTransaction_Quality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxPointsToGainPerTransaction_Quality;
    /**
     * The PaymentLinkTimeout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentLinkTimeout;
    /**
     * The PaymentMethodsForInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodsForInstallments;
    /**
     * The PaymentMethodsForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodsForResale;
    /**
     * The PaymentMethodsForTicketSchemes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodsForTicketSchemes;
    /**
     * The PointExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PointExchange;
    /**
     * The PointsAlsoGrantedToAccounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PointsAlsoGrantedToAccounts;
    /**
     * The QualityPointsExpiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QualityPointsExpiry;
    /**
     * The QualityPointsExpirySpecificDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QualityPointsExpirySpecificDate;
    /**
     * The ShowLoyaltyBalanceOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowLoyaltyBalanceOnline;
    /**
     * The ShowLoyaltyBalanceOnlineExcludingClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowLoyaltyBalanceOnlineExcludingClientTypes;
    /**
     * The ShowQualityBalanceOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowQualityBalanceOnline;
    /**
     * The ShowQualityBalanceOnlineExcludingClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowQualityBalanceOnlineExcludingClientTypes;
    /**
     * The SupportedTransactionTypesForRecovery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportedTransactionTypesForRecovery;
    /**
     * The TransactionClientCanPayFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionClientCanPayFor;
    /**
     * Constructor method for Security.PaymentCompanyParameters
     * @uses Security_PaymentCompanyParameters::setAdHocRefundAmountLimit()
     * @uses Security_PaymentCompanyParameters::setAllowImplicitSettlement()
     * @uses Security_PaymentCompanyParameters::setAllowPayForBalancedBasketWithProducts()
     * @uses Security_PaymentCompanyParameters::setAllowUnionAvailablePaymentMethods()
     * @uses Security_PaymentCompanyParameters::setClientPayForItems()
     * @uses Security_PaymentCompanyParameters::setDirectDebitExportSummarizationPolicy()
     * @uses Security_PaymentCompanyParameters::setIsDisplayPointsAsCash()
     * @uses Security_PaymentCompanyParameters::setItemsPaidByPointsGainPoints()
     * @uses Security_PaymentCompanyParameters::setLoyaltyPointsExpiry()
     * @uses Security_PaymentCompanyParameters::setLoyaltyPointsExpirySpecificDate()
     * @uses Security_PaymentCompanyParameters::setLoyaltyPointsGrantPolicy()
     * @uses Security_PaymentCompanyParameters::setLoyaltyPointsHandler()
     * @uses Security_PaymentCompanyParameters::setMaxPointsToGainPerOwner()
     * @uses Security_PaymentCompanyParameters::setMaxPointsToGainPerOwner_Quality()
     * @uses Security_PaymentCompanyParameters::setMaxPointsToGainPerTransaction()
     * @uses Security_PaymentCompanyParameters::setMaxPointsToGainPerTransaction_Quality()
     * @uses Security_PaymentCompanyParameters::setPaymentLinkTimeout()
     * @uses Security_PaymentCompanyParameters::setPaymentMethodsForInstallments()
     * @uses Security_PaymentCompanyParameters::setPaymentMethodsForResale()
     * @uses Security_PaymentCompanyParameters::setPaymentMethodsForTicketSchemes()
     * @uses Security_PaymentCompanyParameters::setPointExchange()
     * @uses Security_PaymentCompanyParameters::setPointsAlsoGrantedToAccounts()
     * @uses Security_PaymentCompanyParameters::setQualityPointsExpiry()
     * @uses Security_PaymentCompanyParameters::setQualityPointsExpirySpecificDate()
     * @uses Security_PaymentCompanyParameters::setShowLoyaltyBalanceOnline()
     * @uses Security_PaymentCompanyParameters::setShowLoyaltyBalanceOnlineExcludingClientTypes()
     * @uses Security_PaymentCompanyParameters::setShowQualityBalanceOnline()
     * @uses Security_PaymentCompanyParameters::setShowQualityBalanceOnlineExcludingClientTypes()
     * @uses Security_PaymentCompanyParameters::setSupportedTransactionTypesForRecovery()
     * @uses Security_PaymentCompanyParameters::setTransactionClientCanPayFor()
     * @param \patest\StructType\Money $adHocRefundAmountLimit
     * @param bool $allowImplicitSettlement
     * @param bool $allowPayForBalancedBasketWithProducts
     * @param bool $allowUnionAvailablePaymentMethods
     * @param string $clientPayForItems
     * @param string $directDebitExportSummarizationPolicy
     * @param bool $isDisplayPointsAsCash
     * @param string $itemsPaidByPointsGainPoints
     * @param int $loyaltyPointsExpiry
     * @param string $loyaltyPointsExpirySpecificDate
     * @param string $loyaltyPointsGrantPolicy
     * @param string $loyaltyPointsHandler
     * @param float $maxPointsToGainPerOwner
     * @param float $maxPointsToGainPerOwner_Quality
     * @param float $maxPointsToGainPerTransaction
     * @param float $maxPointsToGainPerTransaction_Quality
     * @param int $paymentLinkTimeout
     * @param string $paymentMethodsForInstallments
     * @param string $paymentMethodsForResale
     * @param string $paymentMethodsForTicketSchemes
     * @param float $pointExchange
     * @param bool $pointsAlsoGrantedToAccounts
     * @param int $qualityPointsExpiry
     * @param string $qualityPointsExpirySpecificDate
     * @param bool $showLoyaltyBalanceOnline
     * @param string $showLoyaltyBalanceOnlineExcludingClientTypes
     * @param bool $showQualityBalanceOnline
     * @param string $showQualityBalanceOnlineExcludingClientTypes
     * @param string $supportedTransactionTypesForRecovery
     * @param string $transactionClientCanPayFor
     */
    public function __construct(\patest\StructType\Money $adHocRefundAmountLimit = null, $allowImplicitSettlement = null, $allowPayForBalancedBasketWithProducts = null, $allowUnionAvailablePaymentMethods = null, $clientPayForItems = null, $directDebitExportSummarizationPolicy = null, $isDisplayPointsAsCash = null, $itemsPaidByPointsGainPoints = null, $loyaltyPointsExpiry = null, $loyaltyPointsExpirySpecificDate = null, $loyaltyPointsGrantPolicy = null, $loyaltyPointsHandler = null, $maxPointsToGainPerOwner = null, $maxPointsToGainPerOwner_Quality = null, $maxPointsToGainPerTransaction = null, $maxPointsToGainPerTransaction_Quality = null, $paymentLinkTimeout = null, $paymentMethodsForInstallments = null, $paymentMethodsForResale = null, $paymentMethodsForTicketSchemes = null, $pointExchange = null, $pointsAlsoGrantedToAccounts = null, $qualityPointsExpiry = null, $qualityPointsExpirySpecificDate = null, $showLoyaltyBalanceOnline = null, $showLoyaltyBalanceOnlineExcludingClientTypes = null, $showQualityBalanceOnline = null, $showQualityBalanceOnlineExcludingClientTypes = null, $supportedTransactionTypesForRecovery = null, $transactionClientCanPayFor = null)
    {
        $this
            ->setAdHocRefundAmountLimit($adHocRefundAmountLimit)
            ->setAllowImplicitSettlement($allowImplicitSettlement)
            ->setAllowPayForBalancedBasketWithProducts($allowPayForBalancedBasketWithProducts)
            ->setAllowUnionAvailablePaymentMethods($allowUnionAvailablePaymentMethods)
            ->setClientPayForItems($clientPayForItems)
            ->setDirectDebitExportSummarizationPolicy($directDebitExportSummarizationPolicy)
            ->setIsDisplayPointsAsCash($isDisplayPointsAsCash)
            ->setItemsPaidByPointsGainPoints($itemsPaidByPointsGainPoints)
            ->setLoyaltyPointsExpiry($loyaltyPointsExpiry)
            ->setLoyaltyPointsExpirySpecificDate($loyaltyPointsExpirySpecificDate)
            ->setLoyaltyPointsGrantPolicy($loyaltyPointsGrantPolicy)
            ->setLoyaltyPointsHandler($loyaltyPointsHandler)
            ->setMaxPointsToGainPerOwner($maxPointsToGainPerOwner)
            ->setMaxPointsToGainPerOwner_Quality($maxPointsToGainPerOwner_Quality)
            ->setMaxPointsToGainPerTransaction($maxPointsToGainPerTransaction)
            ->setMaxPointsToGainPerTransaction_Quality($maxPointsToGainPerTransaction_Quality)
            ->setPaymentLinkTimeout($paymentLinkTimeout)
            ->setPaymentMethodsForInstallments($paymentMethodsForInstallments)
            ->setPaymentMethodsForResale($paymentMethodsForResale)
            ->setPaymentMethodsForTicketSchemes($paymentMethodsForTicketSchemes)
            ->setPointExchange($pointExchange)
            ->setPointsAlsoGrantedToAccounts($pointsAlsoGrantedToAccounts)
            ->setQualityPointsExpiry($qualityPointsExpiry)
            ->setQualityPointsExpirySpecificDate($qualityPointsExpirySpecificDate)
            ->setShowLoyaltyBalanceOnline($showLoyaltyBalanceOnline)
            ->setShowLoyaltyBalanceOnlineExcludingClientTypes($showLoyaltyBalanceOnlineExcludingClientTypes)
            ->setShowQualityBalanceOnline($showQualityBalanceOnline)
            ->setShowQualityBalanceOnlineExcludingClientTypes($showQualityBalanceOnlineExcludingClientTypes)
            ->setSupportedTransactionTypesForRecovery($supportedTransactionTypesForRecovery)
            ->setTransactionClientCanPayFor($transactionClientCanPayFor);
    }
    /**
     * Get AdHocRefundAmountLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAdHocRefundAmountLimit()
    {
        return isset($this->AdHocRefundAmountLimit) ? $this->AdHocRefundAmountLimit : null;
    }
    /**
     * Set AdHocRefundAmountLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $adHocRefundAmountLimit
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setAdHocRefundAmountLimit(\patest\StructType\Money $adHocRefundAmountLimit = null)
    {
        if (is_null($adHocRefundAmountLimit) || (is_array($adHocRefundAmountLimit) && empty($adHocRefundAmountLimit))) {
            unset($this->AdHocRefundAmountLimit);
        } else {
            $this->AdHocRefundAmountLimit = $adHocRefundAmountLimit;
        }
        return $this;
    }
    /**
     * Get AllowImplicitSettlement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowImplicitSettlement()
    {
        return isset($this->AllowImplicitSettlement) ? $this->AllowImplicitSettlement : null;
    }
    /**
     * Set AllowImplicitSettlement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowImplicitSettlement
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setAllowImplicitSettlement($allowImplicitSettlement = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowImplicitSettlement) && !is_bool($allowImplicitSettlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowImplicitSettlement, true), gettype($allowImplicitSettlement)), __LINE__);
        }
        if (is_null($allowImplicitSettlement) || (is_array($allowImplicitSettlement) && empty($allowImplicitSettlement))) {
            unset($this->AllowImplicitSettlement);
        } else {
            $this->AllowImplicitSettlement = $allowImplicitSettlement;
        }
        return $this;
    }
    /**
     * Get AllowPayForBalancedBasketWithProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowPayForBalancedBasketWithProducts()
    {
        return isset($this->AllowPayForBalancedBasketWithProducts) ? $this->AllowPayForBalancedBasketWithProducts : null;
    }
    /**
     * Set AllowPayForBalancedBasketWithProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowPayForBalancedBasketWithProducts
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setAllowPayForBalancedBasketWithProducts($allowPayForBalancedBasketWithProducts = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPayForBalancedBasketWithProducts) && !is_bool($allowPayForBalancedBasketWithProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPayForBalancedBasketWithProducts, true), gettype($allowPayForBalancedBasketWithProducts)), __LINE__);
        }
        if (is_null($allowPayForBalancedBasketWithProducts) || (is_array($allowPayForBalancedBasketWithProducts) && empty($allowPayForBalancedBasketWithProducts))) {
            unset($this->AllowPayForBalancedBasketWithProducts);
        } else {
            $this->AllowPayForBalancedBasketWithProducts = $allowPayForBalancedBasketWithProducts;
        }
        return $this;
    }
    /**
     * Get AllowUnionAvailablePaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowUnionAvailablePaymentMethods()
    {
        return isset($this->AllowUnionAvailablePaymentMethods) ? $this->AllowUnionAvailablePaymentMethods : null;
    }
    /**
     * Set AllowUnionAvailablePaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowUnionAvailablePaymentMethods
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setAllowUnionAvailablePaymentMethods($allowUnionAvailablePaymentMethods = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowUnionAvailablePaymentMethods) && !is_bool($allowUnionAvailablePaymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowUnionAvailablePaymentMethods, true), gettype($allowUnionAvailablePaymentMethods)), __LINE__);
        }
        if (is_null($allowUnionAvailablePaymentMethods) || (is_array($allowUnionAvailablePaymentMethods) && empty($allowUnionAvailablePaymentMethods))) {
            unset($this->AllowUnionAvailablePaymentMethods);
        } else {
            $this->AllowUnionAvailablePaymentMethods = $allowUnionAvailablePaymentMethods;
        }
        return $this;
    }
    /**
     * Get ClientPayForItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPayForItems()
    {
        return isset($this->ClientPayForItems) ? $this->ClientPayForItems : null;
    }
    /**
     * Set ClientPayForItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientPayForItemsEnum::valueIsValid()
     * @uses \patest\EnumType\ClientPayForItemsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientPayForItems
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setClientPayForItems($clientPayForItems = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientPayForItemsEnum::valueIsValid($clientPayForItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientPayForItemsEnum', is_array($clientPayForItems) ? implode(', ', $clientPayForItems) : var_export($clientPayForItems, true), implode(', ', \patest\EnumType\ClientPayForItemsEnum::getValidValues())), __LINE__);
        }
        if (is_null($clientPayForItems) || (is_array($clientPayForItems) && empty($clientPayForItems))) {
            unset($this->ClientPayForItems);
        } else {
            $this->ClientPayForItems = $clientPayForItems;
        }
        return $this;
    }
    /**
     * Get DirectDebitExportSummarizationPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitExportSummarizationPolicy()
    {
        return isset($this->DirectDebitExportSummarizationPolicy) ? $this->DirectDebitExportSummarizationPolicy : null;
    }
    /**
     * Set DirectDebitExportSummarizationPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DirectDebitExportSummarizationPolicy::valueIsValid()
     * @uses \patest\EnumType\DirectDebitExportSummarizationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directDebitExportSummarizationPolicy
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setDirectDebitExportSummarizationPolicy($directDebitExportSummarizationPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DirectDebitExportSummarizationPolicy::valueIsValid($directDebitExportSummarizationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DirectDebitExportSummarizationPolicy', is_array($directDebitExportSummarizationPolicy) ? implode(', ', $directDebitExportSummarizationPolicy) : var_export($directDebitExportSummarizationPolicy, true), implode(', ', \patest\EnumType\DirectDebitExportSummarizationPolicy::getValidValues())), __LINE__);
        }
        if (is_null($directDebitExportSummarizationPolicy) || (is_array($directDebitExportSummarizationPolicy) && empty($directDebitExportSummarizationPolicy))) {
            unset($this->DirectDebitExportSummarizationPolicy);
        } else {
            $this->DirectDebitExportSummarizationPolicy = $directDebitExportSummarizationPolicy;
        }
        return $this;
    }
    /**
     * Get IsDisplayPointsAsCash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDisplayPointsAsCash()
    {
        return isset($this->IsDisplayPointsAsCash) ? $this->IsDisplayPointsAsCash : null;
    }
    /**
     * Set IsDisplayPointsAsCash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDisplayPointsAsCash
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setIsDisplayPointsAsCash($isDisplayPointsAsCash = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDisplayPointsAsCash) && !is_bool($isDisplayPointsAsCash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisplayPointsAsCash, true), gettype($isDisplayPointsAsCash)), __LINE__);
        }
        if (is_null($isDisplayPointsAsCash) || (is_array($isDisplayPointsAsCash) && empty($isDisplayPointsAsCash))) {
            unset($this->IsDisplayPointsAsCash);
        } else {
            $this->IsDisplayPointsAsCash = $isDisplayPointsAsCash;
        }
        return $this;
    }
    /**
     * Get ItemsPaidByPointsGainPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemsPaidByPointsGainPoints()
    {
        return isset($this->ItemsPaidByPointsGainPoints) ? $this->ItemsPaidByPointsGainPoints : null;
    }
    /**
     * Set ItemsPaidByPointsGainPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemPaidByPointsGainPointsEnum::valueIsValid()
     * @uses \patest\EnumType\ItemPaidByPointsGainPointsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemsPaidByPointsGainPoints
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setItemsPaidByPointsGainPoints($itemsPaidByPointsGainPoints = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemPaidByPointsGainPointsEnum::valueIsValid($itemsPaidByPointsGainPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemPaidByPointsGainPointsEnum', is_array($itemsPaidByPointsGainPoints) ? implode(', ', $itemsPaidByPointsGainPoints) : var_export($itemsPaidByPointsGainPoints, true), implode(', ', \patest\EnumType\ItemPaidByPointsGainPointsEnum::getValidValues())), __LINE__);
        }
        if (is_null($itemsPaidByPointsGainPoints) || (is_array($itemsPaidByPointsGainPoints) && empty($itemsPaidByPointsGainPoints))) {
            unset($this->ItemsPaidByPointsGainPoints);
        } else {
            $this->ItemsPaidByPointsGainPoints = $itemsPaidByPointsGainPoints;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLoyaltyPointsExpiry()
    {
        return isset($this->LoyaltyPointsExpiry) ? $this->LoyaltyPointsExpiry : null;
    }
    /**
     * Set LoyaltyPointsExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $loyaltyPointsExpiry
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setLoyaltyPointsExpiry($loyaltyPointsExpiry = null)
    {
        // validation for constraint: int
        if (!is_null($loyaltyPointsExpiry) && !(is_int($loyaltyPointsExpiry) || ctype_digit($loyaltyPointsExpiry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyaltyPointsExpiry, true), gettype($loyaltyPointsExpiry)), __LINE__);
        }
        if (is_null($loyaltyPointsExpiry) || (is_array($loyaltyPointsExpiry) && empty($loyaltyPointsExpiry))) {
            unset($this->LoyaltyPointsExpiry);
        } else {
            $this->LoyaltyPointsExpiry = $loyaltyPointsExpiry;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsExpirySpecificDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoyaltyPointsExpirySpecificDate()
    {
        return isset($this->LoyaltyPointsExpirySpecificDate) ? $this->LoyaltyPointsExpirySpecificDate : null;
    }
    /**
     * Set LoyaltyPointsExpirySpecificDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loyaltyPointsExpirySpecificDate
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setLoyaltyPointsExpirySpecificDate($loyaltyPointsExpirySpecificDate = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyPointsExpirySpecificDate) && !is_string($loyaltyPointsExpirySpecificDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyPointsExpirySpecificDate, true), gettype($loyaltyPointsExpirySpecificDate)), __LINE__);
        }
        if (is_null($loyaltyPointsExpirySpecificDate) || (is_array($loyaltyPointsExpirySpecificDate) && empty($loyaltyPointsExpirySpecificDate))) {
            unset($this->LoyaltyPointsExpirySpecificDate);
        } else {
            $this->LoyaltyPointsExpirySpecificDate = $loyaltyPointsExpirySpecificDate;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsGrantPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoyaltyPointsGrantPolicy()
    {
        return isset($this->LoyaltyPointsGrantPolicy) ? $this->LoyaltyPointsGrantPolicy : null;
    }
    /**
     * Set LoyaltyPointsGrantPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsGrantPolicyForNonMoneyPayments::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsGrantPolicyForNonMoneyPayments::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loyaltyPointsGrantPolicy
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setLoyaltyPointsGrantPolicy($loyaltyPointsGrantPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsGrantPolicyForNonMoneyPayments::valueIsValid($loyaltyPointsGrantPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsGrantPolicyForNonMoneyPayments', is_array($loyaltyPointsGrantPolicy) ? implode(', ', $loyaltyPointsGrantPolicy) : var_export($loyaltyPointsGrantPolicy, true), implode(', ', \patest\EnumType\LoyaltyPointsGrantPolicyForNonMoneyPayments::getValidValues())), __LINE__);
        }
        if (is_null($loyaltyPointsGrantPolicy) || (is_array($loyaltyPointsGrantPolicy) && empty($loyaltyPointsGrantPolicy))) {
            unset($this->LoyaltyPointsGrantPolicy);
        } else {
            $this->LoyaltyPointsGrantPolicy = $loyaltyPointsGrantPolicy;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsHandler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoyaltyPointsHandler()
    {
        return isset($this->LoyaltyPointsHandler) ? $this->LoyaltyPointsHandler : null;
    }
    /**
     * Set LoyaltyPointsHandler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loyaltyPointsHandler
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setLoyaltyPointsHandler($loyaltyPointsHandler = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyPointsHandler) && !is_string($loyaltyPointsHandler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyPointsHandler, true), gettype($loyaltyPointsHandler)), __LINE__);
        }
        if (is_null($loyaltyPointsHandler) || (is_array($loyaltyPointsHandler) && empty($loyaltyPointsHandler))) {
            unset($this->LoyaltyPointsHandler);
        } else {
            $this->LoyaltyPointsHandler = $loyaltyPointsHandler;
        }
        return $this;
    }
    /**
     * Get MaxPointsToGainPerOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxPointsToGainPerOwner()
    {
        return isset($this->MaxPointsToGainPerOwner) ? $this->MaxPointsToGainPerOwner : null;
    }
    /**
     * Set MaxPointsToGainPerOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxPointsToGainPerOwner
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setMaxPointsToGainPerOwner($maxPointsToGainPerOwner = null)
    {
        // validation for constraint: float
        if (!is_null($maxPointsToGainPerOwner) && !(is_float($maxPointsToGainPerOwner) || is_numeric($maxPointsToGainPerOwner))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxPointsToGainPerOwner, true), gettype($maxPointsToGainPerOwner)), __LINE__);
        }
        if (is_null($maxPointsToGainPerOwner) || (is_array($maxPointsToGainPerOwner) && empty($maxPointsToGainPerOwner))) {
            unset($this->MaxPointsToGainPerOwner);
        } else {
            $this->MaxPointsToGainPerOwner = $maxPointsToGainPerOwner;
        }
        return $this;
    }
    /**
     * Get MaxPointsToGainPerOwner_Quality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxPointsToGainPerOwner_Quality()
    {
        return isset($this->MaxPointsToGainPerOwner_Quality) ? $this->MaxPointsToGainPerOwner_Quality : null;
    }
    /**
     * Set MaxPointsToGainPerOwner_Quality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxPointsToGainPerOwner_Quality
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setMaxPointsToGainPerOwner_Quality($maxPointsToGainPerOwner_Quality = null)
    {
        // validation for constraint: float
        if (!is_null($maxPointsToGainPerOwner_Quality) && !(is_float($maxPointsToGainPerOwner_Quality) || is_numeric($maxPointsToGainPerOwner_Quality))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxPointsToGainPerOwner_Quality, true), gettype($maxPointsToGainPerOwner_Quality)), __LINE__);
        }
        if (is_null($maxPointsToGainPerOwner_Quality) || (is_array($maxPointsToGainPerOwner_Quality) && empty($maxPointsToGainPerOwner_Quality))) {
            unset($this->MaxPointsToGainPerOwner_Quality);
        } else {
            $this->MaxPointsToGainPerOwner_Quality = $maxPointsToGainPerOwner_Quality;
        }
        return $this;
    }
    /**
     * Get MaxPointsToGainPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxPointsToGainPerTransaction()
    {
        return isset($this->MaxPointsToGainPerTransaction) ? $this->MaxPointsToGainPerTransaction : null;
    }
    /**
     * Set MaxPointsToGainPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxPointsToGainPerTransaction
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setMaxPointsToGainPerTransaction($maxPointsToGainPerTransaction = null)
    {
        // validation for constraint: float
        if (!is_null($maxPointsToGainPerTransaction) && !(is_float($maxPointsToGainPerTransaction) || is_numeric($maxPointsToGainPerTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxPointsToGainPerTransaction, true), gettype($maxPointsToGainPerTransaction)), __LINE__);
        }
        if (is_null($maxPointsToGainPerTransaction) || (is_array($maxPointsToGainPerTransaction) && empty($maxPointsToGainPerTransaction))) {
            unset($this->MaxPointsToGainPerTransaction);
        } else {
            $this->MaxPointsToGainPerTransaction = $maxPointsToGainPerTransaction;
        }
        return $this;
    }
    /**
     * Get MaxPointsToGainPerTransaction_Quality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxPointsToGainPerTransaction_Quality()
    {
        return isset($this->MaxPointsToGainPerTransaction_Quality) ? $this->MaxPointsToGainPerTransaction_Quality : null;
    }
    /**
     * Set MaxPointsToGainPerTransaction_Quality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxPointsToGainPerTransaction_Quality
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setMaxPointsToGainPerTransaction_Quality($maxPointsToGainPerTransaction_Quality = null)
    {
        // validation for constraint: float
        if (!is_null($maxPointsToGainPerTransaction_Quality) && !(is_float($maxPointsToGainPerTransaction_Quality) || is_numeric($maxPointsToGainPerTransaction_Quality))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxPointsToGainPerTransaction_Quality, true), gettype($maxPointsToGainPerTransaction_Quality)), __LINE__);
        }
        if (is_null($maxPointsToGainPerTransaction_Quality) || (is_array($maxPointsToGainPerTransaction_Quality) && empty($maxPointsToGainPerTransaction_Quality))) {
            unset($this->MaxPointsToGainPerTransaction_Quality);
        } else {
            $this->MaxPointsToGainPerTransaction_Quality = $maxPointsToGainPerTransaction_Quality;
        }
        return $this;
    }
    /**
     * Get PaymentLinkTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentLinkTimeout()
    {
        return isset($this->PaymentLinkTimeout) ? $this->PaymentLinkTimeout : null;
    }
    /**
     * Set PaymentLinkTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentLinkTimeout
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPaymentLinkTimeout($paymentLinkTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLinkTimeout) && !(is_int($paymentLinkTimeout) || ctype_digit($paymentLinkTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentLinkTimeout, true), gettype($paymentLinkTimeout)), __LINE__);
        }
        if (is_null($paymentLinkTimeout) || (is_array($paymentLinkTimeout) && empty($paymentLinkTimeout))) {
            unset($this->PaymentLinkTimeout);
        } else {
            $this->PaymentLinkTimeout = $paymentLinkTimeout;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsForInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodsForInstallments()
    {
        return isset($this->PaymentMethodsForInstallments) ? $this->PaymentMethodsForInstallments : null;
    }
    /**
     * Set PaymentMethodsForInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodsForInstallments
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPaymentMethodsForInstallments($paymentMethodsForInstallments = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodsForInstallments) && !is_string($paymentMethodsForInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodsForInstallments, true), gettype($paymentMethodsForInstallments)), __LINE__);
        }
        if (is_null($paymentMethodsForInstallments) || (is_array($paymentMethodsForInstallments) && empty($paymentMethodsForInstallments))) {
            unset($this->PaymentMethodsForInstallments);
        } else {
            $this->PaymentMethodsForInstallments = $paymentMethodsForInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodsForResale()
    {
        return isset($this->PaymentMethodsForResale) ? $this->PaymentMethodsForResale : null;
    }
    /**
     * Set PaymentMethodsForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodsForResale
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPaymentMethodsForResale($paymentMethodsForResale = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodsForResale) && !is_string($paymentMethodsForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodsForResale, true), gettype($paymentMethodsForResale)), __LINE__);
        }
        if (is_null($paymentMethodsForResale) || (is_array($paymentMethodsForResale) && empty($paymentMethodsForResale))) {
            unset($this->PaymentMethodsForResale);
        } else {
            $this->PaymentMethodsForResale = $paymentMethodsForResale;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsForTicketSchemes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodsForTicketSchemes()
    {
        return isset($this->PaymentMethodsForTicketSchemes) ? $this->PaymentMethodsForTicketSchemes : null;
    }
    /**
     * Set PaymentMethodsForTicketSchemes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodsForTicketSchemes
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPaymentMethodsForTicketSchemes($paymentMethodsForTicketSchemes = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodsForTicketSchemes) && !is_string($paymentMethodsForTicketSchemes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodsForTicketSchemes, true), gettype($paymentMethodsForTicketSchemes)), __LINE__);
        }
        if (is_null($paymentMethodsForTicketSchemes) || (is_array($paymentMethodsForTicketSchemes) && empty($paymentMethodsForTicketSchemes))) {
            unset($this->PaymentMethodsForTicketSchemes);
        } else {
            $this->PaymentMethodsForTicketSchemes = $paymentMethodsForTicketSchemes;
        }
        return $this;
    }
    /**
     * Get PointExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPointExchange()
    {
        return isset($this->PointExchange) ? $this->PointExchange : null;
    }
    /**
     * Set PointExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pointExchange
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPointExchange($pointExchange = null)
    {
        // validation for constraint: float
        if (!is_null($pointExchange) && !(is_float($pointExchange) || is_numeric($pointExchange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointExchange, true), gettype($pointExchange)), __LINE__);
        }
        if (is_null($pointExchange) || (is_array($pointExchange) && empty($pointExchange))) {
            unset($this->PointExchange);
        } else {
            $this->PointExchange = $pointExchange;
        }
        return $this;
    }
    /**
     * Get PointsAlsoGrantedToAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPointsAlsoGrantedToAccounts()
    {
        return isset($this->PointsAlsoGrantedToAccounts) ? $this->PointsAlsoGrantedToAccounts : null;
    }
    /**
     * Set PointsAlsoGrantedToAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pointsAlsoGrantedToAccounts
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setPointsAlsoGrantedToAccounts($pointsAlsoGrantedToAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($pointsAlsoGrantedToAccounts) && !is_bool($pointsAlsoGrantedToAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pointsAlsoGrantedToAccounts, true), gettype($pointsAlsoGrantedToAccounts)), __LINE__);
        }
        if (is_null($pointsAlsoGrantedToAccounts) || (is_array($pointsAlsoGrantedToAccounts) && empty($pointsAlsoGrantedToAccounts))) {
            unset($this->PointsAlsoGrantedToAccounts);
        } else {
            $this->PointsAlsoGrantedToAccounts = $pointsAlsoGrantedToAccounts;
        }
        return $this;
    }
    /**
     * Get QualityPointsExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQualityPointsExpiry()
    {
        return isset($this->QualityPointsExpiry) ? $this->QualityPointsExpiry : null;
    }
    /**
     * Set QualityPointsExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qualityPointsExpiry
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setQualityPointsExpiry($qualityPointsExpiry = null)
    {
        // validation for constraint: int
        if (!is_null($qualityPointsExpiry) && !(is_int($qualityPointsExpiry) || ctype_digit($qualityPointsExpiry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qualityPointsExpiry, true), gettype($qualityPointsExpiry)), __LINE__);
        }
        if (is_null($qualityPointsExpiry) || (is_array($qualityPointsExpiry) && empty($qualityPointsExpiry))) {
            unset($this->QualityPointsExpiry);
        } else {
            $this->QualityPointsExpiry = $qualityPointsExpiry;
        }
        return $this;
    }
    /**
     * Get QualityPointsExpirySpecificDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQualityPointsExpirySpecificDate()
    {
        return isset($this->QualityPointsExpirySpecificDate) ? $this->QualityPointsExpirySpecificDate : null;
    }
    /**
     * Set QualityPointsExpirySpecificDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qualityPointsExpirySpecificDate
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setQualityPointsExpirySpecificDate($qualityPointsExpirySpecificDate = null)
    {
        // validation for constraint: string
        if (!is_null($qualityPointsExpirySpecificDate) && !is_string($qualityPointsExpirySpecificDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualityPointsExpirySpecificDate, true), gettype($qualityPointsExpirySpecificDate)), __LINE__);
        }
        if (is_null($qualityPointsExpirySpecificDate) || (is_array($qualityPointsExpirySpecificDate) && empty($qualityPointsExpirySpecificDate))) {
            unset($this->QualityPointsExpirySpecificDate);
        } else {
            $this->QualityPointsExpirySpecificDate = $qualityPointsExpirySpecificDate;
        }
        return $this;
    }
    /**
     * Get ShowLoyaltyBalanceOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowLoyaltyBalanceOnline()
    {
        return isset($this->ShowLoyaltyBalanceOnline) ? $this->ShowLoyaltyBalanceOnline : null;
    }
    /**
     * Set ShowLoyaltyBalanceOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showLoyaltyBalanceOnline
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setShowLoyaltyBalanceOnline($showLoyaltyBalanceOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLoyaltyBalanceOnline) && !is_bool($showLoyaltyBalanceOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLoyaltyBalanceOnline, true), gettype($showLoyaltyBalanceOnline)), __LINE__);
        }
        if (is_null($showLoyaltyBalanceOnline) || (is_array($showLoyaltyBalanceOnline) && empty($showLoyaltyBalanceOnline))) {
            unset($this->ShowLoyaltyBalanceOnline);
        } else {
            $this->ShowLoyaltyBalanceOnline = $showLoyaltyBalanceOnline;
        }
        return $this;
    }
    /**
     * Get ShowLoyaltyBalanceOnlineExcludingClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowLoyaltyBalanceOnlineExcludingClientTypes()
    {
        return isset($this->ShowLoyaltyBalanceOnlineExcludingClientTypes) ? $this->ShowLoyaltyBalanceOnlineExcludingClientTypes : null;
    }
    /**
     * Set ShowLoyaltyBalanceOnlineExcludingClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showLoyaltyBalanceOnlineExcludingClientTypes
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setShowLoyaltyBalanceOnlineExcludingClientTypes($showLoyaltyBalanceOnlineExcludingClientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($showLoyaltyBalanceOnlineExcludingClientTypes) && !is_string($showLoyaltyBalanceOnlineExcludingClientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showLoyaltyBalanceOnlineExcludingClientTypes, true), gettype($showLoyaltyBalanceOnlineExcludingClientTypes)), __LINE__);
        }
        if (is_null($showLoyaltyBalanceOnlineExcludingClientTypes) || (is_array($showLoyaltyBalanceOnlineExcludingClientTypes) && empty($showLoyaltyBalanceOnlineExcludingClientTypes))) {
            unset($this->ShowLoyaltyBalanceOnlineExcludingClientTypes);
        } else {
            $this->ShowLoyaltyBalanceOnlineExcludingClientTypes = $showLoyaltyBalanceOnlineExcludingClientTypes;
        }
        return $this;
    }
    /**
     * Get ShowQualityBalanceOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowQualityBalanceOnline()
    {
        return isset($this->ShowQualityBalanceOnline) ? $this->ShowQualityBalanceOnline : null;
    }
    /**
     * Set ShowQualityBalanceOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showQualityBalanceOnline
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setShowQualityBalanceOnline($showQualityBalanceOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($showQualityBalanceOnline) && !is_bool($showQualityBalanceOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showQualityBalanceOnline, true), gettype($showQualityBalanceOnline)), __LINE__);
        }
        if (is_null($showQualityBalanceOnline) || (is_array($showQualityBalanceOnline) && empty($showQualityBalanceOnline))) {
            unset($this->ShowQualityBalanceOnline);
        } else {
            $this->ShowQualityBalanceOnline = $showQualityBalanceOnline;
        }
        return $this;
    }
    /**
     * Get ShowQualityBalanceOnlineExcludingClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowQualityBalanceOnlineExcludingClientTypes()
    {
        return isset($this->ShowQualityBalanceOnlineExcludingClientTypes) ? $this->ShowQualityBalanceOnlineExcludingClientTypes : null;
    }
    /**
     * Set ShowQualityBalanceOnlineExcludingClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showQualityBalanceOnlineExcludingClientTypes
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setShowQualityBalanceOnlineExcludingClientTypes($showQualityBalanceOnlineExcludingClientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($showQualityBalanceOnlineExcludingClientTypes) && !is_string($showQualityBalanceOnlineExcludingClientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showQualityBalanceOnlineExcludingClientTypes, true), gettype($showQualityBalanceOnlineExcludingClientTypes)), __LINE__);
        }
        if (is_null($showQualityBalanceOnlineExcludingClientTypes) || (is_array($showQualityBalanceOnlineExcludingClientTypes) && empty($showQualityBalanceOnlineExcludingClientTypes))) {
            unset($this->ShowQualityBalanceOnlineExcludingClientTypes);
        } else {
            $this->ShowQualityBalanceOnlineExcludingClientTypes = $showQualityBalanceOnlineExcludingClientTypes;
        }
        return $this;
    }
    /**
     * Get SupportedTransactionTypesForRecovery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportedTransactionTypesForRecovery()
    {
        return isset($this->SupportedTransactionTypesForRecovery) ? $this->SupportedTransactionTypesForRecovery : null;
    }
    /**
     * Set SupportedTransactionTypesForRecovery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supportedTransactionTypesForRecovery
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setSupportedTransactionTypesForRecovery($supportedTransactionTypesForRecovery = null)
    {
        // validation for constraint: string
        if (!is_null($supportedTransactionTypesForRecovery) && !is_string($supportedTransactionTypesForRecovery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supportedTransactionTypesForRecovery, true), gettype($supportedTransactionTypesForRecovery)), __LINE__);
        }
        if (is_null($supportedTransactionTypesForRecovery) || (is_array($supportedTransactionTypesForRecovery) && empty($supportedTransactionTypesForRecovery))) {
            unset($this->SupportedTransactionTypesForRecovery);
        } else {
            $this->SupportedTransactionTypesForRecovery = $supportedTransactionTypesForRecovery;
        }
        return $this;
    }
    /**
     * Get TransactionClientCanPayFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionClientCanPayFor()
    {
        return isset($this->TransactionClientCanPayFor) ? $this->TransactionClientCanPayFor : null;
    }
    /**
     * Set TransactionClientCanPayFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionClientCanPayForEnum::valueIsValid()
     * @uses \patest\EnumType\TransactionClientCanPayForEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionClientCanPayFor
     * @return \patest\StructType\Security_PaymentCompanyParameters
     */
    public function setTransactionClientCanPayFor($transactionClientCanPayFor = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionClientCanPayForEnum::valueIsValid($transactionClientCanPayFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionClientCanPayForEnum', is_array($transactionClientCanPayFor) ? implode(', ', $transactionClientCanPayFor) : var_export($transactionClientCanPayFor, true), implode(', ', \patest\EnumType\TransactionClientCanPayForEnum::getValidValues())), __LINE__);
        }
        if (is_null($transactionClientCanPayFor) || (is_array($transactionClientCanPayFor) && empty($transactionClientCanPayFor))) {
            unset($this->TransactionClientCanPayFor);
        } else {
            $this->TransactionClientCanPayFor = $transactionClientCanPayFor;
        }
        return $this;
    }
}
