<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.OTPParameters StructType
 * @subpackage Structs
 */
class Security_OTPParameters extends Security_CompanyParameterBase
{
    /**
     * The BlockBruteForceLogins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BlockBruteForceLogins;
    /**
     * The BlockingEmailBody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BlockingEmailBody;
    /**
     * The BlockingEmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BlockingEmailSubject;
    /**
     * The EmailBody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EmailBody;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EmailSubject;
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnabled;
    /**
     * The MaxBruteForceAttempts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxBruteForceAttempts;
    /**
     * The MaxFailedAttempts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxFailedAttempts;
    /**
     * The OTPExpiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OTPExpiry;
    /**
     * The OTPLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OTPLength;
    /**
     * The SendBlockingNotification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendBlockingNotification;
    /**
     * Constructor method for Security.OTPParameters
     * @uses Security_OTPParameters::setBlockBruteForceLogins()
     * @uses Security_OTPParameters::setBlockingEmailBody()
     * @uses Security_OTPParameters::setBlockingEmailSubject()
     * @uses Security_OTPParameters::setEmailBody()
     * @uses Security_OTPParameters::setEmailSubject()
     * @uses Security_OTPParameters::setIsEnabled()
     * @uses Security_OTPParameters::setMaxBruteForceAttempts()
     * @uses Security_OTPParameters::setMaxFailedAttempts()
     * @uses Security_OTPParameters::setOTPExpiry()
     * @uses Security_OTPParameters::setOTPLength()
     * @uses Security_OTPParameters::setSendBlockingNotification()
     * @param bool $blockBruteForceLogins
     * @param \patest\StructType\GlobalString $blockingEmailBody
     * @param \patest\StructType\GlobalString $blockingEmailSubject
     * @param \patest\StructType\GlobalString $emailBody
     * @param \patest\StructType\GlobalString $emailSubject
     * @param bool $isEnabled
     * @param int $maxBruteForceAttempts
     * @param int $maxFailedAttempts
     * @param int $oTPExpiry
     * @param int $oTPLength
     * @param bool $sendBlockingNotification
     */
    public function __construct($blockBruteForceLogins = null, \patest\StructType\GlobalString $blockingEmailBody = null, \patest\StructType\GlobalString $blockingEmailSubject = null, \patest\StructType\GlobalString $emailBody = null, \patest\StructType\GlobalString $emailSubject = null, $isEnabled = null, $maxBruteForceAttempts = null, $maxFailedAttempts = null, $oTPExpiry = null, $oTPLength = null, $sendBlockingNotification = null)
    {
        $this
            ->setBlockBruteForceLogins($blockBruteForceLogins)
            ->setBlockingEmailBody($blockingEmailBody)
            ->setBlockingEmailSubject($blockingEmailSubject)
            ->setEmailBody($emailBody)
            ->setEmailSubject($emailSubject)
            ->setIsEnabled($isEnabled)
            ->setMaxBruteForceAttempts($maxBruteForceAttempts)
            ->setMaxFailedAttempts($maxFailedAttempts)
            ->setOTPExpiry($oTPExpiry)
            ->setOTPLength($oTPLength)
            ->setSendBlockingNotification($sendBlockingNotification);
    }
    /**
     * Get BlockBruteForceLogins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlockBruteForceLogins()
    {
        return isset($this->BlockBruteForceLogins) ? $this->BlockBruteForceLogins : null;
    }
    /**
     * Set BlockBruteForceLogins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blockBruteForceLogins
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setBlockBruteForceLogins($blockBruteForceLogins = null)
    {
        // validation for constraint: boolean
        if (!is_null($blockBruteForceLogins) && !is_bool($blockBruteForceLogins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blockBruteForceLogins, true), gettype($blockBruteForceLogins)), __LINE__);
        }
        if (is_null($blockBruteForceLogins) || (is_array($blockBruteForceLogins) && empty($blockBruteForceLogins))) {
            unset($this->BlockBruteForceLogins);
        } else {
            $this->BlockBruteForceLogins = $blockBruteForceLogins;
        }
        return $this;
    }
    /**
     * Get BlockingEmailBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBlockingEmailBody()
    {
        return isset($this->BlockingEmailBody) ? $this->BlockingEmailBody : null;
    }
    /**
     * Set BlockingEmailBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $blockingEmailBody
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setBlockingEmailBody(\patest\StructType\GlobalString $blockingEmailBody = null)
    {
        if (is_null($blockingEmailBody) || (is_array($blockingEmailBody) && empty($blockingEmailBody))) {
            unset($this->BlockingEmailBody);
        } else {
            $this->BlockingEmailBody = $blockingEmailBody;
        }
        return $this;
    }
    /**
     * Get BlockingEmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBlockingEmailSubject()
    {
        return isset($this->BlockingEmailSubject) ? $this->BlockingEmailSubject : null;
    }
    /**
     * Set BlockingEmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $blockingEmailSubject
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setBlockingEmailSubject(\patest\StructType\GlobalString $blockingEmailSubject = null)
    {
        if (is_null($blockingEmailSubject) || (is_array($blockingEmailSubject) && empty($blockingEmailSubject))) {
            unset($this->BlockingEmailSubject);
        } else {
            $this->BlockingEmailSubject = $blockingEmailSubject;
        }
        return $this;
    }
    /**
     * Get EmailBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEmailBody()
    {
        return isset($this->EmailBody) ? $this->EmailBody : null;
    }
    /**
     * Set EmailBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $emailBody
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setEmailBody(\patest\StructType\GlobalString $emailBody = null)
    {
        if (is_null($emailBody) || (is_array($emailBody) && empty($emailBody))) {
            unset($this->EmailBody);
        } else {
            $this->EmailBody = $emailBody;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $emailSubject
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setEmailSubject(\patest\StructType\GlobalString $emailSubject = null)
    {
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get IsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return isset($this->IsEnabled) ? $this->IsEnabled : null;
    }
    /**
     * Set IsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnabled
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        if (is_null($isEnabled) || (is_array($isEnabled) && empty($isEnabled))) {
            unset($this->IsEnabled);
        } else {
            $this->IsEnabled = $isEnabled;
        }
        return $this;
    }
    /**
     * Get MaxBruteForceAttempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxBruteForceAttempts()
    {
        return isset($this->MaxBruteForceAttempts) ? $this->MaxBruteForceAttempts : null;
    }
    /**
     * Set MaxBruteForceAttempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxBruteForceAttempts
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setMaxBruteForceAttempts($maxBruteForceAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($maxBruteForceAttempts) && !(is_int($maxBruteForceAttempts) || ctype_digit($maxBruteForceAttempts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBruteForceAttempts, true), gettype($maxBruteForceAttempts)), __LINE__);
        }
        if (is_null($maxBruteForceAttempts) || (is_array($maxBruteForceAttempts) && empty($maxBruteForceAttempts))) {
            unset($this->MaxBruteForceAttempts);
        } else {
            $this->MaxBruteForceAttempts = $maxBruteForceAttempts;
        }
        return $this;
    }
    /**
     * Get MaxFailedAttempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxFailedAttempts()
    {
        return isset($this->MaxFailedAttempts) ? $this->MaxFailedAttempts : null;
    }
    /**
     * Set MaxFailedAttempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxFailedAttempts
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setMaxFailedAttempts($maxFailedAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($maxFailedAttempts) && !(is_int($maxFailedAttempts) || ctype_digit($maxFailedAttempts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxFailedAttempts, true), gettype($maxFailedAttempts)), __LINE__);
        }
        if (is_null($maxFailedAttempts) || (is_array($maxFailedAttempts) && empty($maxFailedAttempts))) {
            unset($this->MaxFailedAttempts);
        } else {
            $this->MaxFailedAttempts = $maxFailedAttempts;
        }
        return $this;
    }
    /**
     * Get OTPExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOTPExpiry()
    {
        return isset($this->OTPExpiry) ? $this->OTPExpiry : null;
    }
    /**
     * Set OTPExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oTPExpiry
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setOTPExpiry($oTPExpiry = null)
    {
        // validation for constraint: int
        if (!is_null($oTPExpiry) && !(is_int($oTPExpiry) || ctype_digit($oTPExpiry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oTPExpiry, true), gettype($oTPExpiry)), __LINE__);
        }
        if (is_null($oTPExpiry) || (is_array($oTPExpiry) && empty($oTPExpiry))) {
            unset($this->OTPExpiry);
        } else {
            $this->OTPExpiry = $oTPExpiry;
        }
        return $this;
    }
    /**
     * Get OTPLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOTPLength()
    {
        return isset($this->OTPLength) ? $this->OTPLength : null;
    }
    /**
     * Set OTPLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oTPLength
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setOTPLength($oTPLength = null)
    {
        // validation for constraint: int
        if (!is_null($oTPLength) && !(is_int($oTPLength) || ctype_digit($oTPLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oTPLength, true), gettype($oTPLength)), __LINE__);
        }
        if (is_null($oTPLength) || (is_array($oTPLength) && empty($oTPLength))) {
            unset($this->OTPLength);
        } else {
            $this->OTPLength = $oTPLength;
        }
        return $this;
    }
    /**
     * Get SendBlockingNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendBlockingNotification()
    {
        return isset($this->SendBlockingNotification) ? $this->SendBlockingNotification : null;
    }
    /**
     * Set SendBlockingNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendBlockingNotification
     * @return \patest\StructType\Security_OTPParameters
     */
    public function setSendBlockingNotification($sendBlockingNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendBlockingNotification) && !is_bool($sendBlockingNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendBlockingNotification, true), gettype($sendBlockingNotification)), __LINE__);
        }
        if (is_null($sendBlockingNotification) || (is_array($sendBlockingNotification) && empty($sendBlockingNotification))) {
            unset($this->SendBlockingNotification);
        } else {
            $this->SendBlockingNotification = $sendBlockingNotification;
        }
        return $this;
    }
}
