<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.KsroCompanyParameters StructType
 * @subpackage Structs
 */
class Security_KsroCompanyParameters extends Security_SalePointParametersBase
{
    /**
     * The AllowMenu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowMenu;
    /**
     * The CollectTicketsForClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectTicketsForClient;
    /**
     * The CollectTicketsForNearEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectTicketsForNearEvents;
    /**
     * The CollectTicketsNearEventsTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectTicketsNearEventsTimeSpan;
    /**
     * The DefaultCollectType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCollectType;
    /**
     * The DefaultSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSaleMode;
    /**
     * The DefaultStartupScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultStartupScreen;
    /**
     * The DisplayCalloutInAreaview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayCalloutInAreaview;
    /**
     * The KioskHomeMenuOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KioskHomeMenuOptions;
    /**
     * The SupportedCollectTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportedCollectTypes;
    /**
     * Constructor method for Security.KsroCompanyParameters
     * @uses Security_KsroCompanyParameters::setAllowMenu()
     * @uses Security_KsroCompanyParameters::setCollectTicketsForClient()
     * @uses Security_KsroCompanyParameters::setCollectTicketsForNearEvents()
     * @uses Security_KsroCompanyParameters::setCollectTicketsNearEventsTimeSpan()
     * @uses Security_KsroCompanyParameters::setDefaultCollectType()
     * @uses Security_KsroCompanyParameters::setDefaultSaleMode()
     * @uses Security_KsroCompanyParameters::setDefaultStartupScreen()
     * @uses Security_KsroCompanyParameters::setDisplayCalloutInAreaview()
     * @uses Security_KsroCompanyParameters::setKioskHomeMenuOptions()
     * @uses Security_KsroCompanyParameters::setSupportedCollectTypes()
     * @param bool $allowMenu
     * @param string $collectTicketsForClient
     * @param string $collectTicketsForNearEvents
     * @param string $collectTicketsNearEventsTimeSpan
     * @param string $defaultCollectType
     * @param string $defaultSaleMode
     * @param string $defaultStartupScreen
     * @param bool $displayCalloutInAreaview
     * @param string $kioskHomeMenuOptions
     * @param string $supportedCollectTypes
     */
    public function __construct($allowMenu = null, $collectTicketsForClient = null, $collectTicketsForNearEvents = null, $collectTicketsNearEventsTimeSpan = null, $defaultCollectType = null, $defaultSaleMode = null, $defaultStartupScreen = null, $displayCalloutInAreaview = null, $kioskHomeMenuOptions = null, $supportedCollectTypes = null)
    {
        $this
            ->setAllowMenu($allowMenu)
            ->setCollectTicketsForClient($collectTicketsForClient)
            ->setCollectTicketsForNearEvents($collectTicketsForNearEvents)
            ->setCollectTicketsNearEventsTimeSpan($collectTicketsNearEventsTimeSpan)
            ->setDefaultCollectType($defaultCollectType)
            ->setDefaultSaleMode($defaultSaleMode)
            ->setDefaultStartupScreen($defaultStartupScreen)
            ->setDisplayCalloutInAreaview($displayCalloutInAreaview)
            ->setKioskHomeMenuOptions($kioskHomeMenuOptions)
            ->setSupportedCollectTypes($supportedCollectTypes);
    }
    /**
     * Get AllowMenu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowMenu()
    {
        return isset($this->AllowMenu) ? $this->AllowMenu : null;
    }
    /**
     * Set AllowMenu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowMenu
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setAllowMenu($allowMenu = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowMenu) && !is_bool($allowMenu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowMenu, true), gettype($allowMenu)), __LINE__);
        }
        if (is_null($allowMenu) || (is_array($allowMenu) && empty($allowMenu))) {
            unset($this->AllowMenu);
        } else {
            $this->AllowMenu = $allowMenu;
        }
        return $this;
    }
    /**
     * Get CollectTicketsForClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectTicketsForClient()
    {
        return isset($this->CollectTicketsForClient) ? $this->CollectTicketsForClient : null;
    }
    /**
     * Set CollectTicketsForClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectTicketsForClient
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setCollectTicketsForClient($collectTicketsForClient = null)
    {
        // validation for constraint: string
        if (!is_null($collectTicketsForClient) && !is_string($collectTicketsForClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectTicketsForClient, true), gettype($collectTicketsForClient)), __LINE__);
        }
        if (is_null($collectTicketsForClient) || (is_array($collectTicketsForClient) && empty($collectTicketsForClient))) {
            unset($this->CollectTicketsForClient);
        } else {
            $this->CollectTicketsForClient = $collectTicketsForClient;
        }
        return $this;
    }
    /**
     * Get CollectTicketsForNearEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectTicketsForNearEvents()
    {
        return isset($this->CollectTicketsForNearEvents) ? $this->CollectTicketsForNearEvents : null;
    }
    /**
     * Set CollectTicketsForNearEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectTicketsForNearEvents
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setCollectTicketsForNearEvents($collectTicketsForNearEvents = null)
    {
        // validation for constraint: string
        if (!is_null($collectTicketsForNearEvents) && !is_string($collectTicketsForNearEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectTicketsForNearEvents, true), gettype($collectTicketsForNearEvents)), __LINE__);
        }
        if (is_null($collectTicketsForNearEvents) || (is_array($collectTicketsForNearEvents) && empty($collectTicketsForNearEvents))) {
            unset($this->CollectTicketsForNearEvents);
        } else {
            $this->CollectTicketsForNearEvents = $collectTicketsForNearEvents;
        }
        return $this;
    }
    /**
     * Get CollectTicketsNearEventsTimeSpan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectTicketsNearEventsTimeSpan()
    {
        return isset($this->CollectTicketsNearEventsTimeSpan) ? $this->CollectTicketsNearEventsTimeSpan : null;
    }
    /**
     * Set CollectTicketsNearEventsTimeSpan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectTicketsNearEventsTimeSpan
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setCollectTicketsNearEventsTimeSpan($collectTicketsNearEventsTimeSpan = null)
    {
        // validation for constraint: string
        if (!is_null($collectTicketsNearEventsTimeSpan) && !is_string($collectTicketsNearEventsTimeSpan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectTicketsNearEventsTimeSpan, true), gettype($collectTicketsNearEventsTimeSpan)), __LINE__);
        }
        if (is_null($collectTicketsNearEventsTimeSpan) || (is_array($collectTicketsNearEventsTimeSpan) && empty($collectTicketsNearEventsTimeSpan))) {
            unset($this->CollectTicketsNearEventsTimeSpan);
        } else {
            $this->CollectTicketsNearEventsTimeSpan = $collectTicketsNearEventsTimeSpan;
        }
        return $this;
    }
    /**
     * Get DefaultCollectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCollectType()
    {
        return isset($this->DefaultCollectType) ? $this->DefaultCollectType : null;
    }
    /**
     * Set DefaultCollectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DefaultCollectTypeEnum::valueIsValid()
     * @uses \patest\EnumType\DefaultCollectTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultCollectType
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setDefaultCollectType($defaultCollectType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DefaultCollectTypeEnum::valueIsValid($defaultCollectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DefaultCollectTypeEnum', is_array($defaultCollectType) ? implode(', ', $defaultCollectType) : var_export($defaultCollectType, true), implode(', ', \patest\EnumType\DefaultCollectTypeEnum::getValidValues())), __LINE__);
        }
        if (is_null($defaultCollectType) || (is_array($defaultCollectType) && empty($defaultCollectType))) {
            unset($this->DefaultCollectType);
        } else {
            $this->DefaultCollectType = $defaultCollectType;
        }
        return $this;
    }
    /**
     * Get DefaultSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSaleMode()
    {
        return isset($this->DefaultSaleMode) ? $this->DefaultSaleMode : null;
    }
    /**
     * Set DefaultSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSaleMode
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setDefaultSaleMode($defaultSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSaleMode) && !is_string($defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSaleMode, true), gettype($defaultSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSaleMode, true)), __LINE__);
        }
        if (is_null($defaultSaleMode) || (is_array($defaultSaleMode) && empty($defaultSaleMode))) {
            unset($this->DefaultSaleMode);
        } else {
            $this->DefaultSaleMode = $defaultSaleMode;
        }
        return $this;
    }
    /**
     * Get DefaultStartupScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultStartupScreen()
    {
        return isset($this->DefaultStartupScreen) ? $this->DefaultStartupScreen : null;
    }
    /**
     * Set DefaultStartupScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DefaultStartScreenEnum::valueIsValid()
     * @uses \patest\EnumType\DefaultStartScreenEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultStartupScreen
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setDefaultStartupScreen($defaultStartupScreen = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DefaultStartScreenEnum::valueIsValid($defaultStartupScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DefaultStartScreenEnum', is_array($defaultStartupScreen) ? implode(', ', $defaultStartupScreen) : var_export($defaultStartupScreen, true), implode(', ', \patest\EnumType\DefaultStartScreenEnum::getValidValues())), __LINE__);
        }
        if (is_null($defaultStartupScreen) || (is_array($defaultStartupScreen) && empty($defaultStartupScreen))) {
            unset($this->DefaultStartupScreen);
        } else {
            $this->DefaultStartupScreen = $defaultStartupScreen;
        }
        return $this;
    }
    /**
     * Get DisplayCalloutInAreaview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayCalloutInAreaview()
    {
        return isset($this->DisplayCalloutInAreaview) ? $this->DisplayCalloutInAreaview : null;
    }
    /**
     * Set DisplayCalloutInAreaview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayCalloutInAreaview
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setDisplayCalloutInAreaview($displayCalloutInAreaview = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayCalloutInAreaview) && !is_bool($displayCalloutInAreaview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayCalloutInAreaview, true), gettype($displayCalloutInAreaview)), __LINE__);
        }
        if (is_null($displayCalloutInAreaview) || (is_array($displayCalloutInAreaview) && empty($displayCalloutInAreaview))) {
            unset($this->DisplayCalloutInAreaview);
        } else {
            $this->DisplayCalloutInAreaview = $displayCalloutInAreaview;
        }
        return $this;
    }
    /**
     * Get KioskHomeMenuOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKioskHomeMenuOptions()
    {
        return isset($this->KioskHomeMenuOptions) ? $this->KioskHomeMenuOptions : null;
    }
    /**
     * Set KioskHomeMenuOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kioskHomeMenuOptions
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setKioskHomeMenuOptions($kioskHomeMenuOptions = null)
    {
        // validation for constraint: string
        if (!is_null($kioskHomeMenuOptions) && !is_string($kioskHomeMenuOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kioskHomeMenuOptions, true), gettype($kioskHomeMenuOptions)), __LINE__);
        }
        if (is_null($kioskHomeMenuOptions) || (is_array($kioskHomeMenuOptions) && empty($kioskHomeMenuOptions))) {
            unset($this->KioskHomeMenuOptions);
        } else {
            $this->KioskHomeMenuOptions = $kioskHomeMenuOptions;
        }
        return $this;
    }
    /**
     * Get SupportedCollectTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportedCollectTypes()
    {
        return isset($this->SupportedCollectTypes) ? $this->SupportedCollectTypes : null;
    }
    /**
     * Set SupportedCollectTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supportedCollectTypes
     * @return \patest\StructType\Security_KsroCompanyParameters
     */
    public function setSupportedCollectTypes($supportedCollectTypes = null)
    {
        // validation for constraint: string
        if (!is_null($supportedCollectTypes) && !is_string($supportedCollectTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supportedCollectTypes, true), gettype($supportedCollectTypes)), __LINE__);
        }
        if (is_null($supportedCollectTypes) || (is_array($supportedCollectTypes) && empty($supportedCollectTypes))) {
            unset($this->SupportedCollectTypes);
        } else {
            $this->SupportedCollectTypes = $supportedCollectTypes;
        }
        return $this;
    }
}
