<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.DonationCompanyParameters StructType
 * @subpackage Structs
 */
class Security_DonationCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The ClientAndDonorMustBeInGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ClientAndDonorMustBeInGroup;
    /**
     * The DisplayFullyUtiliztedBenefits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayFullyUtiliztedBenefits;
    /**
     * The DonationTypesForMatchingGifts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationTypesForMatchingGifts;
    /**
     * The LockForTurnbackTickets
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockForTurnbackTickets;
    /**
     * The MatchingGiftSoftCreditOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MatchingGiftSoftCreditOption;
    /**
     * The ProcessPledgeDirectDebitInstallmentsDaysInAdvance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessPledgeDirectDebitInstallmentsDaysInAdvance;
    /**
     * The RelationshipsAndRolesForMatchingGiftsString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipsAndRolesForMatchingGiftsString;
    /**
     * The SoftCreditRelationships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoftCreditRelationships;
    /**
     * Constructor method for Security.DonationCompanyParameters
     * @uses Security_DonationCompanyParameters::setClientAndDonorMustBeInGroup()
     * @uses Security_DonationCompanyParameters::setDisplayFullyUtiliztedBenefits()
     * @uses Security_DonationCompanyParameters::setDonationTypesForMatchingGifts()
     * @uses Security_DonationCompanyParameters::setLockForTurnbackTickets()
     * @uses Security_DonationCompanyParameters::setMatchingGiftSoftCreditOption()
     * @uses Security_DonationCompanyParameters::setProcessPledgeDirectDebitInstallmentsDaysInAdvance()
     * @uses Security_DonationCompanyParameters::setRelationshipsAndRolesForMatchingGiftsString()
     * @uses Security_DonationCompanyParameters::setSoftCreditRelationships()
     * @param bool $clientAndDonorMustBeInGroup
     * @param bool $displayFullyUtiliztedBenefits
     * @param string $donationTypesForMatchingGifts
     * @param string $lockForTurnbackTickets
     * @param string $matchingGiftSoftCreditOption
     * @param int $processPledgeDirectDebitInstallmentsDaysInAdvance
     * @param string $relationshipsAndRolesForMatchingGiftsString
     * @param string $softCreditRelationships
     */
    public function __construct($clientAndDonorMustBeInGroup = null, $displayFullyUtiliztedBenefits = null, $donationTypesForMatchingGifts = null, $lockForTurnbackTickets = null, $matchingGiftSoftCreditOption = null, $processPledgeDirectDebitInstallmentsDaysInAdvance = null, $relationshipsAndRolesForMatchingGiftsString = null, $softCreditRelationships = null)
    {
        $this
            ->setClientAndDonorMustBeInGroup($clientAndDonorMustBeInGroup)
            ->setDisplayFullyUtiliztedBenefits($displayFullyUtiliztedBenefits)
            ->setDonationTypesForMatchingGifts($donationTypesForMatchingGifts)
            ->setLockForTurnbackTickets($lockForTurnbackTickets)
            ->setMatchingGiftSoftCreditOption($matchingGiftSoftCreditOption)
            ->setProcessPledgeDirectDebitInstallmentsDaysInAdvance($processPledgeDirectDebitInstallmentsDaysInAdvance)
            ->setRelationshipsAndRolesForMatchingGiftsString($relationshipsAndRolesForMatchingGiftsString)
            ->setSoftCreditRelationships($softCreditRelationships);
    }
    /**
     * Get ClientAndDonorMustBeInGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClientAndDonorMustBeInGroup()
    {
        return isset($this->ClientAndDonorMustBeInGroup) ? $this->ClientAndDonorMustBeInGroup : null;
    }
    /**
     * Set ClientAndDonorMustBeInGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $clientAndDonorMustBeInGroup
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setClientAndDonorMustBeInGroup($clientAndDonorMustBeInGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($clientAndDonorMustBeInGroup) && !is_bool($clientAndDonorMustBeInGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clientAndDonorMustBeInGroup, true), gettype($clientAndDonorMustBeInGroup)), __LINE__);
        }
        if (is_null($clientAndDonorMustBeInGroup) || (is_array($clientAndDonorMustBeInGroup) && empty($clientAndDonorMustBeInGroup))) {
            unset($this->ClientAndDonorMustBeInGroup);
        } else {
            $this->ClientAndDonorMustBeInGroup = $clientAndDonorMustBeInGroup;
        }
        return $this;
    }
    /**
     * Get DisplayFullyUtiliztedBenefits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayFullyUtiliztedBenefits()
    {
        return isset($this->DisplayFullyUtiliztedBenefits) ? $this->DisplayFullyUtiliztedBenefits : null;
    }
    /**
     * Set DisplayFullyUtiliztedBenefits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayFullyUtiliztedBenefits
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setDisplayFullyUtiliztedBenefits($displayFullyUtiliztedBenefits = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayFullyUtiliztedBenefits) && !is_bool($displayFullyUtiliztedBenefits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayFullyUtiliztedBenefits, true), gettype($displayFullyUtiliztedBenefits)), __LINE__);
        }
        if (is_null($displayFullyUtiliztedBenefits) || (is_array($displayFullyUtiliztedBenefits) && empty($displayFullyUtiliztedBenefits))) {
            unset($this->DisplayFullyUtiliztedBenefits);
        } else {
            $this->DisplayFullyUtiliztedBenefits = $displayFullyUtiliztedBenefits;
        }
        return $this;
    }
    /**
     * Get DonationTypesForMatchingGifts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationTypesForMatchingGifts()
    {
        return isset($this->DonationTypesForMatchingGifts) ? $this->DonationTypesForMatchingGifts : null;
    }
    /**
     * Set DonationTypesForMatchingGifts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationTypesForMatchingGifts
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setDonationTypesForMatchingGifts($donationTypesForMatchingGifts = null)
    {
        // validation for constraint: string
        if (!is_null($donationTypesForMatchingGifts) && !is_string($donationTypesForMatchingGifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationTypesForMatchingGifts, true), gettype($donationTypesForMatchingGifts)), __LINE__);
        }
        if (is_null($donationTypesForMatchingGifts) || (is_array($donationTypesForMatchingGifts) && empty($donationTypesForMatchingGifts))) {
            unset($this->DonationTypesForMatchingGifts);
        } else {
            $this->DonationTypesForMatchingGifts = $donationTypesForMatchingGifts;
        }
        return $this;
    }
    /**
     * Get LockForTurnbackTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockForTurnbackTickets()
    {
        return isset($this->LockForTurnbackTickets) ? $this->LockForTurnbackTickets : null;
    }
    /**
     * Set LockForTurnbackTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockForTurnbackTickets
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setLockForTurnbackTickets($lockForTurnbackTickets = null)
    {
        // validation for constraint: string
        if (!is_null($lockForTurnbackTickets) && !is_string($lockForTurnbackTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockForTurnbackTickets, true), gettype($lockForTurnbackTickets)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockForTurnbackTickets) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockForTurnbackTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockForTurnbackTickets, true)), __LINE__);
        }
        if (is_null($lockForTurnbackTickets) || (is_array($lockForTurnbackTickets) && empty($lockForTurnbackTickets))) {
            unset($this->LockForTurnbackTickets);
        } else {
            $this->LockForTurnbackTickets = $lockForTurnbackTickets;
        }
        return $this;
    }
    /**
     * Get MatchingGiftSoftCreditOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchingGiftSoftCreditOption()
    {
        return isset($this->MatchingGiftSoftCreditOption) ? $this->MatchingGiftSoftCreditOption : null;
    }
    /**
     * Set MatchingGiftSoftCreditOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MatchingGiftSoftCreditOption::valueIsValid()
     * @uses \patest\EnumType\MatchingGiftSoftCreditOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matchingGiftSoftCreditOption
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setMatchingGiftSoftCreditOption($matchingGiftSoftCreditOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MatchingGiftSoftCreditOption::valueIsValid($matchingGiftSoftCreditOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MatchingGiftSoftCreditOption', is_array($matchingGiftSoftCreditOption) ? implode(', ', $matchingGiftSoftCreditOption) : var_export($matchingGiftSoftCreditOption, true), implode(', ', \patest\EnumType\MatchingGiftSoftCreditOption::getValidValues())), __LINE__);
        }
        if (is_null($matchingGiftSoftCreditOption) || (is_array($matchingGiftSoftCreditOption) && empty($matchingGiftSoftCreditOption))) {
            unset($this->MatchingGiftSoftCreditOption);
        } else {
            $this->MatchingGiftSoftCreditOption = $matchingGiftSoftCreditOption;
        }
        return $this;
    }
    /**
     * Get ProcessPledgeDirectDebitInstallmentsDaysInAdvance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessPledgeDirectDebitInstallmentsDaysInAdvance()
    {
        return isset($this->ProcessPledgeDirectDebitInstallmentsDaysInAdvance) ? $this->ProcessPledgeDirectDebitInstallmentsDaysInAdvance : null;
    }
    /**
     * Set ProcessPledgeDirectDebitInstallmentsDaysInAdvance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processPledgeDirectDebitInstallmentsDaysInAdvance
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setProcessPledgeDirectDebitInstallmentsDaysInAdvance($processPledgeDirectDebitInstallmentsDaysInAdvance = null)
    {
        // validation for constraint: int
        if (!is_null($processPledgeDirectDebitInstallmentsDaysInAdvance) && !(is_int($processPledgeDirectDebitInstallmentsDaysInAdvance) || ctype_digit($processPledgeDirectDebitInstallmentsDaysInAdvance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processPledgeDirectDebitInstallmentsDaysInAdvance, true), gettype($processPledgeDirectDebitInstallmentsDaysInAdvance)), __LINE__);
        }
        if (is_null($processPledgeDirectDebitInstallmentsDaysInAdvance) || (is_array($processPledgeDirectDebitInstallmentsDaysInAdvance) && empty($processPledgeDirectDebitInstallmentsDaysInAdvance))) {
            unset($this->ProcessPledgeDirectDebitInstallmentsDaysInAdvance);
        } else {
            $this->ProcessPledgeDirectDebitInstallmentsDaysInAdvance = $processPledgeDirectDebitInstallmentsDaysInAdvance;
        }
        return $this;
    }
    /**
     * Get RelationshipsAndRolesForMatchingGiftsString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipsAndRolesForMatchingGiftsString()
    {
        return isset($this->RelationshipsAndRolesForMatchingGiftsString) ? $this->RelationshipsAndRolesForMatchingGiftsString : null;
    }
    /**
     * Set RelationshipsAndRolesForMatchingGiftsString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipsAndRolesForMatchingGiftsString
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setRelationshipsAndRolesForMatchingGiftsString($relationshipsAndRolesForMatchingGiftsString = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipsAndRolesForMatchingGiftsString) && !is_string($relationshipsAndRolesForMatchingGiftsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipsAndRolesForMatchingGiftsString, true), gettype($relationshipsAndRolesForMatchingGiftsString)), __LINE__);
        }
        if (is_null($relationshipsAndRolesForMatchingGiftsString) || (is_array($relationshipsAndRolesForMatchingGiftsString) && empty($relationshipsAndRolesForMatchingGiftsString))) {
            unset($this->RelationshipsAndRolesForMatchingGiftsString);
        } else {
            $this->RelationshipsAndRolesForMatchingGiftsString = $relationshipsAndRolesForMatchingGiftsString;
        }
        return $this;
    }
    /**
     * Get SoftCreditRelationships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoftCreditRelationships()
    {
        return isset($this->SoftCreditRelationships) ? $this->SoftCreditRelationships : null;
    }
    /**
     * Set SoftCreditRelationships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $softCreditRelationships
     * @return \patest\StructType\Security_DonationCompanyParameters
     */
    public function setSoftCreditRelationships($softCreditRelationships = null)
    {
        // validation for constraint: string
        if (!is_null($softCreditRelationships) && !is_string($softCreditRelationships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softCreditRelationships, true), gettype($softCreditRelationships)), __LINE__);
        }
        if (is_null($softCreditRelationships) || (is_array($softCreditRelationships) && empty($softCreditRelationships))) {
            unset($this->SoftCreditRelationships);
        } else {
            $this->SoftCreditRelationships = $softCreditRelationships;
        }
        return $this;
    }
}
