<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.Company StructType
 * @subpackage Structs
 */
class Security_Company extends TenantIndependentPersistableEntity
{
    /**
     * The DomainIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainIdentifier;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The GlobalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalId;
    /**
     * The GlobalTenantIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalTenantIdentifier;
    /**
     * The LogoImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LogoImageId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Security.Company
     * @uses Security_Company::setDomainIdentifier()
     * @uses Security_Company::setEmailAddress()
     * @uses Security_Company::setGlobalId()
     * @uses Security_Company::setGlobalTenantIdentifier()
     * @uses Security_Company::setLogoImageId()
     * @uses Security_Company::setName()
     * @param string $domainIdentifier
     * @param string $emailAddress
     * @param int $globalId
     * @param int $globalTenantIdentifier
     * @param int $logoImageId
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($domainIdentifier = null, $emailAddress = null, $globalId = null, $globalTenantIdentifier = null, $logoImageId = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setDomainIdentifier($domainIdentifier)
            ->setEmailAddress($emailAddress)
            ->setGlobalId($globalId)
            ->setGlobalTenantIdentifier($globalTenantIdentifier)
            ->setLogoImageId($logoImageId)
            ->setName($name);
    }
    /**
     * Get DomainIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainIdentifier()
    {
        return isset($this->DomainIdentifier) ? $this->DomainIdentifier : null;
    }
    /**
     * Set DomainIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainIdentifier
     * @return \patest\StructType\Security_Company
     */
    public function setDomainIdentifier($domainIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($domainIdentifier) && !is_string($domainIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainIdentifier, true), gettype($domainIdentifier)), __LINE__);
        }
        if (is_null($domainIdentifier) || (is_array($domainIdentifier) && empty($domainIdentifier))) {
            unset($this->DomainIdentifier);
        } else {
            $this->DomainIdentifier = $domainIdentifier;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \patest\StructType\Security_Company
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get GlobalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalId()
    {
        return isset($this->GlobalId) ? $this->GlobalId : null;
    }
    /**
     * Set GlobalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalId
     * @return \patest\StructType\Security_Company
     */
    public function setGlobalId($globalId = null)
    {
        // validation for constraint: int
        if (!is_null($globalId) && !(is_int($globalId) || ctype_digit($globalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalId, true), gettype($globalId)), __LINE__);
        }
        if (is_null($globalId) || (is_array($globalId) && empty($globalId))) {
            unset($this->GlobalId);
        } else {
            $this->GlobalId = $globalId;
        }
        return $this;
    }
    /**
     * Get GlobalTenantIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalTenantIdentifier()
    {
        return isset($this->GlobalTenantIdentifier) ? $this->GlobalTenantIdentifier : null;
    }
    /**
     * Set GlobalTenantIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalTenantIdentifier
     * @return \patest\StructType\Security_Company
     */
    public function setGlobalTenantIdentifier($globalTenantIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($globalTenantIdentifier) && !(is_int($globalTenantIdentifier) || ctype_digit($globalTenantIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalTenantIdentifier, true), gettype($globalTenantIdentifier)), __LINE__);
        }
        if (is_null($globalTenantIdentifier) || (is_array($globalTenantIdentifier) && empty($globalTenantIdentifier))) {
            unset($this->GlobalTenantIdentifier);
        } else {
            $this->GlobalTenantIdentifier = $globalTenantIdentifier;
        }
        return $this;
    }
    /**
     * Get LogoImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLogoImageId()
    {
        return isset($this->LogoImageId) ? $this->LogoImageId : null;
    }
    /**
     * Set LogoImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $logoImageId
     * @return \patest\StructType\Security_Company
     */
    public function setLogoImageId($logoImageId = null)
    {
        // validation for constraint: int
        if (!is_null($logoImageId) && !(is_int($logoImageId) || ctype_digit($logoImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logoImageId, true), gettype($logoImageId)), __LINE__);
        }
        if (is_null($logoImageId) || (is_array($logoImageId) && empty($logoImageId))) {
            unset($this->LogoImageId);
        } else {
            $this->LogoImageId = $logoImageId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Security_Company
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
