<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ClearingCompanyParameters StructType
 * @subpackage Structs
 */
class Security_ClearingCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The CreditCardPrefixLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditCardPrefixLength;
    /**
     * The CreditCardSuffixLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditCardSuffixLength;
    /**
     * The CreditCardValidationPrefixLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditCardValidationPrefixLength;
    /**
     * Constructor method for Security.ClearingCompanyParameters
     * @uses Security_ClearingCompanyParameters::setCreditCardPrefixLength()
     * @uses Security_ClearingCompanyParameters::setCreditCardSuffixLength()
     * @uses Security_ClearingCompanyParameters::setCreditCardValidationPrefixLength()
     * @param int $creditCardPrefixLength
     * @param int $creditCardSuffixLength
     * @param int $creditCardValidationPrefixLength
     */
    public function __construct($creditCardPrefixLength = null, $creditCardSuffixLength = null, $creditCardValidationPrefixLength = null)
    {
        $this
            ->setCreditCardPrefixLength($creditCardPrefixLength)
            ->setCreditCardSuffixLength($creditCardSuffixLength)
            ->setCreditCardValidationPrefixLength($creditCardValidationPrefixLength);
    }
    /**
     * Get CreditCardPrefixLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditCardPrefixLength()
    {
        return isset($this->CreditCardPrefixLength) ? $this->CreditCardPrefixLength : null;
    }
    /**
     * Set CreditCardPrefixLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditCardPrefixLength
     * @return \patest\StructType\Security_ClearingCompanyParameters
     */
    public function setCreditCardPrefixLength($creditCardPrefixLength = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardPrefixLength) && !(is_int($creditCardPrefixLength) || ctype_digit($creditCardPrefixLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditCardPrefixLength, true), gettype($creditCardPrefixLength)), __LINE__);
        }
        if (is_null($creditCardPrefixLength) || (is_array($creditCardPrefixLength) && empty($creditCardPrefixLength))) {
            unset($this->CreditCardPrefixLength);
        } else {
            $this->CreditCardPrefixLength = $creditCardPrefixLength;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffixLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditCardSuffixLength()
    {
        return isset($this->CreditCardSuffixLength) ? $this->CreditCardSuffixLength : null;
    }
    /**
     * Set CreditCardSuffixLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditCardSuffixLength
     * @return \patest\StructType\Security_ClearingCompanyParameters
     */
    public function setCreditCardSuffixLength($creditCardSuffixLength = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardSuffixLength) && !(is_int($creditCardSuffixLength) || ctype_digit($creditCardSuffixLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditCardSuffixLength, true), gettype($creditCardSuffixLength)), __LINE__);
        }
        if (is_null($creditCardSuffixLength) || (is_array($creditCardSuffixLength) && empty($creditCardSuffixLength))) {
            unset($this->CreditCardSuffixLength);
        } else {
            $this->CreditCardSuffixLength = $creditCardSuffixLength;
        }
        return $this;
    }
    /**
     * Get CreditCardValidationPrefixLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditCardValidationPrefixLength()
    {
        return isset($this->CreditCardValidationPrefixLength) ? $this->CreditCardValidationPrefixLength : null;
    }
    /**
     * Set CreditCardValidationPrefixLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditCardValidationPrefixLength
     * @return \patest\StructType\Security_ClearingCompanyParameters
     */
    public function setCreditCardValidationPrefixLength($creditCardValidationPrefixLength = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardValidationPrefixLength) && !(is_int($creditCardValidationPrefixLength) || ctype_digit($creditCardValidationPrefixLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditCardValidationPrefixLength, true), gettype($creditCardValidationPrefixLength)), __LINE__);
        }
        if (is_null($creditCardValidationPrefixLength) || (is_array($creditCardValidationPrefixLength) && empty($creditCardValidationPrefixLength))) {
            unset($this->CreditCardValidationPrefixLength);
        } else {
            $this->CreditCardValidationPrefixLength = $creditCardValidationPrefixLength;
        }
        return $this;
    }
}
