<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.BallotCompanyParameters StructType
 * @subpackage Structs
 */
class Security_BallotCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The ApplyClientTypeToWinner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ApplyClientTypeToWinner;
    /**
     * The BallotCheckoutDefaultHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BallotCheckoutDefaultHeader;
    /**
     * The BallotConfirmationLetterDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotConfirmationLetterDocumentId;
    /**
     * The BallotConfirmationLetterSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotConfirmationLetterSubject;
    /**
     * The BallotEventDefaultHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BallotEventDefaultHeader;
    /**
     * The BallotMinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotMinSeats;
    /**
     * The BallotRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotRunMode;
    /**
     * The MultiEventBallotDefaultHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MultiEventBallotDefaultHeader;
    /**
     * The PaymentMethodsForBallotsInEsro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodsForBallotsInEsro;
    /**
     * The PaymentMethodsForBallotsInPortal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodsForBallotsInPortal;
    /**
     * The UseTicketReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseTicketReservations;
    /**
     * Constructor method for Security.BallotCompanyParameters
     * @uses Security_BallotCompanyParameters::setApplyClientTypeToWinner()
     * @uses Security_BallotCompanyParameters::setBallotCheckoutDefaultHeader()
     * @uses Security_BallotCompanyParameters::setBallotConfirmationLetterDocumentId()
     * @uses Security_BallotCompanyParameters::setBallotConfirmationLetterSubject()
     * @uses Security_BallotCompanyParameters::setBallotEventDefaultHeader()
     * @uses Security_BallotCompanyParameters::setBallotMinSeats()
     * @uses Security_BallotCompanyParameters::setBallotRunMode()
     * @uses Security_BallotCompanyParameters::setMultiEventBallotDefaultHeader()
     * @uses Security_BallotCompanyParameters::setPaymentMethodsForBallotsInEsro()
     * @uses Security_BallotCompanyParameters::setPaymentMethodsForBallotsInPortal()
     * @uses Security_BallotCompanyParameters::setUseTicketReservations()
     * @param bool $applyClientTypeToWinner
     * @param \patest\StructType\GlobalString $ballotCheckoutDefaultHeader
     * @param string $ballotConfirmationLetterDocumentId
     * @param string $ballotConfirmationLetterSubject
     * @param \patest\StructType\GlobalString $ballotEventDefaultHeader
     * @param int $ballotMinSeats
     * @param string $ballotRunMode
     * @param \patest\StructType\GlobalString $multiEventBallotDefaultHeader
     * @param string $paymentMethodsForBallotsInEsro
     * @param string $paymentMethodsForBallotsInPortal
     * @param bool $useTicketReservations
     */
    public function __construct($applyClientTypeToWinner = null, \patest\StructType\GlobalString $ballotCheckoutDefaultHeader = null, $ballotConfirmationLetterDocumentId = null, $ballotConfirmationLetterSubject = null, \patest\StructType\GlobalString $ballotEventDefaultHeader = null, $ballotMinSeats = null, $ballotRunMode = null, \patest\StructType\GlobalString $multiEventBallotDefaultHeader = null, $paymentMethodsForBallotsInEsro = null, $paymentMethodsForBallotsInPortal = null, $useTicketReservations = null)
    {
        $this
            ->setApplyClientTypeToWinner($applyClientTypeToWinner)
            ->setBallotCheckoutDefaultHeader($ballotCheckoutDefaultHeader)
            ->setBallotConfirmationLetterDocumentId($ballotConfirmationLetterDocumentId)
            ->setBallotConfirmationLetterSubject($ballotConfirmationLetterSubject)
            ->setBallotEventDefaultHeader($ballotEventDefaultHeader)
            ->setBallotMinSeats($ballotMinSeats)
            ->setBallotRunMode($ballotRunMode)
            ->setMultiEventBallotDefaultHeader($multiEventBallotDefaultHeader)
            ->setPaymentMethodsForBallotsInEsro($paymentMethodsForBallotsInEsro)
            ->setPaymentMethodsForBallotsInPortal($paymentMethodsForBallotsInPortal)
            ->setUseTicketReservations($useTicketReservations);
    }
    /**
     * Get ApplyClientTypeToWinner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApplyClientTypeToWinner()
    {
        return isset($this->ApplyClientTypeToWinner) ? $this->ApplyClientTypeToWinner : null;
    }
    /**
     * Set ApplyClientTypeToWinner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $applyClientTypeToWinner
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setApplyClientTypeToWinner($applyClientTypeToWinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyClientTypeToWinner) && !is_bool($applyClientTypeToWinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyClientTypeToWinner, true), gettype($applyClientTypeToWinner)), __LINE__);
        }
        if (is_null($applyClientTypeToWinner) || (is_array($applyClientTypeToWinner) && empty($applyClientTypeToWinner))) {
            unset($this->ApplyClientTypeToWinner);
        } else {
            $this->ApplyClientTypeToWinner = $applyClientTypeToWinner;
        }
        return $this;
    }
    /**
     * Get BallotCheckoutDefaultHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBallotCheckoutDefaultHeader()
    {
        return isset($this->BallotCheckoutDefaultHeader) ? $this->BallotCheckoutDefaultHeader : null;
    }
    /**
     * Set BallotCheckoutDefaultHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $ballotCheckoutDefaultHeader
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotCheckoutDefaultHeader(\patest\StructType\GlobalString $ballotCheckoutDefaultHeader = null)
    {
        if (is_null($ballotCheckoutDefaultHeader) || (is_array($ballotCheckoutDefaultHeader) && empty($ballotCheckoutDefaultHeader))) {
            unset($this->BallotCheckoutDefaultHeader);
        } else {
            $this->BallotCheckoutDefaultHeader = $ballotCheckoutDefaultHeader;
        }
        return $this;
    }
    /**
     * Get BallotConfirmationLetterDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotConfirmationLetterDocumentId()
    {
        return isset($this->BallotConfirmationLetterDocumentId) ? $this->BallotConfirmationLetterDocumentId : null;
    }
    /**
     * Set BallotConfirmationLetterDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotConfirmationLetterDocumentId
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotConfirmationLetterDocumentId($ballotConfirmationLetterDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotConfirmationLetterDocumentId) && !is_string($ballotConfirmationLetterDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotConfirmationLetterDocumentId, true), gettype($ballotConfirmationLetterDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotConfirmationLetterDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotConfirmationLetterDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotConfirmationLetterDocumentId, true)), __LINE__);
        }
        if (is_null($ballotConfirmationLetterDocumentId) || (is_array($ballotConfirmationLetterDocumentId) && empty($ballotConfirmationLetterDocumentId))) {
            unset($this->BallotConfirmationLetterDocumentId);
        } else {
            $this->BallotConfirmationLetterDocumentId = $ballotConfirmationLetterDocumentId;
        }
        return $this;
    }
    /**
     * Get BallotConfirmationLetterSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotConfirmationLetterSubject()
    {
        return isset($this->BallotConfirmationLetterSubject) ? $this->BallotConfirmationLetterSubject : null;
    }
    /**
     * Set BallotConfirmationLetterSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotConfirmationLetterSubject
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotConfirmationLetterSubject($ballotConfirmationLetterSubject = null)
    {
        // validation for constraint: string
        if (!is_null($ballotConfirmationLetterSubject) && !is_string($ballotConfirmationLetterSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotConfirmationLetterSubject, true), gettype($ballotConfirmationLetterSubject)), __LINE__);
        }
        if (is_null($ballotConfirmationLetterSubject) || (is_array($ballotConfirmationLetterSubject) && empty($ballotConfirmationLetterSubject))) {
            unset($this->BallotConfirmationLetterSubject);
        } else {
            $this->BallotConfirmationLetterSubject = $ballotConfirmationLetterSubject;
        }
        return $this;
    }
    /**
     * Get BallotEventDefaultHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBallotEventDefaultHeader()
    {
        return isset($this->BallotEventDefaultHeader) ? $this->BallotEventDefaultHeader : null;
    }
    /**
     * Set BallotEventDefaultHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $ballotEventDefaultHeader
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotEventDefaultHeader(\patest\StructType\GlobalString $ballotEventDefaultHeader = null)
    {
        if (is_null($ballotEventDefaultHeader) || (is_array($ballotEventDefaultHeader) && empty($ballotEventDefaultHeader))) {
            unset($this->BallotEventDefaultHeader);
        } else {
            $this->BallotEventDefaultHeader = $ballotEventDefaultHeader;
        }
        return $this;
    }
    /**
     * Get BallotMinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotMinSeats()
    {
        return isset($this->BallotMinSeats) ? $this->BallotMinSeats : null;
    }
    /**
     * Set BallotMinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotMinSeats
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotMinSeats($ballotMinSeats = null)
    {
        // validation for constraint: int
        if (!is_null($ballotMinSeats) && !(is_int($ballotMinSeats) || ctype_digit($ballotMinSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotMinSeats, true), gettype($ballotMinSeats)), __LINE__);
        }
        if (is_null($ballotMinSeats) || (is_array($ballotMinSeats) && empty($ballotMinSeats))) {
            unset($this->BallotMinSeats);
        } else {
            $this->BallotMinSeats = $ballotMinSeats;
        }
        return $this;
    }
    /**
     * Get BallotRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotRunMode()
    {
        return isset($this->BallotRunMode) ? $this->BallotRunMode : null;
    }
    /**
     * Set BallotRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotRunMode::valueIsValid()
     * @uses \patest\EnumType\BallotRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotRunMode
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setBallotRunMode($ballotRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotRunMode::valueIsValid($ballotRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotRunMode', is_array($ballotRunMode) ? implode(', ', $ballotRunMode) : var_export($ballotRunMode, true), implode(', ', \patest\EnumType\BallotRunMode::getValidValues())), __LINE__);
        }
        if (is_null($ballotRunMode) || (is_array($ballotRunMode) && empty($ballotRunMode))) {
            unset($this->BallotRunMode);
        } else {
            $this->BallotRunMode = $ballotRunMode;
        }
        return $this;
    }
    /**
     * Get MultiEventBallotDefaultHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMultiEventBallotDefaultHeader()
    {
        return isset($this->MultiEventBallotDefaultHeader) ? $this->MultiEventBallotDefaultHeader : null;
    }
    /**
     * Set MultiEventBallotDefaultHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $multiEventBallotDefaultHeader
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setMultiEventBallotDefaultHeader(\patest\StructType\GlobalString $multiEventBallotDefaultHeader = null)
    {
        if (is_null($multiEventBallotDefaultHeader) || (is_array($multiEventBallotDefaultHeader) && empty($multiEventBallotDefaultHeader))) {
            unset($this->MultiEventBallotDefaultHeader);
        } else {
            $this->MultiEventBallotDefaultHeader = $multiEventBallotDefaultHeader;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsForBallotsInEsro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodsForBallotsInEsro()
    {
        return isset($this->PaymentMethodsForBallotsInEsro) ? $this->PaymentMethodsForBallotsInEsro : null;
    }
    /**
     * Set PaymentMethodsForBallotsInEsro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodsForBallotsInEsro
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setPaymentMethodsForBallotsInEsro($paymentMethodsForBallotsInEsro = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodsForBallotsInEsro) && !is_string($paymentMethodsForBallotsInEsro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodsForBallotsInEsro, true), gettype($paymentMethodsForBallotsInEsro)), __LINE__);
        }
        if (is_null($paymentMethodsForBallotsInEsro) || (is_array($paymentMethodsForBallotsInEsro) && empty($paymentMethodsForBallotsInEsro))) {
            unset($this->PaymentMethodsForBallotsInEsro);
        } else {
            $this->PaymentMethodsForBallotsInEsro = $paymentMethodsForBallotsInEsro;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsForBallotsInPortal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodsForBallotsInPortal()
    {
        return isset($this->PaymentMethodsForBallotsInPortal) ? $this->PaymentMethodsForBallotsInPortal : null;
    }
    /**
     * Set PaymentMethodsForBallotsInPortal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodsForBallotsInPortal
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setPaymentMethodsForBallotsInPortal($paymentMethodsForBallotsInPortal = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodsForBallotsInPortal) && !is_string($paymentMethodsForBallotsInPortal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodsForBallotsInPortal, true), gettype($paymentMethodsForBallotsInPortal)), __LINE__);
        }
        if (is_null($paymentMethodsForBallotsInPortal) || (is_array($paymentMethodsForBallotsInPortal) && empty($paymentMethodsForBallotsInPortal))) {
            unset($this->PaymentMethodsForBallotsInPortal);
        } else {
            $this->PaymentMethodsForBallotsInPortal = $paymentMethodsForBallotsInPortal;
        }
        return $this;
    }
    /**
     * Get UseTicketReservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseTicketReservations()
    {
        return isset($this->UseTicketReservations) ? $this->UseTicketReservations : null;
    }
    /**
     * Set UseTicketReservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useTicketReservations
     * @return \patest\StructType\Security_BallotCompanyParameters
     */
    public function setUseTicketReservations($useTicketReservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTicketReservations) && !is_bool($useTicketReservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useTicketReservations, true), gettype($useTicketReservations)), __LINE__);
        }
        if (is_null($useTicketReservations) || (is_array($useTicketReservations) && empty($useTicketReservations))) {
            unset($this->UseTicketReservations);
        } else {
            $this->UseTicketReservations = $useTicketReservations;
        }
        return $this;
    }
}
