<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.AzureStorage StructType
 * @subpackage Structs
 */
class Security_AzureStorage extends PersistableEntity
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The SasCreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SasCreationDate;
    /**
     * The SasExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SasExpiryDate;
    /**
     * The SasUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SasUri;
    /**
     * Constructor method for Security.AzureStorage
     * @uses Security_AzureStorage::setName()
     * @uses Security_AzureStorage::setSasCreationDate()
     * @uses Security_AzureStorage::setSasExpiryDate()
     * @uses Security_AzureStorage::setSasUri()
     * @param \patest\StructType\GlobalString $name
     * @param string $sasCreationDate
     * @param string $sasExpiryDate
     * @param string $sasUri
     */
    public function __construct(\patest\StructType\GlobalString $name = null, $sasCreationDate = null, $sasExpiryDate = null, $sasUri = null)
    {
        $this
            ->setName($name)
            ->setSasCreationDate($sasCreationDate)
            ->setSasExpiryDate($sasExpiryDate)
            ->setSasUri($sasUri);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Security_AzureStorage
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SasCreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSasCreationDate()
    {
        return isset($this->SasCreationDate) ? $this->SasCreationDate : null;
    }
    /**
     * Set SasCreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sasCreationDate
     * @return \patest\StructType\Security_AzureStorage
     */
    public function setSasCreationDate($sasCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($sasCreationDate) && !is_string($sasCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sasCreationDate, true), gettype($sasCreationDate)), __LINE__);
        }
        if (is_null($sasCreationDate) || (is_array($sasCreationDate) && empty($sasCreationDate))) {
            unset($this->SasCreationDate);
        } else {
            $this->SasCreationDate = $sasCreationDate;
        }
        return $this;
    }
    /**
     * Get SasExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSasExpiryDate()
    {
        return isset($this->SasExpiryDate) ? $this->SasExpiryDate : null;
    }
    /**
     * Set SasExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sasExpiryDate
     * @return \patest\StructType\Security_AzureStorage
     */
    public function setSasExpiryDate($sasExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($sasExpiryDate) && !is_string($sasExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sasExpiryDate, true), gettype($sasExpiryDate)), __LINE__);
        }
        if (is_null($sasExpiryDate) || (is_array($sasExpiryDate) && empty($sasExpiryDate))) {
            unset($this->SasExpiryDate);
        } else {
            $this->SasExpiryDate = $sasExpiryDate;
        }
        return $this;
    }
    /**
     * Get SasUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSasUri()
    {
        return isset($this->SasUri) ? $this->SasUri : null;
    }
    /**
     * Set SasUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sasUri
     * @return \patest\StructType\Security_AzureStorage
     */
    public function setSasUri($sasUri = null)
    {
        // validation for constraint: string
        if (!is_null($sasUri) && !is_string($sasUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sasUri, true), gettype($sasUri)), __LINE__);
        }
        if (is_null($sasUri) || (is_array($sasUri) && empty($sasUri))) {
            unset($this->SasUri);
        } else {
            $this->SasUri = $sasUri;
        }
        return $this;
    }
}
