<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatsConsumptionSplitItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatsConsumptionSplitItem
 * @subpackage Structs
 */
class SeatsConsumptionSplitItem extends AbstractStructBase
{
    /**
     * The Occupied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Occupied;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservedCount;
    /**
     * The SoldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SoldCount;
    /**
     * The ForResaleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ForResaleCount;
    /**
     * Constructor method for SeatsConsumptionSplitItem
     * @uses SeatsConsumptionSplitItem::setOccupied()
     * @uses SeatsConsumptionSplitItem::setPriceLevelId()
     * @uses SeatsConsumptionSplitItem::setPriceTypeId()
     * @uses SeatsConsumptionSplitItem::setReservedCount()
     * @uses SeatsConsumptionSplitItem::setSoldCount()
     * @uses SeatsConsumptionSplitItem::setForResaleCount()
     * @param int $occupied
     * @param string $priceLevelId
     * @param string $priceTypeId
     * @param int $reservedCount
     * @param int $soldCount
     * @param int $forResaleCount
     */
    public function __construct($occupied = null, $priceLevelId = null, $priceTypeId = null, $reservedCount = null, $soldCount = null, $forResaleCount = null)
    {
        $this
            ->setOccupied($occupied)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypeId($priceTypeId)
            ->setReservedCount($reservedCount)
            ->setSoldCount($soldCount)
            ->setForResaleCount($forResaleCount);
    }
    /**
     * Get Occupied value
     * @return int|null
     */
    public function getOccupied()
    {
        return $this->Occupied;
    }
    /**
     * Set Occupied value
     * @param int $occupied
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setOccupied($occupied = null)
    {
        // validation for constraint: int
        if (!is_null($occupied) && !(is_int($occupied) || ctype_digit($occupied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupied, true), gettype($occupied)), __LINE__);
        }
        $this->Occupied = $occupied;
        return $this;
    }
    /**
     * Get PriceLevelId value
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return $this->PriceLevelId;
    }
    /**
     * Set PriceLevelId value
     * @param string $priceLevelId
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        $this->PriceLevelId = $priceLevelId;
        return $this;
    }
    /**
     * Get PriceTypeId value
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return $this->PriceTypeId;
    }
    /**
     * Set PriceTypeId value
     * @param string $priceTypeId
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        $this->PriceTypeId = $priceTypeId;
        return $this;
    }
    /**
     * Get ReservedCount value
     * @return int|null
     */
    public function getReservedCount()
    {
        return $this->ReservedCount;
    }
    /**
     * Set ReservedCount value
     * @param int $reservedCount
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        $this->ReservedCount = $reservedCount;
        return $this;
    }
    /**
     * Get SoldCount value
     * @return int|null
     */
    public function getSoldCount()
    {
        return $this->SoldCount;
    }
    /**
     * Set SoldCount value
     * @param int $soldCount
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        $this->SoldCount = $soldCount;
        return $this;
    }
    /**
     * Get ForResaleCount value
     * @return int|null
     */
    public function getForResaleCount()
    {
        return $this->ForResaleCount;
    }
    /**
     * Set ForResaleCount value
     * @param int $forResaleCount
     * @return \patest\StructType\SeatsConsumptionSplitItem
     */
    public function setForResaleCount($forResaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($forResaleCount) && !(is_int($forResaleCount) || ctype_digit($forResaleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forResaleCount, true), gettype($forResaleCount)), __LINE__);
        }
        $this->ForResaleCount = $forResaleCount;
        return $this;
    }
}
