<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatingPlanOwnerData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatingPlanOwnerData
 * @subpackage Structs
 */
class SeatingPlanOwnerData extends AbstractStructBase
{
    /**
     * The CompanyOwnsInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CompanyOwnsInventory;
    /**
     * The EventDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDateTime;
    /**
     * The EventMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EventMinutes;
    /**
     * The OwnerGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerGuid;
    /**
     * The OwnerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OwnerType;
    /**
     * The TimeZoneIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneIdentifier;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * Constructor method for SeatingPlanOwnerData
     * @uses SeatingPlanOwnerData::setCompanyOwnsInventory()
     * @uses SeatingPlanOwnerData::setEventDateTime()
     * @uses SeatingPlanOwnerData::setEventMinutes()
     * @uses SeatingPlanOwnerData::setOwnerGuid()
     * @uses SeatingPlanOwnerData::setOwnerType()
     * @uses SeatingPlanOwnerData::setTimeZoneIdentifier()
     * @uses SeatingPlanOwnerData::setOwnerName()
     * @param bool $companyOwnsInventory
     * @param string $eventDateTime
     * @param int $eventMinutes
     * @param string $ownerGuid
     * @param string $ownerType
     * @param string $timeZoneIdentifier
     * @param string $ownerName
     */
    public function __construct($companyOwnsInventory = null, $eventDateTime = null, $eventMinutes = null, $ownerGuid = null, $ownerType = null, $timeZoneIdentifier = null, $ownerName = null)
    {
        $this
            ->setCompanyOwnsInventory($companyOwnsInventory)
            ->setEventDateTime($eventDateTime)
            ->setEventMinutes($eventMinutes)
            ->setOwnerGuid($ownerGuid)
            ->setOwnerType($ownerType)
            ->setTimeZoneIdentifier($timeZoneIdentifier)
            ->setOwnerName($ownerName);
    }
    /**
     * Get CompanyOwnsInventory value
     * @return bool|null
     */
    public function getCompanyOwnsInventory()
    {
        return $this->CompanyOwnsInventory;
    }
    /**
     * Set CompanyOwnsInventory value
     * @param bool $companyOwnsInventory
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setCompanyOwnsInventory($companyOwnsInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($companyOwnsInventory) && !is_bool($companyOwnsInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($companyOwnsInventory, true), gettype($companyOwnsInventory)), __LINE__);
        }
        $this->CompanyOwnsInventory = $companyOwnsInventory;
        return $this;
    }
    /**
     * Get EventDateTime value
     * @return string|null
     */
    public function getEventDateTime()
    {
        return $this->EventDateTime;
    }
    /**
     * Set EventDateTime value
     * @param string $eventDateTime
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setEventDateTime($eventDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTime) && !is_string($eventDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTime, true), gettype($eventDateTime)), __LINE__);
        }
        $this->EventDateTime = $eventDateTime;
        return $this;
    }
    /**
     * Get EventMinutes value
     * @return int|null
     */
    public function getEventMinutes()
    {
        return $this->EventMinutes;
    }
    /**
     * Set EventMinutes value
     * @param int $eventMinutes
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setEventMinutes($eventMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($eventMinutes) && !(is_int($eventMinutes) || ctype_digit($eventMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventMinutes, true), gettype($eventMinutes)), __LINE__);
        }
        $this->EventMinutes = $eventMinutes;
        return $this;
    }
    /**
     * Get OwnerGuid value
     * @return string|null
     */
    public function getOwnerGuid()
    {
        return $this->OwnerGuid;
    }
    /**
     * Set OwnerGuid value
     * @param string $ownerGuid
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setOwnerGuid($ownerGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ownerGuid) && !is_string($ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerGuid, true), gettype($ownerGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerGuid, true)), __LINE__);
        }
        $this->OwnerGuid = $ownerGuid;
        return $this;
    }
    /**
     * Get OwnerType value
     * @return string|null
     */
    public function getOwnerType()
    {
        return $this->OwnerType;
    }
    /**
     * Set OwnerType value
     * @uses \patest\EnumType\SeatingPlanOwnerType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanOwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerType
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanOwnerType::valueIsValid($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanOwnerType', is_array($ownerType) ? implode(', ', $ownerType) : var_export($ownerType, true), implode(', ', \patest\EnumType\SeatingPlanOwnerType::getValidValues())), __LINE__);
        }
        $this->OwnerType = $ownerType;
        return $this;
    }
    /**
     * Get TimeZoneIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneIdentifier()
    {
        return isset($this->TimeZoneIdentifier) ? $this->TimeZoneIdentifier : null;
    }
    /**
     * Set TimeZoneIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneIdentifier
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setTimeZoneIdentifier($timeZoneIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneIdentifier) && !is_string($timeZoneIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneIdentifier, true), gettype($timeZoneIdentifier)), __LINE__);
        }
        if (is_null($timeZoneIdentifier) || (is_array($timeZoneIdentifier) && empty($timeZoneIdentifier))) {
            unset($this->TimeZoneIdentifier);
        } else {
            $this->TimeZoneIdentifier = $timeZoneIdentifier;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\SeatingPlanOwnerData
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
}
