<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Search.TransactionFilter StructType
 * @subpackage Structs
 */
class Search_TransactionFilter extends FilterEntity
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The ActualEventDateTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActualEventDateTimeFrom;
    /**
     * The ActualEventDateTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActualEventDateTimeTo;
    /**
     * The AffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AffiliateAccountId;
    /**
     * The AmountFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountFrom;
    /**
     * The AmountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountTo;
    /**
     * The AmountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountType;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CharityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CharityId;
    /**
     * The ChequeBranchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeBranchCode;
    /**
     * The ChequeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeNumber;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientId;
    /**
     * The ClientKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ClientKind;
    /**
     * The ContainsDonations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContainsDonations;
    /**
     * The ContainsMerchandise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContainsMerchandise;
    /**
     * The ContainsPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContainsPayments;
    /**
     * The ContainsSubscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContainsSubscriptions;
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The CouponDefinitionIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponDefinitionIdList
     */
    public $CouponDefinitionIdList;
    /**
     * The CouponORVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CouponORVoucherNumber;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCard;
    /**
     * The CreditCardExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardExpiryDate;
    /**
     * The CreditCardLastFourDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardLastFourDigits;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardSuffix;
    /**
     * The CRMID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CRMID;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The DonationKindForSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationKindForSearch;
    /**
     * The DonationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DonationsList
     */
    public $DonationsList;
    /**
     * The EmailPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailPhone;
    /**
     * The EventAreaPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventAreaPriceLevelId;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateFrom;
    /**
     * The EventDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateTo;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The ExpiresOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiresOn;
    /**
     * The ExpiresWithinMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExpiresWithinMinutes;
    /**
     * The ExternalTicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalTicketNumber;
    /**
     * The FilterByProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterByProduct;
    /**
     * The FilterOutGroupSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterOutGroupSale;
    /**
     * The FirstNameInclude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstNameInclude;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The FundsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FundsList
     */
    public $FundsList;
    /**
     * The GiftCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftCardNumber;
    /**
     * The GiftCardNumberAsPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftCardNumberAsPayment;
    /**
     * The GiftCardProgramId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftCardProgramId;
    /**
     * The GiftCardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftCardTypeId;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherDefinitionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GiftVoucherDefinitionList
     */
    public $GiftVoucherDefinitionList;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * The GroupOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupOrderId;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IDCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDCardNumber;
    /**
     * The IncludeInternalTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeInternalTransactions;
    /**
     * The IncludePledgeInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePledgeInstallments;
    /**
     * The IncludeSubscriptionTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeSubscriptionTickets;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateNumber;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The MembershipAllianceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipAllianceId;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The MembershipPrintStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipPrintStatus;
    /**
     * The MerchandiseBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchandiseBarcode;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The OBOAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OBOAccountId;
    /**
     * The OnlyGiftVouchers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnlyGiftVouchers;
    /**
     * The OnlyMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnlyMemberships;
    /**
     * The OnlyTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnlyTickets;
    /**
     * The OptionsToAdd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionsToAdd;
    /**
     * The OtherNamesInlcude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherNamesInlcude;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageId;
    /**
     * The PaymentGiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentGiftVoucherDefinitionId;
    /**
     * The PaymentGiftVoucherDefinitionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentGiftVoucherDefinitionList
     */
    public $PaymentGiftVoucherDefinitionList;
    /**
     * The PaymentGiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentGiftVoucherTypeId;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodsList
     */
    public $PaymentMethodsList;
    /**
     * The PaymentPlanNextDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentPlanNextDueDate;
    /**
     * The PaymentPlanNextDueDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentPlanNextDueDateFrom;
    /**
     * The PaymentPlanNextDueDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentPlanNextDueDateTo;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PaymentStatusList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatusList;
    /**
     * The PrepaidOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrepaidOnly;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The ProductItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductItemType;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Receipt;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The RefundCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RefundCategoryId;
    /**
     * The RefundCategoryIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RefundCategoryIdList
     */
    public $RefundCategoryIdList;
    /**
     * The RenewedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RenewedOnly;
    /**
     * The ReservationExpiryDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDateFrom;
    /**
     * The ReservationExpiryDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDateTo;
    /**
     * The ReservedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReservedItems;
    /**
     * The ReservedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReservedOnly;
    /**
     * The ReservedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservedStatus;
    /**
     * The ReservedStatusExtended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservedStatusExtended;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SchemaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemaId;
    /**
     * The SchemaLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemaLevelId;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SoldByUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoldByUser;
    /**
     * The SolicitorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SolicitorId;
    /**
     * The SubscriptionHallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionHallId;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubscriptionPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionPriceLevelId;
    /**
     * The SubscriptionPrintStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionPrintStatus;
    /**
     * The SubscriptionRenewedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SubscriptionRenewedOnly;
    /**
     * The SubscriptionRowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionRowName;
    /**
     * The SubscriptionSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionSeatName;
    /**
     * The TextSearchOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextSearchOption;
    /**
     * The TicketAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketAreaId;
    /**
     * The TicketAreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketAreaIds
     */
    public $TicketAreaIds;
    /**
     * The TicketBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBarcode;
    /**
     * The TicketEventAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketEventAreaId;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TicketsPrintStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsPrintStatus;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * The Top
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Top;
    /**
     * The TransactionAmountFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TransactionAmountFrom;
    /**
     * The TransactionAmountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TransactionAmountTo;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The TransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionIds;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionReferenceNumber;
    /**
     * The TransactionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionStatus;
    /**
     * The UnpaidAmountFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnpaidAmountFrom;
    /**
     * The UnpaidAmountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnpaidAmountTo;
    /**
     * The UnprintedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnprintedItems;
    /**
     * The UnprintedMembershipOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnprintedMembershipOnly;
    /**
     * The UnprintedSubscriptionOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnprintedSubscriptionOnly;
    /**
     * The VATRegistrationNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VATRegistrationNo;
    /**
     * The WasScanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasScanned;
    /**
     * The ZipPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipPostalCode;
    /**
     * Constructor method for Search.TransactionFilter
     * @uses Search_TransactionFilter::setAccountName()
     * @uses Search_TransactionFilter::setAccountNumber()
     * @uses Search_TransactionFilter::setActualEventDateTimeFrom()
     * @uses Search_TransactionFilter::setActualEventDateTimeTo()
     * @uses Search_TransactionFilter::setAffiliateAccountId()
     * @uses Search_TransactionFilter::setAmountFrom()
     * @uses Search_TransactionFilter::setAmountTo()
     * @uses Search_TransactionFilter::setAmountType()
     * @uses Search_TransactionFilter::setAppealId()
     * @uses Search_TransactionFilter::setApplicationChannel()
     * @uses Search_TransactionFilter::setAreaId()
     * @uses Search_TransactionFilter::setAreaIds()
     * @uses Search_TransactionFilter::setBankCode()
     * @uses Search_TransactionFilter::setCampaignId()
     * @uses Search_TransactionFilter::setCategoryId()
     * @uses Search_TransactionFilter::setCharityId()
     * @uses Search_TransactionFilter::setChequeBranchCode()
     * @uses Search_TransactionFilter::setChequeNumber()
     * @uses Search_TransactionFilter::setClientId()
     * @uses Search_TransactionFilter::setClientKind()
     * @uses Search_TransactionFilter::setContainsDonations()
     * @uses Search_TransactionFilter::setContainsMerchandise()
     * @uses Search_TransactionFilter::setContainsPayments()
     * @uses Search_TransactionFilter::setContainsSubscriptions()
     * @uses Search_TransactionFilter::setCouponDefinitionId()
     * @uses Search_TransactionFilter::setCouponDefinitionIdList()
     * @uses Search_TransactionFilter::setCouponORVoucherNumber()
     * @uses Search_TransactionFilter::setCreditCard()
     * @uses Search_TransactionFilter::setCreditCardExpiryDate()
     * @uses Search_TransactionFilter::setCreditCardLastFourDigits()
     * @uses Search_TransactionFilter::setCreditCardSuffix()
     * @uses Search_TransactionFilter::setCRMID()
     * @uses Search_TransactionFilter::setDonationId()
     * @uses Search_TransactionFilter::setDonationKindForSearch()
     * @uses Search_TransactionFilter::setDonationsList()
     * @uses Search_TransactionFilter::setEmailPhone()
     * @uses Search_TransactionFilter::setEventAreaPriceLevelId()
     * @uses Search_TransactionFilter::setEventDate()
     * @uses Search_TransactionFilter::setEventDateFrom()
     * @uses Search_TransactionFilter::setEventDateTo()
     * @uses Search_TransactionFilter::setEventId()
     * @uses Search_TransactionFilter::setEventType1Id()
     * @uses Search_TransactionFilter::setEventType2Id()
     * @uses Search_TransactionFilter::setEventType3Id()
     * @uses Search_TransactionFilter::setEventType4Id()
     * @uses Search_TransactionFilter::setEventType5Id()
     * @uses Search_TransactionFilter::setEventTypeId()
     * @uses Search_TransactionFilter::setExpiresOn()
     * @uses Search_TransactionFilter::setExpiresWithinMinutes()
     * @uses Search_TransactionFilter::setExternalTicketNumber()
     * @uses Search_TransactionFilter::setFilterByProduct()
     * @uses Search_TransactionFilter::setFilterOutGroupSale()
     * @uses Search_TransactionFilter::setFirstNameInclude()
     * @uses Search_TransactionFilter::setFundId()
     * @uses Search_TransactionFilter::setFundsList()
     * @uses Search_TransactionFilter::setGiftCardNumber()
     * @uses Search_TransactionFilter::setGiftCardNumberAsPayment()
     * @uses Search_TransactionFilter::setGiftCardProgramId()
     * @uses Search_TransactionFilter::setGiftCardTypeId()
     * @uses Search_TransactionFilter::setGiftVoucherDefinitionId()
     * @uses Search_TransactionFilter::setGiftVoucherDefinitionList()
     * @uses Search_TransactionFilter::setGiftVoucherNumber()
     * @uses Search_TransactionFilter::setGiftVoucherTypeId()
     * @uses Search_TransactionFilter::setGroupOrderId()
     * @uses Search_TransactionFilter::setHallId()
     * @uses Search_TransactionFilter::setIDCardNumber()
     * @uses Search_TransactionFilter::setIncludeInternalTransactions()
     * @uses Search_TransactionFilter::setIncludePledgeInstallments()
     * @uses Search_TransactionFilter::setIncludeSubscriptionTickets()
     * @uses Search_TransactionFilter::setItemTypeId()
     * @uses Search_TransactionFilter::setLastName()
     * @uses Search_TransactionFilter::setMandateNumber()
     * @uses Search_TransactionFilter::setMandateTypeId()
     * @uses Search_TransactionFilter::setMembershipAllianceId()
     * @uses Search_TransactionFilter::setMembershipDefinitionId()
     * @uses Search_TransactionFilter::setMembershipNumber()
     * @uses Search_TransactionFilter::setMembershipPrintStatus()
     * @uses Search_TransactionFilter::setMerchandiseBarcode()
     * @uses Search_TransactionFilter::setMerchandiseId()
     * @uses Search_TransactionFilter::setOBOAccountId()
     * @uses Search_TransactionFilter::setOnlyGiftVouchers()
     * @uses Search_TransactionFilter::setOnlyMemberships()
     * @uses Search_TransactionFilter::setOnlyTickets()
     * @uses Search_TransactionFilter::setOptionsToAdd()
     * @uses Search_TransactionFilter::setOtherNamesInlcude()
     * @uses Search_TransactionFilter::setPackageId()
     * @uses Search_TransactionFilter::setPaymentGiftVoucherDefinitionId()
     * @uses Search_TransactionFilter::setPaymentGiftVoucherDefinitionList()
     * @uses Search_TransactionFilter::setPaymentGiftVoucherTypeId()
     * @uses Search_TransactionFilter::setPaymentMethod()
     * @uses Search_TransactionFilter::setPaymentMethodId()
     * @uses Search_TransactionFilter::setPaymentMethodsList()
     * @uses Search_TransactionFilter::setPaymentPlanNextDueDate()
     * @uses Search_TransactionFilter::setPaymentPlanNextDueDateFrom()
     * @uses Search_TransactionFilter::setPaymentPlanNextDueDateTo()
     * @uses Search_TransactionFilter::setPaymentStatus()
     * @uses Search_TransactionFilter::setPaymentStatusList()
     * @uses Search_TransactionFilter::setPrepaidOnly()
     * @uses Search_TransactionFilter::setPriceLevelId()
     * @uses Search_TransactionFilter::setProductItemType()
     * @uses Search_TransactionFilter::setReceipt()
     * @uses Search_TransactionFilter::setReferenceNumber()
     * @uses Search_TransactionFilter::setRefundCategoryId()
     * @uses Search_TransactionFilter::setRefundCategoryIdList()
     * @uses Search_TransactionFilter::setRenewedOnly()
     * @uses Search_TransactionFilter::setReservationExpiryDateFrom()
     * @uses Search_TransactionFilter::setReservationExpiryDateTo()
     * @uses Search_TransactionFilter::setReservedItems()
     * @uses Search_TransactionFilter::setReservedOnly()
     * @uses Search_TransactionFilter::setReservedStatus()
     * @uses Search_TransactionFilter::setReservedStatusExtended()
     * @uses Search_TransactionFilter::setRowName()
     * @uses Search_TransactionFilter::setSaleModeId()
     * @uses Search_TransactionFilter::setSalesRepId()
     * @uses Search_TransactionFilter::setSchemaId()
     * @uses Search_TransactionFilter::setSchemaLevelId()
     * @uses Search_TransactionFilter::setSeasonId()
     * @uses Search_TransactionFilter::setSeatName()
     * @uses Search_TransactionFilter::setSectorId()
     * @uses Search_TransactionFilter::setSellerBranchId()
     * @uses Search_TransactionFilter::setSeriesId()
     * @uses Search_TransactionFilter::setSGOrderId()
     * @uses Search_TransactionFilter::setShowId()
     * @uses Search_TransactionFilter::setSiteId()
     * @uses Search_TransactionFilter::setSoldByUser()
     * @uses Search_TransactionFilter::setSolicitorId()
     * @uses Search_TransactionFilter::setSubscriptionHallId()
     * @uses Search_TransactionFilter::setSubscriptionId()
     * @uses Search_TransactionFilter::setSubscriptionNumber()
     * @uses Search_TransactionFilter::setSubscriptionPriceLevelId()
     * @uses Search_TransactionFilter::setSubscriptionPrintStatus()
     * @uses Search_TransactionFilter::setSubscriptionRenewedOnly()
     * @uses Search_TransactionFilter::setSubscriptionRowName()
     * @uses Search_TransactionFilter::setSubscriptionSeatName()
     * @uses Search_TransactionFilter::setTextSearchOption()
     * @uses Search_TransactionFilter::setTicketAreaId()
     * @uses Search_TransactionFilter::setTicketAreaIds()
     * @uses Search_TransactionFilter::setTicketBarcode()
     * @uses Search_TransactionFilter::setTicketEventAreaId()
     * @uses Search_TransactionFilter::setTicketNumber()
     * @uses Search_TransactionFilter::setTicketsPrintStatus()
     * @uses Search_TransactionFilter::setTicketType()
     * @uses Search_TransactionFilter::setTop()
     * @uses Search_TransactionFilter::setTransactionAmountFrom()
     * @uses Search_TransactionFilter::setTransactionAmountTo()
     * @uses Search_TransactionFilter::setTransactionDate()
     * @uses Search_TransactionFilter::setTransactionDateFrom()
     * @uses Search_TransactionFilter::setTransactionDateTo()
     * @uses Search_TransactionFilter::setTransactionIds()
     * @uses Search_TransactionFilter::setTransactionNumber()
     * @uses Search_TransactionFilter::setTransactionReferenceNumber()
     * @uses Search_TransactionFilter::setTransactionStatus()
     * @uses Search_TransactionFilter::setUnpaidAmountFrom()
     * @uses Search_TransactionFilter::setUnpaidAmountTo()
     * @uses Search_TransactionFilter::setUnprintedItems()
     * @uses Search_TransactionFilter::setUnprintedMembershipOnly()
     * @uses Search_TransactionFilter::setUnprintedSubscriptionOnly()
     * @uses Search_TransactionFilter::setVATRegistrationNo()
     * @uses Search_TransactionFilter::setWasScanned()
     * @uses Search_TransactionFilter::setZipPostalCode()
     * @param string $accountName
     * @param string $accountNumber
     * @param string $actualEventDateTimeFrom
     * @param string $actualEventDateTimeTo
     * @param string $affiliateAccountId
     * @param float $amountFrom
     * @param float $amountTo
     * @param string $amountType
     * @param string $appealId
     * @param string $applicationChannel
     * @param string $areaId
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $bankCode
     * @param string $campaignId
     * @param string $categoryId
     * @param string $charityId
     * @param string $chequeBranchCode
     * @param string $chequeNumber
     * @param string $clientId
     * @param string[] $clientKind
     * @param bool $containsDonations
     * @param bool $containsMerchandise
     * @param bool $containsPayments
     * @param bool $containsSubscriptions
     * @param string $couponDefinitionId
     * @param \patest\StructType\CouponDefinitionIdList $couponDefinitionIdList
     * @param string $couponORVoucherNumber
     * @param string $creditCard
     * @param string $creditCardExpiryDate
     * @param string $creditCardLastFourDigits
     * @param string $creditCardSuffix
     * @param string $cRMID
     * @param string $donationId
     * @param string $donationKindForSearch
     * @param \patest\StructType\DonationsList $donationsList
     * @param string $emailPhone
     * @param string $eventAreaPriceLevelId
     * @param string $eventDate
     * @param string $eventDateFrom
     * @param string $eventDateTo
     * @param string $eventId
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param string $eventTypeId
     * @param string $expiresOn
     * @param int $expiresWithinMinutes
     * @param string $externalTicketNumber
     * @param string $filterByProduct
     * @param bool $filterOutGroupSale
     * @param string $firstNameInclude
     * @param string $fundId
     * @param \patest\StructType\FundsList $fundsList
     * @param string $giftCardNumber
     * @param string $giftCardNumberAsPayment
     * @param string $giftCardProgramId
     * @param string $giftCardTypeId
     * @param string $giftVoucherDefinitionId
     * @param \patest\StructType\GiftVoucherDefinitionList $giftVoucherDefinitionList
     * @param string $giftVoucherNumber
     * @param string $giftVoucherTypeId
     * @param int $groupOrderId
     * @param string $hallId
     * @param string $iDCardNumber
     * @param bool $includeInternalTransactions
     * @param bool $includePledgeInstallments
     * @param bool $includeSubscriptionTickets
     * @param string $itemTypeId
     * @param string $lastName
     * @param string $mandateNumber
     * @param string $mandateTypeId
     * @param string $membershipAllianceId
     * @param string $membershipDefinitionId
     * @param string $membershipNumber
     * @param string $membershipPrintStatus
     * @param string $merchandiseBarcode
     * @param string $merchandiseId
     * @param string $oBOAccountId
     * @param bool $onlyGiftVouchers
     * @param bool $onlyMemberships
     * @param bool $onlyTickets
     * @param string $optionsToAdd
     * @param string $otherNamesInlcude
     * @param string $packageId
     * @param string $paymentGiftVoucherDefinitionId
     * @param \patest\StructType\PaymentGiftVoucherDefinitionList $paymentGiftVoucherDefinitionList
     * @param string $paymentGiftVoucherTypeId
     * @param string $paymentMethod
     * @param string $paymentMethodId
     * @param \patest\StructType\PaymentMethodsList $paymentMethodsList
     * @param string $paymentPlanNextDueDate
     * @param string $paymentPlanNextDueDateFrom
     * @param string $paymentPlanNextDueDateTo
     * @param string $paymentStatus
     * @param string $paymentStatusList
     * @param bool $prepaidOnly
     * @param string $priceLevelId
     * @param string $productItemType
     * @param int $receipt
     * @param string $referenceNumber
     * @param string $refundCategoryId
     * @param \patest\StructType\RefundCategoryIdList $refundCategoryIdList
     * @param bool $renewedOnly
     * @param string $reservationExpiryDateFrom
     * @param string $reservationExpiryDateTo
     * @param bool $reservedItems
     * @param bool $reservedOnly
     * @param string $reservedStatus
     * @param string $reservedStatusExtended
     * @param string $rowName
     * @param string $saleModeId
     * @param string $salesRepId
     * @param string $schemaId
     * @param string $schemaLevelId
     * @param string $seasonId
     * @param string $seatName
     * @param string $sectorId
     * @param string $sellerBranchId
     * @param string $seriesId
     * @param string $sGOrderId
     * @param string $showId
     * @param string $siteId
     * @param string $soldByUser
     * @param string $solicitorId
     * @param string $subscriptionHallId
     * @param string $subscriptionId
     * @param string $subscriptionNumber
     * @param string $subscriptionPriceLevelId
     * @param string $subscriptionPrintStatus
     * @param bool $subscriptionRenewedOnly
     * @param string $subscriptionRowName
     * @param string $subscriptionSeatName
     * @param string $textSearchOption
     * @param string $ticketAreaId
     * @param \patest\StructType\TicketAreaIds $ticketAreaIds
     * @param string $ticketBarcode
     * @param string $ticketEventAreaId
     * @param int $ticketNumber
     * @param string $ticketsPrintStatus
     * @param string $ticketType
     * @param int $top
     * @param float $transactionAmountFrom
     * @param float $transactionAmountTo
     * @param string $transactionDate
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param string $transactionIds
     * @param string $transactionNumber
     * @param string $transactionReferenceNumber
     * @param string $transactionStatus
     * @param float $unpaidAmountFrom
     * @param float $unpaidAmountTo
     * @param bool $unprintedItems
     * @param bool $unprintedMembershipOnly
     * @param bool $unprintedSubscriptionOnly
     * @param string $vATRegistrationNo
     * @param bool $wasScanned
     * @param string $zipPostalCode
     */
    public function __construct($accountName = null, $accountNumber = null, $actualEventDateTimeFrom = null, $actualEventDateTimeTo = null, $affiliateAccountId = null, $amountFrom = null, $amountTo = null, $amountType = null, $appealId = null, $applicationChannel = null, $areaId = null, \patest\StructType\AreaIds $areaIds = null, $bankCode = null, $campaignId = null, $categoryId = null, $charityId = null, $chequeBranchCode = null, $chequeNumber = null, $clientId = null, array $clientKind = array(), $containsDonations = null, $containsMerchandise = null, $containsPayments = null, $containsSubscriptions = null, $couponDefinitionId = null, \patest\StructType\CouponDefinitionIdList $couponDefinitionIdList = null, $couponORVoucherNumber = null, $creditCard = null, $creditCardExpiryDate = null, $creditCardLastFourDigits = null, $creditCardSuffix = null, $cRMID = null, $donationId = null, $donationKindForSearch = null, \patest\StructType\DonationsList $donationsList = null, $emailPhone = null, $eventAreaPriceLevelId = null, $eventDate = null, $eventDateFrom = null, $eventDateTo = null, $eventId = null, $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $eventTypeId = null, $expiresOn = null, $expiresWithinMinutes = null, $externalTicketNumber = null, $filterByProduct = null, $filterOutGroupSale = null, $firstNameInclude = null, $fundId = null, \patest\StructType\FundsList $fundsList = null, $giftCardNumber = null, $giftCardNumberAsPayment = null, $giftCardProgramId = null, $giftCardTypeId = null, $giftVoucherDefinitionId = null, \patest\StructType\GiftVoucherDefinitionList $giftVoucherDefinitionList = null, $giftVoucherNumber = null, $giftVoucherTypeId = null, $groupOrderId = null, $hallId = null, $iDCardNumber = null, $includeInternalTransactions = null, $includePledgeInstallments = null, $includeSubscriptionTickets = null, $itemTypeId = null, $lastName = null, $mandateNumber = null, $mandateTypeId = null, $membershipAllianceId = null, $membershipDefinitionId = null, $membershipNumber = null, $membershipPrintStatus = null, $merchandiseBarcode = null, $merchandiseId = null, $oBOAccountId = null, $onlyGiftVouchers = null, $onlyMemberships = null, $onlyTickets = null, $optionsToAdd = null, $otherNamesInlcude = null, $packageId = null, $paymentGiftVoucherDefinitionId = null, \patest\StructType\PaymentGiftVoucherDefinitionList $paymentGiftVoucherDefinitionList = null, $paymentGiftVoucherTypeId = null, $paymentMethod = null, $paymentMethodId = null, \patest\StructType\PaymentMethodsList $paymentMethodsList = null, $paymentPlanNextDueDate = null, $paymentPlanNextDueDateFrom = null, $paymentPlanNextDueDateTo = null, $paymentStatus = null, $paymentStatusList = null, $prepaidOnly = null, $priceLevelId = null, $productItemType = null, $receipt = null, $referenceNumber = null, $refundCategoryId = null, \patest\StructType\RefundCategoryIdList $refundCategoryIdList = null, $renewedOnly = null, $reservationExpiryDateFrom = null, $reservationExpiryDateTo = null, $reservedItems = null, $reservedOnly = null, $reservedStatus = null, $reservedStatusExtended = null, $rowName = null, $saleModeId = null, $salesRepId = null, $schemaId = null, $schemaLevelId = null, $seasonId = null, $seatName = null, $sectorId = null, $sellerBranchId = null, $seriesId = null, $sGOrderId = null, $showId = null, $siteId = null, $soldByUser = null, $solicitorId = null, $subscriptionHallId = null, $subscriptionId = null, $subscriptionNumber = null, $subscriptionPriceLevelId = null, $subscriptionPrintStatus = null, $subscriptionRenewedOnly = null, $subscriptionRowName = null, $subscriptionSeatName = null, $textSearchOption = null, $ticketAreaId = null, \patest\StructType\TicketAreaIds $ticketAreaIds = null, $ticketBarcode = null, $ticketEventAreaId = null, $ticketNumber = null, $ticketsPrintStatus = null, $ticketType = null, $top = null, $transactionAmountFrom = null, $transactionAmountTo = null, $transactionDate = null, $transactionDateFrom = null, $transactionDateTo = null, $transactionIds = null, $transactionNumber = null, $transactionReferenceNumber = null, $transactionStatus = null, $unpaidAmountFrom = null, $unpaidAmountTo = null, $unprintedItems = null, $unprintedMembershipOnly = null, $unprintedSubscriptionOnly = null, $vATRegistrationNo = null, $wasScanned = null, $zipPostalCode = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setActualEventDateTimeFrom($actualEventDateTimeFrom)
            ->setActualEventDateTimeTo($actualEventDateTimeTo)
            ->setAffiliateAccountId($affiliateAccountId)
            ->setAmountFrom($amountFrom)
            ->setAmountTo($amountTo)
            ->setAmountType($amountType)
            ->setAppealId($appealId)
            ->setApplicationChannel($applicationChannel)
            ->setAreaId($areaId)
            ->setAreaIds($areaIds)
            ->setBankCode($bankCode)
            ->setCampaignId($campaignId)
            ->setCategoryId($categoryId)
            ->setCharityId($charityId)
            ->setChequeBranchCode($chequeBranchCode)
            ->setChequeNumber($chequeNumber)
            ->setClientId($clientId)
            ->setClientKind($clientKind)
            ->setContainsDonations($containsDonations)
            ->setContainsMerchandise($containsMerchandise)
            ->setContainsPayments($containsPayments)
            ->setContainsSubscriptions($containsSubscriptions)
            ->setCouponDefinitionId($couponDefinitionId)
            ->setCouponDefinitionIdList($couponDefinitionIdList)
            ->setCouponORVoucherNumber($couponORVoucherNumber)
            ->setCreditCard($creditCard)
            ->setCreditCardExpiryDate($creditCardExpiryDate)
            ->setCreditCardLastFourDigits($creditCardLastFourDigits)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setCRMID($cRMID)
            ->setDonationId($donationId)
            ->setDonationKindForSearch($donationKindForSearch)
            ->setDonationsList($donationsList)
            ->setEmailPhone($emailPhone)
            ->setEventAreaPriceLevelId($eventAreaPriceLevelId)
            ->setEventDate($eventDate)
            ->setEventDateFrom($eventDateFrom)
            ->setEventDateTo($eventDateTo)
            ->setEventId($eventId)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setEventTypeId($eventTypeId)
            ->setExpiresOn($expiresOn)
            ->setExpiresWithinMinutes($expiresWithinMinutes)
            ->setExternalTicketNumber($externalTicketNumber)
            ->setFilterByProduct($filterByProduct)
            ->setFilterOutGroupSale($filterOutGroupSale)
            ->setFirstNameInclude($firstNameInclude)
            ->setFundId($fundId)
            ->setFundsList($fundsList)
            ->setGiftCardNumber($giftCardNumber)
            ->setGiftCardNumberAsPayment($giftCardNumberAsPayment)
            ->setGiftCardProgramId($giftCardProgramId)
            ->setGiftCardTypeId($giftCardTypeId)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherDefinitionList($giftVoucherDefinitionList)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setGroupOrderId($groupOrderId)
            ->setHallId($hallId)
            ->setIDCardNumber($iDCardNumber)
            ->setIncludeInternalTransactions($includeInternalTransactions)
            ->setIncludePledgeInstallments($includePledgeInstallments)
            ->setIncludeSubscriptionTickets($includeSubscriptionTickets)
            ->setItemTypeId($itemTypeId)
            ->setLastName($lastName)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeId($mandateTypeId)
            ->setMembershipAllianceId($membershipAllianceId)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipNumber($membershipNumber)
            ->setMembershipPrintStatus($membershipPrintStatus)
            ->setMerchandiseBarcode($merchandiseBarcode)
            ->setMerchandiseId($merchandiseId)
            ->setOBOAccountId($oBOAccountId)
            ->setOnlyGiftVouchers($onlyGiftVouchers)
            ->setOnlyMemberships($onlyMemberships)
            ->setOnlyTickets($onlyTickets)
            ->setOptionsToAdd($optionsToAdd)
            ->setOtherNamesInlcude($otherNamesInlcude)
            ->setPackageId($packageId)
            ->setPaymentGiftVoucherDefinitionId($paymentGiftVoucherDefinitionId)
            ->setPaymentGiftVoucherDefinitionList($paymentGiftVoucherDefinitionList)
            ->setPaymentGiftVoucherTypeId($paymentGiftVoucherTypeId)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodsList($paymentMethodsList)
            ->setPaymentPlanNextDueDate($paymentPlanNextDueDate)
            ->setPaymentPlanNextDueDateFrom($paymentPlanNextDueDateFrom)
            ->setPaymentPlanNextDueDateTo($paymentPlanNextDueDateTo)
            ->setPaymentStatus($paymentStatus)
            ->setPaymentStatusList($paymentStatusList)
            ->setPrepaidOnly($prepaidOnly)
            ->setPriceLevelId($priceLevelId)
            ->setProductItemType($productItemType)
            ->setReceipt($receipt)
            ->setReferenceNumber($referenceNumber)
            ->setRefundCategoryId($refundCategoryId)
            ->setRefundCategoryIdList($refundCategoryIdList)
            ->setRenewedOnly($renewedOnly)
            ->setReservationExpiryDateFrom($reservationExpiryDateFrom)
            ->setReservationExpiryDateTo($reservationExpiryDateTo)
            ->setReservedItems($reservedItems)
            ->setReservedOnly($reservedOnly)
            ->setReservedStatus($reservedStatus)
            ->setReservedStatusExtended($reservedStatusExtended)
            ->setRowName($rowName)
            ->setSaleModeId($saleModeId)
            ->setSalesRepId($salesRepId)
            ->setSchemaId($schemaId)
            ->setSchemaLevelId($schemaLevelId)
            ->setSeasonId($seasonId)
            ->setSeatName($seatName)
            ->setSectorId($sectorId)
            ->setSellerBranchId($sellerBranchId)
            ->setSeriesId($seriesId)
            ->setSGOrderId($sGOrderId)
            ->setShowId($showId)
            ->setSiteId($siteId)
            ->setSoldByUser($soldByUser)
            ->setSolicitorId($solicitorId)
            ->setSubscriptionHallId($subscriptionHallId)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubscriptionPriceLevelId($subscriptionPriceLevelId)
            ->setSubscriptionPrintStatus($subscriptionPrintStatus)
            ->setSubscriptionRenewedOnly($subscriptionRenewedOnly)
            ->setSubscriptionRowName($subscriptionRowName)
            ->setSubscriptionSeatName($subscriptionSeatName)
            ->setTextSearchOption($textSearchOption)
            ->setTicketAreaId($ticketAreaId)
            ->setTicketAreaIds($ticketAreaIds)
            ->setTicketBarcode($ticketBarcode)
            ->setTicketEventAreaId($ticketEventAreaId)
            ->setTicketNumber($ticketNumber)
            ->setTicketsPrintStatus($ticketsPrintStatus)
            ->setTicketType($ticketType)
            ->setTop($top)
            ->setTransactionAmountFrom($transactionAmountFrom)
            ->setTransactionAmountTo($transactionAmountTo)
            ->setTransactionDate($transactionDate)
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setTransactionIds($transactionIds)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setTransactionStatus($transactionStatus)
            ->setUnpaidAmountFrom($unpaidAmountFrom)
            ->setUnpaidAmountTo($unpaidAmountTo)
            ->setUnprintedItems($unprintedItems)
            ->setUnprintedMembershipOnly($unprintedMembershipOnly)
            ->setUnprintedSubscriptionOnly($unprintedSubscriptionOnly)
            ->setVATRegistrationNo($vATRegistrationNo)
            ->setWasScanned($wasScanned)
            ->setZipPostalCode($zipPostalCode);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get ActualEventDateTimeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActualEventDateTimeFrom()
    {
        return isset($this->ActualEventDateTimeFrom) ? $this->ActualEventDateTimeFrom : null;
    }
    /**
     * Set ActualEventDateTimeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actualEventDateTimeFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setActualEventDateTimeFrom($actualEventDateTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($actualEventDateTimeFrom) && !is_string($actualEventDateTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualEventDateTimeFrom, true), gettype($actualEventDateTimeFrom)), __LINE__);
        }
        if (is_null($actualEventDateTimeFrom) || (is_array($actualEventDateTimeFrom) && empty($actualEventDateTimeFrom))) {
            unset($this->ActualEventDateTimeFrom);
        } else {
            $this->ActualEventDateTimeFrom = $actualEventDateTimeFrom;
        }
        return $this;
    }
    /**
     * Get ActualEventDateTimeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActualEventDateTimeTo()
    {
        return isset($this->ActualEventDateTimeTo) ? $this->ActualEventDateTimeTo : null;
    }
    /**
     * Set ActualEventDateTimeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actualEventDateTimeTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setActualEventDateTimeTo($actualEventDateTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($actualEventDateTimeTo) && !is_string($actualEventDateTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualEventDateTimeTo, true), gettype($actualEventDateTimeTo)), __LINE__);
        }
        if (is_null($actualEventDateTimeTo) || (is_array($actualEventDateTimeTo) && empty($actualEventDateTimeTo))) {
            unset($this->ActualEventDateTimeTo);
        } else {
            $this->ActualEventDateTimeTo = $actualEventDateTimeTo;
        }
        return $this;
    }
    /**
     * Get AffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAffiliateAccountId()
    {
        return isset($this->AffiliateAccountId) ? $this->AffiliateAccountId : null;
    }
    /**
     * Set AffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $affiliateAccountId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAffiliateAccountId($affiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateAccountId) && !is_string($affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateAccountId, true), gettype($affiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($affiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($affiliateAccountId, true)), __LINE__);
        }
        if (is_null($affiliateAccountId) || (is_array($affiliateAccountId) && empty($affiliateAccountId))) {
            unset($this->AffiliateAccountId);
        } else {
            $this->AffiliateAccountId = $affiliateAccountId;
        }
        return $this;
    }
    /**
     * Get AmountFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountFrom()
    {
        return isset($this->AmountFrom) ? $this->AmountFrom : null;
    }
    /**
     * Set AmountFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAmountFrom($amountFrom = null)
    {
        // validation for constraint: float
        if (!is_null($amountFrom) && !(is_float($amountFrom) || is_numeric($amountFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountFrom, true), gettype($amountFrom)), __LINE__);
        }
        if (is_null($amountFrom) || (is_array($amountFrom) && empty($amountFrom))) {
            unset($this->AmountFrom);
        } else {
            $this->AmountFrom = $amountFrom;
        }
        return $this;
    }
    /**
     * Get AmountTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountTo()
    {
        return isset($this->AmountTo) ? $this->AmountTo : null;
    }
    /**
     * Set AmountTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAmountTo($amountTo = null)
    {
        // validation for constraint: float
        if (!is_null($amountTo) && !(is_float($amountTo) || is_numeric($amountTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountTo, true), gettype($amountTo)), __LINE__);
        }
        if (is_null($amountTo) || (is_array($amountTo) && empty($amountTo))) {
            unset($this->AmountTo);
        } else {
            $this->AmountTo = $amountTo;
        }
        return $this;
    }
    /**
     * Get AmountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountType()
    {
        return isset($this->AmountType) ? $this->AmountType : null;
    }
    /**
     * Set AmountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AmountType::valueIsValid()
     * @uses \patest\EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountType
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAmountType($amountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AmountType::valueIsValid($amountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AmountType', is_array($amountType) ? implode(', ', $amountType) : var_export($amountType, true), implode(', ', \patest\EnumType\AmountType::getValidValues())), __LINE__);
        }
        if (is_null($amountType) || (is_array($amountType) && empty($amountType))) {
            unset($this->AmountType);
        } else {
            $this->AmountType = $amountType;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CharityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharityId()
    {
        return isset($this->CharityId) ? $this->CharityId : null;
    }
    /**
     * Set CharityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $charityId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCharityId($charityId = null)
    {
        // validation for constraint: string
        if (!is_null($charityId) && !is_string($charityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charityId, true), gettype($charityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($charityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $charityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($charityId, true)), __LINE__);
        }
        if (is_null($charityId) || (is_array($charityId) && empty($charityId))) {
            unset($this->CharityId);
        } else {
            $this->CharityId = $charityId;
        }
        return $this;
    }
    /**
     * Get ChequeBranchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeBranchCode()
    {
        return isset($this->ChequeBranchCode) ? $this->ChequeBranchCode : null;
    }
    /**
     * Set ChequeBranchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeBranchCode
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setChequeBranchCode($chequeBranchCode = null)
    {
        // validation for constraint: string
        if (!is_null($chequeBranchCode) && !is_string($chequeBranchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeBranchCode, true), gettype($chequeBranchCode)), __LINE__);
        }
        if (is_null($chequeBranchCode) || (is_array($chequeBranchCode) && empty($chequeBranchCode))) {
            unset($this->ChequeBranchCode);
        } else {
            $this->ChequeBranchCode = $chequeBranchCode;
        }
        return $this;
    }
    /**
     * Get ChequeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeNumber()
    {
        return isset($this->ChequeNumber) ? $this->ChequeNumber : null;
    }
    /**
     * Set ChequeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setChequeNumber($chequeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chequeNumber) && !is_string($chequeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeNumber, true), gettype($chequeNumber)), __LINE__);
        }
        if (is_null($chequeNumber) || (is_array($chequeNumber) && empty($chequeNumber))) {
            unset($this->ChequeNumber);
        } else {
            $this->ChequeNumber = $chequeNumber;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getClientKind()
    {
        return isset($this->ClientKind) ? $this->ClientKind : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientKind method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientKind method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientKindForArrayConstraintsFromSetClientKind(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $search_TransactionFilterClientKindItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($search_TransactionFilterClientKindItem)) {
                $invalidValues[] = is_object($search_TransactionFilterClientKindItem) ? get_class($search_TransactionFilterClientKindItem) : sprintf('%s(%s)', gettype($search_TransactionFilterClientKindItem), var_export($search_TransactionFilterClientKindItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $clientKind
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setClientKind(array $clientKind = array())
    {
        // validation for constraint: list
        if ('' !== ($clientKindArrayErrorMessage = self::validateClientKindForArrayConstraintsFromSetClientKind($clientKind))) {
            throw new \InvalidArgumentException($clientKindArrayErrorMessage, __LINE__);
        }
        if (is_null($clientKind) || (is_array($clientKind) && empty($clientKind))) {
            unset($this->ClientKind);
        } else {
            $this->ClientKind = is_array($clientKind) ? implode(' ', $clientKind) : null;
        }
        return $this;
    }
    /**
     * Get ContainsDonations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContainsDonations()
    {
        return isset($this->ContainsDonations) ? $this->ContainsDonations : null;
    }
    /**
     * Set ContainsDonations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $containsDonations
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setContainsDonations($containsDonations = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsDonations) && !is_bool($containsDonations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsDonations, true), gettype($containsDonations)), __LINE__);
        }
        if (is_null($containsDonations) || (is_array($containsDonations) && empty($containsDonations))) {
            unset($this->ContainsDonations);
        } else {
            $this->ContainsDonations = $containsDonations;
        }
        return $this;
    }
    /**
     * Get ContainsMerchandise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContainsMerchandise()
    {
        return isset($this->ContainsMerchandise) ? $this->ContainsMerchandise : null;
    }
    /**
     * Set ContainsMerchandise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $containsMerchandise
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setContainsMerchandise($containsMerchandise = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsMerchandise) && !is_bool($containsMerchandise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsMerchandise, true), gettype($containsMerchandise)), __LINE__);
        }
        if (is_null($containsMerchandise) || (is_array($containsMerchandise) && empty($containsMerchandise))) {
            unset($this->ContainsMerchandise);
        } else {
            $this->ContainsMerchandise = $containsMerchandise;
        }
        return $this;
    }
    /**
     * Get ContainsPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContainsPayments()
    {
        return isset($this->ContainsPayments) ? $this->ContainsPayments : null;
    }
    /**
     * Set ContainsPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $containsPayments
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setContainsPayments($containsPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsPayments) && !is_bool($containsPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsPayments, true), gettype($containsPayments)), __LINE__);
        }
        if (is_null($containsPayments) || (is_array($containsPayments) && empty($containsPayments))) {
            unset($this->ContainsPayments);
        } else {
            $this->ContainsPayments = $containsPayments;
        }
        return $this;
    }
    /**
     * Get ContainsSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContainsSubscriptions()
    {
        return isset($this->ContainsSubscriptions) ? $this->ContainsSubscriptions : null;
    }
    /**
     * Set ContainsSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $containsSubscriptions
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setContainsSubscriptions($containsSubscriptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsSubscriptions) && !is_bool($containsSubscriptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsSubscriptions, true), gettype($containsSubscriptions)), __LINE__);
        }
        if (is_null($containsSubscriptions) || (is_array($containsSubscriptions) && empty($containsSubscriptions))) {
            unset($this->ContainsSubscriptions);
        } else {
            $this->ContainsSubscriptions = $containsSubscriptions;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponDefinitionIdList|null
     */
    public function getCouponDefinitionIdList()
    {
        return isset($this->CouponDefinitionIdList) ? $this->CouponDefinitionIdList : null;
    }
    /**
     * Set CouponDefinitionIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponDefinitionIdList $couponDefinitionIdList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCouponDefinitionIdList(\patest\StructType\CouponDefinitionIdList $couponDefinitionIdList = null)
    {
        if (is_null($couponDefinitionIdList) || (is_array($couponDefinitionIdList) && empty($couponDefinitionIdList))) {
            unset($this->CouponDefinitionIdList);
        } else {
            $this->CouponDefinitionIdList = $couponDefinitionIdList;
        }
        return $this;
    }
    /**
     * Get CouponORVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponORVoucherNumber()
    {
        return isset($this->CouponORVoucherNumber) ? $this->CouponORVoucherNumber : null;
    }
    /**
     * Set CouponORVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponORVoucherNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCouponORVoucherNumber($couponORVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($couponORVoucherNumber) && !is_string($couponORVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponORVoucherNumber, true), gettype($couponORVoucherNumber)), __LINE__);
        }
        if (is_null($couponORVoucherNumber) || (is_array($couponORVoucherNumber) && empty($couponORVoucherNumber))) {
            unset($this->CouponORVoucherNumber);
        } else {
            $this->CouponORVoucherNumber = $couponORVoucherNumber;
        }
        return $this;
    }
    /**
     * Get CreditCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCard()
    {
        return isset($this->CreditCard) ? $this->CreditCard : null;
    }
    /**
     * Set CreditCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCard
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCreditCard($creditCard = null)
    {
        // validation for constraint: string
        if (!is_null($creditCard) && !is_string($creditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCard, true), gettype($creditCard)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCard) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCard, true)), __LINE__);
        }
        if (is_null($creditCard) || (is_array($creditCard) && empty($creditCard))) {
            unset($this->CreditCard);
        } else {
            $this->CreditCard = $creditCard;
        }
        return $this;
    }
    /**
     * Get CreditCardExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardExpiryDate()
    {
        return isset($this->CreditCardExpiryDate) ? $this->CreditCardExpiryDate : null;
    }
    /**
     * Set CreditCardExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardExpiryDate
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCreditCardExpiryDate($creditCardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpiryDate) && !is_string($creditCardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardExpiryDate, true), gettype($creditCardExpiryDate)), __LINE__);
        }
        if (is_null($creditCardExpiryDate) || (is_array($creditCardExpiryDate) && empty($creditCardExpiryDate))) {
            unset($this->CreditCardExpiryDate);
        } else {
            $this->CreditCardExpiryDate = $creditCardExpiryDate;
        }
        return $this;
    }
    /**
     * Get CreditCardLastFourDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardLastFourDigits()
    {
        return isset($this->CreditCardLastFourDigits) ? $this->CreditCardLastFourDigits : null;
    }
    /**
     * Set CreditCardLastFourDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardLastFourDigits
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCreditCardLastFourDigits($creditCardLastFourDigits = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardLastFourDigits) && !is_string($creditCardLastFourDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardLastFourDigits, true), gettype($creditCardLastFourDigits)), __LINE__);
        }
        if (is_null($creditCardLastFourDigits) || (is_array($creditCardLastFourDigits) && empty($creditCardLastFourDigits))) {
            unset($this->CreditCardLastFourDigits);
        } else {
            $this->CreditCardLastFourDigits = $creditCardLastFourDigits;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardSuffix
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCreditCardSuffix($creditCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardSuffix) && !is_string($creditCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardSuffix, true), gettype($creditCardSuffix)), __LINE__);
        }
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get CRMID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCRMID()
    {
        return isset($this->CRMID) ? $this->CRMID : null;
    }
    /**
     * Set CRMID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cRMID
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setCRMID($cRMID = null)
    {
        // validation for constraint: string
        if (!is_null($cRMID) && !is_string($cRMID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRMID, true), gettype($cRMID)), __LINE__);
        }
        if (is_null($cRMID) || (is_array($cRMID) && empty($cRMID))) {
            unset($this->CRMID);
        } else {
            $this->CRMID = $cRMID;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationId()
    {
        return isset($this->DonationId) ? $this->DonationId : null;
    }
    /**
     * Set DonationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        if (is_null($donationId) || (is_array($donationId) && empty($donationId))) {
            unset($this->DonationId);
        } else {
            $this->DonationId = $donationId;
        }
        return $this;
    }
    /**
     * Get DonationKindForSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationKindForSearch()
    {
        return isset($this->DonationKindForSearch) ? $this->DonationKindForSearch : null;
    }
    /**
     * Set DonationKindForSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationKindForSearch
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setDonationKindForSearch($donationKindForSearch = null)
    {
        // validation for constraint: string
        if (!is_null($donationKindForSearch) && !is_string($donationKindForSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationKindForSearch, true), gettype($donationKindForSearch)), __LINE__);
        }
        if (is_null($donationKindForSearch) || (is_array($donationKindForSearch) && empty($donationKindForSearch))) {
            unset($this->DonationKindForSearch);
        } else {
            $this->DonationKindForSearch = $donationKindForSearch;
        }
        return $this;
    }
    /**
     * Get DonationsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DonationsList|null
     */
    public function getDonationsList()
    {
        return isset($this->DonationsList) ? $this->DonationsList : null;
    }
    /**
     * Set DonationsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DonationsList $donationsList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setDonationsList(\patest\StructType\DonationsList $donationsList = null)
    {
        if (is_null($donationsList) || (is_array($donationsList) && empty($donationsList))) {
            unset($this->DonationsList);
        } else {
            $this->DonationsList = $donationsList;
        }
        return $this;
    }
    /**
     * Get EmailPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailPhone()
    {
        return isset($this->EmailPhone) ? $this->EmailPhone : null;
    }
    /**
     * Set EmailPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailPhone
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEmailPhone($emailPhone = null)
    {
        // validation for constraint: string
        if (!is_null($emailPhone) && !is_string($emailPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailPhone, true), gettype($emailPhone)), __LINE__);
        }
        if (is_null($emailPhone) || (is_array($emailPhone) && empty($emailPhone))) {
            unset($this->EmailPhone);
        } else {
            $this->EmailPhone = $emailPhone;
        }
        return $this;
    }
    /**
     * Get EventAreaPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventAreaPriceLevelId()
    {
        return isset($this->EventAreaPriceLevelId) ? $this->EventAreaPriceLevelId : null;
    }
    /**
     * Set EventAreaPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventAreaPriceLevelId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventAreaPriceLevelId($eventAreaPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($eventAreaPriceLevelId) && !is_string($eventAreaPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventAreaPriceLevelId, true), gettype($eventAreaPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventAreaPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventAreaPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventAreaPriceLevelId, true)), __LINE__);
        }
        if (is_null($eventAreaPriceLevelId) || (is_array($eventAreaPriceLevelId) && empty($eventAreaPriceLevelId))) {
            unset($this->EventAreaPriceLevelId);
        } else {
            $this->EventAreaPriceLevelId = $eventAreaPriceLevelId;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DateEnum::valueIsValid()
     * @uses \patest\EnumType\DateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventDate
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DateEnum::valueIsValid($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DateEnum', is_array($eventDate) ? implode(', ', $eventDate) : var_export($eventDate, true), implode(', ', \patest\EnumType\DateEnum::getValidValues())), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateFrom()
    {
        return isset($this->EventDateFrom) ? $this->EventDateFrom : null;
    }
    /**
     * Set EventDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventDateFrom($eventDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateFrom) && !is_string($eventDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateFrom, true), gettype($eventDateFrom)), __LINE__);
        }
        if (is_null($eventDateFrom) || (is_array($eventDateFrom) && empty($eventDateFrom))) {
            unset($this->EventDateFrom);
        } else {
            $this->EventDateFrom = $eventDateFrom;
        }
        return $this;
    }
    /**
     * Get EventDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateTo()
    {
        return isset($this->EventDateTo) ? $this->EventDateTo : null;
    }
    /**
     * Set EventDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventDateTo($eventDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTo) && !is_string($eventDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTo, true), gettype($eventDateTo)), __LINE__);
        }
        if (is_null($eventDateTo) || (is_array($eventDateTo) && empty($eventDateTo))) {
            unset($this->EventDateTo);
        } else {
            $this->EventDateTo = $eventDateTo;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get ExpiresOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiresOn()
    {
        return isset($this->ExpiresOn) ? $this->ExpiresOn : null;
    }
    /**
     * Set ExpiresOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReservationExpireType::valueIsValid()
     * @uses \patest\EnumType\ReservationExpireType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expiresOn
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setExpiresOn($expiresOn = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservationExpireType::valueIsValid($expiresOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservationExpireType', is_array($expiresOn) ? implode(', ', $expiresOn) : var_export($expiresOn, true), implode(', ', \patest\EnumType\ReservationExpireType::getValidValues())), __LINE__);
        }
        if (is_null($expiresOn) || (is_array($expiresOn) && empty($expiresOn))) {
            unset($this->ExpiresOn);
        } else {
            $this->ExpiresOn = $expiresOn;
        }
        return $this;
    }
    /**
     * Get ExpiresWithinMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpiresWithinMinutes()
    {
        return isset($this->ExpiresWithinMinutes) ? $this->ExpiresWithinMinutes : null;
    }
    /**
     * Set ExpiresWithinMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expiresWithinMinutes
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setExpiresWithinMinutes($expiresWithinMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($expiresWithinMinutes) && !(is_int($expiresWithinMinutes) || ctype_digit($expiresWithinMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiresWithinMinutes, true), gettype($expiresWithinMinutes)), __LINE__);
        }
        if (is_null($expiresWithinMinutes) || (is_array($expiresWithinMinutes) && empty($expiresWithinMinutes))) {
            unset($this->ExpiresWithinMinutes);
        } else {
            $this->ExpiresWithinMinutes = $expiresWithinMinutes;
        }
        return $this;
    }
    /**
     * Get ExternalTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalTicketNumber()
    {
        return isset($this->ExternalTicketNumber) ? $this->ExternalTicketNumber : null;
    }
    /**
     * Set ExternalTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalTicketNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setExternalTicketNumber($externalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalTicketNumber) && !is_string($externalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTicketNumber, true), gettype($externalTicketNumber)), __LINE__);
        }
        if (is_null($externalTicketNumber) || (is_array($externalTicketNumber) && empty($externalTicketNumber))) {
            unset($this->ExternalTicketNumber);
        } else {
            $this->ExternalTicketNumber = $externalTicketNumber;
        }
        return $this;
    }
    /**
     * Get FilterByProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterByProduct()
    {
        return isset($this->FilterByProduct) ? $this->FilterByProduct : null;
    }
    /**
     * Set FilterByProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterByProduct
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setFilterByProduct($filterByProduct = null)
    {
        // validation for constraint: string
        if (!is_null($filterByProduct) && !is_string($filterByProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterByProduct, true), gettype($filterByProduct)), __LINE__);
        }
        if (is_null($filterByProduct) || (is_array($filterByProduct) && empty($filterByProduct))) {
            unset($this->FilterByProduct);
        } else {
            $this->FilterByProduct = $filterByProduct;
        }
        return $this;
    }
    /**
     * Get FilterOutGroupSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterOutGroupSale()
    {
        return isset($this->FilterOutGroupSale) ? $this->FilterOutGroupSale : null;
    }
    /**
     * Set FilterOutGroupSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterOutGroupSale
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setFilterOutGroupSale($filterOutGroupSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterOutGroupSale) && !is_bool($filterOutGroupSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterOutGroupSale, true), gettype($filterOutGroupSale)), __LINE__);
        }
        if (is_null($filterOutGroupSale) || (is_array($filterOutGroupSale) && empty($filterOutGroupSale))) {
            unset($this->FilterOutGroupSale);
        } else {
            $this->FilterOutGroupSale = $filterOutGroupSale;
        }
        return $this;
    }
    /**
     * Get FirstNameInclude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstNameInclude()
    {
        return isset($this->FirstNameInclude) ? $this->FirstNameInclude : null;
    }
    /**
     * Set FirstNameInclude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstNameInclude
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setFirstNameInclude($firstNameInclude = null)
    {
        // validation for constraint: string
        if (!is_null($firstNameInclude) && !is_string($firstNameInclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstNameInclude, true), gettype($firstNameInclude)), __LINE__);
        }
        if (is_null($firstNameInclude) || (is_array($firstNameInclude) && empty($firstNameInclude))) {
            unset($this->FirstNameInclude);
        } else {
            $this->FirstNameInclude = $firstNameInclude;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get FundsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FundsList|null
     */
    public function getFundsList()
    {
        return isset($this->FundsList) ? $this->FundsList : null;
    }
    /**
     * Set FundsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FundsList $fundsList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setFundsList(\patest\StructType\FundsList $fundsList = null)
    {
        if (is_null($fundsList) || (is_array($fundsList) && empty($fundsList))) {
            unset($this->FundsList);
        } else {
            $this->FundsList = $fundsList;
        }
        return $this;
    }
    /**
     * Get GiftCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftCardNumber()
    {
        return isset($this->GiftCardNumber) ? $this->GiftCardNumber : null;
    }
    /**
     * Set GiftCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftCardNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardNumber, true), gettype($giftCardNumber)), __LINE__);
        }
        if (is_null($giftCardNumber) || (is_array($giftCardNumber) && empty($giftCardNumber))) {
            unset($this->GiftCardNumber);
        } else {
            $this->GiftCardNumber = $giftCardNumber;
        }
        return $this;
    }
    /**
     * Get GiftCardNumberAsPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftCardNumberAsPayment()
    {
        return isset($this->GiftCardNumberAsPayment) ? $this->GiftCardNumberAsPayment : null;
    }
    /**
     * Set GiftCardNumberAsPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftCardNumberAsPayment
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftCardNumberAsPayment($giftCardNumberAsPayment = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumberAsPayment) && !is_string($giftCardNumberAsPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardNumberAsPayment, true), gettype($giftCardNumberAsPayment)), __LINE__);
        }
        if (is_null($giftCardNumberAsPayment) || (is_array($giftCardNumberAsPayment) && empty($giftCardNumberAsPayment))) {
            unset($this->GiftCardNumberAsPayment);
        } else {
            $this->GiftCardNumberAsPayment = $giftCardNumberAsPayment;
        }
        return $this;
    }
    /**
     * Get GiftCardProgramId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftCardProgramId()
    {
        return isset($this->GiftCardProgramId) ? $this->GiftCardProgramId : null;
    }
    /**
     * Set GiftCardProgramId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftCardProgramId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftCardProgramId($giftCardProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardProgramId) && !is_string($giftCardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardProgramId, true), gettype($giftCardProgramId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftCardProgramId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftCardProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftCardProgramId, true)), __LINE__);
        }
        if (is_null($giftCardProgramId) || (is_array($giftCardProgramId) && empty($giftCardProgramId))) {
            unset($this->GiftCardProgramId);
        } else {
            $this->GiftCardProgramId = $giftCardProgramId;
        }
        return $this;
    }
    /**
     * Get GiftCardTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftCardTypeId()
    {
        return isset($this->GiftCardTypeId) ? $this->GiftCardTypeId : null;
    }
    /**
     * Set GiftCardTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftCardTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftCardTypeId($giftCardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardTypeId) && !is_string($giftCardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardTypeId, true), gettype($giftCardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftCardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftCardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftCardTypeId, true)), __LINE__);
        }
        if (is_null($giftCardTypeId) || (is_array($giftCardTypeId) && empty($giftCardTypeId))) {
            unset($this->GiftCardTypeId);
        } else {
            $this->GiftCardTypeId = $giftCardTypeId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GiftVoucherDefinitionList|null
     */
    public function getGiftVoucherDefinitionList()
    {
        return isset($this->GiftVoucherDefinitionList) ? $this->GiftVoucherDefinitionList : null;
    }
    /**
     * Set GiftVoucherDefinitionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GiftVoucherDefinitionList $giftVoucherDefinitionList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftVoucherDefinitionList(\patest\StructType\GiftVoucherDefinitionList $giftVoucherDefinitionList = null)
    {
        if (is_null($giftVoucherDefinitionList) || (is_array($giftVoucherDefinitionList) && empty($giftVoucherDefinitionList))) {
            unset($this->GiftVoucherDefinitionList);
        } else {
            $this->GiftVoucherDefinitionList = $giftVoucherDefinitionList;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get GroupOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupOrderId()
    {
        return isset($this->GroupOrderId) ? $this->GroupOrderId : null;
    }
    /**
     * Set GroupOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupOrderId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setGroupOrderId($groupOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrderId) && !(is_int($groupOrderId) || ctype_digit($groupOrderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrderId, true), gettype($groupOrderId)), __LINE__);
        }
        if (is_null($groupOrderId) || (is_array($groupOrderId) && empty($groupOrderId))) {
            unset($this->GroupOrderId);
        } else {
            $this->GroupOrderId = $groupOrderId;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IDCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDCardNumber()
    {
        return isset($this->IDCardNumber) ? $this->IDCardNumber : null;
    }
    /**
     * Set IDCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDCardNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setIDCardNumber($iDCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iDCardNumber) && !is_string($iDCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCardNumber, true), gettype($iDCardNumber)), __LINE__);
        }
        if (is_null($iDCardNumber) || (is_array($iDCardNumber) && empty($iDCardNumber))) {
            unset($this->IDCardNumber);
        } else {
            $this->IDCardNumber = $iDCardNumber;
        }
        return $this;
    }
    /**
     * Get IncludeInternalTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeInternalTransactions()
    {
        return isset($this->IncludeInternalTransactions) ? $this->IncludeInternalTransactions : null;
    }
    /**
     * Set IncludeInternalTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeInternalTransactions
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setIncludeInternalTransactions($includeInternalTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInternalTransactions) && !is_bool($includeInternalTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInternalTransactions, true), gettype($includeInternalTransactions)), __LINE__);
        }
        if (is_null($includeInternalTransactions) || (is_array($includeInternalTransactions) && empty($includeInternalTransactions))) {
            unset($this->IncludeInternalTransactions);
        } else {
            $this->IncludeInternalTransactions = $includeInternalTransactions;
        }
        return $this;
    }
    /**
     * Get IncludePledgeInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePledgeInstallments()
    {
        return isset($this->IncludePledgeInstallments) ? $this->IncludePledgeInstallments : null;
    }
    /**
     * Set IncludePledgeInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePledgeInstallments
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setIncludePledgeInstallments($includePledgeInstallments = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePledgeInstallments) && !is_bool($includePledgeInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePledgeInstallments, true), gettype($includePledgeInstallments)), __LINE__);
        }
        if (is_null($includePledgeInstallments) || (is_array($includePledgeInstallments) && empty($includePledgeInstallments))) {
            unset($this->IncludePledgeInstallments);
        } else {
            $this->IncludePledgeInstallments = $includePledgeInstallments;
        }
        return $this;
    }
    /**
     * Get IncludeSubscriptionTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeSubscriptionTickets()
    {
        return isset($this->IncludeSubscriptionTickets) ? $this->IncludeSubscriptionTickets : null;
    }
    /**
     * Set IncludeSubscriptionTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeSubscriptionTickets
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setIncludeSubscriptionTickets($includeSubscriptionTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSubscriptionTickets) && !is_bool($includeSubscriptionTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSubscriptionTickets, true), gettype($includeSubscriptionTickets)), __LINE__);
        }
        if (is_null($includeSubscriptionTickets) || (is_array($includeSubscriptionTickets) && empty($includeSubscriptionTickets))) {
            unset($this->IncludeSubscriptionTickets);
        } else {
            $this->IncludeSubscriptionTickets = $includeSubscriptionTickets;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mandateNumber) && !is_string($mandateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get MembershipAllianceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipAllianceId()
    {
        return isset($this->MembershipAllianceId) ? $this->MembershipAllianceId : null;
    }
    /**
     * Set MembershipAllianceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipAllianceId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMembershipAllianceId($membershipAllianceId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipAllianceId) && !is_string($membershipAllianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipAllianceId, true), gettype($membershipAllianceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipAllianceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipAllianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipAllianceId, true)), __LINE__);
        }
        if (is_null($membershipAllianceId) || (is_array($membershipAllianceId) && empty($membershipAllianceId))) {
            unset($this->MembershipAllianceId);
        } else {
            $this->MembershipAllianceId = $membershipAllianceId;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get MembershipPrintStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipPrintStatus()
    {
        return isset($this->MembershipPrintStatus) ? $this->MembershipPrintStatus : null;
    }
    /**
     * Set MembershipPrintStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $membershipPrintStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMembershipPrintStatus($membershipPrintStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($membershipPrintStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($membershipPrintStatus) ? implode(', ', $membershipPrintStatus) : var_export($membershipPrintStatus, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($membershipPrintStatus) || (is_array($membershipPrintStatus) && empty($membershipPrintStatus))) {
            unset($this->MembershipPrintStatus);
        } else {
            $this->MembershipPrintStatus = $membershipPrintStatus;
        }
        return $this;
    }
    /**
     * Get MerchandiseBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseBarcode()
    {
        return isset($this->MerchandiseBarcode) ? $this->MerchandiseBarcode : null;
    }
    /**
     * Set MerchandiseBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseBarcode
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMerchandiseBarcode($merchandiseBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseBarcode) && !is_string($merchandiseBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseBarcode, true), gettype($merchandiseBarcode)), __LINE__);
        }
        if (is_null($merchandiseBarcode) || (is_array($merchandiseBarcode) && empty($merchandiseBarcode))) {
            unset($this->MerchandiseBarcode);
        } else {
            $this->MerchandiseBarcode = $merchandiseBarcode;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get OBOAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOBOAccountId()
    {
        return isset($this->OBOAccountId) ? $this->OBOAccountId : null;
    }
    /**
     * Set OBOAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oBOAccountId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOBOAccountId($oBOAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($oBOAccountId) && !is_string($oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oBOAccountId, true), gettype($oBOAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oBOAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oBOAccountId, true)), __LINE__);
        }
        if (is_null($oBOAccountId) || (is_array($oBOAccountId) && empty($oBOAccountId))) {
            unset($this->OBOAccountId);
        } else {
            $this->OBOAccountId = $oBOAccountId;
        }
        return $this;
    }
    /**
     * Get OnlyGiftVouchers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnlyGiftVouchers()
    {
        return isset($this->OnlyGiftVouchers) ? $this->OnlyGiftVouchers : null;
    }
    /**
     * Set OnlyGiftVouchers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onlyGiftVouchers
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOnlyGiftVouchers($onlyGiftVouchers = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyGiftVouchers) && !is_bool($onlyGiftVouchers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyGiftVouchers, true), gettype($onlyGiftVouchers)), __LINE__);
        }
        if (is_null($onlyGiftVouchers) || (is_array($onlyGiftVouchers) && empty($onlyGiftVouchers))) {
            unset($this->OnlyGiftVouchers);
        } else {
            $this->OnlyGiftVouchers = $onlyGiftVouchers;
        }
        return $this;
    }
    /**
     * Get OnlyMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnlyMemberships()
    {
        return isset($this->OnlyMemberships) ? $this->OnlyMemberships : null;
    }
    /**
     * Set OnlyMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onlyMemberships
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOnlyMemberships($onlyMemberships = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyMemberships) && !is_bool($onlyMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyMemberships, true), gettype($onlyMemberships)), __LINE__);
        }
        if (is_null($onlyMemberships) || (is_array($onlyMemberships) && empty($onlyMemberships))) {
            unset($this->OnlyMemberships);
        } else {
            $this->OnlyMemberships = $onlyMemberships;
        }
        return $this;
    }
    /**
     * Get OnlyTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnlyTickets()
    {
        return isset($this->OnlyTickets) ? $this->OnlyTickets : null;
    }
    /**
     * Set OnlyTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onlyTickets
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOnlyTickets($onlyTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyTickets) && !is_bool($onlyTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyTickets, true), gettype($onlyTickets)), __LINE__);
        }
        if (is_null($onlyTickets) || (is_array($onlyTickets) && empty($onlyTickets))) {
            unset($this->OnlyTickets);
        } else {
            $this->OnlyTickets = $onlyTickets;
        }
        return $this;
    }
    /**
     * Get OptionsToAdd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionsToAdd()
    {
        return isset($this->OptionsToAdd) ? $this->OptionsToAdd : null;
    }
    /**
     * Set OptionsToAdd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionsToAdd
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOptionsToAdd($optionsToAdd = null)
    {
        // validation for constraint: string
        if (!is_null($optionsToAdd) && !is_string($optionsToAdd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionsToAdd, true), gettype($optionsToAdd)), __LINE__);
        }
        if (is_null($optionsToAdd) || (is_array($optionsToAdd) && empty($optionsToAdd))) {
            unset($this->OptionsToAdd);
        } else {
            $this->OptionsToAdd = $optionsToAdd;
        }
        return $this;
    }
    /**
     * Get OtherNamesInlcude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherNamesInlcude()
    {
        return isset($this->OtherNamesInlcude) ? $this->OtherNamesInlcude : null;
    }
    /**
     * Set OtherNamesInlcude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherNamesInlcude
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setOtherNamesInlcude($otherNamesInlcude = null)
    {
        // validation for constraint: string
        if (!is_null($otherNamesInlcude) && !is_string($otherNamesInlcude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherNamesInlcude, true), gettype($otherNamesInlcude)), __LINE__);
        }
        if (is_null($otherNamesInlcude) || (is_array($otherNamesInlcude) && empty($otherNamesInlcude))) {
            unset($this->OtherNamesInlcude);
        } else {
            $this->OtherNamesInlcude = $otherNamesInlcude;
        }
        return $this;
    }
    /**
     * Get PackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageId()
    {
        return isset($this->PackageId) ? $this->PackageId : null;
    }
    /**
     * Set PackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageId, true)), __LINE__);
        }
        if (is_null($packageId) || (is_array($packageId) && empty($packageId))) {
            unset($this->PackageId);
        } else {
            $this->PackageId = $packageId;
        }
        return $this;
    }
    /**
     * Get PaymentGiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentGiftVoucherDefinitionId()
    {
        return isset($this->PaymentGiftVoucherDefinitionId) ? $this->PaymentGiftVoucherDefinitionId : null;
    }
    /**
     * Set PaymentGiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentGiftVoucherDefinitionId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentGiftVoucherDefinitionId($paymentGiftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGiftVoucherDefinitionId) && !is_string($paymentGiftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentGiftVoucherDefinitionId, true), gettype($paymentGiftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentGiftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentGiftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentGiftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($paymentGiftVoucherDefinitionId) || (is_array($paymentGiftVoucherDefinitionId) && empty($paymentGiftVoucherDefinitionId))) {
            unset($this->PaymentGiftVoucherDefinitionId);
        } else {
            $this->PaymentGiftVoucherDefinitionId = $paymentGiftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get PaymentGiftVoucherDefinitionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentGiftVoucherDefinitionList|null
     */
    public function getPaymentGiftVoucherDefinitionList()
    {
        return isset($this->PaymentGiftVoucherDefinitionList) ? $this->PaymentGiftVoucherDefinitionList : null;
    }
    /**
     * Set PaymentGiftVoucherDefinitionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentGiftVoucherDefinitionList $paymentGiftVoucherDefinitionList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentGiftVoucherDefinitionList(\patest\StructType\PaymentGiftVoucherDefinitionList $paymentGiftVoucherDefinitionList = null)
    {
        if (is_null($paymentGiftVoucherDefinitionList) || (is_array($paymentGiftVoucherDefinitionList) && empty($paymentGiftVoucherDefinitionList))) {
            unset($this->PaymentGiftVoucherDefinitionList);
        } else {
            $this->PaymentGiftVoucherDefinitionList = $paymentGiftVoucherDefinitionList;
        }
        return $this;
    }
    /**
     * Get PaymentGiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentGiftVoucherTypeId()
    {
        return isset($this->PaymentGiftVoucherTypeId) ? $this->PaymentGiftVoucherTypeId : null;
    }
    /**
     * Set PaymentGiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentGiftVoucherTypeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentGiftVoucherTypeId($paymentGiftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGiftVoucherTypeId) && !is_string($paymentGiftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentGiftVoucherTypeId, true), gettype($paymentGiftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentGiftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentGiftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentGiftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($paymentGiftVoucherTypeId) || (is_array($paymentGiftVoucherTypeId) && empty($paymentGiftVoucherTypeId))) {
            unset($this->PaymentGiftVoucherTypeId);
        } else {
            $this->PaymentGiftVoucherTypeId = $paymentGiftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethod) ? implode(', ', $paymentMethod) : var_export($paymentMethod, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodsList|null
     */
    public function getPaymentMethodsList()
    {
        return isset($this->PaymentMethodsList) ? $this->PaymentMethodsList : null;
    }
    /**
     * Set PaymentMethodsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentMethodsList $paymentMethodsList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentMethodsList(\patest\StructType\PaymentMethodsList $paymentMethodsList = null)
    {
        if (is_null($paymentMethodsList) || (is_array($paymentMethodsList) && empty($paymentMethodsList))) {
            unset($this->PaymentMethodsList);
        } else {
            $this->PaymentMethodsList = $paymentMethodsList;
        }
        return $this;
    }
    /**
     * Get PaymentPlanNextDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanNextDueDate()
    {
        return isset($this->PaymentPlanNextDueDate) ? $this->PaymentPlanNextDueDate : null;
    }
    /**
     * Set PaymentPlanNextDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DateEnum::valueIsValid()
     * @uses \patest\EnumType\DateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentPlanNextDueDate
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentPlanNextDueDate($paymentPlanNextDueDate = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DateEnum::valueIsValid($paymentPlanNextDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DateEnum', is_array($paymentPlanNextDueDate) ? implode(', ', $paymentPlanNextDueDate) : var_export($paymentPlanNextDueDate, true), implode(', ', \patest\EnumType\DateEnum::getValidValues())), __LINE__);
        }
        if (is_null($paymentPlanNextDueDate) || (is_array($paymentPlanNextDueDate) && empty($paymentPlanNextDueDate))) {
            unset($this->PaymentPlanNextDueDate);
        } else {
            $this->PaymentPlanNextDueDate = $paymentPlanNextDueDate;
        }
        return $this;
    }
    /**
     * Get PaymentPlanNextDueDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanNextDueDateFrom()
    {
        return isset($this->PaymentPlanNextDueDateFrom) ? $this->PaymentPlanNextDueDateFrom : null;
    }
    /**
     * Set PaymentPlanNextDueDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanNextDueDateFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentPlanNextDueDateFrom($paymentPlanNextDueDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanNextDueDateFrom) && !is_string($paymentPlanNextDueDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanNextDueDateFrom, true), gettype($paymentPlanNextDueDateFrom)), __LINE__);
        }
        if (is_null($paymentPlanNextDueDateFrom) || (is_array($paymentPlanNextDueDateFrom) && empty($paymentPlanNextDueDateFrom))) {
            unset($this->PaymentPlanNextDueDateFrom);
        } else {
            $this->PaymentPlanNextDueDateFrom = $paymentPlanNextDueDateFrom;
        }
        return $this;
    }
    /**
     * Get PaymentPlanNextDueDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanNextDueDateTo()
    {
        return isset($this->PaymentPlanNextDueDateTo) ? $this->PaymentPlanNextDueDateTo : null;
    }
    /**
     * Set PaymentPlanNextDueDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanNextDueDateTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentPlanNextDueDateTo($paymentPlanNextDueDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanNextDueDateTo) && !is_string($paymentPlanNextDueDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanNextDueDateTo, true), gettype($paymentPlanNextDueDateTo)), __LINE__);
        }
        if (is_null($paymentPlanNextDueDateTo) || (is_array($paymentPlanNextDueDateTo) && empty($paymentPlanNextDueDateTo))) {
            unset($this->PaymentPlanNextDueDateTo);
        } else {
            $this->PaymentPlanNextDueDateTo = $paymentPlanNextDueDateTo;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PaymentStatusList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatusList()
    {
        return isset($this->PaymentStatusList) ? $this->PaymentStatusList : null;
    }
    /**
     * Set PaymentStatusList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentStatusList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPaymentStatusList($paymentStatusList = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusList) && !is_string($paymentStatusList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusList, true), gettype($paymentStatusList)), __LINE__);
        }
        if (is_null($paymentStatusList) || (is_array($paymentStatusList) && empty($paymentStatusList))) {
            unset($this->PaymentStatusList);
        } else {
            $this->PaymentStatusList = $paymentStatusList;
        }
        return $this;
    }
    /**
     * Get PrepaidOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrepaidOnly()
    {
        return isset($this->PrepaidOnly) ? $this->PrepaidOnly : null;
    }
    /**
     * Set PrepaidOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $prepaidOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPrepaidOnly($prepaidOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaidOnly) && !is_bool($prepaidOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaidOnly, true), gettype($prepaidOnly)), __LINE__);
        }
        if (is_null($prepaidOnly) || (is_array($prepaidOnly) && empty($prepaidOnly))) {
            unset($this->PrepaidOnly);
        } else {
            $this->PrepaidOnly = $prepaidOnly;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get ProductItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductItemType()
    {
        return isset($this->ProductItemType) ? $this->ProductItemType : null;
    }
    /**
     * Set ProductItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productItemType
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setProductItemType($productItemType = null)
    {
        // validation for constraint: string
        if (!is_null($productItemType) && !is_string($productItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productItemType, true), gettype($productItemType)), __LINE__);
        }
        if (is_null($productItemType) || (is_array($productItemType) && empty($productItemType))) {
            unset($this->ProductItemType);
        } else {
            $this->ProductItemType = $productItemType;
        }
        return $this;
    }
    /**
     * Get Receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReceipt()
    {
        return isset($this->Receipt) ? $this->Receipt : null;
    }
    /**
     * Set Receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $receipt
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReceipt($receipt = null)
    {
        // validation for constraint: int
        if (!is_null($receipt) && !(is_int($receipt) || ctype_digit($receipt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receipt, true), gettype($receipt)), __LINE__);
        }
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->Receipt);
        } else {
            $this->Receipt = $receipt;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get RefundCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundCategoryId()
    {
        return isset($this->RefundCategoryId) ? $this->RefundCategoryId : null;
    }
    /**
     * Set RefundCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundCategoryId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setRefundCategoryId($refundCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($refundCategoryId) && !is_string($refundCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundCategoryId, true), gettype($refundCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($refundCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $refundCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($refundCategoryId, true)), __LINE__);
        }
        if (is_null($refundCategoryId) || (is_array($refundCategoryId) && empty($refundCategoryId))) {
            unset($this->RefundCategoryId);
        } else {
            $this->RefundCategoryId = $refundCategoryId;
        }
        return $this;
    }
    /**
     * Get RefundCategoryIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RefundCategoryIdList|null
     */
    public function getRefundCategoryIdList()
    {
        return isset($this->RefundCategoryIdList) ? $this->RefundCategoryIdList : null;
    }
    /**
     * Set RefundCategoryIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RefundCategoryIdList $refundCategoryIdList
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setRefundCategoryIdList(\patest\StructType\RefundCategoryIdList $refundCategoryIdList = null)
    {
        if (is_null($refundCategoryIdList) || (is_array($refundCategoryIdList) && empty($refundCategoryIdList))) {
            unset($this->RefundCategoryIdList);
        } else {
            $this->RefundCategoryIdList = $refundCategoryIdList;
        }
        return $this;
    }
    /**
     * Get RenewedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRenewedOnly()
    {
        return isset($this->RenewedOnly) ? $this->RenewedOnly : null;
    }
    /**
     * Set RenewedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $renewedOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setRenewedOnly($renewedOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($renewedOnly) && !is_bool($renewedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($renewedOnly, true), gettype($renewedOnly)), __LINE__);
        }
        if (is_null($renewedOnly) || (is_array($renewedOnly) && empty($renewedOnly))) {
            unset($this->RenewedOnly);
        } else {
            $this->RenewedOnly = $renewedOnly;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDateFrom()
    {
        return isset($this->ReservationExpiryDateFrom) ? $this->ReservationExpiryDateFrom : null;
    }
    /**
     * Set ReservationExpiryDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDateFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservationExpiryDateFrom($reservationExpiryDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDateFrom) && !is_string($reservationExpiryDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDateFrom, true), gettype($reservationExpiryDateFrom)), __LINE__);
        }
        if (is_null($reservationExpiryDateFrom) || (is_array($reservationExpiryDateFrom) && empty($reservationExpiryDateFrom))) {
            unset($this->ReservationExpiryDateFrom);
        } else {
            $this->ReservationExpiryDateFrom = $reservationExpiryDateFrom;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDateTo()
    {
        return isset($this->ReservationExpiryDateTo) ? $this->ReservationExpiryDateTo : null;
    }
    /**
     * Set ReservationExpiryDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDateTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservationExpiryDateTo($reservationExpiryDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDateTo) && !is_string($reservationExpiryDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDateTo, true), gettype($reservationExpiryDateTo)), __LINE__);
        }
        if (is_null($reservationExpiryDateTo) || (is_array($reservationExpiryDateTo) && empty($reservationExpiryDateTo))) {
            unset($this->ReservationExpiryDateTo);
        } else {
            $this->ReservationExpiryDateTo = $reservationExpiryDateTo;
        }
        return $this;
    }
    /**
     * Get ReservedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReservedItems()
    {
        return isset($this->ReservedItems) ? $this->ReservedItems : null;
    }
    /**
     * Set ReservedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reservedItems
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservedItems($reservedItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservedItems) && !is_bool($reservedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservedItems, true), gettype($reservedItems)), __LINE__);
        }
        if (is_null($reservedItems) || (is_array($reservedItems) && empty($reservedItems))) {
            unset($this->ReservedItems);
        } else {
            $this->ReservedItems = $reservedItems;
        }
        return $this;
    }
    /**
     * Get ReservedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReservedOnly()
    {
        return isset($this->ReservedOnly) ? $this->ReservedOnly : null;
    }
    /**
     * Set ReservedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reservedOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservedOnly($reservedOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservedOnly) && !is_bool($reservedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservedOnly, true), gettype($reservedOnly)), __LINE__);
        }
        if (is_null($reservedOnly) || (is_array($reservedOnly) && empty($reservedOnly))) {
            unset($this->ReservedOnly);
        } else {
            $this->ReservedOnly = $reservedOnly;
        }
        return $this;
    }
    /**
     * Get ReservedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservedStatus()
    {
        return isset($this->ReservedStatus) ? $this->ReservedStatus : null;
    }
    /**
     * Set ReservedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReservedStatus::valueIsValid()
     * @uses \patest\EnumType\ReservedStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservedStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservedStatus($reservedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservedStatus::valueIsValid($reservedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservedStatus', is_array($reservedStatus) ? implode(', ', $reservedStatus) : var_export($reservedStatus, true), implode(', ', \patest\EnumType\ReservedStatus::getValidValues())), __LINE__);
        }
        if (is_null($reservedStatus) || (is_array($reservedStatus) && empty($reservedStatus))) {
            unset($this->ReservedStatus);
        } else {
            $this->ReservedStatus = $reservedStatus;
        }
        return $this;
    }
    /**
     * Get ReservedStatusExtended value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservedStatusExtended()
    {
        return isset($this->ReservedStatusExtended) ? $this->ReservedStatusExtended : null;
    }
    /**
     * Set ReservedStatusExtended value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReservedStatusExtended::valueIsValid()
     * @uses \patest\EnumType\ReservedStatusExtended::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservedStatusExtended
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setReservedStatusExtended($reservedStatusExtended = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservedStatusExtended::valueIsValid($reservedStatusExtended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservedStatusExtended', is_array($reservedStatusExtended) ? implode(', ', $reservedStatusExtended) : var_export($reservedStatusExtended, true), implode(', ', \patest\EnumType\ReservedStatusExtended::getValidValues())), __LINE__);
        }
        if (is_null($reservedStatusExtended) || (is_array($reservedStatusExtended) && empty($reservedStatusExtended))) {
            unset($this->ReservedStatusExtended);
        } else {
            $this->ReservedStatusExtended = $reservedStatusExtended;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SchemaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemaId()
    {
        return isset($this->SchemaId) ? $this->SchemaId : null;
    }
    /**
     * Set SchemaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemaId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSchemaId($schemaId = null)
    {
        // validation for constraint: string
        if (!is_null($schemaId) && !is_string($schemaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaId, true), gettype($schemaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemaId, true)), __LINE__);
        }
        if (is_null($schemaId) || (is_array($schemaId) && empty($schemaId))) {
            unset($this->SchemaId);
        } else {
            $this->SchemaId = $schemaId;
        }
        return $this;
    }
    /**
     * Get SchemaLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemaLevelId()
    {
        return isset($this->SchemaLevelId) ? $this->SchemaLevelId : null;
    }
    /**
     * Set SchemaLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemaLevelId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSchemaLevelId($schemaLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($schemaLevelId) && !is_string($schemaLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaLevelId, true), gettype($schemaLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemaLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemaLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemaLevelId, true)), __LINE__);
        }
        if (is_null($schemaLevelId) || (is_array($schemaLevelId) && empty($schemaLevelId))) {
            unset($this->SchemaLevelId);
        } else {
            $this->SchemaLevelId = $schemaLevelId;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get SoldByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldByUser()
    {
        return isset($this->SoldByUser) ? $this->SoldByUser : null;
    }
    /**
     * Set SoldByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldByUser
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSoldByUser($soldByUser = null)
    {
        // validation for constraint: string
        if (!is_null($soldByUser) && !is_string($soldByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldByUser, true), gettype($soldByUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($soldByUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $soldByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($soldByUser, true)), __LINE__);
        }
        if (is_null($soldByUser) || (is_array($soldByUser) && empty($soldByUser))) {
            unset($this->SoldByUser);
        } else {
            $this->SoldByUser = $soldByUser;
        }
        return $this;
    }
    /**
     * Get SolicitorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSolicitorId()
    {
        return isset($this->SolicitorId) ? $this->SolicitorId : null;
    }
    /**
     * Set SolicitorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $solicitorId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSolicitorId($solicitorId = null)
    {
        // validation for constraint: string
        if (!is_null($solicitorId) && !is_string($solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solicitorId, true), gettype($solicitorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($solicitorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($solicitorId, true)), __LINE__);
        }
        if (is_null($solicitorId) || (is_array($solicitorId) && empty($solicitorId))) {
            unset($this->SolicitorId);
        } else {
            $this->SolicitorId = $solicitorId;
        }
        return $this;
    }
    /**
     * Get SubscriptionHallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionHallId()
    {
        return isset($this->SubscriptionHallId) ? $this->SubscriptionHallId : null;
    }
    /**
     * Set SubscriptionHallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionHallId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionHallId($subscriptionHallId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionHallId) && !is_string($subscriptionHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionHallId, true), gettype($subscriptionHallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionHallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionHallId, true)), __LINE__);
        }
        if (is_null($subscriptionHallId) || (is_array($subscriptionHallId) && empty($subscriptionHallId))) {
            unset($this->SubscriptionHallId);
        } else {
            $this->SubscriptionHallId = $subscriptionHallId;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubscriptionPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionPriceLevelId()
    {
        return isset($this->SubscriptionPriceLevelId) ? $this->SubscriptionPriceLevelId : null;
    }
    /**
     * Set SubscriptionPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionPriceLevelId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionPriceLevelId($subscriptionPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionPriceLevelId) && !is_string($subscriptionPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionPriceLevelId, true), gettype($subscriptionPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionPriceLevelId, true)), __LINE__);
        }
        if (is_null($subscriptionPriceLevelId) || (is_array($subscriptionPriceLevelId) && empty($subscriptionPriceLevelId))) {
            unset($this->SubscriptionPriceLevelId);
        } else {
            $this->SubscriptionPriceLevelId = $subscriptionPriceLevelId;
        }
        return $this;
    }
    /**
     * Get SubscriptionPrintStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionPrintStatus()
    {
        return isset($this->SubscriptionPrintStatus) ? $this->SubscriptionPrintStatus : null;
    }
    /**
     * Set SubscriptionPrintStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPrintStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionPrintStatus($subscriptionPrintStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($subscriptionPrintStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($subscriptionPrintStatus) ? implode(', ', $subscriptionPrintStatus) : var_export($subscriptionPrintStatus, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionPrintStatus) || (is_array($subscriptionPrintStatus) && empty($subscriptionPrintStatus))) {
            unset($this->SubscriptionPrintStatus);
        } else {
            $this->SubscriptionPrintStatus = $subscriptionPrintStatus;
        }
        return $this;
    }
    /**
     * Get SubscriptionRenewedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSubscriptionRenewedOnly()
    {
        return isset($this->SubscriptionRenewedOnly) ? $this->SubscriptionRenewedOnly : null;
    }
    /**
     * Set SubscriptionRenewedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $subscriptionRenewedOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionRenewedOnly($subscriptionRenewedOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscriptionRenewedOnly) && !is_bool($subscriptionRenewedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subscriptionRenewedOnly, true), gettype($subscriptionRenewedOnly)), __LINE__);
        }
        if (is_null($subscriptionRenewedOnly) || (is_array($subscriptionRenewedOnly) && empty($subscriptionRenewedOnly))) {
            unset($this->SubscriptionRenewedOnly);
        } else {
            $this->SubscriptionRenewedOnly = $subscriptionRenewedOnly;
        }
        return $this;
    }
    /**
     * Get SubscriptionRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionRowName()
    {
        return isset($this->SubscriptionRowName) ? $this->SubscriptionRowName : null;
    }
    /**
     * Set SubscriptionRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionRowName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionRowName($subscriptionRowName = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionRowName) && !is_string($subscriptionRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionRowName, true), gettype($subscriptionRowName)), __LINE__);
        }
        if (is_null($subscriptionRowName) || (is_array($subscriptionRowName) && empty($subscriptionRowName))) {
            unset($this->SubscriptionRowName);
        } else {
            $this->SubscriptionRowName = $subscriptionRowName;
        }
        return $this;
    }
    /**
     * Get SubscriptionSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionSeatName()
    {
        return isset($this->SubscriptionSeatName) ? $this->SubscriptionSeatName : null;
    }
    /**
     * Set SubscriptionSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionSeatName
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setSubscriptionSeatName($subscriptionSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionSeatName) && !is_string($subscriptionSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionSeatName, true), gettype($subscriptionSeatName)), __LINE__);
        }
        if (is_null($subscriptionSeatName) || (is_array($subscriptionSeatName) && empty($subscriptionSeatName))) {
            unset($this->SubscriptionSeatName);
        } else {
            $this->SubscriptionSeatName = $subscriptionSeatName;
        }
        return $this;
    }
    /**
     * Get TextSearchOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextSearchOption()
    {
        return isset($this->TextSearchOption) ? $this->TextSearchOption : null;
    }
    /**
     * Set TextSearchOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TextCriteriaOperationKind::valueIsValid()
     * @uses \patest\EnumType\TextCriteriaOperationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $textSearchOption
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTextSearchOption($textSearchOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TextCriteriaOperationKind::valueIsValid($textSearchOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TextCriteriaOperationKind', is_array($textSearchOption) ? implode(', ', $textSearchOption) : var_export($textSearchOption, true), implode(', ', \patest\EnumType\TextCriteriaOperationKind::getValidValues())), __LINE__);
        }
        if (is_null($textSearchOption) || (is_array($textSearchOption) && empty($textSearchOption))) {
            unset($this->TextSearchOption);
        } else {
            $this->TextSearchOption = $textSearchOption;
        }
        return $this;
    }
    /**
     * Get TicketAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketAreaId()
    {
        return isset($this->TicketAreaId) ? $this->TicketAreaId : null;
    }
    /**
     * Set TicketAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketAreaId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketAreaId($ticketAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketAreaId) && !is_string($ticketAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketAreaId, true), gettype($ticketAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketAreaId, true)), __LINE__);
        }
        if (is_null($ticketAreaId) || (is_array($ticketAreaId) && empty($ticketAreaId))) {
            unset($this->TicketAreaId);
        } else {
            $this->TicketAreaId = $ticketAreaId;
        }
        return $this;
    }
    /**
     * Get TicketAreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketAreaIds|null
     */
    public function getTicketAreaIds()
    {
        return isset($this->TicketAreaIds) ? $this->TicketAreaIds : null;
    }
    /**
     * Set TicketAreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketAreaIds $ticketAreaIds
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketAreaIds(\patest\StructType\TicketAreaIds $ticketAreaIds = null)
    {
        if (is_null($ticketAreaIds) || (is_array($ticketAreaIds) && empty($ticketAreaIds))) {
            unset($this->TicketAreaIds);
        } else {
            $this->TicketAreaIds = $ticketAreaIds;
        }
        return $this;
    }
    /**
     * Get TicketBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBarcode()
    {
        return isset($this->TicketBarcode) ? $this->TicketBarcode : null;
    }
    /**
     * Set TicketBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBarcode
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketBarcode($ticketBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBarcode) && !is_string($ticketBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBarcode, true), gettype($ticketBarcode)), __LINE__);
        }
        if (is_null($ticketBarcode) || (is_array($ticketBarcode) && empty($ticketBarcode))) {
            unset($this->TicketBarcode);
        } else {
            $this->TicketBarcode = $ticketBarcode;
        }
        return $this;
    }
    /**
     * Get TicketEventAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketEventAreaId()
    {
        return isset($this->TicketEventAreaId) ? $this->TicketEventAreaId : null;
    }
    /**
     * Set TicketEventAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketEventAreaId
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketEventAreaId($ticketEventAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketEventAreaId) && !is_string($ticketEventAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketEventAreaId, true), gettype($ticketEventAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketEventAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketEventAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketEventAreaId, true)), __LINE__);
        }
        if (is_null($ticketEventAreaId) || (is_array($ticketEventAreaId) && empty($ticketEventAreaId))) {
            unset($this->TicketEventAreaId);
        } else {
            $this->TicketEventAreaId = $ticketEventAreaId;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TicketsPrintStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsPrintStatus()
    {
        return isset($this->TicketsPrintStatus) ? $this->TicketsPrintStatus : null;
    }
    /**
     * Set TicketsPrintStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketsPrintStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketsPrintStatus($ticketsPrintStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($ticketsPrintStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($ticketsPrintStatus) ? implode(', ', $ticketsPrintStatus) : var_export($ticketsPrintStatus, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketsPrintStatus) || (is_array($ticketsPrintStatus) && empty($ticketsPrintStatus))) {
            unset($this->TicketsPrintStatus);
        } else {
            $this->TicketsPrintStatus = $ticketsPrintStatus;
        }
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientTicketType::valueIsValid()
     * @uses \patest\EnumType\ClientTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientTicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientTicketType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \patest\EnumType\ClientTicketType::getValidValues())), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
    /**
     * Get Top value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTop()
    {
        return isset($this->Top) ? $this->Top : null;
    }
    /**
     * Set Top value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $top
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTop($top = null)
    {
        // validation for constraint: int
        if (!is_null($top) && !(is_int($top) || ctype_digit($top))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($top, true), gettype($top)), __LINE__);
        }
        if (is_null($top) || (is_array($top) && empty($top))) {
            unset($this->Top);
        } else {
            $this->Top = $top;
        }
        return $this;
    }
    /**
     * Get TransactionAmountFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTransactionAmountFrom()
    {
        return isset($this->TransactionAmountFrom) ? $this->TransactionAmountFrom : null;
    }
    /**
     * Set TransactionAmountFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $transactionAmountFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionAmountFrom($transactionAmountFrom = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmountFrom) && !(is_float($transactionAmountFrom) || is_numeric($transactionAmountFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmountFrom, true), gettype($transactionAmountFrom)), __LINE__);
        }
        if (is_null($transactionAmountFrom) || (is_array($transactionAmountFrom) && empty($transactionAmountFrom))) {
            unset($this->TransactionAmountFrom);
        } else {
            $this->TransactionAmountFrom = $transactionAmountFrom;
        }
        return $this;
    }
    /**
     * Get TransactionAmountTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTransactionAmountTo()
    {
        return isset($this->TransactionAmountTo) ? $this->TransactionAmountTo : null;
    }
    /**
     * Set TransactionAmountTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $transactionAmountTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionAmountTo($transactionAmountTo = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmountTo) && !(is_float($transactionAmountTo) || is_numeric($transactionAmountTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmountTo, true), gettype($transactionAmountTo)), __LINE__);
        }
        if (is_null($transactionAmountTo) || (is_array($transactionAmountTo) && empty($transactionAmountTo))) {
            unset($this->TransactionAmountTo);
        } else {
            $this->TransactionAmountTo = $transactionAmountTo;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DateEnum::valueIsValid()
     * @uses \patest\EnumType\DateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionDate
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DateEnum::valueIsValid($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DateEnum', is_array($transactionDate) ? implode(', ', $transactionDate) : var_export($transactionDate, true), implode(', ', \patest\EnumType\DateEnum::getValidValues())), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateFrom()
    {
        return isset($this->TransactionDateFrom) ? $this->TransactionDateFrom : null;
    }
    /**
     * Set TransactionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateFrom, true), gettype($transactionDateFrom)), __LINE__);
        }
        if (is_null($transactionDateFrom) || (is_array($transactionDateFrom) && empty($transactionDateFrom))) {
            unset($this->TransactionDateFrom);
        } else {
            $this->TransactionDateFrom = $transactionDateFrom;
        }
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateTo()
    {
        return isset($this->TransactionDateTo) ? $this->TransactionDateTo : null;
    }
    /**
     * Set TransactionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTo, true), gettype($transactionDateTo)), __LINE__);
        }
        if (is_null($transactionDateTo) || (is_array($transactionDateTo) && empty($transactionDateTo))) {
            unset($this->TransactionDateTo);
        } else {
            $this->TransactionDateTo = $transactionDateTo;
        }
        return $this;
    }
    /**
     * Get TransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionIds()
    {
        return isset($this->TransactionIds) ? $this->TransactionIds : null;
    }
    /**
     * Set TransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionIds
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionIds($transactionIds = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIds) && !is_string($transactionIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIds, true), gettype($transactionIds)), __LINE__);
        }
        if (is_null($transactionIds) || (is_array($transactionIds) && empty($transactionIds))) {
            unset($this->TransactionIds);
        } else {
            $this->TransactionIds = $transactionIds;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionReferenceNumber
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionReferenceNumber) && !is_string($transactionReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get TransactionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return isset($this->TransactionStatus) ? $this->TransactionStatus : null;
    }
    /**
     * Set TransactionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionStatus::valueIsValid()
     * @uses \patest\EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionStatus', is_array($transactionStatus) ? implode(', ', $transactionStatus) : var_export($transactionStatus, true), implode(', ', \patest\EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        if (is_null($transactionStatus) || (is_array($transactionStatus) && empty($transactionStatus))) {
            unset($this->TransactionStatus);
        } else {
            $this->TransactionStatus = $transactionStatus;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnpaidAmountFrom()
    {
        return isset($this->UnpaidAmountFrom) ? $this->UnpaidAmountFrom : null;
    }
    /**
     * Set UnpaidAmountFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unpaidAmountFrom
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setUnpaidAmountFrom($unpaidAmountFrom = null)
    {
        // validation for constraint: float
        if (!is_null($unpaidAmountFrom) && !(is_float($unpaidAmountFrom) || is_numeric($unpaidAmountFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unpaidAmountFrom, true), gettype($unpaidAmountFrom)), __LINE__);
        }
        if (is_null($unpaidAmountFrom) || (is_array($unpaidAmountFrom) && empty($unpaidAmountFrom))) {
            unset($this->UnpaidAmountFrom);
        } else {
            $this->UnpaidAmountFrom = $unpaidAmountFrom;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnpaidAmountTo()
    {
        return isset($this->UnpaidAmountTo) ? $this->UnpaidAmountTo : null;
    }
    /**
     * Set UnpaidAmountTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unpaidAmountTo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setUnpaidAmountTo($unpaidAmountTo = null)
    {
        // validation for constraint: float
        if (!is_null($unpaidAmountTo) && !(is_float($unpaidAmountTo) || is_numeric($unpaidAmountTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unpaidAmountTo, true), gettype($unpaidAmountTo)), __LINE__);
        }
        if (is_null($unpaidAmountTo) || (is_array($unpaidAmountTo) && empty($unpaidAmountTo))) {
            unset($this->UnpaidAmountTo);
        } else {
            $this->UnpaidAmountTo = $unpaidAmountTo;
        }
        return $this;
    }
    /**
     * Get UnprintedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnprintedItems()
    {
        return isset($this->UnprintedItems) ? $this->UnprintedItems : null;
    }
    /**
     * Set UnprintedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unprintedItems
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setUnprintedItems($unprintedItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($unprintedItems) && !is_bool($unprintedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unprintedItems, true), gettype($unprintedItems)), __LINE__);
        }
        if (is_null($unprintedItems) || (is_array($unprintedItems) && empty($unprintedItems))) {
            unset($this->UnprintedItems);
        } else {
            $this->UnprintedItems = $unprintedItems;
        }
        return $this;
    }
    /**
     * Get UnprintedMembershipOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnprintedMembershipOnly()
    {
        return isset($this->UnprintedMembershipOnly) ? $this->UnprintedMembershipOnly : null;
    }
    /**
     * Set UnprintedMembershipOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unprintedMembershipOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setUnprintedMembershipOnly($unprintedMembershipOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($unprintedMembershipOnly) && !is_bool($unprintedMembershipOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unprintedMembershipOnly, true), gettype($unprintedMembershipOnly)), __LINE__);
        }
        if (is_null($unprintedMembershipOnly) || (is_array($unprintedMembershipOnly) && empty($unprintedMembershipOnly))) {
            unset($this->UnprintedMembershipOnly);
        } else {
            $this->UnprintedMembershipOnly = $unprintedMembershipOnly;
        }
        return $this;
    }
    /**
     * Get UnprintedSubscriptionOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnprintedSubscriptionOnly()
    {
        return isset($this->UnprintedSubscriptionOnly) ? $this->UnprintedSubscriptionOnly : null;
    }
    /**
     * Set UnprintedSubscriptionOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unprintedSubscriptionOnly
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setUnprintedSubscriptionOnly($unprintedSubscriptionOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($unprintedSubscriptionOnly) && !is_bool($unprintedSubscriptionOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unprintedSubscriptionOnly, true), gettype($unprintedSubscriptionOnly)), __LINE__);
        }
        if (is_null($unprintedSubscriptionOnly) || (is_array($unprintedSubscriptionOnly) && empty($unprintedSubscriptionOnly))) {
            unset($this->UnprintedSubscriptionOnly);
        } else {
            $this->UnprintedSubscriptionOnly = $unprintedSubscriptionOnly;
        }
        return $this;
    }
    /**
     * Get VATRegistrationNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVATRegistrationNo()
    {
        return isset($this->VATRegistrationNo) ? $this->VATRegistrationNo : null;
    }
    /**
     * Set VATRegistrationNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vATRegistrationNo
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setVATRegistrationNo($vATRegistrationNo = null)
    {
        // validation for constraint: string
        if (!is_null($vATRegistrationNo) && !is_string($vATRegistrationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vATRegistrationNo, true), gettype($vATRegistrationNo)), __LINE__);
        }
        if (is_null($vATRegistrationNo) || (is_array($vATRegistrationNo) && empty($vATRegistrationNo))) {
            unset($this->VATRegistrationNo);
        } else {
            $this->VATRegistrationNo = $vATRegistrationNo;
        }
        return $this;
    }
    /**
     * Get WasScanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasScanned()
    {
        return isset($this->WasScanned) ? $this->WasScanned : null;
    }
    /**
     * Set WasScanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasScanned
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setWasScanned($wasScanned = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasScanned) && !is_bool($wasScanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasScanned, true), gettype($wasScanned)), __LINE__);
        }
        if (is_null($wasScanned) || (is_array($wasScanned) && empty($wasScanned))) {
            unset($this->WasScanned);
        } else {
            $this->WasScanned = $wasScanned;
        }
        return $this;
    }
    /**
     * Get ZipPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipPostalCode()
    {
        return isset($this->ZipPostalCode) ? $this->ZipPostalCode : null;
    }
    /**
     * Set ZipPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipPostalCode
     * @return \patest\StructType\Search_TransactionFilter
     */
    public function setZipPostalCode($zipPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipPostalCode) && !is_string($zipPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipPostalCode, true), gettype($zipPostalCode)), __LINE__);
        }
        if (is_null($zipPostalCode) || (is_array($zipPostalCode) && empty($zipPostalCode))) {
            unset($this->ZipPostalCode);
        } else {
            $this->ZipPostalCode = $zipPostalCode;
        }
        return $this;
    }
}
