<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchForMatchingGiftsOptions-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchForMatchingGiftsOptions-Request
 * @subpackage Structs
 */
class SearchForMatchingGiftsOptions_Request extends ExtensibleDataContract
{
    /**
     * The AccountNameSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNameSearch;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * Constructor method for SearchForMatchingGiftsOptions-Request
     * @uses SearchForMatchingGiftsOptions_Request::setAccountNameSearch()
     * @uses SearchForMatchingGiftsOptions_Request::setClientId()
     * @param string $accountNameSearch
     * @param string $clientId
     */
    public function __construct($accountNameSearch = null, $clientId = null)
    {
        $this
            ->setAccountNameSearch($accountNameSearch)
            ->setClientId($clientId);
    }
    /**
     * Get AccountNameSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNameSearch()
    {
        return isset($this->AccountNameSearch) ? $this->AccountNameSearch : null;
    }
    /**
     * Set AccountNameSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNameSearch
     * @return \patest\StructType\SearchForMatchingGiftsOptions_Request
     */
    public function setAccountNameSearch($accountNameSearch = null)
    {
        // validation for constraint: string
        if (!is_null($accountNameSearch) && !is_string($accountNameSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNameSearch, true), gettype($accountNameSearch)), __LINE__);
        }
        if (is_null($accountNameSearch) || (is_array($accountNameSearch) && empty($accountNameSearch))) {
            unset($this->AccountNameSearch);
        } else {
            $this->AccountNameSearch = $accountNameSearch;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\SearchForMatchingGiftsOptions_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
}
