<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScanBarcodeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ScanBarcodeRequest
 * @subpackage Structs
 */
class ScanBarcodeRequest extends ExtensibleDataContract
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeInfoPreparedTextFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeInfoPreparedTextFormat;
    /**
     * The BarcodeInfoType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeInfoType;
    /**
     * The ScanAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScanAction;
    /**
     * The ScanningSession
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningSession;
    /**
     * Constructor method for ScanBarcodeRequest
     * @uses ScanBarcodeRequest::setBarcode()
     * @uses ScanBarcodeRequest::setBarcodeInfoPreparedTextFormat()
     * @uses ScanBarcodeRequest::setBarcodeInfoType()
     * @uses ScanBarcodeRequest::setScanAction()
     * @uses ScanBarcodeRequest::setScanningSession()
     * @param string $barcode
     * @param string $barcodeInfoPreparedTextFormat
     * @param string $barcodeInfoType
     * @param string $scanAction
     * @param string $scanningSession
     */
    public function __construct($barcode = null, $barcodeInfoPreparedTextFormat = null, $barcodeInfoType = null, $scanAction = null, $scanningSession = null)
    {
        $this
            ->setBarcode($barcode)
            ->setBarcodeInfoPreparedTextFormat($barcodeInfoPreparedTextFormat)
            ->setBarcodeInfoType($barcodeInfoType)
            ->setScanAction($scanAction)
            ->setScanningSession($scanningSession);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\ScanBarcodeRequest
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeInfoPreparedTextFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeInfoPreparedTextFormat()
    {
        return isset($this->BarcodeInfoPreparedTextFormat) ? $this->BarcodeInfoPreparedTextFormat : null;
    }
    /**
     * Set BarcodeInfoPreparedTextFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeInfoPreparedTextFormat
     * @return \patest\StructType\ScanBarcodeRequest
     */
    public function setBarcodeInfoPreparedTextFormat($barcodeInfoPreparedTextFormat = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeInfoPreparedTextFormat) && !is_string($barcodeInfoPreparedTextFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeInfoPreparedTextFormat, true), gettype($barcodeInfoPreparedTextFormat)), __LINE__);
        }
        if (is_null($barcodeInfoPreparedTextFormat) || (is_array($barcodeInfoPreparedTextFormat) && empty($barcodeInfoPreparedTextFormat))) {
            unset($this->BarcodeInfoPreparedTextFormat);
        } else {
            $this->BarcodeInfoPreparedTextFormat = $barcodeInfoPreparedTextFormat;
        }
        return $this;
    }
    /**
     * Get BarcodeInfoType value
     * @return string|null
     */
    public function getBarcodeInfoType()
    {
        return $this->BarcodeInfoType;
    }
    /**
     * Set BarcodeInfoType value
     * @uses \patest\EnumType\BarcodeInfoType::valueIsValid()
     * @uses \patest\EnumType\BarcodeInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barcodeInfoType
     * @return \patest\StructType\ScanBarcodeRequest
     */
    public function setBarcodeInfoType($barcodeInfoType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeInfoType::valueIsValid($barcodeInfoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeInfoType', is_array($barcodeInfoType) ? implode(', ', $barcodeInfoType) : var_export($barcodeInfoType, true), implode(', ', \patest\EnumType\BarcodeInfoType::getValidValues())), __LINE__);
        }
        $this->BarcodeInfoType = $barcodeInfoType;
        return $this;
    }
    /**
     * Get ScanAction value
     * @return string|null
     */
    public function getScanAction()
    {
        return $this->ScanAction;
    }
    /**
     * Set ScanAction value
     * @uses \patest\EnumType\BarcodeScanAction::valueIsValid()
     * @uses \patest\EnumType\BarcodeScanAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scanAction
     * @return \patest\StructType\ScanBarcodeRequest
     */
    public function setScanAction($scanAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeScanAction::valueIsValid($scanAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeScanAction', is_array($scanAction) ? implode(', ', $scanAction) : var_export($scanAction, true), implode(', ', \patest\EnumType\BarcodeScanAction::getValidValues())), __LINE__);
        }
        $this->ScanAction = $scanAction;
        return $this;
    }
    /**
     * Get ScanningSession value
     * @return string|null
     */
    public function getScanningSession()
    {
        return $this->ScanningSession;
    }
    /**
     * Set ScanningSession value
     * @param string $scanningSession
     * @return \patest\StructType\ScanBarcodeRequest
     */
    public function setScanningSession($scanningSession = null)
    {
        // validation for constraint: string
        if (!is_null($scanningSession) && !is_string($scanningSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningSession, true), gettype($scanningSession)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningSession) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningSession, true)), __LINE__);
        }
        $this->ScanningSession = $scanningSession;
        return $this;
    }
}
