<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.TicketingExtrasElement StructType
 * @subpackage Structs
 */
class Sales_TicketingExtrasElement extends Sales_ExtraProductElement
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The OfferedDatesType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OfferedDatesType;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowIds
     */
    public $ShowIds;
    /**
     * The ShowTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowTypeIds
     */
    public $ShowTypeIds;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Sales.TicketingExtrasElement
     * @uses Sales_TicketingExtrasElement::setAreaIds()
     * @uses Sales_TicketingExtrasElement::setFromDate()
     * @uses Sales_TicketingExtrasElement::setOfferedDatesType()
     * @uses Sales_TicketingExtrasElement::setPriceLevelIds()
     * @uses Sales_TicketingExtrasElement::setShowIds()
     * @uses Sales_TicketingExtrasElement::setShowTypeIds()
     * @uses Sales_TicketingExtrasElement::setToDate()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $fromDate
     * @param string $offeredDatesType
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\ShowIds $showIds
     * @param \patest\StructType\ShowTypeIds $showTypeIds
     * @param string $toDate
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $fromDate = null, $offeredDatesType = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\ShowIds $showIds = null, \patest\StructType\ShowTypeIds $showTypeIds = null, $toDate = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setFromDate($fromDate)
            ->setOfferedDatesType($offeredDatesType)
            ->setPriceLevelIds($priceLevelIds)
            ->setShowIds($showIds)
            ->setShowTypeIds($showTypeIds)
            ->setToDate($toDate);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get OfferedDatesType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOfferedDatesType()
    {
        return isset($this->OfferedDatesType) ? $this->OfferedDatesType : null;
    }
    /**
     * Set OfferedDatesType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OfferedEventDatesPolicy::valueIsValid()
     * @uses \patest\EnumType\OfferedEventDatesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offeredDatesType
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setOfferedDatesType($offeredDatesType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OfferedEventDatesPolicy::valueIsValid($offeredDatesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OfferedEventDatesPolicy', is_array($offeredDatesType) ? implode(', ', $offeredDatesType) : var_export($offeredDatesType, true), implode(', ', \patest\EnumType\OfferedEventDatesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($offeredDatesType) || (is_array($offeredDatesType) && empty($offeredDatesType))) {
            unset($this->OfferedDatesType);
        } else {
            $this->OfferedDatesType = $offeredDatesType;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowIds|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowIds $showIds
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setShowIds(\patest\StructType\ShowIds $showIds = null)
    {
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get ShowTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowTypeIds|null
     */
    public function getShowTypeIds()
    {
        return isset($this->ShowTypeIds) ? $this->ShowTypeIds : null;
    }
    /**
     * Set ShowTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowTypeIds $showTypeIds
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setShowTypeIds(\patest\StructType\ShowTypeIds $showTypeIds = null)
    {
        if (is_null($showTypeIds) || (is_array($showTypeIds) && empty($showTypeIds))) {
            unset($this->ShowTypeIds);
        } else {
            $this->ShowTypeIds = $showTypeIds;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Sales_TicketingExtrasElement
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
