<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SubscriptionItemDetails StructType
 * @subpackage Structs
 */
class Sales_SubscriptionItemDetails extends Ticketing_SubscriptionBasketItemData
{
    /**
     * The BackwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransactionId;
    /**
     * The CanAutoRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoRenew;
    /**
     * The CanRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRenew;
    /**
     * The EffectiveEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveEndDate;
    /**
     * The PreservedSeatsStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreservedSeatsStatus;
    /**
     * The SubscriptionNameAndNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNameAndNumber;
    /**
     * Constructor method for Sales.SubscriptionItemDetails
     * @uses Sales_SubscriptionItemDetails::setBackwardTransactionId()
     * @uses Sales_SubscriptionItemDetails::setCanAutoRenew()
     * @uses Sales_SubscriptionItemDetails::setCanRenew()
     * @uses Sales_SubscriptionItemDetails::setEffectiveEndDate()
     * @uses Sales_SubscriptionItemDetails::setPreservedSeatsStatus()
     * @uses Sales_SubscriptionItemDetails::setSubscriptionNameAndNumber()
     * @param string $backwardTransactionId
     * @param bool $canAutoRenew
     * @param bool $canRenew
     * @param string $effectiveEndDate
     * @param string $preservedSeatsStatus
     * @param string $subscriptionNameAndNumber
     */
    public function __construct($backwardTransactionId = null, $canAutoRenew = null, $canRenew = null, $effectiveEndDate = null, $preservedSeatsStatus = null, $subscriptionNameAndNumber = null)
    {
        $this
            ->setBackwardTransactionId($backwardTransactionId)
            ->setCanAutoRenew($canAutoRenew)
            ->setCanRenew($canRenew)
            ->setEffectiveEndDate($effectiveEndDate)
            ->setPreservedSeatsStatus($preservedSeatsStatus)
            ->setSubscriptionNameAndNumber($subscriptionNameAndNumber);
    }
    /**
     * Get BackwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransactionId()
    {
        return isset($this->BackwardTransactionId) ? $this->BackwardTransactionId : null;
    }
    /**
     * Set BackwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransactionId
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setBackwardTransactionId($backwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransactionId) && !is_string($backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransactionId, true), gettype($backwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransactionId, true)), __LINE__);
        }
        if (is_null($backwardTransactionId) || (is_array($backwardTransactionId) && empty($backwardTransactionId))) {
            unset($this->BackwardTransactionId);
        } else {
            $this->BackwardTransactionId = $backwardTransactionId;
        }
        return $this;
    }
    /**
     * Get CanAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoRenew()
    {
        return isset($this->CanAutoRenew) ? $this->CanAutoRenew : null;
    }
    /**
     * Set CanAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoRenew
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setCanAutoRenew($canAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoRenew) && !is_bool($canAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoRenew, true), gettype($canAutoRenew)), __LINE__);
        }
        if (is_null($canAutoRenew) || (is_array($canAutoRenew) && empty($canAutoRenew))) {
            unset($this->CanAutoRenew);
        } else {
            $this->CanAutoRenew = $canAutoRenew;
        }
        return $this;
    }
    /**
     * Get CanRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRenew()
    {
        return isset($this->CanRenew) ? $this->CanRenew : null;
    }
    /**
     * Set CanRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRenew
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setCanRenew($canRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRenew) && !is_bool($canRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRenew, true), gettype($canRenew)), __LINE__);
        }
        if (is_null($canRenew) || (is_array($canRenew) && empty($canRenew))) {
            unset($this->CanRenew);
        } else {
            $this->CanRenew = $canRenew;
        }
        return $this;
    }
    /**
     * Get EffectiveEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveEndDate()
    {
        return isset($this->EffectiveEndDate) ? $this->EffectiveEndDate : null;
    }
    /**
     * Set EffectiveEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveEndDate
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setEffectiveEndDate($effectiveEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEndDate) && !is_string($effectiveEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEndDate, true), gettype($effectiveEndDate)), __LINE__);
        }
        if (is_null($effectiveEndDate) || (is_array($effectiveEndDate) && empty($effectiveEndDate))) {
            unset($this->EffectiveEndDate);
        } else {
            $this->EffectiveEndDate = $effectiveEndDate;
        }
        return $this;
    }
    /**
     * Get PreservedSeatsStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreservedSeatsStatus()
    {
        return isset($this->PreservedSeatsStatus) ? $this->PreservedSeatsStatus : null;
    }
    /**
     * Set PreservedSeatsStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberPreservedSeatStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriberPreservedSeatStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preservedSeatsStatus
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setPreservedSeatsStatus($preservedSeatsStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberPreservedSeatStatus::valueIsValid($preservedSeatsStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberPreservedSeatStatus', is_array($preservedSeatsStatus) ? implode(', ', $preservedSeatsStatus) : var_export($preservedSeatsStatus, true), implode(', ', \patest\EnumType\SubscriberPreservedSeatStatus::getValidValues())), __LINE__);
        }
        if (is_null($preservedSeatsStatus) || (is_array($preservedSeatsStatus) && empty($preservedSeatsStatus))) {
            unset($this->PreservedSeatsStatus);
        } else {
            $this->PreservedSeatsStatus = $preservedSeatsStatus;
        }
        return $this;
    }
    /**
     * Get SubscriptionNameAndNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNameAndNumber()
    {
        return isset($this->SubscriptionNameAndNumber) ? $this->SubscriptionNameAndNumber : null;
    }
    /**
     * Set SubscriptionNameAndNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNameAndNumber
     * @return \patest\StructType\Sales_SubscriptionItemDetails
     */
    public function setSubscriptionNameAndNumber($subscriptionNameAndNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNameAndNumber) && !is_string($subscriptionNameAndNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNameAndNumber, true), gettype($subscriptionNameAndNumber)), __LINE__);
        }
        if (is_null($subscriptionNameAndNumber) || (is_array($subscriptionNameAndNumber) && empty($subscriptionNameAndNumber))) {
            unset($this->SubscriptionNameAndNumber);
        } else {
            $this->SubscriptionNameAndNumber = $subscriptionNameAndNumber;
        }
        return $this;
    }
}
