<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SubscriptionExtrasElement StructType
 * @subpackage Structs
 */
class Sales_SubscriptionExtrasElement extends Sales_ExtraProductElement
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIds
     */
    public $SeriesIds;
    /**
     * The SeriesSchemeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesSchemeIds
     */
    public $SeriesSchemeIds;
    /**
     * Constructor method for Sales.SubscriptionExtrasElement
     * @uses Sales_SubscriptionExtrasElement::setAreaIds()
     * @uses Sales_SubscriptionExtrasElement::setPriceLevelIds()
     * @uses Sales_SubscriptionExtrasElement::setSeasonId()
     * @uses Sales_SubscriptionExtrasElement::setSeriesIds()
     * @uses Sales_SubscriptionExtrasElement::setSeriesSchemeIds()
     * @param \patest\StructType\AreaIds $areaIds
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param string $seasonId
     * @param \patest\StructType\SeriesIds $seriesIds
     * @param \patest\StructType\SeriesSchemeIds $seriesSchemeIds
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, $seasonId = null, \patest\StructType\SeriesIds $seriesIds = null, \patest\StructType\SeriesSchemeIds $seriesSchemeIds = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setPriceLevelIds($priceLevelIds)
            ->setSeasonId($seasonId)
            ->setSeriesIds($seriesIds)
            ->setSeriesSchemeIds($seriesSchemeIds);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Sales_SubscriptionExtrasElement
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Sales_SubscriptionExtrasElement
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Sales_SubscriptionExtrasElement
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIds|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIds $seriesIds
     * @return \patest\StructType\Sales_SubscriptionExtrasElement
     */
    public function setSeriesIds(\patest\StructType\SeriesIds $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get SeriesSchemeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesSchemeIds|null
     */
    public function getSeriesSchemeIds()
    {
        return isset($this->SeriesSchemeIds) ? $this->SeriesSchemeIds : null;
    }
    /**
     * Set SeriesSchemeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesSchemeIds $seriesSchemeIds
     * @return \patest\StructType\Sales_SubscriptionExtrasElement
     */
    public function setSeriesSchemeIds(\patest\StructType\SeriesSchemeIds $seriesSchemeIds = null)
    {
        if (is_null($seriesSchemeIds) || (is_array($seriesSchemeIds) && empty($seriesSchemeIds))) {
            unset($this->SeriesSchemeIds);
        } else {
            $this->SeriesSchemeIds = $seriesSchemeIds;
        }
        return $this;
    }
}
