<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ShowPackageElement StructType
 * @subpackage Structs
 */
class Sales_ShowPackageElement extends Sales_ProductPackageElement
{
    /**
     * The MaxTicketsPerShow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerShow;
    /**
     * The MinTicketsPerShow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinTicketsPerShow;
    /**
     * The SameQuantityPerShow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SameQuantityPerShow;
    /**
     * Constructor method for Sales.ShowPackageElement
     * @uses Sales_ShowPackageElement::setMaxTicketsPerShow()
     * @uses Sales_ShowPackageElement::setMinTicketsPerShow()
     * @uses Sales_ShowPackageElement::setSameQuantityPerShow()
     * @param int $maxTicketsPerShow
     * @param int $minTicketsPerShow
     * @param bool $sameQuantityPerShow
     */
    public function __construct($maxTicketsPerShow = null, $minTicketsPerShow = null, $sameQuantityPerShow = null)
    {
        $this
            ->setMaxTicketsPerShow($maxTicketsPerShow)
            ->setMinTicketsPerShow($minTicketsPerShow)
            ->setSameQuantityPerShow($sameQuantityPerShow);
    }
    /**
     * Get MaxTicketsPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerShow()
    {
        return isset($this->MaxTicketsPerShow) ? $this->MaxTicketsPerShow : null;
    }
    /**
     * Set MaxTicketsPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerShow
     * @return \patest\StructType\Sales_ShowPackageElement
     */
    public function setMaxTicketsPerShow($maxTicketsPerShow = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerShow) && !(is_int($maxTicketsPerShow) || ctype_digit($maxTicketsPerShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerShow, true), gettype($maxTicketsPerShow)), __LINE__);
        }
        if (is_null($maxTicketsPerShow) || (is_array($maxTicketsPerShow) && empty($maxTicketsPerShow))) {
            unset($this->MaxTicketsPerShow);
        } else {
            $this->MaxTicketsPerShow = $maxTicketsPerShow;
        }
        return $this;
    }
    /**
     * Get MinTicketsPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinTicketsPerShow()
    {
        return isset($this->MinTicketsPerShow) ? $this->MinTicketsPerShow : null;
    }
    /**
     * Set MinTicketsPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minTicketsPerShow
     * @return \patest\StructType\Sales_ShowPackageElement
     */
    public function setMinTicketsPerShow($minTicketsPerShow = null)
    {
        // validation for constraint: int
        if (!is_null($minTicketsPerShow) && !(is_int($minTicketsPerShow) || ctype_digit($minTicketsPerShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTicketsPerShow, true), gettype($minTicketsPerShow)), __LINE__);
        }
        if (is_null($minTicketsPerShow) || (is_array($minTicketsPerShow) && empty($minTicketsPerShow))) {
            unset($this->MinTicketsPerShow);
        } else {
            $this->MinTicketsPerShow = $minTicketsPerShow;
        }
        return $this;
    }
    /**
     * Get SameQuantityPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSameQuantityPerShow()
    {
        return isset($this->SameQuantityPerShow) ? $this->SameQuantityPerShow : null;
    }
    /**
     * Set SameQuantityPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sameQuantityPerShow
     * @return \patest\StructType\Sales_ShowPackageElement
     */
    public function setSameQuantityPerShow($sameQuantityPerShow = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameQuantityPerShow) && !is_bool($sameQuantityPerShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameQuantityPerShow, true), gettype($sameQuantityPerShow)), __LINE__);
        }
        if (is_null($sameQuantityPerShow) || (is_array($sameQuantityPerShow) && empty($sameQuantityPerShow))) {
            unset($this->SameQuantityPerShow);
        } else {
            $this->SameQuantityPerShow = $sameQuantityPerShow;
        }
        return $this;
    }
}
