<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SeatGeekAcknowledgementUserReaction StructType
 * @subpackage Structs
 */
class Sales_SeatGeekAcknowledgementUserReaction extends PersistableEntity
{
    /**
     * The AcknowledgementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AcknowledgementId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The OpenTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenTransactionId;
    /**
     * The OpenUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenUserId;
    /**
     * The SeatGeekActionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatGeekActionId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The UserReactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UserReactionValue;
    /**
     * Constructor method for Sales.SeatGeekAcknowledgementUserReaction
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setAcknowledgementId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setClientId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setCreationDateTime()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setOpenTransactionId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setOpenUserId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setSeatGeekActionId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setTransactionId()
     * @uses Sales_SeatGeekAcknowledgementUserReaction::setUserReactionValue()
     * @param string $acknowledgementId
     * @param string $clientId
     * @param string $creationDateTime
     * @param string $openTransactionId
     * @param string $openUserId
     * @param int $seatGeekActionId
     * @param string $transactionId
     * @param bool $userReactionValue
     */
    public function __construct($acknowledgementId = null, $clientId = null, $creationDateTime = null, $openTransactionId = null, $openUserId = null, $seatGeekActionId = null, $transactionId = null, $userReactionValue = null)
    {
        $this
            ->setAcknowledgementId($acknowledgementId)
            ->setClientId($clientId)
            ->setCreationDateTime($creationDateTime)
            ->setOpenTransactionId($openTransactionId)
            ->setOpenUserId($openUserId)
            ->setSeatGeekActionId($seatGeekActionId)
            ->setTransactionId($transactionId)
            ->setUserReactionValue($userReactionValue);
    }
    /**
     * Get AcknowledgementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcknowledgementId()
    {
        return isset($this->AcknowledgementId) ? $this->AcknowledgementId : null;
    }
    /**
     * Set AcknowledgementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acknowledgementId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setAcknowledgementId($acknowledgementId = null)
    {
        // validation for constraint: string
        if (!is_null($acknowledgementId) && !is_string($acknowledgementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acknowledgementId, true), gettype($acknowledgementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($acknowledgementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $acknowledgementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($acknowledgementId, true)), __LINE__);
        }
        if (is_null($acknowledgementId) || (is_array($acknowledgementId) && empty($acknowledgementId))) {
            unset($this->AcknowledgementId);
        } else {
            $this->AcknowledgementId = $acknowledgementId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get OpenTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenTransactionId()
    {
        return isset($this->OpenTransactionId) ? $this->OpenTransactionId : null;
    }
    /**
     * Set OpenTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openTransactionId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setOpenTransactionId($openTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($openTransactionId) && !is_string($openTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openTransactionId, true), gettype($openTransactionId)), __LINE__);
        }
        if (is_null($openTransactionId) || (is_array($openTransactionId) && empty($openTransactionId))) {
            unset($this->OpenTransactionId);
        } else {
            $this->OpenTransactionId = $openTransactionId;
        }
        return $this;
    }
    /**
     * Get OpenUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenUserId()
    {
        return isset($this->OpenUserId) ? $this->OpenUserId : null;
    }
    /**
     * Set OpenUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openUserId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setOpenUserId($openUserId = null)
    {
        // validation for constraint: string
        if (!is_null($openUserId) && !is_string($openUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUserId, true), gettype($openUserId)), __LINE__);
        }
        if (is_null($openUserId) || (is_array($openUserId) && empty($openUserId))) {
            unset($this->OpenUserId);
        } else {
            $this->OpenUserId = $openUserId;
        }
        return $this;
    }
    /**
     * Get SeatGeekActionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatGeekActionId()
    {
        return isset($this->SeatGeekActionId) ? $this->SeatGeekActionId : null;
    }
    /**
     * Set SeatGeekActionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatGeekActionId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setSeatGeekActionId($seatGeekActionId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGeekActionId) && !(is_int($seatGeekActionId) || ctype_digit($seatGeekActionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGeekActionId, true), gettype($seatGeekActionId)), __LINE__);
        }
        if (is_null($seatGeekActionId) || (is_array($seatGeekActionId) && empty($seatGeekActionId))) {
            unset($this->SeatGeekActionId);
        } else {
            $this->SeatGeekActionId = $seatGeekActionId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get UserReactionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUserReactionValue()
    {
        return isset($this->UserReactionValue) ? $this->UserReactionValue : null;
    }
    /**
     * Set UserReactionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $userReactionValue
     * @return \patest\StructType\Sales_SeatGeekAcknowledgementUserReaction
     */
    public function setUserReactionValue($userReactionValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($userReactionValue) && !is_bool($userReactionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userReactionValue, true), gettype($userReactionValue)), __LINE__);
        }
        if (is_null($userReactionValue) || (is_array($userReactionValue) && empty($userReactionValue))) {
            unset($this->UserReactionValue);
        } else {
            $this->UserReactionValue = $userReactionValue;
        }
        return $this;
    }
}
