<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceType StructType
 * @subpackage Structs
 */
class Sales_PriceType extends DistributableEntity
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref
     */
    public $AccessControlData;
    /**
     * The AccessControlReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlReferenceId;
    /**
     * The AccessControlSyncStatusSummary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSyncStatusSummary;
    /**
     * The AccessControlSystemNames
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSystemNames;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AgeRestriction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AgeRestriction;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DescriptionForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DescriptionForDisplay;
    /**
     * The DetailedInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DetailedInfo;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsForRestrictedSeatsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForRestrictedSeatsOnly;
    /**
     * The IsInternallyApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternallyApplied;
    /**
     * The IsPriceOverridable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPriceOverridable;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaxClientAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxClientAge;
    /**
     * The MinClientAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinClientAge;
    /**
     * The MinutesBeforeEventWhenAllowPrintTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinutesBeforeEventWhenAllowPrintTickets;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageType;
    /**
     * The PriceTypeForNextAgeGroup
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeForNextAgeGroup;
    /**
     * The PriceTypeGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeGroupId;
    /**
     * The PrintDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PrintDescription;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Purpose;
    /**
     * The ReportAsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReportAsComplimentary;
    /**
     * The SalesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalesDescription;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShortDescription;
    /**
     * The TermsAndConditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TermsAndConditions;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.PriceType
     * @uses Sales_PriceType::setAccessControlData()
     * @uses Sales_PriceType::setAccessControlReferenceId()
     * @uses Sales_PriceType::setAccessControlSyncStatusSummary()
     * @uses Sales_PriceType::setAccessControlSystemNames()
     * @uses Sales_PriceType::setAclSchemeId()
     * @uses Sales_PriceType::setAgeRestriction()
     * @uses Sales_PriceType::setDescription()
     * @uses Sales_PriceType::setDescriptionForDisplay()
     * @uses Sales_PriceType::setDetailedInfo()
     * @uses Sales_PriceType::setDisplayStyleValue()
     * @uses Sales_PriceType::setIsActive()
     * @uses Sales_PriceType::setIsForRestrictedSeatsOnly()
     * @uses Sales_PriceType::setIsInternallyApplied()
     * @uses Sales_PriceType::setIsPriceOverridable()
     * @uses Sales_PriceType::setIsSystem()
     * @uses Sales_PriceType::setLedgerId()
     * @uses Sales_PriceType::setMaxClientAge()
     * @uses Sales_PriceType::setMinClientAge()
     * @uses Sales_PriceType::setMinutesBeforeEventWhenAllowPrintTickets()
     * @uses Sales_PriceType::setOrdinal()
     * @uses Sales_PriceType::setOrganizationUnitId()
     * @uses Sales_PriceType::setPackageType()
     * @uses Sales_PriceType::setPriceTypeForNextAgeGroup()
     * @uses Sales_PriceType::setPriceTypeGroupId()
     * @uses Sales_PriceType::setPrintDescription()
     * @uses Sales_PriceType::setProjectIdentifierId()
     * @uses Sales_PriceType::setPurpose()
     * @uses Sales_PriceType::setReportAsComplimentary()
     * @uses Sales_PriceType::setSalesDescription()
     * @uses Sales_PriceType::setShortDescription()
     * @uses Sales_PriceType::setTermsAndConditions()
     * @uses Sales_PriceType::setVisibleBySubordinates()
     * @param \patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref $accessControlData
     * @param string $accessControlReferenceId
     * @param string $accessControlSyncStatusSummary
     * @param string $accessControlSystemNames
     * @param int $aclSchemeId
     * @param bool $ageRestriction
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\GlobalString $descriptionForDisplay
     * @param \patest\StructType\GlobalString $detailedInfo
     * @param string $displayStyleValue
     * @param bool $isActive
     * @param bool $isForRestrictedSeatsOnly
     * @param bool $isInternallyApplied
     * @param bool $isPriceOverridable
     * @param bool $isSystem
     * @param string $ledgerId
     * @param int $maxClientAge
     * @param int $minClientAge
     * @param int $minutesBeforeEventWhenAllowPrintTickets
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param int $packageType
     * @param string $priceTypeForNextAgeGroup
     * @param string $priceTypeGroupId
     * @param \patest\StructType\GlobalString $printDescription
     * @param string $projectIdentifierId
     * @param string $purpose
     * @param bool $reportAsComplimentary
     * @param \patest\StructType\GlobalString $salesDescription
     * @param \patest\StructType\GlobalString $shortDescription
     * @param \patest\StructType\GlobalString $termsAndConditions
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref $accessControlData = null, $accessControlReferenceId = null, $accessControlSyncStatusSummary = null, $accessControlSystemNames = null, $aclSchemeId = null, $ageRestriction = null, \patest\StructType\GlobalString $description = null, \patest\StructType\GlobalString $descriptionForDisplay = null, \patest\StructType\GlobalString $detailedInfo = null, $displayStyleValue = null, $isActive = null, $isForRestrictedSeatsOnly = null, $isInternallyApplied = null, $isPriceOverridable = null, $isSystem = null, $ledgerId = null, $maxClientAge = null, $minClientAge = null, $minutesBeforeEventWhenAllowPrintTickets = null, $ordinal = null, $organizationUnitId = null, $packageType = null, $priceTypeForNextAgeGroup = null, $priceTypeGroupId = null, \patest\StructType\GlobalString $printDescription = null, $projectIdentifierId = null, $purpose = null, $reportAsComplimentary = null, \patest\StructType\GlobalString $salesDescription = null, \patest\StructType\GlobalString $shortDescription = null, \patest\StructType\GlobalString $termsAndConditions = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAccessControlReferenceId($accessControlReferenceId)
            ->setAccessControlSyncStatusSummary($accessControlSyncStatusSummary)
            ->setAccessControlSystemNames($accessControlSystemNames)
            ->setAclSchemeId($aclSchemeId)
            ->setAgeRestriction($ageRestriction)
            ->setDescription($description)
            ->setDescriptionForDisplay($descriptionForDisplay)
            ->setDetailedInfo($detailedInfo)
            ->setDisplayStyleValue($displayStyleValue)
            ->setIsActive($isActive)
            ->setIsForRestrictedSeatsOnly($isForRestrictedSeatsOnly)
            ->setIsInternallyApplied($isInternallyApplied)
            ->setIsPriceOverridable($isPriceOverridable)
            ->setIsSystem($isSystem)
            ->setLedgerId($ledgerId)
            ->setMaxClientAge($maxClientAge)
            ->setMinClientAge($minClientAge)
            ->setMinutesBeforeEventWhenAllowPrintTickets($minutesBeforeEventWhenAllowPrintTickets)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPackageType($packageType)
            ->setPriceTypeForNextAgeGroup($priceTypeForNextAgeGroup)
            ->setPriceTypeGroupId($priceTypeGroupId)
            ->setPrintDescription($printDescription)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setPurpose($purpose)
            ->setReportAsComplimentary($reportAsComplimentary)
            ->setSalesDescription($salesDescription)
            ->setShortDescription($shortDescription)
            ->setTermsAndConditions($termsAndConditions)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref $accessControlData
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAccessControlData(\patest\StructType\RecordSetOfAccessControl_EntityAccessControlDataXref $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AccessControlReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlReferenceId()
    {
        return isset($this->AccessControlReferenceId) ? $this->AccessControlReferenceId : null;
    }
    /**
     * Set AccessControlReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlReferenceId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAccessControlReferenceId($accessControlReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlReferenceId) && !is_string($accessControlReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlReferenceId, true), gettype($accessControlReferenceId)), __LINE__);
        }
        if (is_null($accessControlReferenceId) || (is_array($accessControlReferenceId) && empty($accessControlReferenceId))) {
            unset($this->AccessControlReferenceId);
        } else {
            $this->AccessControlReferenceId = $accessControlReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlSyncStatusSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSyncStatusSummary()
    {
        return isset($this->AccessControlSyncStatusSummary) ? $this->AccessControlSyncStatusSummary : null;
    }
    /**
     * Set AccessControlSyncStatusSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSyncStatusSummary
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAccessControlSyncStatusSummary($accessControlSyncStatusSummary = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSyncStatusSummary) && !is_string($accessControlSyncStatusSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSyncStatusSummary, true), gettype($accessControlSyncStatusSummary)), __LINE__);
        }
        if (is_null($accessControlSyncStatusSummary) || (is_array($accessControlSyncStatusSummary) && empty($accessControlSyncStatusSummary))) {
            unset($this->AccessControlSyncStatusSummary);
        } else {
            $this->AccessControlSyncStatusSummary = $accessControlSyncStatusSummary;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemNames()
    {
        return isset($this->AccessControlSystemNames) ? $this->AccessControlSystemNames : null;
    }
    /**
     * Set AccessControlSystemNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemNames
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAccessControlSystemNames($accessControlSystemNames = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemNames) && !is_string($accessControlSystemNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemNames, true), gettype($accessControlSystemNames)), __LINE__);
        }
        if (is_null($accessControlSystemNames) || (is_array($accessControlSystemNames) && empty($accessControlSystemNames))) {
            unset($this->AccessControlSystemNames);
        } else {
            $this->AccessControlSystemNames = $accessControlSystemNames;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AgeRestriction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAgeRestriction()
    {
        return isset($this->AgeRestriction) ? $this->AgeRestriction : null;
    }
    /**
     * Set AgeRestriction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ageRestriction
     * @return \patest\StructType\Sales_PriceType
     */
    public function setAgeRestriction($ageRestriction = null)
    {
        // validation for constraint: boolean
        if (!is_null($ageRestriction) && !is_bool($ageRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ageRestriction, true), gettype($ageRestriction)), __LINE__);
        }
        if (is_null($ageRestriction) || (is_array($ageRestriction) && empty($ageRestriction))) {
            unset($this->AgeRestriction);
        } else {
            $this->AgeRestriction = $ageRestriction;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_PriceType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DescriptionForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescriptionForDisplay()
    {
        return isset($this->DescriptionForDisplay) ? $this->DescriptionForDisplay : null;
    }
    /**
     * Set DescriptionForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $descriptionForDisplay
     * @return \patest\StructType\Sales_PriceType
     */
    public function setDescriptionForDisplay(\patest\StructType\GlobalString $descriptionForDisplay = null)
    {
        if (is_null($descriptionForDisplay) || (is_array($descriptionForDisplay) && empty($descriptionForDisplay))) {
            unset($this->DescriptionForDisplay);
        } else {
            $this->DescriptionForDisplay = $descriptionForDisplay;
        }
        return $this;
    }
    /**
     * Get DetailedInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDetailedInfo()
    {
        return isset($this->DetailedInfo) ? $this->DetailedInfo : null;
    }
    /**
     * Set DetailedInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $detailedInfo
     * @return \patest\StructType\Sales_PriceType
     */
    public function setDetailedInfo(\patest\StructType\GlobalString $detailedInfo = null)
    {
        if (is_null($detailedInfo) || (is_array($detailedInfo) && empty($detailedInfo))) {
            unset($this->DetailedInfo);
        } else {
            $this->DetailedInfo = $detailedInfo;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\Sales_PriceType
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_PriceType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsForRestrictedSeatsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForRestrictedSeatsOnly()
    {
        return isset($this->IsForRestrictedSeatsOnly) ? $this->IsForRestrictedSeatsOnly : null;
    }
    /**
     * Set IsForRestrictedSeatsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForRestrictedSeatsOnly
     * @return \patest\StructType\Sales_PriceType
     */
    public function setIsForRestrictedSeatsOnly($isForRestrictedSeatsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForRestrictedSeatsOnly) && !is_bool($isForRestrictedSeatsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForRestrictedSeatsOnly, true), gettype($isForRestrictedSeatsOnly)), __LINE__);
        }
        if (is_null($isForRestrictedSeatsOnly) || (is_array($isForRestrictedSeatsOnly) && empty($isForRestrictedSeatsOnly))) {
            unset($this->IsForRestrictedSeatsOnly);
        } else {
            $this->IsForRestrictedSeatsOnly = $isForRestrictedSeatsOnly;
        }
        return $this;
    }
    /**
     * Get IsInternallyApplied value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternallyApplied()
    {
        return isset($this->IsInternallyApplied) ? $this->IsInternallyApplied : null;
    }
    /**
     * Set IsInternallyApplied value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternallyApplied
     * @return \patest\StructType\Sales_PriceType
     */
    public function setIsInternallyApplied($isInternallyApplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternallyApplied) && !is_bool($isInternallyApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternallyApplied, true), gettype($isInternallyApplied)), __LINE__);
        }
        if (is_null($isInternallyApplied) || (is_array($isInternallyApplied) && empty($isInternallyApplied))) {
            unset($this->IsInternallyApplied);
        } else {
            $this->IsInternallyApplied = $isInternallyApplied;
        }
        return $this;
    }
    /**
     * Get IsPriceOverridable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPriceOverridable()
    {
        return isset($this->IsPriceOverridable) ? $this->IsPriceOverridable : null;
    }
    /**
     * Set IsPriceOverridable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPriceOverridable
     * @return \patest\StructType\Sales_PriceType
     */
    public function setIsPriceOverridable($isPriceOverridable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPriceOverridable) && !is_bool($isPriceOverridable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPriceOverridable, true), gettype($isPriceOverridable)), __LINE__);
        }
        if (is_null($isPriceOverridable) || (is_array($isPriceOverridable) && empty($isPriceOverridable))) {
            unset($this->IsPriceOverridable);
        } else {
            $this->IsPriceOverridable = $isPriceOverridable;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Sales_PriceType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaxClientAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxClientAge()
    {
        return isset($this->MaxClientAge) ? $this->MaxClientAge : null;
    }
    /**
     * Set MaxClientAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxClientAge
     * @return \patest\StructType\Sales_PriceType
     */
    public function setMaxClientAge($maxClientAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxClientAge) && !(is_int($maxClientAge) || ctype_digit($maxClientAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxClientAge, true), gettype($maxClientAge)), __LINE__);
        }
        if (is_null($maxClientAge) || (is_array($maxClientAge) && empty($maxClientAge))) {
            unset($this->MaxClientAge);
        } else {
            $this->MaxClientAge = $maxClientAge;
        }
        return $this;
    }
    /**
     * Get MinClientAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinClientAge()
    {
        return isset($this->MinClientAge) ? $this->MinClientAge : null;
    }
    /**
     * Set MinClientAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minClientAge
     * @return \patest\StructType\Sales_PriceType
     */
    public function setMinClientAge($minClientAge = null)
    {
        // validation for constraint: int
        if (!is_null($minClientAge) && !(is_int($minClientAge) || ctype_digit($minClientAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minClientAge, true), gettype($minClientAge)), __LINE__);
        }
        if (is_null($minClientAge) || (is_array($minClientAge) && empty($minClientAge))) {
            unset($this->MinClientAge);
        } else {
            $this->MinClientAge = $minClientAge;
        }
        return $this;
    }
    /**
     * Get MinutesBeforeEventWhenAllowPrintTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinutesBeforeEventWhenAllowPrintTickets()
    {
        return isset($this->MinutesBeforeEventWhenAllowPrintTickets) ? $this->MinutesBeforeEventWhenAllowPrintTickets : null;
    }
    /**
     * Set MinutesBeforeEventWhenAllowPrintTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minutesBeforeEventWhenAllowPrintTickets
     * @return \patest\StructType\Sales_PriceType
     */
    public function setMinutesBeforeEventWhenAllowPrintTickets($minutesBeforeEventWhenAllowPrintTickets = null)
    {
        // validation for constraint: int
        if (!is_null($minutesBeforeEventWhenAllowPrintTickets) && !(is_int($minutesBeforeEventWhenAllowPrintTickets) || ctype_digit($minutesBeforeEventWhenAllowPrintTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesBeforeEventWhenAllowPrintTickets, true), gettype($minutesBeforeEventWhenAllowPrintTickets)), __LINE__);
        }
        if (is_null($minutesBeforeEventWhenAllowPrintTickets) || (is_array($minutesBeforeEventWhenAllowPrintTickets) && empty($minutesBeforeEventWhenAllowPrintTickets))) {
            unset($this->MinutesBeforeEventWhenAllowPrintTickets);
        } else {
            $this->MinutesBeforeEventWhenAllowPrintTickets = $minutesBeforeEventWhenAllowPrintTickets;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Sales_PriceType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PackageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageType()
    {
        return isset($this->PackageType) ? $this->PackageType : null;
    }
    /**
     * Set PackageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageType
     * @return \patest\StructType\Sales_PriceType
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: int
        if (!is_null($packageType) && !(is_int($packageType) || ctype_digit($packageType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        if (is_null($packageType) || (is_array($packageType) && empty($packageType))) {
            unset($this->PackageType);
        } else {
            $this->PackageType = $packageType;
        }
        return $this;
    }
    /**
     * Get PriceTypeForNextAgeGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeForNextAgeGroup()
    {
        return isset($this->PriceTypeForNextAgeGroup) ? $this->PriceTypeForNextAgeGroup : null;
    }
    /**
     * Set PriceTypeForNextAgeGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeForNextAgeGroup
     * @return \patest\StructType\Sales_PriceType
     */
    public function setPriceTypeForNextAgeGroup($priceTypeForNextAgeGroup = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeForNextAgeGroup) && !is_string($priceTypeForNextAgeGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeForNextAgeGroup, true), gettype($priceTypeForNextAgeGroup)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeForNextAgeGroup) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeForNextAgeGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeForNextAgeGroup, true)), __LINE__);
        }
        if (is_null($priceTypeForNextAgeGroup) || (is_array($priceTypeForNextAgeGroup) && empty($priceTypeForNextAgeGroup))) {
            unset($this->PriceTypeForNextAgeGroup);
        } else {
            $this->PriceTypeForNextAgeGroup = $priceTypeForNextAgeGroup;
        }
        return $this;
    }
    /**
     * Get PriceTypeGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeGroupId()
    {
        return isset($this->PriceTypeGroupId) ? $this->PriceTypeGroupId : null;
    }
    /**
     * Set PriceTypeGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeGroupId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setPriceTypeGroupId($priceTypeGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeGroupId) && !is_string($priceTypeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeGroupId, true), gettype($priceTypeGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeGroupId, true)), __LINE__);
        }
        if (is_null($priceTypeGroupId) || (is_array($priceTypeGroupId) && empty($priceTypeGroupId))) {
            unset($this->PriceTypeGroupId);
        } else {
            $this->PriceTypeGroupId = $priceTypeGroupId;
        }
        return $this;
    }
    /**
     * Get PrintDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPrintDescription()
    {
        return isset($this->PrintDescription) ? $this->PrintDescription : null;
    }
    /**
     * Set PrintDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $printDescription
     * @return \patest\StructType\Sales_PriceType
     */
    public function setPrintDescription(\patest\StructType\GlobalString $printDescription = null)
    {
        if (is_null($printDescription) || (is_array($printDescription) && empty($printDescription))) {
            unset($this->PrintDescription);
        } else {
            $this->PrintDescription = $printDescription;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Sales_PriceType
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get Purpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurpose()
    {
        return isset($this->Purpose) ? $this->Purpose : null;
    }
    /**
     * Set Purpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purpose
     * @return \patest\StructType\Sales_PriceType
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        if (is_null($purpose) || (is_array($purpose) && empty($purpose))) {
            unset($this->Purpose);
        } else {
            $this->Purpose = $purpose;
        }
        return $this;
    }
    /**
     * Get ReportAsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReportAsComplimentary()
    {
        return isset($this->ReportAsComplimentary) ? $this->ReportAsComplimentary : null;
    }
    /**
     * Set ReportAsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reportAsComplimentary
     * @return \patest\StructType\Sales_PriceType
     */
    public function setReportAsComplimentary($reportAsComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($reportAsComplimentary) && !is_bool($reportAsComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reportAsComplimentary, true), gettype($reportAsComplimentary)), __LINE__);
        }
        if (is_null($reportAsComplimentary) || (is_array($reportAsComplimentary) && empty($reportAsComplimentary))) {
            unset($this->ReportAsComplimentary);
        } else {
            $this->ReportAsComplimentary = $reportAsComplimentary;
        }
        return $this;
    }
    /**
     * Get SalesDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalesDescription()
    {
        return isset($this->SalesDescription) ? $this->SalesDescription : null;
    }
    /**
     * Set SalesDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salesDescription
     * @return \patest\StructType\Sales_PriceType
     */
    public function setSalesDescription(\patest\StructType\GlobalString $salesDescription = null)
    {
        if (is_null($salesDescription) || (is_array($salesDescription) && empty($salesDescription))) {
            unset($this->SalesDescription);
        } else {
            $this->SalesDescription = $salesDescription;
        }
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $shortDescription
     * @return \patest\StructType\Sales_PriceType
     */
    public function setShortDescription(\patest\StructType\GlobalString $shortDescription = null)
    {
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Get TermsAndConditions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTermsAndConditions()
    {
        return isset($this->TermsAndConditions) ? $this->TermsAndConditions : null;
    }
    /**
     * Set TermsAndConditions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $termsAndConditions
     * @return \patest\StructType\Sales_PriceType
     */
    public function setTermsAndConditions(\patest\StructType\GlobalString $termsAndConditions = null)
    {
        if (is_null($termsAndConditions) || (is_array($termsAndConditions) && empty($termsAndConditions))) {
            unset($this->TermsAndConditions);
        } else {
            $this->TermsAndConditions = $termsAndConditions;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_PriceType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
