<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceModifiersDefinitionInfo StructType
 * @subpackage Structs
 */
class Sales_PriceModifiersDefinitionInfo extends PersistableEntity
{
    /**
     * The CalculationBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculationBase;
    /**
     * The CalculationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculationLevel;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The IsAccumulative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccumulative;
    /**
     * The IsPresentAsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPresentAsIncluded;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The RegistrationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationLevel;
    /**
     * The SplittingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SplittingMode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueType;
    /**
     * Constructor method for Sales.PriceModifiersDefinitionInfo
     * @uses Sales_PriceModifiersDefinitionInfo::setCalculationBase()
     * @uses Sales_PriceModifiersDefinitionInfo::setCalculationLevel()
     * @uses Sales_PriceModifiersDefinitionInfo::setDefinitionId()
     * @uses Sales_PriceModifiersDefinitionInfo::setIsAccumulative()
     * @uses Sales_PriceModifiersDefinitionInfo::setIsPresentAsIncluded()
     * @uses Sales_PriceModifiersDefinitionInfo::setPriority()
     * @uses Sales_PriceModifiersDefinitionInfo::setRegistrationLevel()
     * @uses Sales_PriceModifiersDefinitionInfo::setSplittingMode()
     * @uses Sales_PriceModifiersDefinitionInfo::setValue()
     * @uses Sales_PriceModifiersDefinitionInfo::setValueType()
     * @param string $calculationBase
     * @param string $calculationLevel
     * @param string $definitionId
     * @param bool $isAccumulative
     * @param bool $isPresentAsIncluded
     * @param int $priority
     * @param string $registrationLevel
     * @param string $splittingMode
     * @param float $value
     * @param string $valueType
     */
    public function __construct($calculationBase = null, $calculationLevel = null, $definitionId = null, $isAccumulative = null, $isPresentAsIncluded = null, $priority = null, $registrationLevel = null, $splittingMode = null, $value = null, $valueType = null)
    {
        $this
            ->setCalculationBase($calculationBase)
            ->setCalculationLevel($calculationLevel)
            ->setDefinitionId($definitionId)
            ->setIsAccumulative($isAccumulative)
            ->setIsPresentAsIncluded($isPresentAsIncluded)
            ->setPriority($priority)
            ->setRegistrationLevel($registrationLevel)
            ->setSplittingMode($splittingMode)
            ->setValue($value)
            ->setValueType($valueType);
    }
    /**
     * Get CalculationBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculationBase()
    {
        return isset($this->CalculationBase) ? $this->CalculationBase : null;
    }
    /**
     * Set CalculationBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierCalculationBase::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationBase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationBase
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setCalculationBase($calculationBase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationBase::valueIsValid($calculationBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationBase', is_array($calculationBase) ? implode(', ', $calculationBase) : var_export($calculationBase, true), implode(', ', \patest\EnumType\PriceModifierCalculationBase::getValidValues())), __LINE__);
        }
        if (is_null($calculationBase) || (is_array($calculationBase) && empty($calculationBase))) {
            unset($this->CalculationBase);
        } else {
            $this->CalculationBase = $calculationBase;
        }
        return $this;
    }
    /**
     * Get CalculationLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculationLevel()
    {
        return isset($this->CalculationLevel) ? $this->CalculationLevel : null;
    }
    /**
     * Set CalculationLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierCalculationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationLevel
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setCalculationLevel($calculationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationLevel::valueIsValid($calculationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationLevel', is_array($calculationLevel) ? implode(', ', $calculationLevel) : var_export($calculationLevel, true), implode(', ', \patest\EnumType\PriceModifierCalculationLevel::getValidValues())), __LINE__);
        }
        if (is_null($calculationLevel) || (is_array($calculationLevel) && empty($calculationLevel))) {
            unset($this->CalculationLevel);
        } else {
            $this->CalculationLevel = $calculationLevel;
        }
        return $this;
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get IsAccumulative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccumulative()
    {
        return isset($this->IsAccumulative) ? $this->IsAccumulative : null;
    }
    /**
     * Set IsAccumulative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccumulative
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setIsAccumulative($isAccumulative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccumulative) && !is_bool($isAccumulative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccumulative, true), gettype($isAccumulative)), __LINE__);
        }
        if (is_null($isAccumulative) || (is_array($isAccumulative) && empty($isAccumulative))) {
            unset($this->IsAccumulative);
        } else {
            $this->IsAccumulative = $isAccumulative;
        }
        return $this;
    }
    /**
     * Get IsPresentAsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPresentAsIncluded()
    {
        return isset($this->IsPresentAsIncluded) ? $this->IsPresentAsIncluded : null;
    }
    /**
     * Set IsPresentAsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPresentAsIncluded
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setIsPresentAsIncluded($isPresentAsIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPresentAsIncluded) && !is_bool($isPresentAsIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPresentAsIncluded, true), gettype($isPresentAsIncluded)), __LINE__);
        }
        if (is_null($isPresentAsIncluded) || (is_array($isPresentAsIncluded) && empty($isPresentAsIncluded))) {
            unset($this->IsPresentAsIncluded);
        } else {
            $this->IsPresentAsIncluded = $isPresentAsIncluded;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RegistrationLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationLevel()
    {
        return isset($this->RegistrationLevel) ? $this->RegistrationLevel : null;
    }
    /**
     * Set RegistrationLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registrationLevel
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setRegistrationLevel($registrationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierRegistrationLevel::valueIsValid($registrationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierRegistrationLevel', is_array($registrationLevel) ? implode(', ', $registrationLevel) : var_export($registrationLevel, true), implode(', ', \patest\EnumType\PriceModifierRegistrationLevel::getValidValues())), __LINE__);
        }
        if (is_null($registrationLevel) || (is_array($registrationLevel) && empty($registrationLevel))) {
            unset($this->RegistrationLevel);
        } else {
            $this->RegistrationLevel = $registrationLevel;
        }
        return $this;
    }
    /**
     * Get SplittingMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSplittingMode()
    {
        return isset($this->SplittingMode) ? $this->SplittingMode : null;
    }
    /**
     * Set SplittingMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierSplittingMode::valueIsValid()
     * @uses \patest\EnumType\PriceModifierSplittingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splittingMode
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setSplittingMode($splittingMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierSplittingMode::valueIsValid($splittingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierSplittingMode', is_array($splittingMode) ? implode(', ', $splittingMode) : var_export($splittingMode, true), implode(', ', \patest\EnumType\PriceModifierSplittingMode::getValidValues())), __LINE__);
        }
        if (is_null($splittingMode) || (is_array($splittingMode) && empty($splittingMode))) {
            unset($this->SplittingMode);
        } else {
            $this->SplittingMode = $splittingMode;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get ValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueType()
    {
        return isset($this->ValueType) ? $this->ValueType : null;
    }
    /**
     * Set ValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        if (is_null($valueType) || (is_array($valueType) && empty($valueType))) {
            unset($this->ValueType);
        } else {
            $this->ValueType = $valueType;
        }
        return $this;
    }
}
