<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceModifierDefinition StructType
 * @subpackage Structs
 */
class Sales_PriceModifierDefinition extends DistributableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CalculationBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculationBase;
    /**
     * The CalculationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculationLevel;
    /**
     * The DefaultValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultValueType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExtraDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDetails;
    /**
     * The FeePurpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FeePurpose;
    /**
     * The InvisibleInApplicationChannels
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvisibleInApplicationChannels;
    /**
     * The IsAccumulative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccumulative;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAdvancedBooking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAdvancedBooking;
    /**
     * The IsPresentAsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPresentAsIncluded;
    /**
     * The IsSeatgeekFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeatgeekFee;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The IsVatExcluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVatExcluded;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaxPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxPerTransaction;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ParametersInformation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParametersInformation;
    /**
     * The Payee
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Payee;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The RegistrationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationLevel;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShortDescription;
    /**
     * The SplittingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SplittingMode;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.PriceModifierDefinition
     * @uses Sales_PriceModifierDefinition::setAclSchemeId()
     * @uses Sales_PriceModifierDefinition::setCalculationBase()
     * @uses Sales_PriceModifierDefinition::setCalculationLevel()
     * @uses Sales_PriceModifierDefinition::setDefaultValueType()
     * @uses Sales_PriceModifierDefinition::setDescription()
     * @uses Sales_PriceModifierDefinition::setExtraDetails()
     * @uses Sales_PriceModifierDefinition::setFeePurpose()
     * @uses Sales_PriceModifierDefinition::setInvisibleInApplicationChannels()
     * @uses Sales_PriceModifierDefinition::setIsAccumulative()
     * @uses Sales_PriceModifierDefinition::setIsActive()
     * @uses Sales_PriceModifierDefinition::setIsAdvancedBooking()
     * @uses Sales_PriceModifierDefinition::setIsPresentAsIncluded()
     * @uses Sales_PriceModifierDefinition::setIsSeatgeekFee()
     * @uses Sales_PriceModifierDefinition::setIsSystem()
     * @uses Sales_PriceModifierDefinition::setIsVatExcluded()
     * @uses Sales_PriceModifierDefinition::setLedgerId()
     * @uses Sales_PriceModifierDefinition::setMaxPerTransaction()
     * @uses Sales_PriceModifierDefinition::setOrganizationUnitId()
     * @uses Sales_PriceModifierDefinition::setParametersInformation()
     * @uses Sales_PriceModifierDefinition::setPayee()
     * @uses Sales_PriceModifierDefinition::setPriority()
     * @uses Sales_PriceModifierDefinition::setProjectIdentifierId()
     * @uses Sales_PriceModifierDefinition::setRegistrationLevel()
     * @uses Sales_PriceModifierDefinition::setShortDescription()
     * @uses Sales_PriceModifierDefinition::setSplittingMode()
     * @uses Sales_PriceModifierDefinition::setSystemName()
     * @uses Sales_PriceModifierDefinition::setType()
     * @uses Sales_PriceModifierDefinition::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $calculationBase
     * @param string $calculationLevel
     * @param string $defaultValueType
     * @param \patest\StructType\GlobalString $description
     * @param string $extraDetails
     * @param string $feePurpose
     * @param string $invisibleInApplicationChannels
     * @param bool $isAccumulative
     * @param bool $isActive
     * @param bool $isAdvancedBooking
     * @param bool $isPresentAsIncluded
     * @param bool $isSeatgeekFee
     * @param bool $isSystem
     * @param bool $isVatExcluded
     * @param string $ledgerId
     * @param \patest\StructType\Money $maxPerTransaction
     * @param string $organizationUnitId
     * @param string $parametersInformation
     * @param string $payee
     * @param int $priority
     * @param string $projectIdentifierId
     * @param string $registrationLevel
     * @param \patest\StructType\GlobalString $shortDescription
     * @param string $splittingMode
     * @param string $systemName
     * @param string $type
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $calculationBase = null, $calculationLevel = null, $defaultValueType = null, \patest\StructType\GlobalString $description = null, $extraDetails = null, $feePurpose = null, $invisibleInApplicationChannels = null, $isAccumulative = null, $isActive = null, $isAdvancedBooking = null, $isPresentAsIncluded = null, $isSeatgeekFee = null, $isSystem = null, $isVatExcluded = null, $ledgerId = null, \patest\StructType\Money $maxPerTransaction = null, $organizationUnitId = null, $parametersInformation = null, $payee = null, $priority = null, $projectIdentifierId = null, $registrationLevel = null, \patest\StructType\GlobalString $shortDescription = null, $splittingMode = null, $systemName = null, $type = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCalculationBase($calculationBase)
            ->setCalculationLevel($calculationLevel)
            ->setDefaultValueType($defaultValueType)
            ->setDescription($description)
            ->setExtraDetails($extraDetails)
            ->setFeePurpose($feePurpose)
            ->setInvisibleInApplicationChannels($invisibleInApplicationChannels)
            ->setIsAccumulative($isAccumulative)
            ->setIsActive($isActive)
            ->setIsAdvancedBooking($isAdvancedBooking)
            ->setIsPresentAsIncluded($isPresentAsIncluded)
            ->setIsSeatgeekFee($isSeatgeekFee)
            ->setIsSystem($isSystem)
            ->setIsVatExcluded($isVatExcluded)
            ->setLedgerId($ledgerId)
            ->setMaxPerTransaction($maxPerTransaction)
            ->setOrganizationUnitId($organizationUnitId)
            ->setParametersInformation($parametersInformation)
            ->setPayee($payee)
            ->setPriority($priority)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setRegistrationLevel($registrationLevel)
            ->setShortDescription($shortDescription)
            ->setSplittingMode($splittingMode)
            ->setSystemName($systemName)
            ->setType($type)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CalculationBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculationBase()
    {
        return isset($this->CalculationBase) ? $this->CalculationBase : null;
    }
    /**
     * Set CalculationBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierCalculationBase::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationBase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationBase
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setCalculationBase($calculationBase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationBase::valueIsValid($calculationBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationBase', is_array($calculationBase) ? implode(', ', $calculationBase) : var_export($calculationBase, true), implode(', ', \patest\EnumType\PriceModifierCalculationBase::getValidValues())), __LINE__);
        }
        if (is_null($calculationBase) || (is_array($calculationBase) && empty($calculationBase))) {
            unset($this->CalculationBase);
        } else {
            $this->CalculationBase = $calculationBase;
        }
        return $this;
    }
    /**
     * Get CalculationLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculationLevel()
    {
        return isset($this->CalculationLevel) ? $this->CalculationLevel : null;
    }
    /**
     * Set CalculationLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierCalculationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationLevel
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setCalculationLevel($calculationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationLevel::valueIsValid($calculationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationLevel', is_array($calculationLevel) ? implode(', ', $calculationLevel) : var_export($calculationLevel, true), implode(', ', \patest\EnumType\PriceModifierCalculationLevel::getValidValues())), __LINE__);
        }
        if (is_null($calculationLevel) || (is_array($calculationLevel) && empty($calculationLevel))) {
            unset($this->CalculationLevel);
        } else {
            $this->CalculationLevel = $calculationLevel;
        }
        return $this;
    }
    /**
     * Get DefaultValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultValueType()
    {
        return isset($this->DefaultValueType) ? $this->DefaultValueType : null;
    }
    /**
     * Set DefaultValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultValueType
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setDefaultValueType($defaultValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($defaultValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($defaultValueType) ? implode(', ', $defaultValueType) : var_export($defaultValueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        if (is_null($defaultValueType) || (is_array($defaultValueType) && empty($defaultValueType))) {
            unset($this->DefaultValueType);
        } else {
            $this->DefaultValueType = $defaultValueType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtraDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDetails()
    {
        return isset($this->ExtraDetails) ? $this->ExtraDetails : null;
    }
    /**
     * Set ExtraDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDetails
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setExtraDetails($extraDetails = null)
    {
        // validation for constraint: string
        if (!is_null($extraDetails) && !is_string($extraDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDetails, true), gettype($extraDetails)), __LINE__);
        }
        if (is_null($extraDetails) || (is_array($extraDetails) && empty($extraDetails))) {
            unset($this->ExtraDetails);
        } else {
            $this->ExtraDetails = $extraDetails;
        }
        return $this;
    }
    /**
     * Get FeePurpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeePurpose()
    {
        return isset($this->FeePurpose) ? $this->FeePurpose : null;
    }
    /**
     * Set FeePurpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierFeePurpose::valueIsValid()
     * @uses \patest\EnumType\PriceModifierFeePurpose::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feePurpose
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setFeePurpose($feePurpose = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierFeePurpose::valueIsValid($feePurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierFeePurpose', is_array($feePurpose) ? implode(', ', $feePurpose) : var_export($feePurpose, true), implode(', ', \patest\EnumType\PriceModifierFeePurpose::getValidValues())), __LINE__);
        }
        if (is_null($feePurpose) || (is_array($feePurpose) && empty($feePurpose))) {
            unset($this->FeePurpose);
        } else {
            $this->FeePurpose = $feePurpose;
        }
        return $this;
    }
    /**
     * Get InvisibleInApplicationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvisibleInApplicationChannels()
    {
        return isset($this->InvisibleInApplicationChannels) ? $this->InvisibleInApplicationChannels : null;
    }
    /**
     * Set InvisibleInApplicationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invisibleInApplicationChannels
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setInvisibleInApplicationChannels($invisibleInApplicationChannels = null)
    {
        // validation for constraint: string
        if (!is_null($invisibleInApplicationChannels) && !is_string($invisibleInApplicationChannels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invisibleInApplicationChannels, true), gettype($invisibleInApplicationChannels)), __LINE__);
        }
        if (is_null($invisibleInApplicationChannels) || (is_array($invisibleInApplicationChannels) && empty($invisibleInApplicationChannels))) {
            unset($this->InvisibleInApplicationChannels);
        } else {
            $this->InvisibleInApplicationChannels = $invisibleInApplicationChannels;
        }
        return $this;
    }
    /**
     * Get IsAccumulative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccumulative()
    {
        return isset($this->IsAccumulative) ? $this->IsAccumulative : null;
    }
    /**
     * Set IsAccumulative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccumulative
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsAccumulative($isAccumulative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccumulative) && !is_bool($isAccumulative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccumulative, true), gettype($isAccumulative)), __LINE__);
        }
        if (is_null($isAccumulative) || (is_array($isAccumulative) && empty($isAccumulative))) {
            unset($this->IsAccumulative);
        } else {
            $this->IsAccumulative = $isAccumulative;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAdvancedBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAdvancedBooking()
    {
        return isset($this->IsAdvancedBooking) ? $this->IsAdvancedBooking : null;
    }
    /**
     * Set IsAdvancedBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAdvancedBooking
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsAdvancedBooking($isAdvancedBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdvancedBooking) && !is_bool($isAdvancedBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAdvancedBooking, true), gettype($isAdvancedBooking)), __LINE__);
        }
        if (is_null($isAdvancedBooking) || (is_array($isAdvancedBooking) && empty($isAdvancedBooking))) {
            unset($this->IsAdvancedBooking);
        } else {
            $this->IsAdvancedBooking = $isAdvancedBooking;
        }
        return $this;
    }
    /**
     * Get IsPresentAsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPresentAsIncluded()
    {
        return isset($this->IsPresentAsIncluded) ? $this->IsPresentAsIncluded : null;
    }
    /**
     * Set IsPresentAsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPresentAsIncluded
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsPresentAsIncluded($isPresentAsIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPresentAsIncluded) && !is_bool($isPresentAsIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPresentAsIncluded, true), gettype($isPresentAsIncluded)), __LINE__);
        }
        if (is_null($isPresentAsIncluded) || (is_array($isPresentAsIncluded) && empty($isPresentAsIncluded))) {
            unset($this->IsPresentAsIncluded);
        } else {
            $this->IsPresentAsIncluded = $isPresentAsIncluded;
        }
        return $this;
    }
    /**
     * Get IsSeatgeekFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeatgeekFee()
    {
        return isset($this->IsSeatgeekFee) ? $this->IsSeatgeekFee : null;
    }
    /**
     * Set IsSeatgeekFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeatgeekFee
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsSeatgeekFee($isSeatgeekFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeatgeekFee) && !is_bool($isSeatgeekFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeatgeekFee, true), gettype($isSeatgeekFee)), __LINE__);
        }
        if (is_null($isSeatgeekFee) || (is_array($isSeatgeekFee) && empty($isSeatgeekFee))) {
            unset($this->IsSeatgeekFee);
        } else {
            $this->IsSeatgeekFee = $isSeatgeekFee;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get IsVatExcluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVatExcluded()
    {
        return isset($this->IsVatExcluded) ? $this->IsVatExcluded : null;
    }
    /**
     * Set IsVatExcluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVatExcluded
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setIsVatExcluded($isVatExcluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVatExcluded) && !is_bool($isVatExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVatExcluded, true), gettype($isVatExcluded)), __LINE__);
        }
        if (is_null($isVatExcluded) || (is_array($isVatExcluded) && empty($isVatExcluded))) {
            unset($this->IsVatExcluded);
        } else {
            $this->IsVatExcluded = $isVatExcluded;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaxPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxPerTransaction()
    {
        return isset($this->MaxPerTransaction) ? $this->MaxPerTransaction : null;
    }
    /**
     * Set MaxPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxPerTransaction
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setMaxPerTransaction(\patest\StructType\Money $maxPerTransaction = null)
    {
        if (is_null($maxPerTransaction) || (is_array($maxPerTransaction) && empty($maxPerTransaction))) {
            unset($this->MaxPerTransaction);
        } else {
            $this->MaxPerTransaction = $maxPerTransaction;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ParametersInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParametersInformation()
    {
        return isset($this->ParametersInformation) ? $this->ParametersInformation : null;
    }
    /**
     * Set ParametersInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parametersInformation
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setParametersInformation($parametersInformation = null)
    {
        // validation for constraint: string
        if (!is_null($parametersInformation) && !is_string($parametersInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parametersInformation, true), gettype($parametersInformation)), __LINE__);
        }
        if (is_null($parametersInformation) || (is_array($parametersInformation) && empty($parametersInformation))) {
            unset($this->ParametersInformation);
        } else {
            $this->ParametersInformation = $parametersInformation;
        }
        return $this;
    }
    /**
     * Get Payee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayee()
    {
        return isset($this->Payee) ? $this->Payee : null;
    }
    /**
     * Set Payee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payee
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setPayee($payee = null)
    {
        // validation for constraint: string
        if (!is_null($payee) && !is_string($payee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payee, true), gettype($payee)), __LINE__);
        }
        if (is_null($payee) || (is_array($payee) && empty($payee))) {
            unset($this->Payee);
        } else {
            $this->Payee = $payee;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get RegistrationLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationLevel()
    {
        return isset($this->RegistrationLevel) ? $this->RegistrationLevel : null;
    }
    /**
     * Set RegistrationLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registrationLevel
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setRegistrationLevel($registrationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierRegistrationLevel::valueIsValid($registrationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierRegistrationLevel', is_array($registrationLevel) ? implode(', ', $registrationLevel) : var_export($registrationLevel, true), implode(', ', \patest\EnumType\PriceModifierRegistrationLevel::getValidValues())), __LINE__);
        }
        if (is_null($registrationLevel) || (is_array($registrationLevel) && empty($registrationLevel))) {
            unset($this->RegistrationLevel);
        } else {
            $this->RegistrationLevel = $registrationLevel;
        }
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $shortDescription
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setShortDescription(\patest\StructType\GlobalString $shortDescription = null)
    {
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Get SplittingMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSplittingMode()
    {
        return isset($this->SplittingMode) ? $this->SplittingMode : null;
    }
    /**
     * Set SplittingMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierSplittingMode::valueIsValid()
     * @uses \patest\EnumType\PriceModifierSplittingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splittingMode
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setSplittingMode($splittingMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierSplittingMode::valueIsValid($splittingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierSplittingMode', is_array($splittingMode) ? implode(', ', $splittingMode) : var_export($splittingMode, true), implode(', ', \patest\EnumType\PriceModifierSplittingMode::getValidValues())), __LINE__);
        }
        if (is_null($splittingMode) || (is_array($splittingMode) && empty($splittingMode))) {
            unset($this->SplittingMode);
        } else {
            $this->SplittingMode = $splittingMode;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_PriceModifierDefinition
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
