<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceListPriceType StructType
 * @subpackage Structs
 */
class Sales_PriceListPriceType extends PersistableEntity
{
    /**
     * The DefaultPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DefaultPrice;
    /**
     * The IsComputed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComputed;
    /**
     * The NominalDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NominalDiscount;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The PercentDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PercentDiscount;
    /**
     * The PriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceListPriceLevel
     */
    public $PriceLevels;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Remark;
    /**
     * Constructor method for Sales.PriceListPriceType
     * @uses Sales_PriceListPriceType::setDefaultPrice()
     * @uses Sales_PriceListPriceType::setIsComputed()
     * @uses Sales_PriceListPriceType::setNominalDiscount()
     * @uses Sales_PriceListPriceType::setOrdinal()
     * @uses Sales_PriceListPriceType::setPercentDiscount()
     * @uses Sales_PriceListPriceType::setPriceLevels()
     * @uses Sales_PriceListPriceType::setPriceListId()
     * @uses Sales_PriceListPriceType::setPriceTypeId()
     * @uses Sales_PriceListPriceType::setPriceTypeName()
     * @uses Sales_PriceListPriceType::setRemark()
     * @param float $defaultPrice
     * @param bool $isComputed
     * @param float $nominalDiscount
     * @param int $ordinal
     * @param float $percentDiscount
     * @param \patest\StructType\RecordSetOfSales_PriceListPriceLevel $priceLevels
     * @param string $priceListId
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param \patest\StructType\GlobalString $remark
     */
    public function __construct($defaultPrice = null, $isComputed = null, $nominalDiscount = null, $ordinal = null, $percentDiscount = null, \patest\StructType\RecordSetOfSales_PriceListPriceLevel $priceLevels = null, $priceListId = null, $priceTypeId = null, $priceTypeName = null, \patest\StructType\GlobalString $remark = null)
    {
        $this
            ->setDefaultPrice($defaultPrice)
            ->setIsComputed($isComputed)
            ->setNominalDiscount($nominalDiscount)
            ->setOrdinal($ordinal)
            ->setPercentDiscount($percentDiscount)
            ->setPriceLevels($priceLevels)
            ->setPriceListId($priceListId)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setRemark($remark);
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $defaultPrice
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setDefaultPrice($defaultPrice = null)
    {
        // validation for constraint: float
        if (!is_null($defaultPrice) && !(is_float($defaultPrice) || is_numeric($defaultPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultPrice, true), gettype($defaultPrice)), __LINE__);
        }
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get IsComputed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComputed()
    {
        return isset($this->IsComputed) ? $this->IsComputed : null;
    }
    /**
     * Set IsComputed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComputed
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setIsComputed($isComputed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComputed) && !is_bool($isComputed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComputed, true), gettype($isComputed)), __LINE__);
        }
        if (is_null($isComputed) || (is_array($isComputed) && empty($isComputed))) {
            unset($this->IsComputed);
        } else {
            $this->IsComputed = $isComputed;
        }
        return $this;
    }
    /**
     * Get NominalDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNominalDiscount()
    {
        return isset($this->NominalDiscount) ? $this->NominalDiscount : null;
    }
    /**
     * Set NominalDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nominalDiscount
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setNominalDiscount($nominalDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($nominalDiscount) && !(is_float($nominalDiscount) || is_numeric($nominalDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nominalDiscount, true), gettype($nominalDiscount)), __LINE__);
        }
        if (is_null($nominalDiscount) || (is_array($nominalDiscount) && empty($nominalDiscount))) {
            unset($this->NominalDiscount);
        } else {
            $this->NominalDiscount = $nominalDiscount;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get PercentDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercentDiscount()
    {
        return isset($this->PercentDiscount) ? $this->PercentDiscount : null;
    }
    /**
     * Set PercentDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percentDiscount
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setPercentDiscount($percentDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($percentDiscount) && !(is_float($percentDiscount) || is_numeric($percentDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentDiscount, true), gettype($percentDiscount)), __LINE__);
        }
        if (is_null($percentDiscount) || (is_array($percentDiscount) && empty($percentDiscount))) {
            unset($this->PercentDiscount);
        } else {
            $this->PercentDiscount = $percentDiscount;
        }
        return $this;
    }
    /**
     * Get PriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceListPriceLevel|null
     */
    public function getPriceLevels()
    {
        return isset($this->PriceLevels) ? $this->PriceLevels : null;
    }
    /**
     * Set PriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceListPriceLevel $priceLevels
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setPriceLevels(\patest\StructType\RecordSetOfSales_PriceListPriceLevel $priceLevels = null)
    {
        if (is_null($priceLevels) || (is_array($priceLevels) && empty($priceLevels))) {
            unset($this->PriceLevels);
        } else {
            $this->PriceLevels = $priceLevels;
        }
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $remark
     * @return \patest\StructType\Sales_PriceListPriceType
     */
    public function setRemark(\patest\StructType\GlobalString $remark = null)
    {
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
}
