<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PaymentTerm StructType
 * @subpackage Structs
 */
class Sales_PaymentTerm extends DistributableEntity
{
    /**
     * The AdditionalDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AdditionalDays;
    /**
     * The BasicDateCalculation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:BasicDateCalculationKind
     * @var string
     */
    public $BasicDateCalculation;
    /**
     * The BasicMethodCalculation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasicMethodCalculation;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.PaymentTerm
     * @uses Sales_PaymentTerm::setAdditionalDays()
     * @uses Sales_PaymentTerm::setBasicDateCalculation()
     * @uses Sales_PaymentTerm::setBasicMethodCalculation()
     * @uses Sales_PaymentTerm::setName()
     * @uses Sales_PaymentTerm::setOrganizationUnitId()
     * @uses Sales_PaymentTerm::setVisibleBySubordinates()
     * @param int $additionalDays
     * @param string $basicDateCalculation
     * @param string $basicMethodCalculation
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($additionalDays = null, $basicDateCalculation = null, $basicMethodCalculation = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAdditionalDays($additionalDays)
            ->setBasicDateCalculation($basicDateCalculation)
            ->setBasicMethodCalculation($basicMethodCalculation)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AdditionalDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAdditionalDays()
    {
        return isset($this->AdditionalDays) ? $this->AdditionalDays : null;
    }
    /**
     * Set AdditionalDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $additionalDays
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setAdditionalDays($additionalDays = null)
    {
        // validation for constraint: int
        if (!is_null($additionalDays) && !(is_int($additionalDays) || ctype_digit($additionalDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalDays, true), gettype($additionalDays)), __LINE__);
        }
        if (is_null($additionalDays) || (is_array($additionalDays) && empty($additionalDays))) {
            unset($this->AdditionalDays);
        } else {
            $this->AdditionalDays = $additionalDays;
        }
        return $this;
    }
    /**
     * Get BasicDateCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasicDateCalculation()
    {
        return isset($this->BasicDateCalculation) ? $this->BasicDateCalculation : null;
    }
    /**
     * Set BasicDateCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basicDateCalculation
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setBasicDateCalculation($basicDateCalculation = null)
    {
        // validation for constraint: string
        if (!is_null($basicDateCalculation) && !is_string($basicDateCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basicDateCalculation, true), gettype($basicDateCalculation)), __LINE__);
        }
        if (is_null($basicDateCalculation) || (is_array($basicDateCalculation) && empty($basicDateCalculation))) {
            unset($this->BasicDateCalculation);
        } else {
            $this->BasicDateCalculation = $basicDateCalculation;
        }
        return $this;
    }
    /**
     * Get BasicMethodCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasicMethodCalculation()
    {
        return isset($this->BasicMethodCalculation) ? $this->BasicMethodCalculation : null;
    }
    /**
     * Set BasicMethodCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BasicMethodCalculationKind::valueIsValid()
     * @uses \patest\EnumType\BasicMethodCalculationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basicMethodCalculation
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setBasicMethodCalculation($basicMethodCalculation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BasicMethodCalculationKind::valueIsValid($basicMethodCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BasicMethodCalculationKind', is_array($basicMethodCalculation) ? implode(', ', $basicMethodCalculation) : var_export($basicMethodCalculation, true), implode(', ', \patest\EnumType\BasicMethodCalculationKind::getValidValues())), __LINE__);
        }
        if (is_null($basicMethodCalculation) || (is_array($basicMethodCalculation) && empty($basicMethodCalculation))) {
            unset($this->BasicMethodCalculation);
        } else {
            $this->BasicMethodCalculation = $basicMethodCalculation;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_PaymentTerm
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
