<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.MembershipTransactionItemInfo StructType
 * @subpackage Structs
 */
class Sales_MembershipTransactionItemInfo extends Sales_TransactionItemInfo
{
    /**
     * The AllianceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllianceId;
    /**
     * The AllianceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllianceName;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The IsBenefitsShared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBenefitsShared;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJoint;
    /**
     * The IsJointOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsJointOwners;
    /**
     * The IsRenewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRenewed;
    /**
     * The JointMembershipPrintingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipPrintingOption;
    /**
     * The JointOwnersDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointOwnersDetails;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipDefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipDefinitionName;
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The MemberSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberSince;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The NumberOfJointOwnersAllowedByPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfJointOwnersAllowedByPlan;
    /**
     * The OldMembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OldMembershipDefinitionId;
    /**
     * The OldMembershipName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldMembershipName;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The RenewedExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewedExpiryDate;
    /**
     * The RenewedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedId;
    /**
     * The RenewedInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedInstanceId;
    /**
     * The RequestedOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedOperation;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The SchemeLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeLevelId;
    /**
     * The SchemeLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeLevelName;
    /**
     * The SchemeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeName;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The UpdateOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfInstanceId;
    /**
     * The UpgradeOnlyMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpgradeOnlyMode;
    /**
     * Constructor method for Sales.MembershipTransactionItemInfo
     * @uses Sales_MembershipTransactionItemInfo::setAllianceId()
     * @uses Sales_MembershipTransactionItemInfo::setAllianceName()
     * @uses Sales_MembershipTransactionItemInfo::setEndDate()
     * @uses Sales_MembershipTransactionItemInfo::setIsBenefitsShared()
     * @uses Sales_MembershipTransactionItemInfo::setIsGift()
     * @uses Sales_MembershipTransactionItemInfo::setIsJoint()
     * @uses Sales_MembershipTransactionItemInfo::setIsJointOwners()
     * @uses Sales_MembershipTransactionItemInfo::setIsRenewed()
     * @uses Sales_MembershipTransactionItemInfo::setJointMembershipPrintingOption()
     * @uses Sales_MembershipTransactionItemInfo::setJointOwnersDetails()
     * @uses Sales_MembershipTransactionItemInfo::setMembershipDefinitionId()
     * @uses Sales_MembershipTransactionItemInfo::setMembershipDefinitionName()
     * @uses Sales_MembershipTransactionItemInfo::setMembershipId()
     * @uses Sales_MembershipTransactionItemInfo::setMembershipNumber()
     * @uses Sales_MembershipTransactionItemInfo::setMemberSince()
     * @uses Sales_MembershipTransactionItemInfo::setNameOnCard()
     * @uses Sales_MembershipTransactionItemInfo::setNumberOfJointOwnersAllowedByPlan()
     * @uses Sales_MembershipTransactionItemInfo::setOldMembershipDefinitionId()
     * @uses Sales_MembershipTransactionItemInfo::setOldMembershipName()
     * @uses Sales_MembershipTransactionItemInfo::setPrintCount()
     * @uses Sales_MembershipTransactionItemInfo::setRenewedExpiryDate()
     * @uses Sales_MembershipTransactionItemInfo::setRenewedId()
     * @uses Sales_MembershipTransactionItemInfo::setRenewedInstanceId()
     * @uses Sales_MembershipTransactionItemInfo::setRequestedOperation()
     * @uses Sales_MembershipTransactionItemInfo::setSchemeId()
     * @uses Sales_MembershipTransactionItemInfo::setSchemeLevelId()
     * @uses Sales_MembershipTransactionItemInfo::setSchemeLevelName()
     * @uses Sales_MembershipTransactionItemInfo::setSchemeName()
     * @uses Sales_MembershipTransactionItemInfo::setStartDate()
     * @uses Sales_MembershipTransactionItemInfo::setStatus()
     * @uses Sales_MembershipTransactionItemInfo::setUpdateOfInstanceId()
     * @uses Sales_MembershipTransactionItemInfo::setUpgradeOnlyMode()
     * @param string $allianceId
     * @param string $allianceName
     * @param string $endDate
     * @param bool $isBenefitsShared
     * @param bool $isGift
     * @param bool $isJoint
     * @param string $isJointOwners
     * @param bool $isRenewed
     * @param string $jointMembershipPrintingOption
     * @param string $jointOwnersDetails
     * @param string $membershipDefinitionId
     * @param string $membershipDefinitionName
     * @param string $membershipId
     * @param string $membershipNumber
     * @param string $memberSince
     * @param string $nameOnCard
     * @param int $numberOfJointOwnersAllowedByPlan
     * @param string $oldMembershipDefinitionId
     * @param string $oldMembershipName
     * @param int $printCount
     * @param string $renewedExpiryDate
     * @param string $renewedId
     * @param string $renewedInstanceId
     * @param string $requestedOperation
     * @param string $schemeId
     * @param string $schemeLevelId
     * @param string $schemeLevelName
     * @param string $schemeName
     * @param string $startDate
     * @param string $status
     * @param string $updateOfInstanceId
     * @param bool $upgradeOnlyMode
     */
    public function __construct($allianceId = null, $allianceName = null, $endDate = null, $isBenefitsShared = null, $isGift = null, $isJoint = null, $isJointOwners = null, $isRenewed = null, $jointMembershipPrintingOption = null, $jointOwnersDetails = null, $membershipDefinitionId = null, $membershipDefinitionName = null, $membershipId = null, $membershipNumber = null, $memberSince = null, $nameOnCard = null, $numberOfJointOwnersAllowedByPlan = null, $oldMembershipDefinitionId = null, $oldMembershipName = null, $printCount = null, $renewedExpiryDate = null, $renewedId = null, $renewedInstanceId = null, $requestedOperation = null, $schemeId = null, $schemeLevelId = null, $schemeLevelName = null, $schemeName = null, $startDate = null, $status = null, $updateOfInstanceId = null, $upgradeOnlyMode = null)
    {
        $this
            ->setAllianceId($allianceId)
            ->setAllianceName($allianceName)
            ->setEndDate($endDate)
            ->setIsBenefitsShared($isBenefitsShared)
            ->setIsGift($isGift)
            ->setIsJoint($isJoint)
            ->setIsJointOwners($isJointOwners)
            ->setIsRenewed($isRenewed)
            ->setJointMembershipPrintingOption($jointMembershipPrintingOption)
            ->setJointOwnersDetails($jointOwnersDetails)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipDefinitionName($membershipDefinitionName)
            ->setMembershipId($membershipId)
            ->setMembershipNumber($membershipNumber)
            ->setMemberSince($memberSince)
            ->setNameOnCard($nameOnCard)
            ->setNumberOfJointOwnersAllowedByPlan($numberOfJointOwnersAllowedByPlan)
            ->setOldMembershipDefinitionId($oldMembershipDefinitionId)
            ->setOldMembershipName($oldMembershipName)
            ->setPrintCount($printCount)
            ->setRenewedExpiryDate($renewedExpiryDate)
            ->setRenewedId($renewedId)
            ->setRenewedInstanceId($renewedInstanceId)
            ->setRequestedOperation($requestedOperation)
            ->setSchemeId($schemeId)
            ->setSchemeLevelId($schemeLevelId)
            ->setSchemeLevelName($schemeLevelName)
            ->setSchemeName($schemeName)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setUpdateOfInstanceId($updateOfInstanceId)
            ->setUpgradeOnlyMode($upgradeOnlyMode);
    }
    /**
     * Get AllianceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceId()
    {
        return isset($this->AllianceId) ? $this->AllianceId : null;
    }
    /**
     * Set AllianceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setAllianceId($allianceId = null)
    {
        // validation for constraint: string
        if (!is_null($allianceId) && !is_string($allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceId, true), gettype($allianceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allianceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allianceId, true)), __LINE__);
        }
        if (is_null($allianceId) || (is_array($allianceId) && empty($allianceId))) {
            unset($this->AllianceId);
        } else {
            $this->AllianceId = $allianceId;
        }
        return $this;
    }
    /**
     * Get AllianceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceName()
    {
        return isset($this->AllianceName) ? $this->AllianceName : null;
    }
    /**
     * Set AllianceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceName
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setAllianceName($allianceName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceName) && !is_string($allianceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceName, true), gettype($allianceName)), __LINE__);
        }
        if (is_null($allianceName) || (is_array($allianceName) && empty($allianceName))) {
            unset($this->AllianceName);
        } else {
            $this->AllianceName = $allianceName;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get IsBenefitsShared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBenefitsShared()
    {
        return isset($this->IsBenefitsShared) ? $this->IsBenefitsShared : null;
    }
    /**
     * Set IsBenefitsShared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBenefitsShared
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setIsBenefitsShared($isBenefitsShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBenefitsShared) && !is_bool($isBenefitsShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBenefitsShared, true), gettype($isBenefitsShared)), __LINE__);
        }
        if (is_null($isBenefitsShared) || (is_array($isBenefitsShared) && empty($isBenefitsShared))) {
            unset($this->IsBenefitsShared);
        } else {
            $this->IsBenefitsShared = $isBenefitsShared;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get IsJoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJoint()
    {
        return isset($this->IsJoint) ? $this->IsJoint : null;
    }
    /**
     * Set IsJoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJoint
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        if (is_null($isJoint) || (is_array($isJoint) && empty($isJoint))) {
            unset($this->IsJoint);
        } else {
            $this->IsJoint = $isJoint;
        }
        return $this;
    }
    /**
     * Get IsJointOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsJointOwners()
    {
        return isset($this->IsJointOwners) ? $this->IsJointOwners : null;
    }
    /**
     * Set IsJointOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointOnwersStatus::valueIsValid()
     * @uses \patest\EnumType\JointOnwersStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isJointOwners
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setIsJointOwners($isJointOwners = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointOnwersStatus::valueIsValid($isJointOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointOnwersStatus', is_array($isJointOwners) ? implode(', ', $isJointOwners) : var_export($isJointOwners, true), implode(', ', \patest\EnumType\JointOnwersStatus::getValidValues())), __LINE__);
        }
        if (is_null($isJointOwners) || (is_array($isJointOwners) && empty($isJointOwners))) {
            unset($this->IsJointOwners);
        } else {
            $this->IsJointOwners = $isJointOwners;
        }
        return $this;
    }
    /**
     * Get IsRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRenewed()
    {
        return isset($this->IsRenewed) ? $this->IsRenewed : null;
    }
    /**
     * Set IsRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRenewed
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setIsRenewed($isRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewed) && !is_bool($isRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRenewed, true), gettype($isRenewed)), __LINE__);
        }
        if (is_null($isRenewed) || (is_array($isRenewed) && empty($isRenewed))) {
            unset($this->IsRenewed);
        } else {
            $this->IsRenewed = $isRenewed;
        }
        return $this;
    }
    /**
     * Get JointMembershipPrintingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPrintingOption()
    {
        return isset($this->JointMembershipPrintingOption) ? $this->JointMembershipPrintingOption : null;
    }
    /**
     * Set JointMembershipPrintingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipPrintingOption::valueIsValid()
     * @uses \patest\EnumType\JointMembershipPrintingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipPrintingOption
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setJointMembershipPrintingOption($jointMembershipPrintingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipPrintingOption::valueIsValid($jointMembershipPrintingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipPrintingOption', is_array($jointMembershipPrintingOption) ? implode(', ', $jointMembershipPrintingOption) : var_export($jointMembershipPrintingOption, true), implode(', ', \patest\EnumType\JointMembershipPrintingOption::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipPrintingOption) || (is_array($jointMembershipPrintingOption) && empty($jointMembershipPrintingOption))) {
            unset($this->JointMembershipPrintingOption);
        } else {
            $this->JointMembershipPrintingOption = $jointMembershipPrintingOption;
        }
        return $this;
    }
    /**
     * Get JointOwnersDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointOwnersDetails()
    {
        return isset($this->JointOwnersDetails) ? $this->JointOwnersDetails : null;
    }
    /**
     * Set JointOwnersDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointOwnersDetails
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setJointOwnersDetails($jointOwnersDetails = null)
    {
        // validation for constraint: string
        if (!is_null($jointOwnersDetails) && !is_string($jointOwnersDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointOwnersDetails, true), gettype($jointOwnersDetails)), __LINE__);
        }
        if (is_null($jointOwnersDetails) || (is_array($jointOwnersDetails) && empty($jointOwnersDetails))) {
            unset($this->JointOwnersDetails);
        } else {
            $this->JointOwnersDetails = $jointOwnersDetails;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionName()
    {
        return isset($this->MembershipDefinitionName) ? $this->MembershipDefinitionName : null;
    }
    /**
     * Set MembershipDefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionName
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setMembershipDefinitionName($membershipDefinitionName = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionName) && !is_string($membershipDefinitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionName, true), gettype($membershipDefinitionName)), __LINE__);
        }
        if (is_null($membershipDefinitionName) || (is_array($membershipDefinitionName) && empty($membershipDefinitionName))) {
            unset($this->MembershipDefinitionName);
        } else {
            $this->MembershipDefinitionName = $membershipDefinitionName;
        }
        return $this;
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get MemberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberSince()
    {
        return isset($this->MemberSince) ? $this->MemberSince : null;
    }
    /**
     * Set MemberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberSince
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setMemberSince($memberSince = null)
    {
        // validation for constraint: string
        if (!is_null($memberSince) && !is_string($memberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberSince, true), gettype($memberSince)), __LINE__);
        }
        if (is_null($memberSince) || (is_array($memberSince) && empty($memberSince))) {
            unset($this->MemberSince);
        } else {
            $this->MemberSince = $memberSince;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get NumberOfJointOwnersAllowedByPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfJointOwnersAllowedByPlan()
    {
        return isset($this->NumberOfJointOwnersAllowedByPlan) ? $this->NumberOfJointOwnersAllowedByPlan : null;
    }
    /**
     * Set NumberOfJointOwnersAllowedByPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfJointOwnersAllowedByPlan
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setNumberOfJointOwnersAllowedByPlan($numberOfJointOwnersAllowedByPlan = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfJointOwnersAllowedByPlan) && !(is_int($numberOfJointOwnersAllowedByPlan) || ctype_digit($numberOfJointOwnersAllowedByPlan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfJointOwnersAllowedByPlan, true), gettype($numberOfJointOwnersAllowedByPlan)), __LINE__);
        }
        if (is_null($numberOfJointOwnersAllowedByPlan) || (is_array($numberOfJointOwnersAllowedByPlan) && empty($numberOfJointOwnersAllowedByPlan))) {
            unset($this->NumberOfJointOwnersAllowedByPlan);
        } else {
            $this->NumberOfJointOwnersAllowedByPlan = $numberOfJointOwnersAllowedByPlan;
        }
        return $this;
    }
    /**
     * Get OldMembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipDefinitionId()
    {
        return isset($this->OldMembershipDefinitionId) ? $this->OldMembershipDefinitionId : null;
    }
    /**
     * Set OldMembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipDefinitionId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setOldMembershipDefinitionId($oldMembershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipDefinitionId) && !is_string($oldMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipDefinitionId, true), gettype($oldMembershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oldMembershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oldMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oldMembershipDefinitionId, true)), __LINE__);
        }
        if (is_null($oldMembershipDefinitionId) || (is_array($oldMembershipDefinitionId) && empty($oldMembershipDefinitionId))) {
            unset($this->OldMembershipDefinitionId);
        } else {
            $this->OldMembershipDefinitionId = $oldMembershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get OldMembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipName()
    {
        return isset($this->OldMembershipName) ? $this->OldMembershipName : null;
    }
    /**
     * Set OldMembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipName
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setOldMembershipName($oldMembershipName = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipName) && !is_string($oldMembershipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipName, true), gettype($oldMembershipName)), __LINE__);
        }
        if (is_null($oldMembershipName) || (is_array($oldMembershipName) && empty($oldMembershipName))) {
            unset($this->OldMembershipName);
        } else {
            $this->OldMembershipName = $oldMembershipName;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get RenewedExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedExpiryDate()
    {
        return isset($this->RenewedExpiryDate) ? $this->RenewedExpiryDate : null;
    }
    /**
     * Set RenewedExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedExpiryDate
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setRenewedExpiryDate($renewedExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($renewedExpiryDate) && !is_string($renewedExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedExpiryDate, true), gettype($renewedExpiryDate)), __LINE__);
        }
        if (is_null($renewedExpiryDate) || (is_array($renewedExpiryDate) && empty($renewedExpiryDate))) {
            unset($this->RenewedExpiryDate);
        } else {
            $this->RenewedExpiryDate = $renewedExpiryDate;
        }
        return $this;
    }
    /**
     * Get RenewedId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedId()
    {
        return isset($this->RenewedId) ? $this->RenewedId : null;
    }
    /**
     * Set RenewedId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setRenewedId($renewedId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedId) && !is_string($renewedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedId, true), gettype($renewedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedId, true)), __LINE__);
        }
        if (is_null($renewedId) || (is_array($renewedId) && empty($renewedId))) {
            unset($this->RenewedId);
        } else {
            $this->RenewedId = $renewedId;
        }
        return $this;
    }
    /**
     * Get RenewedInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedInstanceId()
    {
        return isset($this->RenewedInstanceId) ? $this->RenewedInstanceId : null;
    }
    /**
     * Set RenewedInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedInstanceId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setRenewedInstanceId($renewedInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedInstanceId) && !is_string($renewedInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedInstanceId, true), gettype($renewedInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedInstanceId, true)), __LINE__);
        }
        if (is_null($renewedInstanceId) || (is_array($renewedInstanceId) && empty($renewedInstanceId))) {
            unset($this->RenewedInstanceId);
        } else {
            $this->RenewedInstanceId = $renewedInstanceId;
        }
        return $this;
    }
    /**
     * Get RequestedOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedOperation()
    {
        return isset($this->RequestedOperation) ? $this->RequestedOperation : null;
    }
    /**
     * Set RequestedOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipRequestedOperation::valueIsValid()
     * @uses \patest\EnumType\MembershipRequestedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedOperation
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setRequestedOperation($requestedOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRequestedOperation::valueIsValid($requestedOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRequestedOperation', is_array($requestedOperation) ? implode(', ', $requestedOperation) : var_export($requestedOperation, true), implode(', ', \patest\EnumType\MembershipRequestedOperation::getValidValues())), __LINE__);
        }
        if (is_null($requestedOperation) || (is_array($requestedOperation) && empty($requestedOperation))) {
            unset($this->RequestedOperation);
        } else {
            $this->RequestedOperation = $requestedOperation;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelId()
    {
        return isset($this->SchemeLevelId) ? $this->SchemeLevelId : null;
    }
    /**
     * Set SchemeLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setSchemeLevelId($schemeLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelId) && !is_string($schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelId, true), gettype($schemeLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeLevelId, true)), __LINE__);
        }
        if (is_null($schemeLevelId) || (is_array($schemeLevelId) && empty($schemeLevelId))) {
            unset($this->SchemeLevelId);
        } else {
            $this->SchemeLevelId = $schemeLevelId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelName()
    {
        return isset($this->SchemeLevelName) ? $this->SchemeLevelName : null;
    }
    /**
     * Set SchemeLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelName
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setSchemeLevelName($schemeLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelName) && !is_string($schemeLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelName, true), gettype($schemeLevelName)), __LINE__);
        }
        if (is_null($schemeLevelName) || (is_array($schemeLevelName) && empty($schemeLevelName))) {
            unset($this->SchemeLevelName);
        } else {
            $this->SchemeLevelName = $schemeLevelName;
        }
        return $this;
    }
    /**
     * Get SchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeName()
    {
        return isset($this->SchemeName) ? $this->SchemeName : null;
    }
    /**
     * Set SchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeName
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setSchemeName($schemeName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeName) && !is_string($schemeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeName, true), gettype($schemeName)), __LINE__);
        }
        if (is_null($schemeName) || (is_array($schemeName) && empty($schemeName))) {
            unset($this->SchemeName);
        } else {
            $this->SchemeName = $schemeName;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UpdateOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfInstanceId()
    {
        return isset($this->UpdateOfInstanceId) ? $this->UpdateOfInstanceId : null;
    }
    /**
     * Set UpdateOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfInstanceId
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setUpdateOfInstanceId($updateOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfInstanceId) && !is_string($updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfInstanceId, true), gettype($updateOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfInstanceId, true)), __LINE__);
        }
        if (is_null($updateOfInstanceId) || (is_array($updateOfInstanceId) && empty($updateOfInstanceId))) {
            unset($this->UpdateOfInstanceId);
        } else {
            $this->UpdateOfInstanceId = $updateOfInstanceId;
        }
        return $this;
    }
    /**
     * Get UpgradeOnlyMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpgradeOnlyMode()
    {
        return isset($this->UpgradeOnlyMode) ? $this->UpgradeOnlyMode : null;
    }
    /**
     * Set UpgradeOnlyMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $upgradeOnlyMode
     * @return \patest\StructType\Sales_MembershipTransactionItemInfo
     */
    public function setUpgradeOnlyMode($upgradeOnlyMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeOnlyMode) && !is_bool($upgradeOnlyMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeOnlyMode, true), gettype($upgradeOnlyMode)), __LINE__);
        }
        if (is_null($upgradeOnlyMode) || (is_array($upgradeOnlyMode) && empty($upgradeOnlyMode))) {
            unset($this->UpgradeOnlyMode);
        } else {
            $this->UpgradeOnlyMode = $upgradeOnlyMode;
        }
        return $this;
    }
}
