<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ItemBenefitUtilization StructType
 * @subpackage Structs
 */
class Sales_ItemBenefitUtilization extends PersistableEntity
{
    /**
     * The BenefitElementInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitElementInstanceId;
    /**
     * The ItemIdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemIdInTransaction;
    /**
     * The TransactionLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionLocalId;
    /**
     * Constructor method for Sales.ItemBenefitUtilization
     * @uses Sales_ItemBenefitUtilization::setBenefitElementInstanceId()
     * @uses Sales_ItemBenefitUtilization::setItemIdInTransaction()
     * @uses Sales_ItemBenefitUtilization::setTransactionLocalId()
     * @param string $benefitElementInstanceId
     * @param int $itemIdInTransaction
     * @param int $transactionLocalId
     */
    public function __construct($benefitElementInstanceId = null, $itemIdInTransaction = null, $transactionLocalId = null)
    {
        $this
            ->setBenefitElementInstanceId($benefitElementInstanceId)
            ->setItemIdInTransaction($itemIdInTransaction)
            ->setTransactionLocalId($transactionLocalId);
    }
    /**
     * Get BenefitElementInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitElementInstanceId()
    {
        return isset($this->BenefitElementInstanceId) ? $this->BenefitElementInstanceId : null;
    }
    /**
     * Set BenefitElementInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitElementInstanceId
     * @return \patest\StructType\Sales_ItemBenefitUtilization
     */
    public function setBenefitElementInstanceId($benefitElementInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitElementInstanceId) && !is_string($benefitElementInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitElementInstanceId, true), gettype($benefitElementInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitElementInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitElementInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitElementInstanceId, true)), __LINE__);
        }
        if (is_null($benefitElementInstanceId) || (is_array($benefitElementInstanceId) && empty($benefitElementInstanceId))) {
            unset($this->BenefitElementInstanceId);
        } else {
            $this->BenefitElementInstanceId = $benefitElementInstanceId;
        }
        return $this;
    }
    /**
     * Get ItemIdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemIdInTransaction()
    {
        return isset($this->ItemIdInTransaction) ? $this->ItemIdInTransaction : null;
    }
    /**
     * Set ItemIdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemIdInTransaction
     * @return \patest\StructType\Sales_ItemBenefitUtilization
     */
    public function setItemIdInTransaction($itemIdInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($itemIdInTransaction) && !(is_int($itemIdInTransaction) || ctype_digit($itemIdInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemIdInTransaction, true), gettype($itemIdInTransaction)), __LINE__);
        }
        if (is_null($itemIdInTransaction) || (is_array($itemIdInTransaction) && empty($itemIdInTransaction))) {
            unset($this->ItemIdInTransaction);
        } else {
            $this->ItemIdInTransaction = $itemIdInTransaction;
        }
        return $this;
    }
    /**
     * Get TransactionLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionLocalId()
    {
        return isset($this->TransactionLocalId) ? $this->TransactionLocalId : null;
    }
    /**
     * Set TransactionLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionLocalId
     * @return \patest\StructType\Sales_ItemBenefitUtilization
     */
    public function setTransactionLocalId($transactionLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionLocalId) && !(is_int($transactionLocalId) || ctype_digit($transactionLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionLocalId, true), gettype($transactionLocalId)), __LINE__);
        }
        if (is_null($transactionLocalId) || (is_array($transactionLocalId) && empty($transactionLocalId))) {
            unset($this->TransactionLocalId);
        } else {
            $this->TransactionLocalId = $transactionLocalId;
        }
        return $this;
    }
}
