<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.InsurancePolicy StructType
 * @subpackage Structs
 */
class Sales_InsurancePolicy extends DistributableEntity
{
    /**
     * The ActivationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivationMode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ItemTypeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeNumber;
    /**
     * The MaxItemPriceToInsure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxItemPriceToInsure;
    /**
     * The MaxItemsToInsure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxItemsToInsure;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Sales.InsurancePolicy
     * @uses Sales_InsurancePolicy::setActivationMode()
     * @uses Sales_InsurancePolicy::setDescription()
     * @uses Sales_InsurancePolicy::setItemTypeNumber()
     * @uses Sales_InsurancePolicy::setMaxItemPriceToInsure()
     * @uses Sales_InsurancePolicy::setMaxItemsToInsure()
     * @uses Sales_InsurancePolicy::setMedia()
     * @uses Sales_InsurancePolicy::setName()
     * @param string $activationMode
     * @param \patest\StructType\GlobalString $description
     * @param int $itemTypeNumber
     * @param \patest\StructType\Money $maxItemPriceToInsure
     * @param int $maxItemsToInsure
     * @param \patest\StructType\Sales_Media $media
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($activationMode = null, \patest\StructType\GlobalString $description = null, $itemTypeNumber = null, \patest\StructType\Money $maxItemPriceToInsure = null, $maxItemsToInsure = null, \patest\StructType\Sales_Media $media = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setActivationMode($activationMode)
            ->setDescription($description)
            ->setItemTypeNumber($itemTypeNumber)
            ->setMaxItemPriceToInsure($maxItemPriceToInsure)
            ->setMaxItemsToInsure($maxItemsToInsure)
            ->setMedia($media)
            ->setName($name);
    }
    /**
     * Get ActivationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivationMode()
    {
        return isset($this->ActivationMode) ? $this->ActivationMode : null;
    }
    /**
     * Set ActivationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierActivationMode::valueIsValid()
     * @uses \patest\EnumType\PriceModifierActivationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activationMode
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setActivationMode($activationMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierActivationMode::valueIsValid($activationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierActivationMode', is_array($activationMode) ? implode(', ', $activationMode) : var_export($activationMode, true), implode(', ', \patest\EnumType\PriceModifierActivationMode::getValidValues())), __LINE__);
        }
        if (is_null($activationMode) || (is_array($activationMode) && empty($activationMode))) {
            unset($this->ActivationMode);
        } else {
            $this->ActivationMode = $activationMode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ItemTypeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeNumber()
    {
        return isset($this->ItemTypeNumber) ? $this->ItemTypeNumber : null;
    }
    /**
     * Set ItemTypeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeNumber
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setItemTypeNumber($itemTypeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeNumber) && !(is_int($itemTypeNumber) || ctype_digit($itemTypeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeNumber, true), gettype($itemTypeNumber)), __LINE__);
        }
        if (is_null($itemTypeNumber) || (is_array($itemTypeNumber) && empty($itemTypeNumber))) {
            unset($this->ItemTypeNumber);
        } else {
            $this->ItemTypeNumber = $itemTypeNumber;
        }
        return $this;
    }
    /**
     * Get MaxItemPriceToInsure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxItemPriceToInsure()
    {
        return isset($this->MaxItemPriceToInsure) ? $this->MaxItemPriceToInsure : null;
    }
    /**
     * Set MaxItemPriceToInsure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxItemPriceToInsure
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setMaxItemPriceToInsure(\patest\StructType\Money $maxItemPriceToInsure = null)
    {
        if (is_null($maxItemPriceToInsure) || (is_array($maxItemPriceToInsure) && empty($maxItemPriceToInsure))) {
            unset($this->MaxItemPriceToInsure);
        } else {
            $this->MaxItemPriceToInsure = $maxItemPriceToInsure;
        }
        return $this;
    }
    /**
     * Get MaxItemsToInsure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxItemsToInsure()
    {
        return isset($this->MaxItemsToInsure) ? $this->MaxItemsToInsure : null;
    }
    /**
     * Set MaxItemsToInsure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxItemsToInsure
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setMaxItemsToInsure($maxItemsToInsure = null)
    {
        // validation for constraint: int
        if (!is_null($maxItemsToInsure) && !(is_int($maxItemsToInsure) || ctype_digit($maxItemsToInsure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxItemsToInsure, true), gettype($maxItemsToInsure)), __LINE__);
        }
        if (is_null($maxItemsToInsure) || (is_array($maxItemsToInsure) && empty($maxItemsToInsure))) {
            unset($this->MaxItemsToInsure);
        } else {
            $this->MaxItemsToInsure = $maxItemsToInsure;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Media $media
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setMedia(\patest\StructType\Sales_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_InsurancePolicy
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
