<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.GroupedBasketRow StructType
 * @subpackage Structs
 */
class Sales_GroupedBasketRow extends AnyEntity
{
    /**
     * The AmountToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountToPay;
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CommissionAmount;
    /**
     * The DetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsText;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DiscountAmount;
    /**
     * The ExtraChargeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExtraChargeAmount;
    /**
     * The HasContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasContinuation;
    /**
     * The HasValidationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasValidationErrors;
    /**
     * The InsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $InsideCommissionAmount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The IsCommissionOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCommissionOverridden;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsDiscountOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDiscountOverridden;
    /**
     * The IsExtraChargeOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExtraChargeOverridden;
    /**
     * The IsInactivePriceModifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInactivePriceModifier;
    /**
     * The IsInsuranceOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInsuranceOverridden;
    /**
     * The IsListPriceOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsListPriceOverridden;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReservation;
    /**
     * The IsReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturn;
    /**
     * The IsSubsidyOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubsidyOverridden;
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $ItemDetails;
    /**
     * The ItemOrPriceModifierIdInTran
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemOrPriceModifierIdInTran;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeId;
    /**
     * The ListPriceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ListPriceAmount;
    /**
     * The ParentRowOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentRowOrdinal;
    /**
     * The PriceModifierType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceModifierType;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qty;
    /**
     * The RowDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowDepth;
    /**
     * The RowOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowOrdinal;
    /**
     * The RowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowType;
    /**
     * The RowTypeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowTypeText;
    /**
     * The SubsidyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SubsidyAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxAmount;
    /**
     * The ThirdPartyVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ThirdPartyVatAmount;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * The VatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VatAmount;
    /**
     * Constructor method for Sales.GroupedBasketRow
     * @uses Sales_GroupedBasketRow::setAmountToPay()
     * @uses Sales_GroupedBasketRow::setCommissionAmount()
     * @uses Sales_GroupedBasketRow::setDetailsText()
     * @uses Sales_GroupedBasketRow::setDiscountAmount()
     * @uses Sales_GroupedBasketRow::setExtraChargeAmount()
     * @uses Sales_GroupedBasketRow::setHasContinuation()
     * @uses Sales_GroupedBasketRow::setHasValidationErrors()
     * @uses Sales_GroupedBasketRow::setInsideCommissionAmount()
     * @uses Sales_GroupedBasketRow::setInsuranceAmount()
     * @uses Sales_GroupedBasketRow::setIsCommissionOverridden()
     * @uses Sales_GroupedBasketRow::setIsComplimentary()
     * @uses Sales_GroupedBasketRow::setIsDiscountOverridden()
     * @uses Sales_GroupedBasketRow::setIsExtraChargeOverridden()
     * @uses Sales_GroupedBasketRow::setIsInactivePriceModifier()
     * @uses Sales_GroupedBasketRow::setIsInsuranceOverridden()
     * @uses Sales_GroupedBasketRow::setIsListPriceOverridden()
     * @uses Sales_GroupedBasketRow::setIsReservation()
     * @uses Sales_GroupedBasketRow::setIsReturn()
     * @uses Sales_GroupedBasketRow::setIsSubsidyOverridden()
     * @uses Sales_GroupedBasketRow::setItemDetails()
     * @uses Sales_GroupedBasketRow::setItemOrPriceModifierIdInTran()
     * @uses Sales_GroupedBasketRow::setItemTypeId()
     * @uses Sales_GroupedBasketRow::setListPriceAmount()
     * @uses Sales_GroupedBasketRow::setParentRowOrdinal()
     * @uses Sales_GroupedBasketRow::setPriceModifierType()
     * @uses Sales_GroupedBasketRow::setPriceTypeId()
     * @uses Sales_GroupedBasketRow::setPriceTypeName()
     * @uses Sales_GroupedBasketRow::setProductId()
     * @uses Sales_GroupedBasketRow::setQty()
     * @uses Sales_GroupedBasketRow::setRowDepth()
     * @uses Sales_GroupedBasketRow::setRowOrdinal()
     * @uses Sales_GroupedBasketRow::setRowType()
     * @uses Sales_GroupedBasketRow::setRowTypeText()
     * @uses Sales_GroupedBasketRow::setSubsidyAmount()
     * @uses Sales_GroupedBasketRow::setTaxAmount()
     * @uses Sales_GroupedBasketRow::setThirdPartyVatAmount()
     * @uses Sales_GroupedBasketRow::setTitle()
     * @uses Sales_GroupedBasketRow::setTotalAmount()
     * @uses Sales_GroupedBasketRow::setVatAmount()
     * @param float $amountToPay
     * @param float $commissionAmount
     * @param string $detailsText
     * @param float $discountAmount
     * @param float $extraChargeAmount
     * @param bool $hasContinuation
     * @param bool $hasValidationErrors
     * @param float $insideCommissionAmount
     * @param float $insuranceAmount
     * @param bool $isCommissionOverridden
     * @param bool $isComplimentary
     * @param bool $isDiscountOverridden
     * @param bool $isExtraChargeOverridden
     * @param bool $isInactivePriceModifier
     * @param bool $isInsuranceOverridden
     * @param bool $isListPriceOverridden
     * @param bool $isReservation
     * @param bool $isReturn
     * @param bool $isSubsidyOverridden
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @param int $itemOrPriceModifierIdInTran
     * @param int $itemTypeId
     * @param float $listPriceAmount
     * @param int $parentRowOrdinal
     * @param string $priceModifierType
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $productId
     * @param int $qty
     * @param int $rowDepth
     * @param int $rowOrdinal
     * @param string $rowType
     * @param string $rowTypeText
     * @param float $subsidyAmount
     * @param float $taxAmount
     * @param float $thirdPartyVatAmount
     * @param string $title
     * @param float $totalAmount
     * @param float $vatAmount
     */
    public function __construct($amountToPay = null, $commissionAmount = null, $detailsText = null, $discountAmount = null, $extraChargeAmount = null, $hasContinuation = null, $hasValidationErrors = null, $insideCommissionAmount = null, $insuranceAmount = null, $isCommissionOverridden = null, $isComplimentary = null, $isDiscountOverridden = null, $isExtraChargeOverridden = null, $isInactivePriceModifier = null, $isInsuranceOverridden = null, $isListPriceOverridden = null, $isReservation = null, $isReturn = null, $isSubsidyOverridden = null, \patest\StructType\Sales_AbstractItemDetails $itemDetails = null, $itemOrPriceModifierIdInTran = null, $itemTypeId = null, $listPriceAmount = null, $parentRowOrdinal = null, $priceModifierType = null, $priceTypeId = null, $priceTypeName = null, $productId = null, $qty = null, $rowDepth = null, $rowOrdinal = null, $rowType = null, $rowTypeText = null, $subsidyAmount = null, $taxAmount = null, $thirdPartyVatAmount = null, $title = null, $totalAmount = null, $vatAmount = null)
    {
        $this
            ->setAmountToPay($amountToPay)
            ->setCommissionAmount($commissionAmount)
            ->setDetailsText($detailsText)
            ->setDiscountAmount($discountAmount)
            ->setExtraChargeAmount($extraChargeAmount)
            ->setHasContinuation($hasContinuation)
            ->setHasValidationErrors($hasValidationErrors)
            ->setInsideCommissionAmount($insideCommissionAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setIsCommissionOverridden($isCommissionOverridden)
            ->setIsComplimentary($isComplimentary)
            ->setIsDiscountOverridden($isDiscountOverridden)
            ->setIsExtraChargeOverridden($isExtraChargeOverridden)
            ->setIsInactivePriceModifier($isInactivePriceModifier)
            ->setIsInsuranceOverridden($isInsuranceOverridden)
            ->setIsListPriceOverridden($isListPriceOverridden)
            ->setIsReservation($isReservation)
            ->setIsReturn($isReturn)
            ->setIsSubsidyOverridden($isSubsidyOverridden)
            ->setItemDetails($itemDetails)
            ->setItemOrPriceModifierIdInTran($itemOrPriceModifierIdInTran)
            ->setItemTypeId($itemTypeId)
            ->setListPriceAmount($listPriceAmount)
            ->setParentRowOrdinal($parentRowOrdinal)
            ->setPriceModifierType($priceModifierType)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setProductId($productId)
            ->setQty($qty)
            ->setRowDepth($rowDepth)
            ->setRowOrdinal($rowOrdinal)
            ->setRowType($rowType)
            ->setRowTypeText($rowTypeText)
            ->setSubsidyAmount($subsidyAmount)
            ->setTaxAmount($taxAmount)
            ->setThirdPartyVatAmount($thirdPartyVatAmount)
            ->setTitle($title)
            ->setTotalAmount($totalAmount)
            ->setVatAmount($vatAmount);
    }
    /**
     * Get AmountToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountToPay()
    {
        return isset($this->AmountToPay) ? $this->AmountToPay : null;
    }
    /**
     * Set AmountToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountToPay
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setAmountToPay($amountToPay = null)
    {
        // validation for constraint: float
        if (!is_null($amountToPay) && !(is_float($amountToPay) || is_numeric($amountToPay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountToPay, true), gettype($amountToPay)), __LINE__);
        }
        if (is_null($amountToPay) || (is_array($amountToPay) && empty($amountToPay))) {
            unset($this->AmountToPay);
        } else {
            $this->AmountToPay = $amountToPay;
        }
        return $this;
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $commissionAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get DetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsText()
    {
        return isset($this->DetailsText) ? $this->DetailsText : null;
    }
    /**
     * Set DetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsText
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setDetailsText($detailsText = null)
    {
        // validation for constraint: string
        if (!is_null($detailsText) && !is_string($detailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsText, true), gettype($detailsText)), __LINE__);
        }
        if (is_null($detailsText) || (is_array($detailsText) && empty($detailsText))) {
            unset($this->DetailsText);
        } else {
            $this->DetailsText = $detailsText;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discountAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get ExtraChargeAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExtraChargeAmount()
    {
        return isset($this->ExtraChargeAmount) ? $this->ExtraChargeAmount : null;
    }
    /**
     * Set ExtraChargeAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $extraChargeAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setExtraChargeAmount($extraChargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($extraChargeAmount) && !(is_float($extraChargeAmount) || is_numeric($extraChargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extraChargeAmount, true), gettype($extraChargeAmount)), __LINE__);
        }
        if (is_null($extraChargeAmount) || (is_array($extraChargeAmount) && empty($extraChargeAmount))) {
            unset($this->ExtraChargeAmount);
        } else {
            $this->ExtraChargeAmount = $extraChargeAmount;
        }
        return $this;
    }
    /**
     * Get HasContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasContinuation()
    {
        return isset($this->HasContinuation) ? $this->HasContinuation : null;
    }
    /**
     * Set HasContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasContinuation
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setHasContinuation($hasContinuation = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasContinuation) && !is_bool($hasContinuation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasContinuation, true), gettype($hasContinuation)), __LINE__);
        }
        if (is_null($hasContinuation) || (is_array($hasContinuation) && empty($hasContinuation))) {
            unset($this->HasContinuation);
        } else {
            $this->HasContinuation = $hasContinuation;
        }
        return $this;
    }
    /**
     * Get HasValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasValidationErrors()
    {
        return isset($this->HasValidationErrors) ? $this->HasValidationErrors : null;
    }
    /**
     * Set HasValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasValidationErrors
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setHasValidationErrors($hasValidationErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasValidationErrors) && !is_bool($hasValidationErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasValidationErrors, true), gettype($hasValidationErrors)), __LINE__);
        }
        if (is_null($hasValidationErrors) || (is_array($hasValidationErrors) && empty($hasValidationErrors))) {
            unset($this->HasValidationErrors);
        } else {
            $this->HasValidationErrors = $hasValidationErrors;
        }
        return $this;
    }
    /**
     * Get InsideCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInsideCommissionAmount()
    {
        return isset($this->InsideCommissionAmount) ? $this->InsideCommissionAmount : null;
    }
    /**
     * Set InsideCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $insideCommissionAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setInsideCommissionAmount($insideCommissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insideCommissionAmount) && !(is_float($insideCommissionAmount) || is_numeric($insideCommissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insideCommissionAmount, true), gettype($insideCommissionAmount)), __LINE__);
        }
        if (is_null($insideCommissionAmount) || (is_array($insideCommissionAmount) && empty($insideCommissionAmount))) {
            unset($this->InsideCommissionAmount);
        } else {
            $this->InsideCommissionAmount = $insideCommissionAmount;
        }
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return isset($this->InsuranceAmount) ? $this->InsuranceAmount : null;
    }
    /**
     * Set InsuranceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $insuranceAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        if (is_null($insuranceAmount) || (is_array($insuranceAmount) && empty($insuranceAmount))) {
            unset($this->InsuranceAmount);
        } else {
            $this->InsuranceAmount = $insuranceAmount;
        }
        return $this;
    }
    /**
     * Get IsCommissionOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCommissionOverridden()
    {
        return isset($this->IsCommissionOverridden) ? $this->IsCommissionOverridden : null;
    }
    /**
     * Set IsCommissionOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCommissionOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsCommissionOverridden($isCommissionOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommissionOverridden) && !is_bool($isCommissionOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommissionOverridden, true), gettype($isCommissionOverridden)), __LINE__);
        }
        if (is_null($isCommissionOverridden) || (is_array($isCommissionOverridden) && empty($isCommissionOverridden))) {
            unset($this->IsCommissionOverridden);
        } else {
            $this->IsCommissionOverridden = $isCommissionOverridden;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsDiscountOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDiscountOverridden()
    {
        return isset($this->IsDiscountOverridden) ? $this->IsDiscountOverridden : null;
    }
    /**
     * Set IsDiscountOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDiscountOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsDiscountOverridden($isDiscountOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDiscountOverridden) && !is_bool($isDiscountOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDiscountOverridden, true), gettype($isDiscountOverridden)), __LINE__);
        }
        if (is_null($isDiscountOverridden) || (is_array($isDiscountOverridden) && empty($isDiscountOverridden))) {
            unset($this->IsDiscountOverridden);
        } else {
            $this->IsDiscountOverridden = $isDiscountOverridden;
        }
        return $this;
    }
    /**
     * Get IsExtraChargeOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExtraChargeOverridden()
    {
        return isset($this->IsExtraChargeOverridden) ? $this->IsExtraChargeOverridden : null;
    }
    /**
     * Set IsExtraChargeOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExtraChargeOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsExtraChargeOverridden($isExtraChargeOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraChargeOverridden) && !is_bool($isExtraChargeOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraChargeOverridden, true), gettype($isExtraChargeOverridden)), __LINE__);
        }
        if (is_null($isExtraChargeOverridden) || (is_array($isExtraChargeOverridden) && empty($isExtraChargeOverridden))) {
            unset($this->IsExtraChargeOverridden);
        } else {
            $this->IsExtraChargeOverridden = $isExtraChargeOverridden;
        }
        return $this;
    }
    /**
     * Get IsInactivePriceModifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInactivePriceModifier()
    {
        return isset($this->IsInactivePriceModifier) ? $this->IsInactivePriceModifier : null;
    }
    /**
     * Set IsInactivePriceModifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInactivePriceModifier
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsInactivePriceModifier($isInactivePriceModifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactivePriceModifier) && !is_bool($isInactivePriceModifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactivePriceModifier, true), gettype($isInactivePriceModifier)), __LINE__);
        }
        if (is_null($isInactivePriceModifier) || (is_array($isInactivePriceModifier) && empty($isInactivePriceModifier))) {
            unset($this->IsInactivePriceModifier);
        } else {
            $this->IsInactivePriceModifier = $isInactivePriceModifier;
        }
        return $this;
    }
    /**
     * Get IsInsuranceOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInsuranceOverridden()
    {
        return isset($this->IsInsuranceOverridden) ? $this->IsInsuranceOverridden : null;
    }
    /**
     * Set IsInsuranceOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInsuranceOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsInsuranceOverridden($isInsuranceOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInsuranceOverridden) && !is_bool($isInsuranceOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInsuranceOverridden, true), gettype($isInsuranceOverridden)), __LINE__);
        }
        if (is_null($isInsuranceOverridden) || (is_array($isInsuranceOverridden) && empty($isInsuranceOverridden))) {
            unset($this->IsInsuranceOverridden);
        } else {
            $this->IsInsuranceOverridden = $isInsuranceOverridden;
        }
        return $this;
    }
    /**
     * Get IsListPriceOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsListPriceOverridden()
    {
        return isset($this->IsListPriceOverridden) ? $this->IsListPriceOverridden : null;
    }
    /**
     * Set IsListPriceOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isListPriceOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsListPriceOverridden($isListPriceOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isListPriceOverridden) && !is_bool($isListPriceOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isListPriceOverridden, true), gettype($isListPriceOverridden)), __LINE__);
        }
        if (is_null($isListPriceOverridden) || (is_array($isListPriceOverridden) && empty($isListPriceOverridden))) {
            unset($this->IsListPriceOverridden);
        } else {
            $this->IsListPriceOverridden = $isListPriceOverridden;
        }
        return $this;
    }
    /**
     * Get IsReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReservation()
    {
        return isset($this->IsReservation) ? $this->IsReservation : null;
    }
    /**
     * Set IsReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReservation
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        if (is_null($isReservation) || (is_array($isReservation) && empty($isReservation))) {
            unset($this->IsReservation);
        } else {
            $this->IsReservation = $isReservation;
        }
        return $this;
    }
    /**
     * Get IsReturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturn()
    {
        return isset($this->IsReturn) ? $this->IsReturn : null;
    }
    /**
     * Set IsReturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturn
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsReturn($isReturn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturn) && !is_bool($isReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturn, true), gettype($isReturn)), __LINE__);
        }
        if (is_null($isReturn) || (is_array($isReturn) && empty($isReturn))) {
            unset($this->IsReturn);
        } else {
            $this->IsReturn = $isReturn;
        }
        return $this;
    }
    /**
     * Get IsSubsidyOverridden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubsidyOverridden()
    {
        return isset($this->IsSubsidyOverridden) ? $this->IsSubsidyOverridden : null;
    }
    /**
     * Set IsSubsidyOverridden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubsidyOverridden
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setIsSubsidyOverridden($isSubsidyOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubsidyOverridden) && !is_bool($isSubsidyOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubsidyOverridden, true), gettype($isSubsidyOverridden)), __LINE__);
        }
        if (is_null($isSubsidyOverridden) || (is_array($isSubsidyOverridden) && empty($isSubsidyOverridden))) {
            unset($this->IsSubsidyOverridden);
        } else {
            $this->IsSubsidyOverridden = $isSubsidyOverridden;
        }
        return $this;
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setItemDetails(\patest\StructType\Sales_AbstractItemDetails $itemDetails = null)
    {
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Get ItemOrPriceModifierIdInTran value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemOrPriceModifierIdInTran()
    {
        return isset($this->ItemOrPriceModifierIdInTran) ? $this->ItemOrPriceModifierIdInTran : null;
    }
    /**
     * Set ItemOrPriceModifierIdInTran value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemOrPriceModifierIdInTran
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setItemOrPriceModifierIdInTran($itemOrPriceModifierIdInTran = null)
    {
        // validation for constraint: int
        if (!is_null($itemOrPriceModifierIdInTran) && !(is_int($itemOrPriceModifierIdInTran) || ctype_digit($itemOrPriceModifierIdInTran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemOrPriceModifierIdInTran, true), gettype($itemOrPriceModifierIdInTran)), __LINE__);
        }
        if (is_null($itemOrPriceModifierIdInTran) || (is_array($itemOrPriceModifierIdInTran) && empty($itemOrPriceModifierIdInTran))) {
            unset($this->ItemOrPriceModifierIdInTran);
        } else {
            $this->ItemOrPriceModifierIdInTran = $itemOrPriceModifierIdInTran;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeId
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeId) && !(is_int($itemTypeId) || ctype_digit($itemTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get ListPriceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getListPriceAmount()
    {
        return isset($this->ListPriceAmount) ? $this->ListPriceAmount : null;
    }
    /**
     * Set ListPriceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $listPriceAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setListPriceAmount($listPriceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($listPriceAmount) && !(is_float($listPriceAmount) || is_numeric($listPriceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listPriceAmount, true), gettype($listPriceAmount)), __LINE__);
        }
        if (is_null($listPriceAmount) || (is_array($listPriceAmount) && empty($listPriceAmount))) {
            unset($this->ListPriceAmount);
        } else {
            $this->ListPriceAmount = $listPriceAmount;
        }
        return $this;
    }
    /**
     * Get ParentRowOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentRowOrdinal()
    {
        return isset($this->ParentRowOrdinal) ? $this->ParentRowOrdinal : null;
    }
    /**
     * Set ParentRowOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentRowOrdinal
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setParentRowOrdinal($parentRowOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($parentRowOrdinal) && !(is_int($parentRowOrdinal) || ctype_digit($parentRowOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentRowOrdinal, true), gettype($parentRowOrdinal)), __LINE__);
        }
        if (is_null($parentRowOrdinal) || (is_array($parentRowOrdinal) && empty($parentRowOrdinal))) {
            unset($this->ParentRowOrdinal);
        } else {
            $this->ParentRowOrdinal = $parentRowOrdinal;
        }
        return $this;
    }
    /**
     * Get PriceModifierType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierType()
    {
        return isset($this->PriceModifierType) ? $this->PriceModifierType : null;
    }
    /**
     * Set PriceModifierType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierType
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setPriceModifierType($priceModifierType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierType) ? implode(', ', $priceModifierType) : var_export($priceModifierType, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($priceModifierType) || (is_array($priceModifierType) && empty($priceModifierType))) {
            unset($this->PriceModifierType);
        } else {
            $this->PriceModifierType = $priceModifierType;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qty
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get RowDepth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowDepth()
    {
        return isset($this->RowDepth) ? $this->RowDepth : null;
    }
    /**
     * Set RowDepth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowDepth
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setRowDepth($rowDepth = null)
    {
        // validation for constraint: int
        if (!is_null($rowDepth) && !(is_int($rowDepth) || ctype_digit($rowDepth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowDepth, true), gettype($rowDepth)), __LINE__);
        }
        if (is_null($rowDepth) || (is_array($rowDepth) && empty($rowDepth))) {
            unset($this->RowDepth);
        } else {
            $this->RowDepth = $rowDepth;
        }
        return $this;
    }
    /**
     * Get RowOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowOrdinal()
    {
        return isset($this->RowOrdinal) ? $this->RowOrdinal : null;
    }
    /**
     * Set RowOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowOrdinal
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setRowOrdinal($rowOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($rowOrdinal) && !(is_int($rowOrdinal) || ctype_digit($rowOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowOrdinal, true), gettype($rowOrdinal)), __LINE__);
        }
        if (is_null($rowOrdinal) || (is_array($rowOrdinal) && empty($rowOrdinal))) {
            unset($this->RowOrdinal);
        } else {
            $this->RowOrdinal = $rowOrdinal;
        }
        return $this;
    }
    /**
     * Get RowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowType()
    {
        return isset($this->RowType) ? $this->RowType : null;
    }
    /**
     * Set RowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GroupedBasketNodeType::valueIsValid()
     * @uses \patest\EnumType\GroupedBasketNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rowType
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setRowType($rowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GroupedBasketNodeType::valueIsValid($rowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GroupedBasketNodeType', is_array($rowType) ? implode(', ', $rowType) : var_export($rowType, true), implode(', ', \patest\EnumType\GroupedBasketNodeType::getValidValues())), __LINE__);
        }
        if (is_null($rowType) || (is_array($rowType) && empty($rowType))) {
            unset($this->RowType);
        } else {
            $this->RowType = $rowType;
        }
        return $this;
    }
    /**
     * Get RowTypeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowTypeText()
    {
        return isset($this->RowTypeText) ? $this->RowTypeText : null;
    }
    /**
     * Set RowTypeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowTypeText
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setRowTypeText($rowTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($rowTypeText) && !is_string($rowTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowTypeText, true), gettype($rowTypeText)), __LINE__);
        }
        if (is_null($rowTypeText) || (is_array($rowTypeText) && empty($rowTypeText))) {
            unset($this->RowTypeText);
        } else {
            $this->RowTypeText = $rowTypeText;
        }
        return $this;
    }
    /**
     * Get SubsidyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSubsidyAmount()
    {
        return isset($this->SubsidyAmount) ? $this->SubsidyAmount : null;
    }
    /**
     * Set SubsidyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $subsidyAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setSubsidyAmount($subsidyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($subsidyAmount) && !(is_float($subsidyAmount) || is_numeric($subsidyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subsidyAmount, true), gettype($subsidyAmount)), __LINE__);
        }
        if (is_null($subsidyAmount) || (is_array($subsidyAmount) && empty($subsidyAmount))) {
            unset($this->SubsidyAmount);
        } else {
            $this->SubsidyAmount = $subsidyAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get ThirdPartyVatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getThirdPartyVatAmount()
    {
        return isset($this->ThirdPartyVatAmount) ? $this->ThirdPartyVatAmount : null;
    }
    /**
     * Set ThirdPartyVatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $thirdPartyVatAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setThirdPartyVatAmount($thirdPartyVatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($thirdPartyVatAmount) && !(is_float($thirdPartyVatAmount) || is_numeric($thirdPartyVatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($thirdPartyVatAmount, true), gettype($thirdPartyVatAmount)), __LINE__);
        }
        if (is_null($thirdPartyVatAmount) || (is_array($thirdPartyVatAmount) && empty($thirdPartyVatAmount))) {
            unset($this->ThirdPartyVatAmount);
        } else {
            $this->ThirdPartyVatAmount = $thirdPartyVatAmount;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get VatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVatAmount()
    {
        return isset($this->VatAmount) ? $this->VatAmount : null;
    }
    /**
     * Set VatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vatAmount
     * @return \patest\StructType\Sales_GroupedBasketRow
     */
    public function setVatAmount($vatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vatAmount) && !(is_float($vatAmount) || is_numeric($vatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatAmount, true), gettype($vatAmount)), __LINE__);
        }
        if (is_null($vatAmount) || (is_array($vatAmount) && empty($vatAmount))) {
            unset($this->VatAmount);
        } else {
            $this->VatAmount = $vatAmount;
        }
        return $this;
    }
}
