<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialJournalTargetSummaryBase StructType
 * @subpackage Structs
 */
class Sales_FinancialJournalTargetSummaryBase extends AnyEntity
{
    /**
     * The BuyingOperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BuyingOperationId;
    /**
     * The BuyingUtcDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuyingUtcDateTime;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CommissionsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CommissionsAmount;
    /**
     * The DetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsText;
    /**
     * The EditedSumToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EditedSumToPay;
    /**
     * The EditedSumToUnPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EditedSumToUnPay;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraFields;
    /**
     * The HasDraftInvoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasDraftInvoice;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The LastAmendmentUtcDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastAmendmentUtcDateTime;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PriceModifierDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceModifierDescription;
    /**
     * The SalesItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesItemType;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId;
    /**
     * The TargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetKind;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The UnpaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidAmount;
    /**
     * The UnpaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidInstallmentsAmount;
    /**
     * Constructor method for Sales.FinancialJournalTargetSummaryBase
     * @uses Sales_FinancialJournalTargetSummaryBase::setBuyingOperationId()
     * @uses Sales_FinancialJournalTargetSummaryBase::setBuyingUtcDateTime()
     * @uses Sales_FinancialJournalTargetSummaryBase::setClientId()
     * @uses Sales_FinancialJournalTargetSummaryBase::setCommissionsAmount()
     * @uses Sales_FinancialJournalTargetSummaryBase::setDetailsText()
     * @uses Sales_FinancialJournalTargetSummaryBase::setEditedSumToPay()
     * @uses Sales_FinancialJournalTargetSummaryBase::setEditedSumToUnPay()
     * @uses Sales_FinancialJournalTargetSummaryBase::setExtraFields()
     * @uses Sales_FinancialJournalTargetSummaryBase::setHasDraftInvoice()
     * @uses Sales_FinancialJournalTargetSummaryBase::setHolderCompanyId()
     * @uses Sales_FinancialJournalTargetSummaryBase::setIdInTransaction()
     * @uses Sales_FinancialJournalTargetSummaryBase::setInvoiceNumber()
     * @uses Sales_FinancialJournalTargetSummaryBase::setLastAmendmentUtcDateTime()
     * @uses Sales_FinancialJournalTargetSummaryBase::setPaidAmount()
     * @uses Sales_FinancialJournalTargetSummaryBase::setPriceModifierDescription()
     * @uses Sales_FinancialJournalTargetSummaryBase::setSalesItemType()
     * @uses Sales_FinancialJournalTargetSummaryBase::setServiceSpecificId()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTargetId()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTargetKind()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTotalPrice()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTransactionNotes()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTransactionNumber()
     * @uses Sales_FinancialJournalTargetSummaryBase::setTransactionReferenceNumber()
     * @uses Sales_FinancialJournalTargetSummaryBase::setUnpaidAmount()
     * @uses Sales_FinancialJournalTargetSummaryBase::setUnpaidInstallmentsAmount()
     * @param string $buyingOperationId
     * @param string $buyingUtcDateTime
     * @param string $clientId
     * @param \patest\StructType\Money $commissionsAmount
     * @param string $detailsText
     * @param \patest\StructType\Money $editedSumToPay
     * @param \patest\StructType\Money $editedSumToUnPay
     * @param string $extraFields
     * @param bool $hasDraftInvoice
     * @param int $holderCompanyId
     * @param int $idInTransaction
     * @param int $invoiceNumber
     * @param string $lastAmendmentUtcDateTime
     * @param \patest\StructType\Money $paidAmount
     * @param \patest\StructType\GlobalString $priceModifierDescription
     * @param int $salesItemType
     * @param string $serviceSpecificId
     * @param string $targetId
     * @param string $targetKind
     * @param \patest\StructType\Money $totalPrice
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param \patest\StructType\Money $unpaidAmount
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     */
    public function __construct($buyingOperationId = null, $buyingUtcDateTime = null, $clientId = null, \patest\StructType\Money $commissionsAmount = null, $detailsText = null, \patest\StructType\Money $editedSumToPay = null, \patest\StructType\Money $editedSumToUnPay = null, $extraFields = null, $hasDraftInvoice = null, $holderCompanyId = null, $idInTransaction = null, $invoiceNumber = null, $lastAmendmentUtcDateTime = null, \patest\StructType\Money $paidAmount = null, \patest\StructType\GlobalString $priceModifierDescription = null, $salesItemType = null, $serviceSpecificId = null, $targetId = null, $targetKind = null, \patest\StructType\Money $totalPrice = null, $transactionNotes = null, $transactionNumber = null, $transactionReferenceNumber = null, \patest\StructType\Money $unpaidAmount = null, \patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        $this
            ->setBuyingOperationId($buyingOperationId)
            ->setBuyingUtcDateTime($buyingUtcDateTime)
            ->setClientId($clientId)
            ->setCommissionsAmount($commissionsAmount)
            ->setDetailsText($detailsText)
            ->setEditedSumToPay($editedSumToPay)
            ->setEditedSumToUnPay($editedSumToUnPay)
            ->setExtraFields($extraFields)
            ->setHasDraftInvoice($hasDraftInvoice)
            ->setHolderCompanyId($holderCompanyId)
            ->setIdInTransaction($idInTransaction)
            ->setInvoiceNumber($invoiceNumber)
            ->setLastAmendmentUtcDateTime($lastAmendmentUtcDateTime)
            ->setPaidAmount($paidAmount)
            ->setPriceModifierDescription($priceModifierDescription)
            ->setSalesItemType($salesItemType)
            ->setServiceSpecificId($serviceSpecificId)
            ->setTargetId($targetId)
            ->setTargetKind($targetKind)
            ->setTotalPrice($totalPrice)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setUnpaidAmount($unpaidAmount)
            ->setUnpaidInstallmentsAmount($unpaidInstallmentsAmount);
    }
    /**
     * Get BuyingOperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyingOperationId()
    {
        return isset($this->BuyingOperationId) ? $this->BuyingOperationId : null;
    }
    /**
     * Set BuyingOperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyingOperationId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setBuyingOperationId($buyingOperationId = null)
    {
        // validation for constraint: string
        if (!is_null($buyingOperationId) && !is_string($buyingOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyingOperationId, true), gettype($buyingOperationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($buyingOperationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $buyingOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($buyingOperationId, true)), __LINE__);
        }
        if (is_null($buyingOperationId) || (is_array($buyingOperationId) && empty($buyingOperationId))) {
            unset($this->BuyingOperationId);
        } else {
            $this->BuyingOperationId = $buyingOperationId;
        }
        return $this;
    }
    /**
     * Get BuyingUtcDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyingUtcDateTime()
    {
        return isset($this->BuyingUtcDateTime) ? $this->BuyingUtcDateTime : null;
    }
    /**
     * Set BuyingUtcDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyingUtcDateTime
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setBuyingUtcDateTime($buyingUtcDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($buyingUtcDateTime) && !is_string($buyingUtcDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyingUtcDateTime, true), gettype($buyingUtcDateTime)), __LINE__);
        }
        if (is_null($buyingUtcDateTime) || (is_array($buyingUtcDateTime) && empty($buyingUtcDateTime))) {
            unset($this->BuyingUtcDateTime);
        } else {
            $this->BuyingUtcDateTime = $buyingUtcDateTime;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CommissionsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCommissionsAmount()
    {
        return isset($this->CommissionsAmount) ? $this->CommissionsAmount : null;
    }
    /**
     * Set CommissionsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $commissionsAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setCommissionsAmount(\patest\StructType\Money $commissionsAmount = null)
    {
        if (is_null($commissionsAmount) || (is_array($commissionsAmount) && empty($commissionsAmount))) {
            unset($this->CommissionsAmount);
        } else {
            $this->CommissionsAmount = $commissionsAmount;
        }
        return $this;
    }
    /**
     * Get DetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsText()
    {
        return isset($this->DetailsText) ? $this->DetailsText : null;
    }
    /**
     * Set DetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsText
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setDetailsText($detailsText = null)
    {
        // validation for constraint: string
        if (!is_null($detailsText) && !is_string($detailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsText, true), gettype($detailsText)), __LINE__);
        }
        if (is_null($detailsText) || (is_array($detailsText) && empty($detailsText))) {
            unset($this->DetailsText);
        } else {
            $this->DetailsText = $detailsText;
        }
        return $this;
    }
    /**
     * Get EditedSumToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEditedSumToPay()
    {
        return isset($this->EditedSumToPay) ? $this->EditedSumToPay : null;
    }
    /**
     * Set EditedSumToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $editedSumToPay
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setEditedSumToPay(\patest\StructType\Money $editedSumToPay = null)
    {
        if (is_null($editedSumToPay) || (is_array($editedSumToPay) && empty($editedSumToPay))) {
            unset($this->EditedSumToPay);
        } else {
            $this->EditedSumToPay = $editedSumToPay;
        }
        return $this;
    }
    /**
     * Get EditedSumToUnPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEditedSumToUnPay()
    {
        return isset($this->EditedSumToUnPay) ? $this->EditedSumToUnPay : null;
    }
    /**
     * Set EditedSumToUnPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $editedSumToUnPay
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setEditedSumToUnPay(\patest\StructType\Money $editedSumToUnPay = null)
    {
        if (is_null($editedSumToUnPay) || (is_array($editedSumToUnPay) && empty($editedSumToUnPay))) {
            unset($this->EditedSumToUnPay);
        } else {
            $this->EditedSumToUnPay = $editedSumToUnPay;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraFields
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setExtraFields($extraFields = null)
    {
        // validation for constraint: string
        if (!is_null($extraFields) && !is_string($extraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraFields, true), gettype($extraFields)), __LINE__);
        }
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get HasDraftInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasDraftInvoice()
    {
        return isset($this->HasDraftInvoice) ? $this->HasDraftInvoice : null;
    }
    /**
     * Set HasDraftInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasDraftInvoice
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setHasDraftInvoice($hasDraftInvoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDraftInvoice) && !is_bool($hasDraftInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasDraftInvoice, true), gettype($hasDraftInvoice)), __LINE__);
        }
        if (is_null($hasDraftInvoice) || (is_array($hasDraftInvoice) && empty($hasDraftInvoice))) {
            unset($this->HasDraftInvoice);
        } else {
            $this->HasDraftInvoice = $hasDraftInvoice;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get LastAmendmentUtcDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastAmendmentUtcDateTime()
    {
        return isset($this->LastAmendmentUtcDateTime) ? $this->LastAmendmentUtcDateTime : null;
    }
    /**
     * Set LastAmendmentUtcDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastAmendmentUtcDateTime
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setLastAmendmentUtcDateTime($lastAmendmentUtcDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastAmendmentUtcDateTime) && !is_string($lastAmendmentUtcDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastAmendmentUtcDateTime, true), gettype($lastAmendmentUtcDateTime)), __LINE__);
        }
        if (is_null($lastAmendmentUtcDateTime) || (is_array($lastAmendmentUtcDateTime) && empty($lastAmendmentUtcDateTime))) {
            unset($this->LastAmendmentUtcDateTime);
        } else {
            $this->LastAmendmentUtcDateTime = $lastAmendmentUtcDateTime;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PriceModifierDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceModifierDescription()
    {
        return isset($this->PriceModifierDescription) ? $this->PriceModifierDescription : null;
    }
    /**
     * Set PriceModifierDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceModifierDescription
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setPriceModifierDescription(\patest\StructType\GlobalString $priceModifierDescription = null)
    {
        if (is_null($priceModifierDescription) || (is_array($priceModifierDescription) && empty($priceModifierDescription))) {
            unset($this->PriceModifierDescription);
        } else {
            $this->PriceModifierDescription = $priceModifierDescription;
        }
        return $this;
    }
    /**
     * Get SalesItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesItemType()
    {
        return isset($this->SalesItemType) ? $this->SalesItemType : null;
    }
    /**
     * Set SalesItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesItemType
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setSalesItemType($salesItemType = null)
    {
        // validation for constraint: int
        if (!is_null($salesItemType) && !(is_int($salesItemType) || ctype_digit($salesItemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesItemType, true), gettype($salesItemType)), __LINE__);
        }
        if (is_null($salesItemType) || (is_array($salesItemType) && empty($salesItemType))) {
            unset($this->SalesItemType);
        } else {
            $this->SalesItemType = $salesItemType;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return isset($this->ServiceSpecificId) ? $this->ServiceSpecificId : null;
    }
    /**
     * Set ServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        if (is_null($serviceSpecificId) || (is_array($serviceSpecificId) && empty($serviceSpecificId))) {
            unset($this->ServiceSpecificId);
        } else {
            $this->ServiceSpecificId = $serviceSpecificId;
        }
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId, true)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetKind()
    {
        return isset($this->TargetKind) ? $this->TargetKind : null;
    }
    /**
     * Set TargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetKind
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTargetKind($targetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($targetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($targetKind) ? implode(', ', $targetKind) : var_export($targetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($targetKind) || (is_array($targetKind) && empty($targetKind))) {
            unset($this->TargetKind);
        } else {
            $this->TargetKind = $targetKind;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidAmount()
    {
        return isset($this->UnpaidAmount) ? $this->UnpaidAmount : null;
    }
    /**
     * Set UnpaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setUnpaidAmount(\patest\StructType\Money $unpaidAmount = null)
    {
        if (is_null($unpaidAmount) || (is_array($unpaidAmount) && empty($unpaidAmount))) {
            unset($this->UnpaidAmount);
        } else {
            $this->UnpaidAmount = $unpaidAmount;
        }
        return $this;
    }
    /**
     * Get UnpaidInstallmentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidInstallmentsAmount()
    {
        return isset($this->UnpaidInstallmentsAmount) ? $this->UnpaidInstallmentsAmount : null;
    }
    /**
     * Set UnpaidInstallmentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummaryBase
     */
    public function setUnpaidInstallmentsAmount(\patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        if (is_null($unpaidInstallmentsAmount) || (is_array($unpaidInstallmentsAmount) && empty($unpaidInstallmentsAmount))) {
            unset($this->UnpaidInstallmentsAmount);
        } else {
            $this->UnpaidInstallmentsAmount = $unpaidInstallmentsAmount;
        }
        return $this;
    }
}
