<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialJournalTargetSummary StructType
 * @subpackage Structs
 */
class Sales_FinancialJournalTargetSummary extends Sales_FinancialJournalTargetSummaryBase
{
    /**
     * The BuyingPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BuyingPrice;
    /**
     * The BuyingSequentialNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BuyingSequentialNumber;
    /**
     * The GroupedItemSpecificId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupedItemSpecificId;
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $ItemDetails;
    /**
     * The PaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidInstallmentsAmount;
    /**
     * The PaymentAmountOnPurchase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentAmountOnPurchase;
    /**
     * The PaymentMethodIdsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodIdsList;
    /**
     * The PaymentPlanAmountOnPurchase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentPlanAmountOnPurchase;
    /**
     * The PaymentPlansAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentPlansAmount;
    /**
     * The RegularPaymentsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RegularPaymentsAmount;
    /**
     * The SubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetId;
    /**
     * The SubTargetServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetServiceSpecificId;
    /**
     * The TargetDisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetDisplayName;
    /**
     * The TargetId2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId2;
    /**
     * Constructor method for Sales.FinancialJournalTargetSummary
     * @uses Sales_FinancialJournalTargetSummary::setBuyingPrice()
     * @uses Sales_FinancialJournalTargetSummary::setBuyingSequentialNumber()
     * @uses Sales_FinancialJournalTargetSummary::setGroupedItemSpecificId()
     * @uses Sales_FinancialJournalTargetSummary::setItemDetails()
     * @uses Sales_FinancialJournalTargetSummary::setPaidInstallmentsAmount()
     * @uses Sales_FinancialJournalTargetSummary::setPaymentAmountOnPurchase()
     * @uses Sales_FinancialJournalTargetSummary::setPaymentMethodIdsList()
     * @uses Sales_FinancialJournalTargetSummary::setPaymentPlanAmountOnPurchase()
     * @uses Sales_FinancialJournalTargetSummary::setPaymentPlansAmount()
     * @uses Sales_FinancialJournalTargetSummary::setRegularPaymentsAmount()
     * @uses Sales_FinancialJournalTargetSummary::setSubTargetId()
     * @uses Sales_FinancialJournalTargetSummary::setSubTargetServiceSpecificId()
     * @uses Sales_FinancialJournalTargetSummary::setTargetDisplayName()
     * @uses Sales_FinancialJournalTargetSummary::setTargetId2()
     * @param \patest\StructType\Money $buyingPrice
     * @param int $buyingSequentialNumber
     * @param string $groupedItemSpecificId
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @param \patest\StructType\Money $paidInstallmentsAmount
     * @param \patest\StructType\Money $paymentAmountOnPurchase
     * @param string $paymentMethodIdsList
     * @param \patest\StructType\Money $paymentPlanAmountOnPurchase
     * @param \patest\StructType\Money $paymentPlansAmount
     * @param \patest\StructType\Money $regularPaymentsAmount
     * @param string $subTargetId
     * @param string $subTargetServiceSpecificId
     * @param string $targetDisplayName
     * @param string $targetId2
     */
    public function __construct(\patest\StructType\Money $buyingPrice = null, $buyingSequentialNumber = null, $groupedItemSpecificId = null, \patest\StructType\Sales_AbstractItemDetails $itemDetails = null, \patest\StructType\Money $paidInstallmentsAmount = null, \patest\StructType\Money $paymentAmountOnPurchase = null, $paymentMethodIdsList = null, \patest\StructType\Money $paymentPlanAmountOnPurchase = null, \patest\StructType\Money $paymentPlansAmount = null, \patest\StructType\Money $regularPaymentsAmount = null, $subTargetId = null, $subTargetServiceSpecificId = null, $targetDisplayName = null, $targetId2 = null)
    {
        $this
            ->setBuyingPrice($buyingPrice)
            ->setBuyingSequentialNumber($buyingSequentialNumber)
            ->setGroupedItemSpecificId($groupedItemSpecificId)
            ->setItemDetails($itemDetails)
            ->setPaidInstallmentsAmount($paidInstallmentsAmount)
            ->setPaymentAmountOnPurchase($paymentAmountOnPurchase)
            ->setPaymentMethodIdsList($paymentMethodIdsList)
            ->setPaymentPlanAmountOnPurchase($paymentPlanAmountOnPurchase)
            ->setPaymentPlansAmount($paymentPlansAmount)
            ->setRegularPaymentsAmount($regularPaymentsAmount)
            ->setSubTargetId($subTargetId)
            ->setSubTargetServiceSpecificId($subTargetServiceSpecificId)
            ->setTargetDisplayName($targetDisplayName)
            ->setTargetId2($targetId2);
    }
    /**
     * Get BuyingPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBuyingPrice()
    {
        return isset($this->BuyingPrice) ? $this->BuyingPrice : null;
    }
    /**
     * Set BuyingPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $buyingPrice
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setBuyingPrice(\patest\StructType\Money $buyingPrice = null)
    {
        if (is_null($buyingPrice) || (is_array($buyingPrice) && empty($buyingPrice))) {
            unset($this->BuyingPrice);
        } else {
            $this->BuyingPrice = $buyingPrice;
        }
        return $this;
    }
    /**
     * Get BuyingSequentialNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBuyingSequentialNumber()
    {
        return isset($this->BuyingSequentialNumber) ? $this->BuyingSequentialNumber : null;
    }
    /**
     * Set BuyingSequentialNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $buyingSequentialNumber
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setBuyingSequentialNumber($buyingSequentialNumber = null)
    {
        // validation for constraint: int
        if (!is_null($buyingSequentialNumber) && !(is_int($buyingSequentialNumber) || ctype_digit($buyingSequentialNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buyingSequentialNumber, true), gettype($buyingSequentialNumber)), __LINE__);
        }
        if (is_null($buyingSequentialNumber) || (is_array($buyingSequentialNumber) && empty($buyingSequentialNumber))) {
            unset($this->BuyingSequentialNumber);
        } else {
            $this->BuyingSequentialNumber = $buyingSequentialNumber;
        }
        return $this;
    }
    /**
     * Get GroupedItemSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupedItemSpecificId()
    {
        return isset($this->GroupedItemSpecificId) ? $this->GroupedItemSpecificId : null;
    }
    /**
     * Set GroupedItemSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupedItemSpecificId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setGroupedItemSpecificId($groupedItemSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($groupedItemSpecificId) && !is_string($groupedItemSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupedItemSpecificId, true), gettype($groupedItemSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupedItemSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupedItemSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupedItemSpecificId, true)), __LINE__);
        }
        if (is_null($groupedItemSpecificId) || (is_array($groupedItemSpecificId) && empty($groupedItemSpecificId))) {
            unset($this->GroupedItemSpecificId);
        } else {
            $this->GroupedItemSpecificId = $groupedItemSpecificId;
        }
        return $this;
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setItemDetails(\patest\StructType\Sales_AbstractItemDetails $itemDetails = null)
    {
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Get PaidInstallmentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidInstallmentsAmount()
    {
        return isset($this->PaidInstallmentsAmount) ? $this->PaidInstallmentsAmount : null;
    }
    /**
     * Set PaidInstallmentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidInstallmentsAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setPaidInstallmentsAmount(\patest\StructType\Money $paidInstallmentsAmount = null)
    {
        if (is_null($paidInstallmentsAmount) || (is_array($paidInstallmentsAmount) && empty($paidInstallmentsAmount))) {
            unset($this->PaidInstallmentsAmount);
        } else {
            $this->PaidInstallmentsAmount = $paidInstallmentsAmount;
        }
        return $this;
    }
    /**
     * Get PaymentAmountOnPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentAmountOnPurchase()
    {
        return isset($this->PaymentAmountOnPurchase) ? $this->PaymentAmountOnPurchase : null;
    }
    /**
     * Set PaymentAmountOnPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentAmountOnPurchase
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setPaymentAmountOnPurchase(\patest\StructType\Money $paymentAmountOnPurchase = null)
    {
        if (is_null($paymentAmountOnPurchase) || (is_array($paymentAmountOnPurchase) && empty($paymentAmountOnPurchase))) {
            unset($this->PaymentAmountOnPurchase);
        } else {
            $this->PaymentAmountOnPurchase = $paymentAmountOnPurchase;
        }
        return $this;
    }
    /**
     * Get PaymentMethodIdsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodIdsList()
    {
        return isset($this->PaymentMethodIdsList) ? $this->PaymentMethodIdsList : null;
    }
    /**
     * Set PaymentMethodIdsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodIdsList
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setPaymentMethodIdsList($paymentMethodIdsList = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodIdsList) && !is_string($paymentMethodIdsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodIdsList, true), gettype($paymentMethodIdsList)), __LINE__);
        }
        if (is_null($paymentMethodIdsList) || (is_array($paymentMethodIdsList) && empty($paymentMethodIdsList))) {
            unset($this->PaymentMethodIdsList);
        } else {
            $this->PaymentMethodIdsList = $paymentMethodIdsList;
        }
        return $this;
    }
    /**
     * Get PaymentPlanAmountOnPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentPlanAmountOnPurchase()
    {
        return isset($this->PaymentPlanAmountOnPurchase) ? $this->PaymentPlanAmountOnPurchase : null;
    }
    /**
     * Set PaymentPlanAmountOnPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentPlanAmountOnPurchase
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setPaymentPlanAmountOnPurchase(\patest\StructType\Money $paymentPlanAmountOnPurchase = null)
    {
        if (is_null($paymentPlanAmountOnPurchase) || (is_array($paymentPlanAmountOnPurchase) && empty($paymentPlanAmountOnPurchase))) {
            unset($this->PaymentPlanAmountOnPurchase);
        } else {
            $this->PaymentPlanAmountOnPurchase = $paymentPlanAmountOnPurchase;
        }
        return $this;
    }
    /**
     * Get PaymentPlansAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentPlansAmount()
    {
        return isset($this->PaymentPlansAmount) ? $this->PaymentPlansAmount : null;
    }
    /**
     * Set PaymentPlansAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentPlansAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setPaymentPlansAmount(\patest\StructType\Money $paymentPlansAmount = null)
    {
        if (is_null($paymentPlansAmount) || (is_array($paymentPlansAmount) && empty($paymentPlansAmount))) {
            unset($this->PaymentPlansAmount);
        } else {
            $this->PaymentPlansAmount = $paymentPlansAmount;
        }
        return $this;
    }
    /**
     * Get RegularPaymentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRegularPaymentsAmount()
    {
        return isset($this->RegularPaymentsAmount) ? $this->RegularPaymentsAmount : null;
    }
    /**
     * Set RegularPaymentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $regularPaymentsAmount
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setRegularPaymentsAmount(\patest\StructType\Money $regularPaymentsAmount = null)
    {
        if (is_null($regularPaymentsAmount) || (is_array($regularPaymentsAmount) && empty($regularPaymentsAmount))) {
            unset($this->RegularPaymentsAmount);
        } else {
            $this->RegularPaymentsAmount = $regularPaymentsAmount;
        }
        return $this;
    }
    /**
     * Get SubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetId()
    {
        return isset($this->SubTargetId) ? $this->SubTargetId : null;
    }
    /**
     * Set SubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setSubTargetId($subTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetId) && !is_string($subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetId, true), gettype($subTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetId, true)), __LINE__);
        }
        if (is_null($subTargetId) || (is_array($subTargetId) && empty($subTargetId))) {
            unset($this->SubTargetId);
        } else {
            $this->SubTargetId = $subTargetId;
        }
        return $this;
    }
    /**
     * Get SubTargetServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetServiceSpecificId()
    {
        return isset($this->SubTargetServiceSpecificId) ? $this->SubTargetServiceSpecificId : null;
    }
    /**
     * Set SubTargetServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetServiceSpecificId
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setSubTargetServiceSpecificId($subTargetServiceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetServiceSpecificId) && !is_string($subTargetServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetServiceSpecificId, true), gettype($subTargetServiceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetServiceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetServiceSpecificId, true)), __LINE__);
        }
        if (is_null($subTargetServiceSpecificId) || (is_array($subTargetServiceSpecificId) && empty($subTargetServiceSpecificId))) {
            unset($this->SubTargetServiceSpecificId);
        } else {
            $this->SubTargetServiceSpecificId = $subTargetServiceSpecificId;
        }
        return $this;
    }
    /**
     * Get TargetDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDisplayName()
    {
        return isset($this->TargetDisplayName) ? $this->TargetDisplayName : null;
    }
    /**
     * Set TargetDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDisplayName
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setTargetDisplayName($targetDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($targetDisplayName) && !is_string($targetDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDisplayName, true), gettype($targetDisplayName)), __LINE__);
        }
        if (is_null($targetDisplayName) || (is_array($targetDisplayName) && empty($targetDisplayName))) {
            unset($this->TargetDisplayName);
        } else {
            $this->TargetDisplayName = $targetDisplayName;
        }
        return $this;
    }
    /**
     * Get TargetId2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId2()
    {
        return isset($this->TargetId2) ? $this->TargetId2 : null;
    }
    /**
     * Set TargetId2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId2
     * @return \patest\StructType\Sales_FinancialJournalTargetSummary
     */
    public function setTargetId2($targetId2 = null)
    {
        // validation for constraint: string
        if (!is_null($targetId2) && !is_string($targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId2, true), gettype($targetId2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId2, true)), __LINE__);
        }
        if (is_null($targetId2) || (is_array($targetId2) && empty($targetId2))) {
            unset($this->TargetId2);
        } else {
            $this->TargetId2 = $targetId2;
        }
        return $this;
    }
}
