<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Deduction StructType
 * @subpackage Structs
 */
class Sales_Deduction extends PersistableEntity
{
    /**
     * The DeductionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DeductionAmount;
    /**
     * The DeductionItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeductionItemId;
    /**
     * The DeductionItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeductionItemType;
    /**
     * The IsFullDeducted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullDeducted;
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * Constructor method for Sales.Deduction
     * @uses Sales_Deduction::setDeductionAmount()
     * @uses Sales_Deduction::setDeductionItemId()
     * @uses Sales_Deduction::setDeductionItemType()
     * @uses Sales_Deduction::setIsFullDeducted()
     * @uses Sales_Deduction::setOperationId()
     * @param \patest\StructType\Money $deductionAmount
     * @param string $deductionItemId
     * @param string $deductionItemType
     * @param bool $isFullDeducted
     * @param string $operationId
     */
    public function __construct(\patest\StructType\Money $deductionAmount = null, $deductionItemId = null, $deductionItemType = null, $isFullDeducted = null, $operationId = null)
    {
        $this
            ->setDeductionAmount($deductionAmount)
            ->setDeductionItemId($deductionItemId)
            ->setDeductionItemType($deductionItemType)
            ->setIsFullDeducted($isFullDeducted)
            ->setOperationId($operationId);
    }
    /**
     * Get DeductionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDeductionAmount()
    {
        return isset($this->DeductionAmount) ? $this->DeductionAmount : null;
    }
    /**
     * Set DeductionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $deductionAmount
     * @return \patest\StructType\Sales_Deduction
     */
    public function setDeductionAmount(\patest\StructType\Money $deductionAmount = null)
    {
        if (is_null($deductionAmount) || (is_array($deductionAmount) && empty($deductionAmount))) {
            unset($this->DeductionAmount);
        } else {
            $this->DeductionAmount = $deductionAmount;
        }
        return $this;
    }
    /**
     * Get DeductionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductionItemId()
    {
        return isset($this->DeductionItemId) ? $this->DeductionItemId : null;
    }
    /**
     * Set DeductionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deductionItemId
     * @return \patest\StructType\Sales_Deduction
     */
    public function setDeductionItemId($deductionItemId = null)
    {
        // validation for constraint: string
        if (!is_null($deductionItemId) && !is_string($deductionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deductionItemId, true), gettype($deductionItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deductionItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deductionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deductionItemId, true)), __LINE__);
        }
        if (is_null($deductionItemId) || (is_array($deductionItemId) && empty($deductionItemId))) {
            unset($this->DeductionItemId);
        } else {
            $this->DeductionItemId = $deductionItemId;
        }
        return $this;
    }
    /**
     * Get DeductionItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductionItemType()
    {
        return isset($this->DeductionItemType) ? $this->DeductionItemType : null;
    }
    /**
     * Set DeductionItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DeductionItemKind::valueIsValid()
     * @uses \patest\EnumType\DeductionItemKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deductionItemType
     * @return \patest\StructType\Sales_Deduction
     */
    public function setDeductionItemType($deductionItemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DeductionItemKind::valueIsValid($deductionItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DeductionItemKind', is_array($deductionItemType) ? implode(', ', $deductionItemType) : var_export($deductionItemType, true), implode(', ', \patest\EnumType\DeductionItemKind::getValidValues())), __LINE__);
        }
        if (is_null($deductionItemType) || (is_array($deductionItemType) && empty($deductionItemType))) {
            unset($this->DeductionItemType);
        } else {
            $this->DeductionItemType = $deductionItemType;
        }
        return $this;
    }
    /**
     * Get IsFullDeducted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullDeducted()
    {
        return isset($this->IsFullDeducted) ? $this->IsFullDeducted : null;
    }
    /**
     * Set IsFullDeducted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullDeducted
     * @return \patest\StructType\Sales_Deduction
     */
    public function setIsFullDeducted($isFullDeducted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullDeducted) && !is_bool($isFullDeducted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullDeducted, true), gettype($isFullDeducted)), __LINE__);
        }
        if (is_null($isFullDeducted) || (is_array($isFullDeducted) && empty($isFullDeducted))) {
            unset($this->IsFullDeducted);
        } else {
            $this->IsFullDeducted = $isFullDeducted;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\Sales_Deduction
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
}
