<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BundleItemInformation StructType
 * @subpackage Structs
 */
class Sales_BundleItemInformation extends AnyEntity
{
    /**
     * The BundleProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleProductId;
    /**
     * The ElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ElementId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Product;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qty;
    /**
     * The SelectedItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedItem;
    /**
     * The YourSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $YourSelection;
    /**
     * Constructor method for Sales.BundleItemInformation
     * @uses Sales_BundleItemInformation::setBundleProductId()
     * @uses Sales_BundleItemInformation::setElementId()
     * @uses Sales_BundleItemInformation::setName()
     * @uses Sales_BundleItemInformation::setProduct()
     * @uses Sales_BundleItemInformation::setQty()
     * @uses Sales_BundleItemInformation::setSelectedItem()
     * @uses Sales_BundleItemInformation::setYourSelection()
     * @param string $bundleProductId
     * @param string $elementId
     * @param string $name
     * @param string $product
     * @param int $qty
     * @param string $selectedItem
     * @param string $yourSelection
     */
    public function __construct($bundleProductId = null, $elementId = null, $name = null, $product = null, $qty = null, $selectedItem = null, $yourSelection = null)
    {
        $this
            ->setBundleProductId($bundleProductId)
            ->setElementId($elementId)
            ->setName($name)
            ->setProduct($product)
            ->setQty($qty)
            ->setSelectedItem($selectedItem)
            ->setYourSelection($yourSelection);
    }
    /**
     * Get BundleProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleProductId()
    {
        return isset($this->BundleProductId) ? $this->BundleProductId : null;
    }
    /**
     * Set BundleProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleProductId
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setBundleProductId($bundleProductId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleProductId) && !is_string($bundleProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleProductId, true), gettype($bundleProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleProductId, true)), __LINE__);
        }
        if (is_null($bundleProductId) || (is_array($bundleProductId) && empty($bundleProductId))) {
            unset($this->BundleProductId);
        } else {
            $this->BundleProductId = $bundleProductId;
        }
        return $this;
    }
    /**
     * Get ElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementId()
    {
        return isset($this->ElementId) ? $this->ElementId : null;
    }
    /**
     * Set ElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementId
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setElementId($elementId = null)
    {
        // validation for constraint: string
        if (!is_null($elementId) && !is_string($elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementId, true), gettype($elementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($elementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $elementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($elementId, true)), __LINE__);
        }
        if (is_null($elementId) || (is_array($elementId) && empty($elementId))) {
            unset($this->ElementId);
        } else {
            $this->ElementId = $elementId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $product
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qty
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get SelectedItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedItem()
    {
        return isset($this->SelectedItem) ? $this->SelectedItem : null;
    }
    /**
     * Set SelectedItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedItem
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setSelectedItem($selectedItem = null)
    {
        // validation for constraint: string
        if (!is_null($selectedItem) && !is_string($selectedItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedItem, true), gettype($selectedItem)), __LINE__);
        }
        if (is_null($selectedItem) || (is_array($selectedItem) && empty($selectedItem))) {
            unset($this->SelectedItem);
        } else {
            $this->SelectedItem = $selectedItem;
        }
        return $this;
    }
    /**
     * Get YourSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getYourSelection()
    {
        return isset($this->YourSelection) ? $this->YourSelection : null;
    }
    /**
     * Set YourSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $yourSelection
     * @return \patest\StructType\Sales_BundleItemInformation
     */
    public function setYourSelection($yourSelection = null)
    {
        // validation for constraint: string
        if (!is_null($yourSelection) && !is_string($yourSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yourSelection, true), gettype($yourSelection)), __LINE__);
        }
        if (is_null($yourSelection) || (is_array($yourSelection) && empty($yourSelection))) {
            unset($this->YourSelection);
        } else {
            $this->YourSelection = $yourSelection;
        }
        return $this;
    }
}
