<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalePointConfiguration StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SalePointConfiguration
 * @subpackage Structs
 */
class SalePointConfiguration extends AbstractStructBase
{
    /**
     * The HasPhysicalKeyboard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPhysicalKeyboard;
    /**
     * The LocaleInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\LocaleInfo
     */
    public $LocaleInfo;
    /**
     * The Peripherals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPeripheralDeviceInfo
     */
    public $Peripherals;
    /**
     * Constructor method for SalePointConfiguration
     * @uses SalePointConfiguration::setHasPhysicalKeyboard()
     * @uses SalePointConfiguration::setLocaleInfo()
     * @uses SalePointConfiguration::setPeripherals()
     * @param bool $hasPhysicalKeyboard
     * @param \patest\StructType\LocaleInfo $localeInfo
     * @param \patest\ArrayType\ArrayOfPeripheralDeviceInfo $peripherals
     */
    public function __construct($hasPhysicalKeyboard = null, \patest\StructType\LocaleInfo $localeInfo = null, \patest\ArrayType\ArrayOfPeripheralDeviceInfo $peripherals = null)
    {
        $this
            ->setHasPhysicalKeyboard($hasPhysicalKeyboard)
            ->setLocaleInfo($localeInfo)
            ->setPeripherals($peripherals);
    }
    /**
     * Get HasPhysicalKeyboard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPhysicalKeyboard()
    {
        return isset($this->HasPhysicalKeyboard) ? $this->HasPhysicalKeyboard : null;
    }
    /**
     * Set HasPhysicalKeyboard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPhysicalKeyboard
     * @return \patest\StructType\SalePointConfiguration
     */
    public function setHasPhysicalKeyboard($hasPhysicalKeyboard = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPhysicalKeyboard) && !is_bool($hasPhysicalKeyboard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPhysicalKeyboard, true), gettype($hasPhysicalKeyboard)), __LINE__);
        }
        if (is_null($hasPhysicalKeyboard) || (is_array($hasPhysicalKeyboard) && empty($hasPhysicalKeyboard))) {
            unset($this->HasPhysicalKeyboard);
        } else {
            $this->HasPhysicalKeyboard = $hasPhysicalKeyboard;
        }
        return $this;
    }
    /**
     * Get LocaleInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\LocaleInfo|null
     */
    public function getLocaleInfo()
    {
        return isset($this->LocaleInfo) ? $this->LocaleInfo : null;
    }
    /**
     * Set LocaleInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\LocaleInfo $localeInfo
     * @return \patest\StructType\SalePointConfiguration
     */
    public function setLocaleInfo(\patest\StructType\LocaleInfo $localeInfo = null)
    {
        if (is_null($localeInfo) || (is_array($localeInfo) && empty($localeInfo))) {
            unset($this->LocaleInfo);
        } else {
            $this->LocaleInfo = $localeInfo;
        }
        return $this;
    }
    /**
     * Get Peripherals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPeripheralDeviceInfo|null
     */
    public function getPeripherals()
    {
        return isset($this->Peripherals) ? $this->Peripherals : null;
    }
    /**
     * Set Peripherals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPeripheralDeviceInfo $peripherals
     * @return \patest\StructType\SalePointConfiguration
     */
    public function setPeripherals(\patest\ArrayType\ArrayOfPeripheralDeviceInfo $peripherals = null)
    {
        if (is_null($peripherals) || (is_array($peripherals) && empty($peripherals))) {
            unset($this->Peripherals);
        } else {
            $this->Peripherals = $peripherals;
        }
        return $this;
    }
}
