<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleSetDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RuleSetDescription
 * @subpackage Structs
 */
class RuleSetDescription extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The PrerequisiteValueGetterIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $PrerequisiteValueGetterIds;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * Constructor method for RuleSetDescription
     * @uses RuleSetDescription::setId()
     * @uses RuleSetDescription::setPrerequisiteValueGetterIds()
     * @uses RuleSetDescription::setSystemName()
     * @param string $id
     * @param \patest\ArrayType\ArrayOfstring $prerequisiteValueGetterIds
     * @param string $systemName
     */
    public function __construct($id = null, \patest\ArrayType\ArrayOfstring $prerequisiteValueGetterIds = null, $systemName = null)
    {
        $this
            ->setId($id)
            ->setPrerequisiteValueGetterIds($prerequisiteValueGetterIds)
            ->setSystemName($systemName);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\RuleSetDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get PrerequisiteValueGetterIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getPrerequisiteValueGetterIds()
    {
        return isset($this->PrerequisiteValueGetterIds) ? $this->PrerequisiteValueGetterIds : null;
    }
    /**
     * Set PrerequisiteValueGetterIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $prerequisiteValueGetterIds
     * @return \patest\StructType\RuleSetDescription
     */
    public function setPrerequisiteValueGetterIds(\patest\ArrayType\ArrayOfstring $prerequisiteValueGetterIds = null)
    {
        if (is_null($prerequisiteValueGetterIds) || (is_array($prerequisiteValueGetterIds) && empty($prerequisiteValueGetterIds))) {
            unset($this->PrerequisiteValueGetterIds);
        } else {
            $this->PrerequisiteValueGetterIds = $prerequisiteValueGetterIds;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\RuleSetDescription
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
}
