<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.RuleSystem StructType
 * @subpackage Structs
 */
class RuleEngine_RuleSystem extends PersistableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OwnerServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerServiceName;
    /**
     * The RuleSets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RuleSets
     */
    public $RuleSets;
    /**
     * Constructor method for RuleEngine.RuleSystem
     * @uses RuleEngine_RuleSystem::setDescription()
     * @uses RuleEngine_RuleSystem::setName()
     * @uses RuleEngine_RuleSystem::setOwnerServiceName()
     * @uses RuleEngine_RuleSystem::setRuleSets()
     * @param string $description
     * @param string $name
     * @param string $ownerServiceName
     * @param \patest\StructType\RuleSets $ruleSets
     */
    public function __construct($description = null, $name = null, $ownerServiceName = null, \patest\StructType\RuleSets $ruleSets = null)
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setOwnerServiceName($ownerServiceName)
            ->setRuleSets($ruleSets);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\RuleEngine_RuleSystem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\RuleEngine_RuleSystem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OwnerServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerServiceName()
    {
        return isset($this->OwnerServiceName) ? $this->OwnerServiceName : null;
    }
    /**
     * Set OwnerServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerServiceName
     * @return \patest\StructType\RuleEngine_RuleSystem
     */
    public function setOwnerServiceName($ownerServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerServiceName) && !is_string($ownerServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerServiceName, true), gettype($ownerServiceName)), __LINE__);
        }
        if (is_null($ownerServiceName) || (is_array($ownerServiceName) && empty($ownerServiceName))) {
            unset($this->OwnerServiceName);
        } else {
            $this->OwnerServiceName = $ownerServiceName;
        }
        return $this;
    }
    /**
     * Get RuleSets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RuleSets|null
     */
    public function getRuleSets()
    {
        return isset($this->RuleSets) ? $this->RuleSets : null;
    }
    /**
     * Set RuleSets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RuleSets $ruleSets
     * @return \patest\StructType\RuleEngine_RuleSystem
     */
    public function setRuleSets(\patest\StructType\RuleSets $ruleSets = null)
    {
        if (is_null($ruleSets) || (is_array($ruleSets) && empty($ruleSets))) {
            unset($this->RuleSets);
        } else {
            $this->RuleSets = $ruleSets;
        }
        return $this;
    }
}
