<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.RuleDependency StructType
 * @subpackage Structs
 */
class RuleEngine_RuleDependency extends PersistableEntity
{
    /**
     * The ActionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActionId;
    /**
     * The CriterionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CriterionId;
    /**
     * The DependencyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DependencyType;
    /**
     * The RelatedEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityId;
    /**
     * The RelatedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityName;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleId;
    /**
     * Constructor method for RuleEngine.RuleDependency
     * @uses RuleEngine_RuleDependency::setActionId()
     * @uses RuleEngine_RuleDependency::setCriterionId()
     * @uses RuleEngine_RuleDependency::setDependencyType()
     * @uses RuleEngine_RuleDependency::setRelatedEntityId()
     * @uses RuleEngine_RuleDependency::setRelatedEntityName()
     * @uses RuleEngine_RuleDependency::setRuleId()
     * @param string $actionId
     * @param string $criterionId
     * @param string $dependencyType
     * @param string $relatedEntityId
     * @param string $relatedEntityName
     * @param string $ruleId
     */
    public function __construct($actionId = null, $criterionId = null, $dependencyType = null, $relatedEntityId = null, $relatedEntityName = null, $ruleId = null)
    {
        $this
            ->setActionId($actionId)
            ->setCriterionId($criterionId)
            ->setDependencyType($dependencyType)
            ->setRelatedEntityId($relatedEntityId)
            ->setRelatedEntityName($relatedEntityName)
            ->setRuleId($ruleId);
    }
    /**
     * Get ActionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionId()
    {
        return isset($this->ActionId) ? $this->ActionId : null;
    }
    /**
     * Set ActionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionId
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setActionId($actionId = null)
    {
        // validation for constraint: string
        if (!is_null($actionId) && !is_string($actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionId, true), gettype($actionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($actionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($actionId, true)), __LINE__);
        }
        if (is_null($actionId) || (is_array($actionId) && empty($actionId))) {
            unset($this->ActionId);
        } else {
            $this->ActionId = $actionId;
        }
        return $this;
    }
    /**
     * Get CriterionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriterionId()
    {
        return isset($this->CriterionId) ? $this->CriterionId : null;
    }
    /**
     * Set CriterionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criterionId
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setCriterionId($criterionId = null)
    {
        // validation for constraint: string
        if (!is_null($criterionId) && !is_string($criterionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($criterionId, true), gettype($criterionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($criterionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $criterionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($criterionId, true)), __LINE__);
        }
        if (is_null($criterionId) || (is_array($criterionId) && empty($criterionId))) {
            unset($this->CriterionId);
        } else {
            $this->CriterionId = $criterionId;
        }
        return $this;
    }
    /**
     * Get DependencyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDependencyType()
    {
        return isset($this->DependencyType) ? $this->DependencyType : null;
    }
    /**
     * Set DependencyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RuleDependencyType::valueIsValid()
     * @uses \patest\EnumType\RuleDependencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dependencyType
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setDependencyType($dependencyType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RuleDependencyType::valueIsValid($dependencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RuleDependencyType', is_array($dependencyType) ? implode(', ', $dependencyType) : var_export($dependencyType, true), implode(', ', \patest\EnumType\RuleDependencyType::getValidValues())), __LINE__);
        }
        if (is_null($dependencyType) || (is_array($dependencyType) && empty($dependencyType))) {
            unset($this->DependencyType);
        } else {
            $this->DependencyType = $dependencyType;
        }
        return $this;
    }
    /**
     * Get RelatedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityId()
    {
        return isset($this->RelatedEntityId) ? $this->RelatedEntityId : null;
    }
    /**
     * Set RelatedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityId
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setRelatedEntityId($relatedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityId) && !is_string($relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityId, true), gettype($relatedEntityId)), __LINE__);
        }
        if (is_null($relatedEntityId) || (is_array($relatedEntityId) && empty($relatedEntityId))) {
            unset($this->RelatedEntityId);
        } else {
            $this->RelatedEntityId = $relatedEntityId;
        }
        return $this;
    }
    /**
     * Get RelatedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityName()
    {
        return isset($this->RelatedEntityName) ? $this->RelatedEntityName : null;
    }
    /**
     * Set RelatedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityName
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setRelatedEntityName($relatedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityName) && !is_string($relatedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityName, true), gettype($relatedEntityName)), __LINE__);
        }
        if (is_null($relatedEntityName) || (is_array($relatedEntityName) && empty($relatedEntityName))) {
            unset($this->RelatedEntityName);
        } else {
            $this->RelatedEntityName = $relatedEntityName;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\RuleEngine_RuleDependency
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleId, true)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
}
