<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.Criterion StructType
 * @subpackage Structs
 */
class RuleEngine_Criterion extends PersistableEntity
{
    /**
     * The DisplayString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayString;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The Operand1Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand1Type;
    /**
     * The Operand1Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand1Value;
    /**
     * The Operand1VocabularyDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand1VocabularyDefinitionId;
    /**
     * The Operand2Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand2Type;
    /**
     * The Operand2Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand2Value;
    /**
     * The Operand2VocabularyDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operand2VocabularyDefinitionId;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operator;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleId;
    /**
     * The ValueTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueTypeName;
    /**
     * Constructor method for RuleEngine.Criterion
     * @uses RuleEngine_Criterion::setDisplayString()
     * @uses RuleEngine_Criterion::setIsDefault()
     * @uses RuleEngine_Criterion::setOperand1Type()
     * @uses RuleEngine_Criterion::setOperand1Value()
     * @uses RuleEngine_Criterion::setOperand1VocabularyDefinitionId()
     * @uses RuleEngine_Criterion::setOperand2Type()
     * @uses RuleEngine_Criterion::setOperand2Value()
     * @uses RuleEngine_Criterion::setOperand2VocabularyDefinitionId()
     * @uses RuleEngine_Criterion::setOperator()
     * @uses RuleEngine_Criterion::setRuleId()
     * @uses RuleEngine_Criterion::setValueTypeName()
     * @param string $displayString
     * @param bool $isDefault
     * @param string $operand1Type
     * @param string $operand1Value
     * @param string $operand1VocabularyDefinitionId
     * @param string $operand2Type
     * @param string $operand2Value
     * @param string $operand2VocabularyDefinitionId
     * @param string $operator
     * @param string $ruleId
     * @param string $valueTypeName
     */
    public function __construct($displayString = null, $isDefault = null, $operand1Type = null, $operand1Value = null, $operand1VocabularyDefinitionId = null, $operand2Type = null, $operand2Value = null, $operand2VocabularyDefinitionId = null, $operator = null, $ruleId = null, $valueTypeName = null)
    {
        $this
            ->setDisplayString($displayString)
            ->setIsDefault($isDefault)
            ->setOperand1Type($operand1Type)
            ->setOperand1Value($operand1Value)
            ->setOperand1VocabularyDefinitionId($operand1VocabularyDefinitionId)
            ->setOperand2Type($operand2Type)
            ->setOperand2Value($operand2Value)
            ->setOperand2VocabularyDefinitionId($operand2VocabularyDefinitionId)
            ->setOperator($operator)
            ->setRuleId($ruleId)
            ->setValueTypeName($valueTypeName);
    }
    /**
     * Get DisplayString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayString()
    {
        return isset($this->DisplayString) ? $this->DisplayString : null;
    }
    /**
     * Set DisplayString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayString
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setDisplayString($displayString = null)
    {
        // validation for constraint: string
        if (!is_null($displayString) && !is_string($displayString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayString, true), gettype($displayString)), __LINE__);
        }
        if (is_null($displayString) || (is_array($displayString) && empty($displayString))) {
            unset($this->DisplayString);
        } else {
            $this->DisplayString = $displayString;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get Operand1Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand1Type()
    {
        return isset($this->Operand1Type) ? $this->Operand1Type : null;
    }
    /**
     * Set Operand1Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperandType::valueIsValid()
     * @uses \patest\EnumType\OperandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operand1Type
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand1Type($operand1Type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OperandType::valueIsValid($operand1Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperandType', is_array($operand1Type) ? implode(', ', $operand1Type) : var_export($operand1Type, true), implode(', ', \patest\EnumType\OperandType::getValidValues())), __LINE__);
        }
        if (is_null($operand1Type) || (is_array($operand1Type) && empty($operand1Type))) {
            unset($this->Operand1Type);
        } else {
            $this->Operand1Type = $operand1Type;
        }
        return $this;
    }
    /**
     * Get Operand1Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand1Value()
    {
        return isset($this->Operand1Value) ? $this->Operand1Value : null;
    }
    /**
     * Set Operand1Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand1Value
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand1Value($operand1Value = null)
    {
        // validation for constraint: string
        if (!is_null($operand1Value) && !is_string($operand1Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand1Value, true), gettype($operand1Value)), __LINE__);
        }
        if (is_null($operand1Value) || (is_array($operand1Value) && empty($operand1Value))) {
            unset($this->Operand1Value);
        } else {
            $this->Operand1Value = $operand1Value;
        }
        return $this;
    }
    /**
     * Get Operand1VocabularyDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand1VocabularyDefinitionId()
    {
        return isset($this->Operand1VocabularyDefinitionId) ? $this->Operand1VocabularyDefinitionId : null;
    }
    /**
     * Set Operand1VocabularyDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand1VocabularyDefinitionId
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand1VocabularyDefinitionId($operand1VocabularyDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($operand1VocabularyDefinitionId) && !is_string($operand1VocabularyDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand1VocabularyDefinitionId, true), gettype($operand1VocabularyDefinitionId)), __LINE__);
        }
        if (is_null($operand1VocabularyDefinitionId) || (is_array($operand1VocabularyDefinitionId) && empty($operand1VocabularyDefinitionId))) {
            unset($this->Operand1VocabularyDefinitionId);
        } else {
            $this->Operand1VocabularyDefinitionId = $operand1VocabularyDefinitionId;
        }
        return $this;
    }
    /**
     * Get Operand2Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand2Type()
    {
        return isset($this->Operand2Type) ? $this->Operand2Type : null;
    }
    /**
     * Set Operand2Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperandType::valueIsValid()
     * @uses \patest\EnumType\OperandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operand2Type
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand2Type($operand2Type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OperandType::valueIsValid($operand2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperandType', is_array($operand2Type) ? implode(', ', $operand2Type) : var_export($operand2Type, true), implode(', ', \patest\EnumType\OperandType::getValidValues())), __LINE__);
        }
        if (is_null($operand2Type) || (is_array($operand2Type) && empty($operand2Type))) {
            unset($this->Operand2Type);
        } else {
            $this->Operand2Type = $operand2Type;
        }
        return $this;
    }
    /**
     * Get Operand2Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand2Value()
    {
        return isset($this->Operand2Value) ? $this->Operand2Value : null;
    }
    /**
     * Set Operand2Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand2Value
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand2Value($operand2Value = null)
    {
        // validation for constraint: string
        if (!is_null($operand2Value) && !is_string($operand2Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand2Value, true), gettype($operand2Value)), __LINE__);
        }
        if (is_null($operand2Value) || (is_array($operand2Value) && empty($operand2Value))) {
            unset($this->Operand2Value);
        } else {
            $this->Operand2Value = $operand2Value;
        }
        return $this;
    }
    /**
     * Get Operand2VocabularyDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperand2VocabularyDefinitionId()
    {
        return isset($this->Operand2VocabularyDefinitionId) ? $this->Operand2VocabularyDefinitionId : null;
    }
    /**
     * Set Operand2VocabularyDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operand2VocabularyDefinitionId
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperand2VocabularyDefinitionId($operand2VocabularyDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($operand2VocabularyDefinitionId) && !is_string($operand2VocabularyDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operand2VocabularyDefinitionId, true), gettype($operand2VocabularyDefinitionId)), __LINE__);
        }
        if (is_null($operand2VocabularyDefinitionId) || (is_array($operand2VocabularyDefinitionId) && empty($operand2VocabularyDefinitionId))) {
            unset($this->Operand2VocabularyDefinitionId);
        } else {
            $this->Operand2VocabularyDefinitionId = $operand2VocabularyDefinitionId;
        }
        return $this;
    }
    /**
     * Get Operator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperator()
    {
        return isset($this->Operator) ? $this->Operator : null;
    }
    /**
     * Set Operator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperatorType::valueIsValid()
     * @uses \patest\EnumType\OperatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OperatorType::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperatorType', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \patest\EnumType\OperatorType::getValidValues())), __LINE__);
        }
        if (is_null($operator) || (is_array($operator) && empty($operator))) {
            unset($this->Operator);
        } else {
            $this->Operator = $operator;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleId, true)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
    /**
     * Get ValueTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueTypeName()
    {
        return isset($this->ValueTypeName) ? $this->ValueTypeName : null;
    }
    /**
     * Set ValueTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueTypeName
     * @return \patest\StructType\RuleEngine_Criterion
     */
    public function setValueTypeName($valueTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($valueTypeName) && !is_string($valueTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueTypeName, true), gettype($valueTypeName)), __LINE__);
        }
        if (is_null($valueTypeName) || (is_array($valueTypeName) && empty($valueTypeName))) {
            unset($this->ValueTypeName);
        } else {
            $this->ValueTypeName = $valueTypeName;
        }
        return $this;
    }
}
