<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RuleDescription
 * @subpackage Structs
 */
class RuleDescription extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Criteria;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The RuleService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleService;
    /**
     * The RuleSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleSet;
    /**
     * The RuleSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleSystem;
    /**
     * Constructor method for RuleDescription
     * @uses RuleDescription::setAction()
     * @uses RuleDescription::setCriteria()
     * @uses RuleDescription::setId()
     * @uses RuleDescription::setRuleService()
     * @uses RuleDescription::setRuleSet()
     * @uses RuleDescription::setRuleSystem()
     * @param string $action
     * @param string $criteria
     * @param string $id
     * @param string $ruleService
     * @param string $ruleSet
     * @param string $ruleSystem
     */
    public function __construct($action = null, $criteria = null, $id = null, $ruleService = null, $ruleSet = null, $ruleSystem = null)
    {
        $this
            ->setAction($action)
            ->setCriteria($criteria)
            ->setId($id)
            ->setRuleService($ruleService)
            ->setRuleSet($ruleSet)
            ->setRuleSystem($ruleSystem);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \patest\StructType\RuleDescription
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criteria
     * @return \patest\StructType\RuleDescription
     */
    public function setCriteria($criteria = null)
    {
        // validation for constraint: string
        if (!is_null($criteria) && !is_string($criteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($criteria, true), gettype($criteria)), __LINE__);
        }
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\RuleDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RuleService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleService()
    {
        return isset($this->RuleService) ? $this->RuleService : null;
    }
    /**
     * Set RuleService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleService
     * @return \patest\StructType\RuleDescription
     */
    public function setRuleService($ruleService = null)
    {
        // validation for constraint: string
        if (!is_null($ruleService) && !is_string($ruleService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleService, true), gettype($ruleService)), __LINE__);
        }
        if (is_null($ruleService) || (is_array($ruleService) && empty($ruleService))) {
            unset($this->RuleService);
        } else {
            $this->RuleService = $ruleService;
        }
        return $this;
    }
    /**
     * Get RuleSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSet()
    {
        return isset($this->RuleSet) ? $this->RuleSet : null;
    }
    /**
     * Set RuleSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSet
     * @return \patest\StructType\RuleDescription
     */
    public function setRuleSet($ruleSet = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSet) && !is_string($ruleSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSet, true), gettype($ruleSet)), __LINE__);
        }
        if (is_null($ruleSet) || (is_array($ruleSet) && empty($ruleSet))) {
            unset($this->RuleSet);
        } else {
            $this->RuleSet = $ruleSet;
        }
        return $this;
    }
    /**
     * Get RuleSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSystem()
    {
        return isset($this->RuleSystem) ? $this->RuleSystem : null;
    }
    /**
     * Set RuleSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSystem
     * @return \patest\StructType\RuleDescription
     */
    public function setRuleSystem($ruleSystem = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSystem) && !is_string($ruleSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSystem, true), gettype($ruleSystem)), __LINE__);
        }
        if (is_null($ruleSystem) || (is_array($ruleSystem) && empty($ruleSystem))) {
            unset($this->RuleSystem);
        } else {
            $this->RuleSystem = $ruleSystem;
        }
        return $this;
    }
}
