<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RowDesign
 * @subpackage Structs
 */
class RowDesign extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The ParentSectorGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentSectorGuid;
    /**
     * The RowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RowGuid;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatDesign
     */
    public $Seats;
    /**
     * Constructor method for RowDesign
     * @uses RowDesign::setDescription()
     * @uses RowDesign::setName()
     * @uses RowDesign::setOrdinal()
     * @uses RowDesign::setParentSectorGuid()
     * @uses RowDesign::setRowGuid()
     * @uses RowDesign::setSeats()
     * @param \patest\StructType\GlobalString $description
     * @param string $name
     * @param int $ordinal
     * @param string $parentSectorGuid
     * @param string $rowGuid
     * @param \patest\ArrayType\ArrayOfSeatDesign $seats
     */
    public function __construct(\patest\StructType\GlobalString $description = null, $name = null, $ordinal = null, $parentSectorGuid = null, $rowGuid = null, \patest\ArrayType\ArrayOfSeatDesign $seats = null)
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setParentSectorGuid($parentSectorGuid)
            ->setRowGuid($rowGuid)
            ->setSeats($seats);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\RowDesign
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\RowDesign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\RowDesign
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get ParentSectorGuid value
     * @return string|null
     */
    public function getParentSectorGuid()
    {
        return $this->ParentSectorGuid;
    }
    /**
     * Set ParentSectorGuid value
     * @param string $parentSectorGuid
     * @return \patest\StructType\RowDesign
     */
    public function setParentSectorGuid($parentSectorGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentSectorGuid) && !is_string($parentSectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentSectorGuid, true), gettype($parentSectorGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentSectorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentSectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentSectorGuid, true)), __LINE__);
        }
        $this->ParentSectorGuid = $parentSectorGuid;
        return $this;
    }
    /**
     * Get RowGuid value
     * @return string|null
     */
    public function getRowGuid()
    {
        return $this->RowGuid;
    }
    /**
     * Set RowGuid value
     * @param string $rowGuid
     * @return \patest\StructType\RowDesign
     */
    public function setRowGuid($rowGuid = null)
    {
        // validation for constraint: string
        if (!is_null($rowGuid) && !is_string($rowGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowGuid, true), gettype($rowGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rowGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rowGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rowGuid, true)), __LINE__);
        }
        $this->RowGuid = $rowGuid;
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatDesign|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatDesign $seats
     * @return \patest\StructType\RowDesign
     */
    public function setSeats(\patest\ArrayType\ArrayOfSeatDesign $seats = null)
    {
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
}
